/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.AppOutputProvider;
import com.applitools.eyes.AppOutputWithScreenshot;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.RegionProvider;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.ServerConnector;
import com.applitools.eyes.Trigger;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;

public class MatchWindowTask {
    private static final int MATCH_INTERVAL = 500;
    private final Logger logger;
    private final ServerConnector serverConnector;
    private final RunningSession runningSession;
    private final int defaultRetryTimeout;
    private final AppOutputProvider appOutputProvider;

    public MatchWindowTask(Logger logger, ServerConnector serverConnector, RunningSession runningSession, int retryTimeout, AppOutputProvider appOutputProvider) {
        ArgumentGuard.notNull((Object)serverConnector, (String)"serverConnector");
        ArgumentGuard.notNull((Object)runningSession, (String)"runningSession");
        ArgumentGuard.greaterThanOrEqualToZero((long)retryTimeout, (String)"retryTimeout");
        ArgumentGuard.notNull((Object)appOutputProvider, (String)"appOutputProvider");
        this.logger = logger;
        this.serverConnector = serverConnector;
        this.runningSession = runningSession;
        this.defaultRetryTimeout = retryTimeout * 1000;
        this.appOutputProvider = appOutputProvider;
    }

    protected MatchResult performMatch(Trigger[] userInputs, AppOutputWithScreenshot appOutput, String tag, boolean ignoreMismatch) {
        MatchWindowData data = new MatchWindowData(userInputs, appOutput.getAppOutput(), tag, ignoreMismatch, new MatchWindowData.Options(tag, userInputs, ignoreMismatch, false, false, false));
        return this.serverConnector.matchWindow(this.runningSession, data);
    }

    public MatchResult matchWindow(Trigger[] userInputs, EyesScreenshot lastScreenshot, RegionProvider regionProvider, String tag, boolean shouldMatchWindowRunOnceOnTimeout, boolean ignoreMismatch, int retryTimeout) {
        MatchResult matchResult;
        AppOutputWithScreenshot appOutput;
        if (retryTimeout < 0) {
            retryTimeout = this.defaultRetryTimeout;
        }
        this.logger.verbose(String.format("retryTimeout = %d", retryTimeout));
        long elapsedTimeStart = System.currentTimeMillis();
        if (0 == retryTimeout || shouldMatchWindowRunOnceOnTimeout) {
            if (shouldMatchWindowRunOnceOnTimeout) {
                GeneralUtils.sleep((long)retryTimeout);
            }
            appOutput = this.appOutputProvider.getAppOutput(regionProvider, lastScreenshot);
            matchResult = this.performMatch(userInputs, appOutput, tag, ignoreMismatch);
        } else {
            appOutput = this.appOutputProvider.getAppOutput(regionProvider, lastScreenshot);
            long start = System.currentTimeMillis();
            matchResult = this.performMatch(userInputs, appOutput, tag, true);
            long retry = System.currentTimeMillis() - start;
            while (retry < (long)retryTimeout && !matchResult.getAsExpected()) {
                GeneralUtils.sleep((long)500L);
                appOutput = this.appOutputProvider.getAppOutput(regionProvider, lastScreenshot);
                matchResult = this.performMatch(userInputs, appOutput, tag, true);
                retry = System.currentTimeMillis() - start;
            }
            if (!matchResult.getAsExpected()) {
                appOutput = this.appOutputProvider.getAppOutput(regionProvider, lastScreenshot);
                matchResult = this.performMatch(userInputs, appOutput, tag, ignoreMismatch);
            }
        }
        double elapsedTime = (System.currentTimeMillis() - elapsedTimeStart) / 1000L;
        this.logger.verbose(String.format("Completed in  %.2f seconds", elapsedTime));
        matchResult.setScreenshot(appOutput.getScreenshot());
        return matchResult;
    }
}

