/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.ICheckSettings;
import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.AppEnvironment;
import com.applitools.eyes.AppOutput;
import com.applitools.eyes.BatchInfo;
import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.FailureReports;
import com.applitools.eyes.IEyesBase;
import com.applitools.eyes.IRegion;
import com.applitools.eyes.IServerConnector;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.Location;
import com.applitools.eyes.LogHandler;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowDataWithScreenshot;
import com.applitools.eyes.MatchWindowTask;
import com.applitools.eyes.NullCutProvider;
import com.applitools.eyes.OutOfBoundsException;
import com.applitools.eyes.PropertyData;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.ScaleProvider;
import com.applitools.eyes.ServerConnector;
import com.applitools.eyes.SessionStartInfo;
import com.applitools.eyes.SessionType;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.TestResultsStatus;
import com.applitools.eyes.Trigger;
import com.applitools.eyes.capture.AppOutputProvider;
import com.applitools.eyes.capture.AppOutputWithScreenshot;
import com.applitools.eyes.config.IConfigurationGetter;
import com.applitools.eyes.config.IConfigurationSetter;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import com.applitools.eyes.debug.FileDebugScreenshotsProvider;
import com.applitools.eyes.debug.NullDebugScreenshotProvider;
import com.applitools.eyes.diagnostics.ResponseTimeAlgorithm;
import com.applitools.eyes.events.ISessionEventHandler;
import com.applitools.eyes.events.SessionEventHandlers;
import com.applitools.eyes.events.ValidationInfo;
import com.applitools.eyes.exceptions.DiffsFoundException;
import com.applitools.eyes.exceptions.NewTestException;
import com.applitools.eyes.exceptions.TestFailedException;
import com.applitools.eyes.fluent.CheckSettings;
import com.applitools.eyes.fluent.ICheckSettingsInternal;
import com.applitools.eyes.positioning.InvalidPositionProvider;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.positioning.RegionProvider;
import com.applitools.eyes.scaling.FixedScaleProvider;
import com.applitools.eyes.scaling.NullScaleProvider;
import com.applitools.eyes.triggers.MouseAction;
import com.applitools.eyes.triggers.MouseTrigger;
import com.applitools.eyes.triggers.TextTrigger;
import com.applitools.eyes.visualgrid.model.RenderingInfo;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.ImageUtils;
import com.applitools.utils.PropertyHandler;
import com.applitools.utils.ReadOnlyPropertyHandler;
import com.applitools.utils.SimplePropertyHandler;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;

public abstract class EyesBase
implements IEyesBase {
    protected static final int USE_DEFAULT_TIMEOUT = -1;
    private static final int MAX_ITERATION = 10;
    private boolean shouldMatchWindowRunOnceOnTimeout;
    private MatchWindowTask matchWindowTask;
    protected IServerConnector serverConnector;
    protected RunningSession runningSession;
    protected SessionStartInfo sessionStartInfo;
    protected RectangleSize viewportSize;
    protected EyesScreenshot lastScreenshot;
    protected PropertyHandler<ScaleProvider> scaleProviderHandler;
    protected PropertyHandler<CutProvider> cutProviderHandler;
    protected PropertyHandler<PositionProvider> positionProviderHandler;
    private boolean isDisabled;
    protected Logger logger;
    protected boolean isOpen;
    private final Queue<Trigger> userInputs;
    private final List<PropertyData> properties = new ArrayList<PropertyData>();
    private boolean isViewportSizeSet;
    protected RenderingInfo renderInfo;
    private int validationId;
    private final SessionEventHandlers sessionEventHandlers = new SessionEventHandlers();
    protected DebugScreenshotsProvider debugScreenshotsProvider;

    public EyesBase() {
        if (this.isDisabled) {
            this.userInputs = null;
            return;
        }
        this.logger = new Logger();
        this.initProviders();
        this.setServerConnector((IServerConnector)new ServerConnector());
        this.runningSession = null;
        this.userInputs = new ArrayDeque<Trigger>();
        this.lastScreenshot = null;
        this.debugScreenshotsProvider = new NullDebugScreenshotProvider();
    }

    private void initProviders(boolean hardReset) {
        if (hardReset) {
            this.scaleProviderHandler = new SimplePropertyHandler();
            this.scaleProviderHandler.set((Object)new NullScaleProvider(this.logger));
            this.cutProviderHandler = new SimplePropertyHandler();
            this.cutProviderHandler.set((Object)new NullCutProvider());
            this.positionProviderHandler = new SimplePropertyHandler();
            this.positionProviderHandler.set((Object)new InvalidPositionProvider());
            return;
        }
        if (this.scaleProviderHandler == null) {
            this.scaleProviderHandler = new SimplePropertyHandler();
            this.scaleProviderHandler.set((Object)new NullScaleProvider(this.logger));
        }
        if (this.cutProviderHandler == null) {
            this.cutProviderHandler = new SimplePropertyHandler();
            this.cutProviderHandler.set((Object)new NullCutProvider());
        }
        if (this.positionProviderHandler == null) {
            this.positionProviderHandler = new SimplePropertyHandler();
            this.positionProviderHandler.set((Object)new InvalidPositionProvider());
        }
    }

    private void initProviders() {
        this.initProviders(false);
    }

    public void setServerConnector(IServerConnector serverConnector) {
        ArgumentGuard.notNull((Object)serverConnector, (String)"serverConnector");
        if (serverConnector.getLogger() == null) {
            serverConnector.setLogger(this.logger);
        }
        this.serverConnector = serverConnector;
    }

    public IConfigurationSetter setApiKey(String apiKey) {
        ArgumentGuard.notNull((Object)apiKey, (String)"apiKey");
        if (this.serverConnector == null) {
            throw new EyesException("server connector not set.");
        }
        this.serverConnector.setApiKey(apiKey);
        return this.getConfigSetter();
    }

    public String getApiKey() {
        if (this.serverConnector == null) {
            throw new EyesException("server connector not set.");
        }
        return this.serverConnector.getApiKey();
    }

    public IConfigurationSetter setServerUrl(String serverUrl) {
        this.setServerUrl(URI.create(serverUrl));
        return this.getConfigSetter();
    }

    public IConfigurationSetter setServerUrl(URI serverUrl) {
        if (this.serverConnector == null) {
            throw new EyesException("server connector not set.");
        }
        if (serverUrl == null) {
            this.serverConnector.setServerUrl(EyesBase.getDefaultServerUrl());
        } else {
            this.serverConnector.setServerUrl(serverUrl);
        }
        return this.getConfigSetter();
    }

    public URI getServerUrl() {
        if (this.serverConnector == null) {
            throw new EyesException("server connector not set.");
        }
        return this.serverConnector.getServerUrl();
    }

    public IConfigurationSetter setProxy(AbstractProxySettings abstractProxySettings) {
        if (this.serverConnector == null) {
            throw new EyesException("server connector not set.");
        }
        this.getConfigSetter().setProxy(abstractProxySettings);
        this.serverConnector.setProxy(abstractProxySettings);
        return this.getConfigSetter();
    }

    public AbstractProxySettings getProxy() {
        if (this.serverConnector == null) {
            throw new EyesException("server connector not set.");
        }
        return this.serverConnector.getProxy();
    }

    public void setIsDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public boolean getIsDisabled() {
        return this.isDisabled;
    }

    protected void clearUserInputs() {
        if (this.isDisabled) {
            return;
        }
        this.userInputs.clear();
    }

    protected Trigger[] getUserInputs() {
        if (this.isDisabled) {
            return null;
        }
        Trigger[] result = new Trigger[this.userInputs.size()];
        return this.userInputs.toArray(result);
    }

    protected abstract String getBaseAgentId();

    public String getFullAgentId() {
        String agentId = this.getConfigGetter().getAgentId();
        if (agentId == null) {
            return this.getBaseAgentId();
        }
        return String.format("%s [%s]", agentId, this.getBaseAgentId());
    }

    public boolean getIsOpen() {
        return this.isOpen;
    }

    public static URI getDefaultServerUrl() {
        try {
            return new URI("https://eyesapi.applitools.com");
        }
        catch (URISyntaxException ex) {
            throw new EyesException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void setLogHandler(LogHandler logHandler) {
        this.logger.setLogHandler(logHandler);
    }

    public LogHandler getLogHandler() {
        return this.logger.getLogHandler();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setImageCut(CutProvider cutProvider) {
        if (cutProvider != null) {
            cutProvider.setLogger(this.logger);
            this.cutProviderHandler = new ReadOnlyPropertyHandler(this.logger, (Object)cutProvider);
        } else {
            this.cutProviderHandler = new SimplePropertyHandler();
            this.cutProviderHandler.set((Object)new NullCutProvider());
        }
    }

    public boolean getIsCutProviderExplicitlySet() {
        return this.cutProviderHandler != null && !(this.cutProviderHandler.get() instanceof NullCutProvider);
    }

    public void setScaleRatio(Double scaleRatio) {
        if (scaleRatio != null) {
            FixedScaleProvider scaleProvider = new FixedScaleProvider(this.logger, scaleRatio);
            this.scaleProviderHandler = new ReadOnlyPropertyHandler(this.logger, (Object)scaleProvider);
        } else {
            this.scaleProviderHandler = new SimplePropertyHandler();
            this.scaleProviderHandler.set((Object)new NullScaleProvider(this.logger));
        }
    }

    public double getScaleRatio() {
        return ((ScaleProvider)this.scaleProviderHandler.get()).getScaleRatio();
    }

    public void addProperty(String name, String value) {
        PropertyData pd = new PropertyData(name, value);
        this.properties.add(pd);
    }

    protected void addProperty(PropertyData propery) {
        this.properties.add(propery);
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public void setSaveDebugScreenshots(boolean saveDebugScreenshots) {
        DebugScreenshotsProvider prev = this.debugScreenshotsProvider;
        this.debugScreenshotsProvider = saveDebugScreenshots ? new FileDebugScreenshotsProvider(this.logger) : new NullDebugScreenshotProvider();
        this.debugScreenshotsProvider.setPrefix(prev.getPrefix());
        this.debugScreenshotsProvider.setPath(prev.getPath());
    }

    public boolean getSaveDebugScreenshots() {
        return !(this.debugScreenshotsProvider instanceof NullDebugScreenshotProvider);
    }

    public void setDebugScreenshotsPath(String pathToSave) {
        this.debugScreenshotsProvider.setPath(pathToSave);
    }

    public String getDebugScreenshotsPath() {
        return this.debugScreenshotsProvider.getPath();
    }

    public void setDebugScreenshotsPrefix(String prefix) {
        this.debugScreenshotsProvider.setPrefix(prefix);
    }

    public String getDebugScreenshotsPrefix() {
        return this.debugScreenshotsProvider.getPrefix();
    }

    public DebugScreenshotsProvider getDebugScreenshotsProvider() {
        return this.debugScreenshotsProvider;
    }

    public TestResults close() {
        return this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResults close(boolean throwEx) {
        try {
            if (this.isDisabled) {
                this.logger.verbose("Ignored");
                TestResults testResults = null;
                return testResults;
            }
            this.logger.verbose(String.format("close(%b)", throwEx));
            ArgumentGuard.isValidState((boolean)this.isOpen, (String)"Eyes not open");
            this.isOpen = false;
            this.lastScreenshot = null;
            this.clearUserInputs();
            this.initProviders(true);
            if (this.runningSession == null) {
                this.logger.log("Server session was not started --- Empty test ended.");
                TestResults testResults = new TestResults();
                return testResults;
            }
            boolean isNewSession = this.runningSession.getIsNewSession();
            this.logger.verbose("Ending server session...");
            boolean save = isNewSession && this.getConfigGetter().getSaveNewTests() || !isNewSession && this.getConfigGetter().getSaveFailedTests();
            this.logger.verbose("Automatically save test? " + String.valueOf(save));
            TestResults results = this.serverConnector.stopSession(this.runningSession, false, save);
            results.setNew(isNewSession);
            results.setUrl(this.runningSession.getUrl());
            this.logger.verbose(results.toString());
            this.sessionEventHandlers.testEnded(this.getAUTSessionId(), results);
            EyesBase.logSessionResultsAndThrowException(this.logger, throwEx, results);
            results.setServerConnector(this.serverConnector);
            TestResults testResults = results;
            return testResults;
        }
        finally {
            this.runningSession = null;
        }
    }

    public static void logSessionResultsAndThrowException(Logger logger, boolean throwEx, TestResults results) {
        TestResultsStatus status = results.getStatus();
        String sessionResultsUrl = results.getUrl();
        String scenarioIdOrName = results.getName();
        String appIdOrName = results.getAppName();
        if (status == TestResultsStatus.Unresolved) {
            if (results.isNew()) {
                logger.log("--- New test ended. Please approve the new baseline at " + sessionResultsUrl);
                if (throwEx) {
                    throw new NewTestException(results, scenarioIdOrName, appIdOrName);
                }
            } else {
                logger.log("--- Failed test ended. See details at " + sessionResultsUrl);
                if (throwEx) {
                    throw new DiffsFoundException(results, scenarioIdOrName, appIdOrName);
                }
            }
        } else if (status == TestResultsStatus.Failed) {
            logger.log("--- Failed test ended. See details at " + sessionResultsUrl);
            if (throwEx) {
                throw new TestFailedException(results, scenarioIdOrName, appIdOrName);
            }
        } else {
            logger.log("--- Test passed. See details at " + sessionResultsUrl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeResponseTime(boolean isDeadlineExceeded) {
        try {
            if (this.isDisabled) {
                this.logger.verbose("Ignored");
            }
            this.logger.verbose(String.format("closeResponseTime(%b)", isDeadlineExceeded));
            ArgumentGuard.isValidState((boolean)this.isOpen, (String)"Eyes not open");
            this.isOpen = false;
            if (this.runningSession == null) {
                this.logger.verbose("Server session was not started");
                this.logger.log("--- Empty test ended.");
                return;
            }
            boolean isNewSession = this.runningSession.getIsNewSession();
            String sessionResultsUrl = this.runningSession.getUrl();
            this.logger.verbose("Ending server session...");
            boolean save = isNewSession && this.getConfigGetter().getSaveNewTests();
            this.logger.verbose("Automatically save test? " + String.valueOf(save));
            TestResults results = this.serverConnector.stopSession(this.runningSession, false, save);
            results.setNew(isNewSession);
            results.setUrl(sessionResultsUrl);
            this.logger.verbose(results.toString());
            if (isDeadlineExceeded && !isNewSession) {
                this.logger.log("--- Failed test ended. See details at " + sessionResultsUrl);
                String message = "'" + this.sessionStartInfo.getScenarioIdOrName() + "' of '" + this.sessionStartInfo.getAppIdOrName() + "'. See details at " + sessionResultsUrl;
                throw new TestFailedException(results, message);
            }
            if (isNewSession) {
                String instructions = "Please approve the new baseline at " + sessionResultsUrl;
                this.logger.log("--- New test ended. " + instructions);
                String message = "'" + this.sessionStartInfo.getScenarioIdOrName() + "' of '" + this.sessionStartInfo.getAppIdOrName() + "'. " + instructions;
                throw new NewTestException(results, message);
            }
            this.logger.log("--- Test passed. See details at " + sessionResultsUrl);
        }
        finally {
            this.runningSession = null;
            this.logger.getLogHandler().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResults abortIfNotClosed() {
        try {
            if (this.isDisabled) {
                this.logger.verbose("Ignored");
                TestResults testResults = null;
                return testResults;
            }
            this.isOpen = false;
            this.lastScreenshot = null;
            this.clearUserInputs();
            if (null == this.runningSession) {
                this.logger.verbose("Closed");
                TestResults testResults = null;
                return testResults;
            }
            this.logger.verbose("Aborting server session...");
            try {
                boolean isNewSession = this.runningSession.getIsNewSession();
                TestResults results = this.serverConnector.stopSession(this.runningSession, true, false);
                results.setNew(isNewSession);
                results.setUrl(this.runningSession.getUrl());
                this.logger.log("--- Test aborted.");
                TestResults testResults = results;
                return testResults;
            }
            catch (EyesException ex) {
                this.logger.log("Failed to abort server session: " + ex.getMessage());
                this.runningSession = null;
                this.closeLogger();
            }
        }
        finally {
            this.runningSession = null;
            this.closeLogger();
        }
        return null;
    }

    public TestResults abort() {
        return this.abortIfNotClosed();
    }

    protected void openLogger() {
        this.logger.getLogHandler().open();
    }

    protected void closeLogger() {
        this.logger.getLogHandler().close();
    }

    public PositionProvider getPositionProvider() {
        return (PositionProvider)this.positionProviderHandler.get();
    }

    public void setPositionProvider(PositionProvider positionProvider) {
        if (positionProvider != null) {
            this.positionProviderHandler = new ReadOnlyPropertyHandler(this.logger, (Object)positionProvider);
        } else {
            this.positionProviderHandler = new SimplePropertyHandler();
            this.positionProviderHandler.set((Object)new InvalidPositionProvider());
        }
    }

    protected MatchResult checkWindowBase(RegionProvider regionProvider, String tag, boolean ignoreMismatch, String source) {
        return this.checkWindowBase(regionProvider, tag, ignoreMismatch, -1, source);
    }

    protected MatchResult checkWindowBase(RegionProvider regionProvider, String tag, boolean ignoreMismatch, int retryTimeout, String source) {
        return this.checkWindowBase(regionProvider, tag, ignoreMismatch, new CheckSettings(retryTimeout), source);
    }

    protected void beforeMatchWindow() {
    }

    protected void afterMatchWindow() {
    }

    protected MatchResult checkWindowBase(RegionProvider regionProvider, String tag, boolean ignoreMismatch, ICheckSettings checkSettings, String source) {
        if (this.getIsDisabled()) {
            this.logger.verbose("Ignored");
            MatchResult result = new MatchResult();
            result.setAsExpected(true);
            return result;
        }
        if (tag == null) {
            tag = "";
        }
        ArgumentGuard.isValidState((boolean)this.getIsOpen(), (String)"Eyes not open");
        ArgumentGuard.notNull((Object)regionProvider, (String)"regionProvider");
        this.ensureRunningSession();
        this.beforeMatchWindow();
        MatchResult result = this.matchWindow(regionProvider, tag, ignoreMismatch, checkSettings, source);
        this.afterMatchWindow();
        this.logger.verbose("MatchWindow Done!");
        if (!ignoreMismatch) {
            this.clearUserInputs();
            this.lastScreenshot = result.getScreenshot(checkSettings);
        }
        this.validateResult(tag, result);
        this.logger.verbose("Done!");
        return result;
    }

    protected abstract String tryCaptureDom();

    protected String tryCaptureAndPostDom(ICheckSettingsInternal checkSettingsInternal) {
        String domUrl = null;
        if (GeneralUtils.configureSendDom((com.applitools.ICheckSettingsInternal)checkSettingsInternal, (IConfigurationGetter)this.getConfigGetter())) {
            try {
                String domJson = this.tryCaptureDom();
                domUrl = this.tryPostDomCapture(domJson);
                this.logger.verbose("domUrl: " + domUrl);
            }
            catch (Exception ex) {
                this.logger.log("Error: " + ex);
            }
        }
        return domUrl;
    }

    protected ValidationInfo fireValidationWillStartEvent(String tag) {
        String autSessionId = this.getAUTSessionId();
        ValidationInfo validationInfo = new ValidationInfo();
        validationInfo.setValidationId("" + ++this.validationId);
        validationInfo.setTag(tag);
        this.getSessionEventHandlers().validationWillStart(autSessionId, validationInfo);
        return validationInfo;
    }

    private MatchResult matchWindow(RegionProvider regionProvider, String tag, boolean ignoreMismatch, ICheckSettings checkSettings, String source) {
        ICheckSettingsInternal checkSettingsInternal = checkSettings instanceof ICheckSettingsInternal ? (ICheckSettingsInternal)checkSettings : null;
        ImageMatchSettings defaultMatchSettings = this.getConfigGetter().getDefaultMatchSettings();
        int retryTimeout = -1;
        if (checkSettingsInternal != null) {
            retryTimeout = checkSettingsInternal.getTimeout();
            if (checkSettingsInternal.getMatchLevel() == null) {
                checkSettings = checkSettings.matchLevel(defaultMatchSettings.getMatchLevel());
            }
            if (checkSettingsInternal.getIgnoreCaret() == null) {
                checkSettings = checkSettings.ignoreCaret(defaultMatchSettings.getIgnoreCaret().booleanValue());
            }
            checkSettingsInternal = (ICheckSettingsInternal)checkSettings;
        }
        Region region = regionProvider.getRegion(checkSettingsInternal);
        this.logger.verbose("params: ([" + region + "], " + tag + ", " + retryTimeout + ")");
        MatchResult result = this.matchWindowTask.matchWindow(this.getUserInputs(), region, tag, this.shouldMatchWindowRunOnceOnTimeout, ignoreMismatch, checkSettingsInternal, retryTimeout, source);
        return result;
    }

    private String tryPostDomCapture(String domJson) {
        if (domJson != null) {
            byte[] resultStream = GeneralUtils.getGzipByteArrayOutputStream((String)domJson);
            return this.matchWindowTask.tryUploadData(resultStream, "application/octet-stream", "application/json");
        }
        return null;
    }

    private void validateResult(String tag, MatchResult result) {
        if (result.getAsExpected()) {
            return;
        }
        this.shouldMatchWindowRunOnceOnTimeout = true;
        if (!this.runningSession.getIsNewSession()) {
            this.logger.log(String.format("Mismatch! (%s)", tag));
        }
        if (this.getConfigGetter().getFailureReports() == FailureReports.IMMEDIATE) {
            throw new TestFailedException(String.format("Mismatch found in '%s' of '%s'", this.sessionStartInfo.getScenarioIdOrName(), this.sessionStartInfo.getAppIdOrName()));
        }
    }

    public void setIsDisabled(Boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    protected MatchWindowDataWithScreenshot testResponseTimeBase(RegionProvider regionProvider, Runnable action, int deadline, int timeout, long matchInterval) {
        MatchWindowDataWithScreenshot result;
        if (this.getIsDisabled()) {
            this.logger.verbose("Ignored");
            return null;
        }
        ArgumentGuard.isValidState((boolean)this.getIsOpen(), (String)"Eyes not open");
        ArgumentGuard.notNull((Object)regionProvider, (String)"regionProvider");
        ArgumentGuard.greaterThanZero((long)deadline, (String)"deadline");
        ArgumentGuard.greaterThanZero((long)timeout, (String)"timeout");
        ArgumentGuard.greaterThanZero((long)matchInterval, (String)"matchInterval");
        this.logger.verbose(String.format("testResponseTimeBase(regionProvider, %d, %d, %d)", deadline, timeout, matchInterval));
        if (this.runningSession == null) {
            this.logger.verbose("No running session, calling start session..");
            this.startSession();
            this.logger.verbose("Done!");
        }
        Thread actionThread = null;
        if (action != null) {
            this.logger.verbose("Starting WebDriver action.");
            actionThread = new Thread(action);
            actionThread.start();
        }
        long startTime = System.currentTimeMillis();
        AppOutputProvider appOutputProvider = new AppOutputProvider(){

            @Override
            public AppOutputWithScreenshot getAppOutput(Region region, ICheckSettingsInternal checkSettingsInternal) {
                return EyesBase.this.getAppOutputWithScreenshot(region, null);
            }
        };
        if (this.runningSession.getIsNewSession()) {
            ResponseTimeAlgorithm.runNewProgressionSession(this.logger, this.serverConnector, this.runningSession, appOutputProvider, regionProvider, startTime, deadline);
            result = null;
        } else {
            result = ResponseTimeAlgorithm.runProgressionSessionForExistingBaseline(this.logger, this.serverConnector, this.runningSession, appOutputProvider, regionProvider, startTime, deadline, timeout, matchInterval);
        }
        if (actionThread != null) {
            this.logger.verbose("Making sure 'action' thread had finished...");
            try {
                actionThread.join(30000L);
            }
            catch (InterruptedException e) {
                this.logger.verbose("Got interrupted while waiting for 'action' to finish!");
            }
        }
        this.logger.verbose("Done!");
        return result;
    }

    protected void beforeOpen() {
    }

    protected void afterOpen() {
    }

    protected void openBase(String appName, String testName, RectangleSize viewportSize, SessionType sessionType) {
        if (this.isDisabled) {
            this.logger.verbose("Ignored");
            return;
        }
        if (this.serverConnector == null) {
            throw new EyesException("server connector not set.");
        }
        if (this.getAppName() == null) {
            ArgumentGuard.notNull((Object)appName, (String)"appName");
            this.getConfigSetter().setAppName(appName);
        }
        ArgumentGuard.notNull((Object)testName, (String)"testName");
        this.getConfigSetter().setTestName(testName);
        this.logger.log("Agent = " + this.getFullAgentId());
        this.logger.verbose(String.format("openBase('%s', '%s', '%s')", appName, testName, viewportSize));
        this.getConfigSetter().setSessionType(sessionType != null ? sessionType : SessionType.SEQUENTIAL);
        this.getConfigSetter().setViewportSize(viewportSize);
        this.openBase();
    }

    protected void openBase() throws EyesException {
        this.openLogger();
        int retry = 0;
        do {
            try {
                if (this.isDisabled) {
                    this.logger.verbose("Ignored");
                    return;
                }
                this.sessionEventHandlers.testStarted(this.getAUTSessionId());
                this.validateApiKey();
                this.logOpenBase();
                this.validateSessionOpen();
                this.initProviders();
                this.isViewportSizeSet = false;
                this.sessionEventHandlers.initStarted();
                this.beforeOpen();
                this.viewportSize = this.getViewportSizeForOpen();
                if (this.viewportSize == null) {
                    this.viewportSize = RectangleSize.EMPTY;
                }
                try {
                    this.ensureRunningSession();
                }
                catch (Exception e) {
                    GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
                    continue;
                }
                this.validationId = -1;
                this.isOpen = true;
                this.afterOpen();
                return;
            }
            catch (EyesException e) {
                this.logger.log(e.getMessage());
                this.logger.getLogHandler().close();
                throw e;
            }
        } while (10 > ++retry);
        throw new EyesException("eyes.openBase() failed");
    }

    protected RectangleSize getViewportSizeForOpen() {
        return this.getConfigGetter().getViewportSize();
    }

    protected void ensureRunningSession() {
        if (this.runningSession != null) {
            this.logger.log("session already running.");
            return;
        }
        this.logger.log("No running session, calling start session...");
        this.startSession();
        this.logger.setSessionId(this.runningSession.getSessionId());
        this.logger.log("Done!");
        this.matchWindowTask = new MatchWindowTask(this.logger, this.serverConnector, this.runningSession, this.getConfigGetter().getMatchTimeout(), this, new AppOutputProvider(){

            @Override
            public AppOutputWithScreenshot getAppOutput(Region region, ICheckSettingsInternal checkSettingsInternal) {
                return EyesBase.this.getAppOutputWithScreenshot(region, checkSettingsInternal);
            }
        });
    }

    private void validateApiKey() {
        if (this.getApiKey() == null) {
            String errMsg = "API key is missing! Please set it using setApiKey()";
            this.logger.log(errMsg);
            throw new EyesException(errMsg);
        }
    }

    private void logOpenBase() {
        this.logger.log(String.format("Eyes server URL is '%s'", this.serverConnector.getServerUrl()));
        this.logger.verbose(String.format("Timeout = '%d'", this.serverConnector.getTimeout()));
        this.logger.log(String.format("matchTimeout = '%d' ", this.getConfigGetter().getMatchTimeout()));
        this.logger.log(String.format("Default match settings = '%s' ", this.getConfigGetter().getDefaultMatchSettings()));
        this.logger.log(String.format("FailureReports = '%s' ", this.getConfigGetter().getFailureReports()));
    }

    private void validateSessionOpen() {
        if (this.isOpen) {
            this.abortIfNotClosed();
            String errMsg = "A test is already running";
            this.logger.log(errMsg);
            throw new EyesException(errMsg);
        }
    }

    protected abstract RectangleSize getViewportSize();

    protected abstract IConfigurationSetter setViewportSize(RectangleSize var1);

    protected void setEffectiveViewportSize(RectangleSize size) {
    }

    public void setExplicitViewportSize(RectangleSize explicitViewportSize) {
        if (explicitViewportSize == null) {
            this.viewportSize = null;
            this.isViewportSizeSet = false;
            return;
        }
        this.logger.verbose("Viewport size explicitly set to " + explicitViewportSize);
        this.viewportSize = explicitViewportSize;
        this.isViewportSizeSet = true;
    }

    protected abstract String getInferredEnvironment();

    protected abstract EyesScreenshot getScreenshot(ICheckSettingsInternal var1);

    protected abstract String getTitle();

    protected void addUserInput(Trigger trigger) {
        if (this.isDisabled) {
            return;
        }
        ArgumentGuard.notNull((Object)trigger, (String)"trigger");
        this.userInputs.add(trigger);
    }

    protected void addTextTriggerBase(Region control, String text) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring '%s' (disabled)", text));
            return;
        }
        ArgumentGuard.notNull((Object)control, (String)"control");
        ArgumentGuard.notNull((Object)text, (String)"text");
        control = new Region((IRegion)control);
        if (this.lastScreenshot == null) {
            this.logger.verbose(String.format("Ignoring '%s' (no screenshot)", text));
            return;
        }
        if ((control = this.lastScreenshot.getIntersectedRegion(control, CoordinatesType.SCREENSHOT_AS_IS)).isSizeEmpty()) {
            this.logger.verbose(String.format("Ignoring '%s' (out of bounds)", text));
            return;
        }
        TextTrigger trigger = new TextTrigger(control, text);
        this.addUserInput(trigger);
        this.logger.verbose(String.format("Added %s", new Object[]{trigger}));
    }

    protected void addMouseTriggerBase(MouseAction action, Region control, Location cursor) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring %s (disabled)", new Object[]{action}));
            return;
        }
        ArgumentGuard.notNull((Object)((Object)action), (String)"action");
        ArgumentGuard.notNull((Object)control, (String)"control");
        ArgumentGuard.notNull((Object)cursor, (String)"cursor");
        if (this.lastScreenshot == null) {
            this.logger.verbose(String.format("Ignoring %s (no screenshot)", new Object[]{action}));
            return;
        }
        Location cursorInScreenshot = new Location(cursor);
        cursorInScreenshot.offset(control.getLocation());
        try {
            cursorInScreenshot = this.lastScreenshot.getLocationInScreenshot(cursorInScreenshot, CoordinatesType.CONTEXT_RELATIVE);
        }
        catch (OutOfBoundsException e) {
            this.logger.verbose(String.format("Ignoring %s (out of bounds)", new Object[]{action}));
            return;
        }
        Region controlScreenshotIntersect = this.lastScreenshot.getIntersectedRegion(control, CoordinatesType.SCREENSHOT_AS_IS);
        if (!controlScreenshotIntersect.isSizeEmpty()) {
            Location l = controlScreenshotIntersect.getLocation();
            cursorInScreenshot.offset(-l.getX(), -l.getY());
        }
        MouseTrigger trigger = new MouseTrigger(action, controlScreenshotIntersect, cursorInScreenshot);
        this.addUserInput(trigger);
        this.logger.verbose(String.format("Added %s", new Object[]{trigger}));
    }

    protected AppEnvironment getAppEnvironment() {
        AppEnvironment appEnv = new AppEnvironment();
        if (this.getConfigGetter().getHostOS() != null) {
            appEnv.setOs(this.getConfigGetter().getHostOS());
        }
        if (this.getConfigGetter().getHostApp() != null) {
            appEnv.setHostingApp(this.getConfigGetter().getHostApp());
        }
        appEnv.setInferred(this.getInferredEnvironment());
        appEnv.setDisplaySize(this.viewportSize);
        return appEnv;
    }

    protected void startSession() {
        this.logger.verbose("startSession()");
        if (this.serverConnector == null) {
            throw new EyesException("server connector not set.");
        }
        this.ensureViewportSize();
        IConfigurationGetter configGetter = this.getConfigGetter();
        BatchInfo testBatch = configGetter.getBatch();
        if (testBatch == null) {
            this.logger.verbose("No batch set");
            this.getConfigSetter().setBatch(new BatchInfo(null));
        } else {
            this.logger.verbose("Batch is " + testBatch);
        }
        AppEnvironment appEnv = this.getAppEnvironment();
        this.sessionEventHandlers.initEnded();
        this.logger.verbose("Application environment is " + appEnv);
        String appName = this.getAppName();
        this.sessionStartInfo = new SessionStartInfo(this.getFullAgentId(), configGetter.getSessionType(), appName, null, this.getTestName(), configGetter.getBatch(), this.getBaselineEnvName(), configGetter.getEnvironmentName(), this.getAppEnvironment(), configGetter.getDefaultMatchSettings(), configGetter.getBranchName(), configGetter.getParentBranchName(), configGetter.getBaselineBranchName(), configGetter.getSaveDiffs(), this.properties);
        this.logger.verbose("Starting server session...");
        this.runningSession = this.serverConnector.startSession(this.sessionStartInfo);
        this.logger.verbose("Server session ID is " + this.runningSession.getId());
        String testInfo = "'" + this.getTestName() + "' of '" + appName + "' " + appEnv;
        if (this.runningSession.getIsNewSession()) {
            this.logger.log("--- New test started - " + testInfo);
            this.shouldMatchWindowRunOnceOnTimeout = true;
        } else {
            this.logger.log("--- Test started - " + testInfo);
            this.shouldMatchWindowRunOnceOnTimeout = false;
        }
    }

    protected String getTestName() {
        return this.getConfigGetter().getTestName();
    }

    protected String getAppName() {
        return this.getConfigGetter().getAppName();
    }

    protected String getBaselineEnvName() {
        return this.getConfigGetter().getBaselineEnvName();
    }

    public Object getAgentSetup() {
        return null;
    }

    private void ensureViewportSize() {
        if (!this.isViewportSizeSet) {
            if (this.viewportSize == null || this.viewportSize.isEmpty()) {
                try {
                    this.viewportSize = this.getViewportSize();
                    this.logger.verbose("viewport size: " + this.viewportSize);
                    this.setEffectiveViewportSize(this.viewportSize);
                }
                catch (NullPointerException e) {
                    this.isViewportSizeSet = false;
                }
            } else {
                try {
                    this.logger.verbose("Setting viewport size to " + this.viewportSize);
                    this.setViewportSize(this.viewportSize);
                    this.isViewportSizeSet = true;
                }
                catch (Exception ex) {
                    this.isViewportSizeSet = false;
                    throw ex;
                }
            }
        }
    }

    protected EyesScreenshot getSubScreenshot(EyesScreenshot screenshot, Region region, ICheckSettingsInternal checkSettingsInternal) {
        return screenshot.getSubScreenshot(region, false);
    }

    private AppOutputWithScreenshot getAppOutputWithScreenshot(Region region, ICheckSettingsInternal checkSettingsInternal) {
        this.logger.verbose("getting screenshot...");
        EyesScreenshot screenshot = this.getScreenshot(checkSettingsInternal);
        this.logger.verbose("Done getting screenshot!");
        Location location = null;
        if (!region.isSizeEmpty()) {
            location = region.getLocation();
            screenshot = screenshot.getSubScreenshot(region, false);
            this.debugScreenshotsProvider.save(screenshot.getImage(), "SUB_SCREENSHOT");
        }
        this.logger.verbose("Getting image bytes (encoded as PNG)...");
        BufferedImage screenshotImage = screenshot.getImage();
        byte[] screenshotBytes = ImageUtils.encodeAsPng((BufferedImage)screenshotImage);
        this.logger.verbose("Done! Getting title...");
        String title = this.getTitle();
        this.logger.verbose("Done!");
        AppOutputWithScreenshot result = new AppOutputWithScreenshot(new AppOutput(title, screenshotBytes, screenshot.domUrl, null), screenshot, location);
        this.logger.verbose("Done!");
        return result;
    }

    public void log(String message) {
        this.logger.log(message);
    }

    protected SessionEventHandlers getSessionEventHandlers() {
        return this.sessionEventHandlers;
    }

    public void addSessionEventHandler(ISessionEventHandler eventHandler) {
        this.sessionEventHandlers.addEventHandler(eventHandler);
    }

    public void removeSessionEventHandler(ISessionEventHandler eventHandler) {
        this.sessionEventHandlers.removeEventHandler(eventHandler);
    }

    public void clearSessionEventHandlers() {
        this.sessionEventHandlers.clearEventHandlers();
    }

    protected abstract String getAUTSessionId();

    public Boolean isSendDom() {
        return this.getConfigGetter().isSendDom();
    }

    public IConfigurationSetter setSendDom(boolean isSendDom) {
        this.getConfigSetter().setSendDom(isSendDom);
        return this.getConfigSetter();
    }

    public RenderingInfo getRenderingInfo() {
        if (this.renderInfo != null) {
            return this.renderInfo;
        }
        this.renderInfo = this.serverConnector.getRenderInfo();
        return this.renderInfo;
    }

    public IConfigurationSetter setBatch(BatchInfo batch) {
        if (this.isDisabled) {
            this.logger.verbose("Ignored");
            return this.getConfigSetter();
        }
        this.logger.verbose("setBatch(" + batch + ")");
        this.getConfigSetter().setBatch(batch);
        return this.getConfigSetter();
    }

    protected abstract IConfigurationGetter getConfigGetter();

    protected abstract IConfigurationSetter getConfigSetter();

    public void abortAsync() {
        this.abort();
    }
}

