/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.connectivity;

import com.applitools.connectivity.api.HttpClient;
import com.applitools.connectivity.api.HttpClientImpl;
import com.applitools.connectivity.api.Request;
import com.applitools.connectivity.api.Response;
import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;

public class RestClient {
    private static final String AGENT_ID_CUSTOM_HEADER = "x-applitools-eyes-client";
    protected Logger logger;
    protected HttpClient restClient;
    protected URI serverUrl;
    protected String agentId;
    protected ObjectMapper jsonMapper;

    public RestClient(Logger logger, URI serverUrl, int timeout) {
        ArgumentGuard.notNull((Object)serverUrl, (String)"serverUrl");
        this.logger = logger;
        this.jsonMapper = new ObjectMapper();
        this.jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.serverUrl = serverUrl;
        this.restClient = new HttpClientImpl(logger, timeout, null);
    }

    public void setLogger(Logger logger) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        this.logger = logger;
        AbstractProxySettings proxySettings = this.restClient.getProxySettings();
        int timeout = this.restClient.getTimeout();
        this.restClient.close();
        this.restClient = new HttpClientImpl(logger, timeout, proxySettings);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setProxy(AbstractProxySettings proxySettings) {
        int timeout = this.restClient.getTimeout();
        this.restClient.close();
        this.restClient = new HttpClientImpl(this.logger, timeout, proxySettings);
    }

    public AbstractProxySettings getProxy() {
        return this.restClient.getProxySettings();
    }

    public void setTimeout(int timeout) {
        ArgumentGuard.greaterThanOrEqualToZero((long)timeout, (String)"timeout");
        AbstractProxySettings proxySettings = this.restClient.getProxySettings();
        this.restClient.close();
        this.restClient = new HttpClientImpl(this.logger, timeout, proxySettings);
    }

    public int getTimeout() {
        return this.restClient.getTimeout();
    }

    protected void setServerUrlBase(URI serverUrl) {
        ArgumentGuard.notNull((Object)serverUrl, (String)"serverUrl");
        this.serverUrl = serverUrl;
    }

    protected URI getServerUrlBase() {
        return this.serverUrl;
    }

    protected void initClient() {
        if (this.restClient.isClosed()) {
            this.restClient = new HttpClientImpl(this.logger, this.getTimeout(), this.getProxy());
        }
    }

    public Response sendHttpWebRequest(final String url, String method, final String ... accept) {
        Request request = this.makeEyesRequest(new HttpRequestBuilder(){

            @Override
            public Request build() {
                return RestClient.this.restClient.target(url).request(accept);
            }
        });
        String currentTime = GeneralUtils.toRfc1123(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
        return request.header("Eyes-Date", currentTime).method(method, null, null);
    }

    protected Request makeEyesRequest(HttpRequestBuilder builder) {
        Request request = builder.build();
        if (this.agentId == null) {
            this.logger.log("Sending a request without agent id");
            return request;
        }
        return request.header(AGENT_ID_CUSTOM_HEADER, this.agentId);
    }

    protected Response sendLongRequest(Request request, String method, String data, String mediaType) throws EyesException {
        String currentTime = GeneralUtils.toRfc1123(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
        request = request.header("Eyes-Expect", "202+location").header("Eyes-Date", currentTime);
        Response response = request.method(method, (Object)data, mediaType);
        String statusUrl = response.getHeader("Location", false);
        int status = response.getStatusCode();
        if (statusUrl != null && status == 202) {
            response.close();
            int wait = 500;
            while (true) {
                if ((response = this.sendHttpWebRequest(statusUrl, "GET", new String[0])).getStatusCode() == 201) {
                    this.logger.verbose("exit (CREATED)");
                    return this.sendHttpWebRequest(response.getHeader("Location", false), "DELETE", new String[0]);
                }
                status = response.getStatusCode();
                if (status != 200) {
                    this.logger.verbose("exit (inside loop) (" + status + ")");
                    return response;
                }
                try {
                    Thread.sleep(wait);
                }
                catch (InterruptedException e) {
                    throw new EyesException("Long request interrupted!", (Throwable)e);
                }
                wait *= 2;
                wait = Math.min(10000, wait);
                response.close();
                this.logger.verbose("polling...");
            }
        }
        this.logger.verbose("exit (" + status + ")");
        return response;
    }

    protected String getReadResponseError(String errMsg, int statusCode, String statusPhrase, String responseBody) {
        ArgumentGuard.notNull((Object)statusPhrase, (String)"statusPhrase");
        if (errMsg == null) {
            errMsg = "";
        }
        if (responseBody == null) {
            responseBody = "";
        }
        return errMsg + " [" + statusCode + " " + statusPhrase + "] " + responseBody;
    }

    protected <T> T parseResponseWithJsonData(Response response, List<Integer> validHttpStatusCodes, TypeReference<T> resultType) throws EyesException {
        Object resultObject;
        ArgumentGuard.notNull((Object)response, (String)"response");
        ArgumentGuard.notNull(validHttpStatusCodes, (String)"validHttpStatusCodes");
        ArgumentGuard.notNull(resultType, (String)"resultType");
        int statusCode = response.getStatusCode();
        String statusPhrase = response.getStatusPhrase();
        String data = response.getBodyString();
        response.close();
        if (!validHttpStatusCodes.contains(statusCode)) {
            String errorMessage = this.getReadResponseError("Invalid status code", statusCode, statusPhrase, data);
            if (statusCode == 401 || statusCode == 403) {
                errorMessage = errorMessage + "\nThis is most likely due to an invalid API key.";
            }
            throw new EyesException(errorMessage);
        }
        try {
            resultObject = this.jsonMapper.readValue(data, resultType);
        }
        catch (IOException e) {
            String errorMessage = this.getReadResponseError("Failed deserialize response body", statusCode, statusPhrase, data);
            throw new EyesException(errorMessage, (Throwable)e);
        }
        return (T)resultObject;
    }

    protected static interface HttpRequestBuilder {
        public Request build();
    }

    protected static interface HttpMethodCall {
        public Response call();
    }
}

