/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.AccessibilityRegionType;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.GetAccessibilityRegion;
import com.applitools.eyes.Region;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collections;
import java.util.List;

public class AccessibilityRegionByRectangle
implements GetAccessibilityRegion {
    @JsonInclude
    private int left;
    @JsonInclude
    private int top;
    @JsonInclude
    private int width;
    @JsonInclude
    private int height;
    @JsonInclude
    private AccessibilityRegionType type;
    @JsonIgnore
    private Region region;

    public AccessibilityRegionByRectangle() {
    }

    public AccessibilityRegionByRectangle(int left, int top, int width, int height, AccessibilityRegionType regionType) {
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
        this.type = regionType;
    }

    public AccessibilityRegionByRectangle(Region region, AccessibilityRegionType regionType) {
        this.type = regionType;
        this.setRegion(region);
    }

    public Region getRegion() {
        return new Region(this.left, this.top, this.width, this.height);
    }

    public void setRegion(Region region) {
        this.region = region;
        this.left = region.getLeft();
        this.top = region.getTop();
        this.width = region.getWidth();
        this.height = region.getHeight();
    }

    public int getLeft() {
        return this.left;
    }

    public int getTop() {
        return this.top;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public AccessibilityRegionType getType() {
        return this.type;
    }

    @Override
    public List<AccessibilityRegionByRectangle> getRegions(EyesScreenshot screenshot) {
        return Collections.singletonList(this);
    }

    public String toString() {
        return "AccessibilityRegionByRectangle{left=" + this.left + ", top=" + this.top + ", width=" + this.width + ", height=" + this.height + ", type=" + (Object)((Object)this.type) + '}';
    }

    public int hashCode() {
        return this.left * 30000 + this.top * 2000 + this.width * 500 + this.height;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof AccessibilityRegionByRectangle)) {
            return false;
        }
        AccessibilityRegionByRectangle otherRegion = (AccessibilityRegionByRectangle)other;
        return otherRegion.width == this.width && otherRegion.height == this.height && otherRegion.left == this.left && otherRegion.top == this.top && otherRegion.type == this.type;
    }
}

