/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.IBatchCloser;
import com.applitools.eyes.LogHandler;
import com.applitools.eyes.Logger;
import com.applitools.eyes.TestResultsSummary;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public abstract class EyesRunner {
    protected Logger logger = new IdPrintingLogger("n/a");
    private Map<String, IBatchCloser> batchesServerConnectorsMap = new HashMap<String, IBatchCloser>();

    public abstract TestResultsSummary getAllTestResultsImpl();

    public abstract TestResultsSummary getAllTestResultsImpl(boolean var1);

    public TestResultsSummary getAllTestResults() {
        return this.getAllTestResults(true);
    }

    public TestResultsSummary getAllTestResults(boolean shouldThrowException) {
        TestResultsSummary allTestResults;
        try {
            allTestResults = this.getAllTestResultsImpl(shouldThrowException);
        }
        finally {
            this.deleteAllBatches();
        }
        return allTestResults;
    }

    private void deleteAllBatches() {
        for (String batch : this.batchesServerConnectorsMap.keySet()) {
            IBatchCloser connector = this.batchesServerConnectorsMap.get(batch);
            connector.closeBatch(batch);
        }
    }

    public void setLogHandler(LogHandler logHandler) {
        this.logger.setLogHandler(logHandler);
        if (!logHandler.isOpen()) {
            logHandler.open();
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void addBatch(String batchId, IBatchCloser batchCloser) {
        if (!this.batchesServerConnectorsMap.containsKey(batchId)) {
            this.batchesServerConnectorsMap.put(batchId, batchCloser);
        }
    }

    protected static class IdPrintingLogger
    extends Logger {
        protected final String runnerId = UUID.randomUUID().toString();
        protected final String suiteName;

        public IdPrintingLogger(String suiteName) {
            this.suiteName = suiteName;
        }

        protected int getMethodsBack() {
            return 4;
        }

        public String getPrefix() {
            return super.getPrefix() + this.suiteName + " (runnerId: " + this.runnerId + ") ";
        }
    }
}

