/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.OutOfBoundsException;
import com.applitools.eyes.Region;
import com.applitools.utils.ArgumentGuard;
import java.awt.image.BufferedImage;

public abstract class EyesScreenshot {
    protected final BufferedImage image;
    protected final Logger logger;
    protected String domUrl;

    public EyesScreenshot(Logger logger, BufferedImage image) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)image, (String)"image");
        this.image = image;
        this.logger = logger;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public String getDomUrl() {
        return this.domUrl;
    }

    public void setDomUrl(String domUrl) {
        this.domUrl = domUrl;
    }

    public abstract EyesScreenshot getSubScreenshot(Region var1, boolean var2);

    public abstract Location convertLocation(Location var1, CoordinatesType var2, CoordinatesType var3);

    public abstract Location getLocationInScreenshot(Location var1, CoordinatesType var2) throws OutOfBoundsException;

    public abstract Region getIntersectedRegion(Region var1, CoordinatesType var2);

    public Region convertRegionLocation(Region region, CoordinatesType from, CoordinatesType to) {
        ArgumentGuard.notNull((Object)region, (String)"region");
        if (region.isSizeEmpty()) {
            return new Region(region);
        }
        ArgumentGuard.notNull((Object)((Object)from), (String)"from");
        ArgumentGuard.notNull((Object)((Object)to), (String)"to");
        Location originalLocation = region.getLocation();
        this.logger.verbose("original location: " + originalLocation);
        Location updatedLocation = this.convertLocation(originalLocation, from, to);
        this.logger.verbose("updated location: " + updatedLocation);
        return new Region(updatedLocation, region.getSize());
    }
}

