/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.connectivity.ServerConnector;
import com.applitools.connectivity.api.Response;
import com.applitools.eyes.AccessibilityRegionByRectangle;
import com.applitools.eyes.AppOutput;
import com.applitools.eyes.EyesBase;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.FloatingMatchSettings;
import com.applitools.eyes.GetAccessibilityRegion;
import com.applitools.eyes.IRegion;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.OutOfBoundsException;
import com.applitools.eyes.Region;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.Trigger;
import com.applitools.eyes.capture.AppOutputProvider;
import com.applitools.eyes.capture.AppOutputWithScreenshot;
import com.applitools.eyes.config.Configuration;
import com.applitools.eyes.fluent.FloatingRegionByRectangle;
import com.applitools.eyes.fluent.GetFloatingRegion;
import com.applitools.eyes.fluent.GetSimpleRegion;
import com.applitools.eyes.fluent.ICheckSettingsInternal;
import com.applitools.eyes.fluent.IGetAccessibilityRegionType;
import com.applitools.eyes.fluent.SimpleRegionByRectangle;
import com.applitools.eyes.visualgrid.model.IGetFloatingRegionOffsets;
import com.applitools.eyes.visualgrid.model.MutableRegion;
import com.applitools.eyes.visualgrid.model.RenderingInfo;
import com.applitools.eyes.visualgrid.model.VisualGridSelector;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class MatchWindowTask {
    private static final int MATCH_INTERVAL = 500;
    private EyesScreenshot lastScreenshot = null;
    private Region lastScreenshotBounds;
    private String lastScreenshotHash;
    private int defaultRetryTimeout;
    protected Logger logger;
    protected ServerConnector serverConnector;
    protected RunningSession runningSession;
    protected AppOutputProvider appOutputProvider;
    protected MatchResult matchResult;
    protected EyesBase eyes;

    protected MatchWindowTask() {
    }

    public MatchWindowTask(Logger logger, ServerConnector serverConnector, RunningSession runningSession, int retryTimeout, EyesBase eyes, AppOutputProvider appOutputProvider) {
        ArgumentGuard.notNull((Object)serverConnector, (String)"serverConnector");
        ArgumentGuard.notNull((Object)runningSession, (String)"runningSession");
        ArgumentGuard.greaterThanOrEqualToZero((long)retryTimeout, (String)"retryTimeout");
        ArgumentGuard.notNull((Object)appOutputProvider, (String)"appOutputProvider");
        this.logger = logger;
        this.serverConnector = serverConnector;
        this.runningSession = runningSession;
        this.defaultRetryTimeout = retryTimeout;
        this.eyes = eyes;
        this.appOutputProvider = appOutputProvider;
    }

    public MatchWindowTask(Logger logger, ServerConnector serverConnector, RunningSession runningSession, int retryTimeout, EyesBase eyes) {
        ArgumentGuard.notNull((Object)serverConnector, (String)"serverConnector");
        ArgumentGuard.notNull((Object)runningSession, (String)"runningSession");
        ArgumentGuard.greaterThanOrEqualToZero((long)retryTimeout, (String)"retryTimeout");
        this.logger = logger;
        this.serverConnector = serverConnector;
        this.runningSession = runningSession;
        this.defaultRetryTimeout = retryTimeout;
        this.eyes = eyes;
        this.appOutputProvider = null;
    }

    public MatchResult performMatch(List<Trigger> userInputs, AppOutputWithScreenshot appOutput, String tag, boolean replaceLast, ImageMatchSettings imageMatchSettings, EyesBase eyes, String source) {
        eyes.getLogger().verbose("enter");
        String agentSetupStr = "";
        Object agentSetup = eyes.getAgentSetup();
        ObjectMapper jsonMapper = new ObjectMapper();
        try {
            agentSetupStr = jsonMapper.writeValueAsString(agentSetup);
        }
        catch (JsonProcessingException e) {
            GeneralUtils.logExceptionStackTrace(this.logger, e);
        }
        MatchResult result = this.performMatch(userInputs, appOutput, tag, replaceLast, imageMatchSettings, agentSetupStr, null, source);
        eyes.getLogger().verbose("exit");
        return result;
    }

    public MatchResult performMatch(AppOutputWithScreenshot appOutput, String tag, ICheckSettingsInternal checkSettingsInternal, ImageMatchSettings imageMatchSettings, List<? extends IRegion> regions, List<VisualGridSelector[]> regionSelectors, EyesBase eyes, String renderId, String source) {
        String agentSetupStr = (String)eyes.getAgentSetup();
        MatchWindowTask.collectRegions(imageMatchSettings, regions, regionSelectors);
        this.collectRegions(imageMatchSettings, checkSettingsInternal);
        return this.performMatch(new ArrayList<Trigger>(), appOutput, tag, false, imageMatchSettings, agentSetupStr, renderId, source);
    }

    private MatchResult performMatch(List<Trigger> userInputs, AppOutputWithScreenshot appOutput, String tag, boolean replaceLast, ImageMatchSettings imageMatchSettings, String agentSetupStr, String renderId, String source) {
        MatchWindowData.Options options = new MatchWindowData.Options(tag, userInputs.toArray(new Trigger[0]), replaceLast, false, false, false, false, imageMatchSettings, source, renderId);
        MatchWindowData data = new MatchWindowData(userInputs.toArray(new Trigger[0]), appOutput.getAppOutput(), tag, false, options, agentSetupStr, renderId);
        if (!this.tryUploadImage(data)) {
            throw new EyesException("matchWindow failed: could not upload image to storage service.");
        }
        return this.serverConnector.matchWindow(this.runningSession, data);
    }

    private boolean tryUploadImage(MatchWindowData data) {
        AppOutput appOutput = data.getAppOutput();
        if (appOutput.getScreenshotUrl() != null) {
            return true;
        }
        byte[] bytes = appOutput.getScreenshotBytes();
        String targetUrl = this.tryUploadData(bytes, "image/png", "image/png");
        appOutput.setScreenshotUrl(targetUrl);
        return targetUrl != null;
    }

    public String tryUploadData(byte[] bytes, String contentType, String mediaType) {
        String targetUrl;
        RenderingInfo renderingInfo = this.serverConnector.getRenderInfo();
        if (renderingInfo != null && (targetUrl = renderingInfo.getResultsUrl()) != null) {
            try {
                UUID uuid = UUID.randomUUID();
                targetUrl = targetUrl.replace("__random__", uuid.toString());
                this.logger.verbose("uploading " + mediaType + " to " + targetUrl);
                int retriesLeft = 3;
                int wait = 500;
                while (retriesLeft-- > 0) {
                    block7: {
                        try {
                            Response response = this.serverConnector.uploadData(bytes, renderingInfo, targetUrl, contentType, mediaType);
                            int statusCode = response.getStatusCode();
                            response.close();
                            if (statusCode == 200 || statusCode == 201) {
                                this.logger.verbose("upload " + mediaType + " guid " + uuid + "complete.");
                                return targetUrl;
                            }
                            if (statusCode >= 500) break block7;
                            break;
                        }
                        catch (Exception e) {
                            if (retriesLeft != 0) break block7;
                            throw e;
                        }
                    }
                    Thread.sleep(wait);
                    wait *= 2;
                    wait = Math.min(10000, wait);
                }
            }
            catch (Exception e) {
                this.logger.log("Error uploading " + mediaType);
                GeneralUtils.logExceptionStackTrace(this.logger, e);
            }
        }
        return null;
    }

    public static void collectRegions(EyesBase eyes, EyesScreenshot screenshot, ICheckSettingsInternal checkSettingsInternal, ImageMatchSettings imageMatchSettings) {
        eyes.getLogger().verbose("enter");
        MatchWindowTask.collectSimpleRegions(eyes, checkSettingsInternal, imageMatchSettings, screenshot);
        MatchWindowTask.collectFloatingRegions(checkSettingsInternal, imageMatchSettings, screenshot);
        MatchWindowTask.collectAccessibilityRegions(checkSettingsInternal, imageMatchSettings, screenshot);
        MatchWindowTask.logRegions(eyes.getLogger(), imageMatchSettings);
        eyes.getLogger().verbose("exit");
    }

    private void collectRegions(ImageMatchSettings imageMatchSettings, ICheckSettingsInternal checkSettingsInternal) {
        imageMatchSettings.setIgnoreRegions(MatchWindowTask.convertSimpleRegions(checkSettingsInternal.getIgnoreRegions(), imageMatchSettings.getIgnoreRegions()));
        imageMatchSettings.setContentRegions(MatchWindowTask.convertSimpleRegions(checkSettingsInternal.getContentRegions(), imageMatchSettings.getContentRegions()));
        imageMatchSettings.setLayoutRegions(MatchWindowTask.convertSimpleRegions(checkSettingsInternal.getLayoutRegions(), imageMatchSettings.getLayoutRegions()));
        imageMatchSettings.setStrictRegions(MatchWindowTask.convertSimpleRegions(checkSettingsInternal.getStrictRegions(), imageMatchSettings.getStrictRegions()));
        imageMatchSettings.setFloatingRegions(this.convertFloatingRegions(checkSettingsInternal.getFloatingRegions(), imageMatchSettings.getFloatingRegions()));
        imageMatchSettings.setAccessibility(this.convertAccessibilityRegions(checkSettingsInternal.getAccessibilityRegions(), imageMatchSettings.getAccessibility()));
    }

    private AccessibilityRegionByRectangle[] convertAccessibilityRegions(GetAccessibilityRegion[] accessibilityRegions, AccessibilityRegionByRectangle[] currentRegions) {
        ArrayList<AccessibilityRegionByRectangle> mutableRegions = new ArrayList<AccessibilityRegionByRectangle>();
        if (currentRegions != null) {
            mutableRegions.addAll(Arrays.asList(currentRegions));
        }
        for (GetAccessibilityRegion getRegions : accessibilityRegions) {
            if (!(getRegions instanceof AccessibilityRegionByRectangle)) continue;
            mutableRegions.addAll(getRegions.getRegions(null));
        }
        return mutableRegions.toArray(new AccessibilityRegionByRectangle[0]);
    }

    private static Region[] convertSimpleRegions(GetSimpleRegion[] simpleRegions, Region[] currentRegions) {
        ArrayList<Region> mutableRegions = new ArrayList<Region>();
        if (currentRegions != null) {
            Collections.addAll(mutableRegions, currentRegions);
        }
        for (GetSimpleRegion simpleRegion : simpleRegions) {
            if (!(simpleRegion instanceof SimpleRegionByRectangle)) continue;
            mutableRegions.addAll(simpleRegion.getRegions(null));
        }
        return mutableRegions.toArray(new Region[0]);
    }

    private FloatingMatchSettings[] convertFloatingRegions(GetFloatingRegion[] floatingRegions, FloatingMatchSettings[] currentRegions) {
        ArrayList<FloatingMatchSettings> mutableRegions = new ArrayList<FloatingMatchSettings>();
        if (currentRegions != null) {
            Collections.addAll(mutableRegions, currentRegions);
        }
        for (GetFloatingRegion getRegions : floatingRegions) {
            if (!(getRegions instanceof FloatingRegionByRectangle)) continue;
            mutableRegions.addAll(getRegions.getRegions(null));
        }
        return mutableRegions.toArray(new FloatingMatchSettings[0]);
    }

    private static void collectRegions(ImageMatchSettings imageMatchSettings, List<? extends IRegion> regions, List<VisualGridSelector[]> regionSelectors) {
        if (regions == null) {
            return;
        }
        int currentCounter = 0;
        int currentTypeIndex = 0;
        int currentTypeRegionCount = regionSelectors.get(0).length;
        ArrayList mutableRegions = new ArrayList();
        mutableRegions.add(new ArrayList());
        mutableRegions.add(new ArrayList());
        mutableRegions.add(new ArrayList());
        mutableRegions.add(new ArrayList());
        mutableRegions.add(new ArrayList());
        mutableRegions.add(new ArrayList());
        mutableRegions.add(new ArrayList());
        for (IRegion iRegion : regions) {
            boolean canAddRegion = false;
            while (!canAddRegion) {
                if (++currentCounter > currentTypeRegionCount) {
                    currentTypeRegionCount = regionSelectors.get(++currentTypeIndex).length;
                    currentCounter = 0;
                    continue;
                }
                canAddRegion = true;
            }
            MutableRegion mr = new MutableRegion(iRegion);
            ((List)mutableRegions.get(currentTypeIndex)).add(mr);
        }
        Location location = Location.ZERO;
        int n = mutableRegions.size() - 1;
        if (((List)mutableRegions.get(n)).size() > 0) {
            location = ((MutableRegion)((List)mutableRegions.get(n)).get(0)).getLocation();
        }
        imageMatchSettings.setIgnoreRegions(MatchWindowTask.filterEmptyEntries((List)mutableRegions.get(0), location));
        imageMatchSettings.setLayoutRegions(MatchWindowTask.filterEmptyEntries((List)mutableRegions.get(1), location));
        imageMatchSettings.setStrictRegions(MatchWindowTask.filterEmptyEntries((List)mutableRegions.get(2), location));
        imageMatchSettings.setContentRegions(MatchWindowTask.filterEmptyEntries((List)mutableRegions.get(3), location));
        ArrayList<FloatingMatchSettings> floatingMatchSettings = new ArrayList<FloatingMatchSettings>();
        for (int i = 0; i < regionSelectors.get(4).length; ++i) {
            VisualGridSelector vgs;
            MutableRegion mr = (MutableRegion)((List)mutableRegions.get(4)).get(i);
            if (mr.getArea() == 0 || !((vgs = regionSelectors.get(4)[i]).getCategory() instanceof IGetFloatingRegionOffsets)) continue;
            IGetFloatingRegionOffsets gfr = (IGetFloatingRegionOffsets)vgs.getCategory();
            FloatingMatchSettings fms = new FloatingMatchSettings(mr.getLeft(), mr.getTop(), mr.getWidth(), mr.getHeight(), gfr.getMaxUpOffset(), gfr.getMaxDownOffset(), gfr.getMaxLeftOffset(), gfr.getMaxRightOffset());
            floatingMatchSettings.add(fms);
        }
        imageMatchSettings.setFloatingRegions(floatingMatchSettings.toArray(new FloatingMatchSettings[0]));
        ArrayList<AccessibilityRegionByRectangle> accessibilityRegions = new ArrayList<AccessibilityRegionByRectangle>();
        VisualGridSelector[] visualGridSelectors = regionSelectors.get(5);
        for (int i = 0; i < visualGridSelectors.length; ++i) {
            VisualGridSelector vgs;
            MutableRegion mr = (MutableRegion)((List)mutableRegions.get(5)).get(i);
            if (mr.getArea() == 0 || !((vgs = visualGridSelectors[i]).getCategory() instanceof IGetAccessibilityRegionType)) continue;
            IGetAccessibilityRegionType gar = (IGetAccessibilityRegionType)vgs.getCategory();
            AccessibilityRegionByRectangle accessibilityRegion = new AccessibilityRegionByRectangle(mr.getLeft() - location.getX(), mr.getTop() - location.getY(), mr.getWidth(), mr.getHeight(), gar.getAccessibilityRegionType());
            accessibilityRegions.add(accessibilityRegion);
        }
        imageMatchSettings.setAccessibility(accessibilityRegions.toArray(new AccessibilityRegionByRectangle[0]));
    }

    private static MutableRegion[] filterEmptyEntries(List<MutableRegion> list, Location location) {
        for (int i = list.size() - 1; i >= 0; --i) {
            MutableRegion mutableRegion = list.get(i);
            if (mutableRegion.getArea() == 0) {
                list.remove(i);
                continue;
            }
            mutableRegion.offset(-location.getX(), -location.getY());
        }
        return list.toArray(new MutableRegion[0]);
    }

    private static void collectSimpleRegions(ICheckSettingsInternal checkSettingsInternal, ImageMatchSettings imageMatchSettings, EyesScreenshot screenshot) {
        imageMatchSettings.setIgnoreRegions(MatchWindowTask.collectSimpleRegions(screenshot, checkSettingsInternal.getIgnoreRegions()));
        imageMatchSettings.setStrictRegions(MatchWindowTask.collectSimpleRegions(screenshot, checkSettingsInternal.getStrictRegions()));
        imageMatchSettings.setLayoutRegions(MatchWindowTask.collectSimpleRegions(screenshot, checkSettingsInternal.getLayoutRegions()));
        imageMatchSettings.setContentRegions(MatchWindowTask.collectSimpleRegions(screenshot, checkSettingsInternal.getContentRegions()));
    }

    /*
     * WARNING - void declaration
     */
    private static Region[] collectSimpleRegions(EyesScreenshot screenshot, GetSimpleRegion[] regionProviders) {
        void var5_7;
        ArrayList<List<Region>> mutableRegions = new ArrayList<List<Region>>();
        GetSimpleRegion[] getSimpleRegionArray = regionProviders;
        int n = getSimpleRegionArray.length;
        boolean bl = false;
        while (var5_7 < n) {
            GetSimpleRegion regionProvider = getSimpleRegionArray[var5_7];
            mutableRegions.add(regionProvider.getRegions(screenshot));
            ++var5_7;
        }
        ArrayList allRegions = new ArrayList();
        for (List list : mutableRegions) {
            allRegions.addAll(list);
        }
        return allRegions.toArray(new Region[0]);
    }

    private static void collectFloatingRegions(ICheckSettingsInternal checkSettingsInternal, ImageMatchSettings imageMatchSettings, EyesScreenshot screenshot) {
        ArrayList<FloatingMatchSettings> floatingRegions = new ArrayList<FloatingMatchSettings>();
        for (GetFloatingRegion floatingRegion : checkSettingsInternal.getFloatingRegions()) {
            List<FloatingMatchSettings> regions = floatingRegion.getRegions(screenshot);
            floatingRegions.addAll(regions);
        }
        imageMatchSettings.setFloatingRegions(floatingRegions.toArray(new FloatingMatchSettings[0]));
    }

    public MatchResult matchWindow(Trigger[] userInputs, Region region, String tag, boolean shouldRunOnceOnTimeout, ICheckSettingsInternal checkSettingsInternal, String source) {
        ImageMatchSettings imageMatchSettings = MatchWindowTask.createImageMatchSettings(checkSettingsInternal, this.eyes);
        int retryTimeout = checkSettingsInternal.getTimeout();
        if (retryTimeout < 0) {
            retryTimeout = this.defaultRetryTimeout;
        }
        this.logger.verbose(String.format("retryTimeout = %d", retryTimeout));
        EyesScreenshot screenshot = this.takeScreenshot(userInputs, region, tag, shouldRunOnceOnTimeout, checkSettingsInternal, imageMatchSettings, retryTimeout, source);
        this.updateLastScreenshot(screenshot);
        return this.matchResult;
    }

    private static void collectSimpleRegions(EyesBase eyes, ICheckSettingsInternal checkSettingsInternal, ImageMatchSettings imageMatchSettings, EyesScreenshot screenshot) {
        imageMatchSettings.setIgnoreRegions(MatchWindowTask.collectSimpleRegions(eyes, checkSettingsInternal.getIgnoreRegions(), screenshot));
        imageMatchSettings.setLayoutRegions(MatchWindowTask.collectSimpleRegions(eyes, checkSettingsInternal.getLayoutRegions(), screenshot));
        imageMatchSettings.setStrictRegions(MatchWindowTask.collectSimpleRegions(eyes, checkSettingsInternal.getStrictRegions(), screenshot));
        imageMatchSettings.setContentRegions(MatchWindowTask.collectSimpleRegions(eyes, checkSettingsInternal.getContentRegions(), screenshot));
    }

    private static Region[] collectSimpleRegions(EyesBase eyes, GetSimpleRegion[] regionProviders, EyesScreenshot screenshot) {
        ArrayList<Region> regions = new ArrayList<Region>();
        for (GetSimpleRegion regionProvider : regionProviders) {
            try {
                regions.addAll(regionProvider.getRegions(screenshot));
            }
            catch (OutOfBoundsException ex) {
                eyes.getLogger().log("WARNING - region was out of bounds.");
            }
        }
        return regions.toArray(new Region[0]);
    }

    public static ImageMatchSettings createImageMatchSettings(ICheckSettingsInternal checkSettingsInternal, EyesScreenshot screenshot, EyesBase eyesBase) {
        eyesBase.getLogger().verbose("enter");
        ImageMatchSettings imageMatchSettings = MatchWindowTask.createImageMatchSettings(checkSettingsInternal, eyesBase);
        if (imageMatchSettings != null) {
            MatchWindowTask.collectSimpleRegions(eyesBase, checkSettingsInternal, imageMatchSettings, screenshot);
            MatchWindowTask.collectFloatingRegions(checkSettingsInternal, imageMatchSettings, screenshot);
            MatchWindowTask.collectAccessibilityRegions(checkSettingsInternal, imageMatchSettings, screenshot);
            MatchWindowTask.logRegions(eyesBase.getLogger(), imageMatchSettings);
        }
        eyesBase.getLogger().verbose("exit");
        return imageMatchSettings;
    }

    public static ImageMatchSettings createImageMatchSettings(ICheckSettingsInternal checkSettingsInternal, EyesBase eyes) {
        ImageMatchSettings imageMatchSettings = null;
        if (checkSettingsInternal != null) {
            Configuration config = eyes.getConfigurationInstance();
            ImageMatchSettings defaultMatchSettings = config.getDefaultMatchSettings();
            imageMatchSettings = new ImageMatchSettings(defaultMatchSettings);
            imageMatchSettings.setMatchLevel(checkSettingsInternal.getMatchLevel() != null ? checkSettingsInternal.getMatchLevel() : defaultMatchSettings.getMatchLevel());
            imageMatchSettings.setIgnoreCaret(checkSettingsInternal.getIgnoreCaret() != null ? checkSettingsInternal.getIgnoreCaret().booleanValue() : config.getIgnoreCaret());
            imageMatchSettings.setUseDom(checkSettingsInternal.isUseDom() != null ? checkSettingsInternal.isUseDom().booleanValue() : config.getUseDom());
            imageMatchSettings.setEnablePatterns(checkSettingsInternal.isEnablePatterns() != null ? checkSettingsInternal.isEnablePatterns().booleanValue() : config.getEnablePatterns());
            imageMatchSettings.setIgnoreDisplacements(checkSettingsInternal.isIgnoreDisplacements() != null ? checkSettingsInternal.isIgnoreDisplacements().booleanValue() : config.getIgnoreDisplacements());
            imageMatchSettings.setAccessibilitySettings(config.getAccessibilityValidation());
        }
        return imageMatchSettings;
    }

    private EyesScreenshot takeScreenshot(Trigger[] userInputs, Region region, String tag, boolean shouldMatchWindowRunOnceOnTimeout, ICheckSettingsInternal checkSettingsInternal, ImageMatchSettings imageMatchSettings, int retryTimeout, String source) {
        EyesScreenshot screenshot;
        long elapsedTimeStart = System.currentTimeMillis();
        this.lastScreenshotHash = null;
        if (0 == retryTimeout || shouldMatchWindowRunOnceOnTimeout) {
            if (shouldMatchWindowRunOnceOnTimeout) {
                GeneralUtils.sleep(retryTimeout);
            }
            screenshot = this.tryTakeScreenshot(userInputs, region, tag, checkSettingsInternal, imageMatchSettings, source);
        } else {
            screenshot = this.retryTakingScreenshot(userInputs, region, tag, checkSettingsInternal, imageMatchSettings, retryTimeout, source);
        }
        double elapsedTime = (System.currentTimeMillis() - elapsedTimeStart) / 1000L;
        this.logger.verbose(String.format("Completed in %.2f seconds", elapsedTime));
        return screenshot;
    }

    private EyesScreenshot retryTakingScreenshot(Trigger[] userInputs, Region region, String tag, ICheckSettingsInternal checkSettingsInternal, ImageMatchSettings imageMatchSettings, int retryTimeout, String source) {
        long start = System.currentTimeMillis();
        EyesScreenshot screenshot = null;
        long retry = System.currentTimeMillis() - start;
        while (retry < (long)retryTimeout) {
            GeneralUtils.sleep(500L);
            screenshot = this.tryTakeScreenshot(userInputs, region, tag, checkSettingsInternal, imageMatchSettings, source);
            if (this.matchResult.getAsExpected()) break;
            retry = System.currentTimeMillis() - start;
        }
        if (!this.matchResult.getAsExpected()) {
            screenshot = this.tryTakeScreenshot(userInputs, region, tag, checkSettingsInternal, imageMatchSettings, source);
        }
        return screenshot;
    }

    private EyesScreenshot tryTakeScreenshot(Trigger[] userInputs, Region region, String tag, ICheckSettingsInternal checkSettingsInternal, ImageMatchSettings imageMatchSettings, String source) {
        AppOutputWithScreenshot appOutput = this.appOutputProvider.getAppOutput(region, checkSettingsInternal, imageMatchSettings);
        EyesScreenshot screenshot = appOutput.getScreenshot();
        AppOutput output = appOutput.getAppOutput();
        String currentScreenshotHash = GeneralUtils.getSha256hash(output.getScreenshotBytes());
        if (currentScreenshotHash.equals(this.lastScreenshotHash)) {
            this.logger.log("Got the same screenshot in retry. Not sending to the server.");
            return screenshot;
        }
        ImageMatchSettings matchSettings = MatchWindowTask.createImageMatchSettings(checkSettingsInternal, screenshot, this.eyes);
        this.matchResult = this.performMatch(Arrays.asList(userInputs), appOutput, tag, this.lastScreenshotHash != null, matchSettings, this.eyes, source);
        this.lastScreenshotHash = currentScreenshotHash;
        return screenshot;
    }

    private void updateLastScreenshot(EyesScreenshot screenshot) {
        if (screenshot != null) {
            this.lastScreenshot = screenshot;
        }
    }

    private void updateBounds(Region region) {
        if (region.isSizeEmpty()) {
            if (this.lastScreenshot == null) {
                this.lastScreenshotBounds = new Region(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
            } else {
                BufferedImage image = this.lastScreenshot.getImage();
                this.lastScreenshotBounds = new Region(0, 0, image.getWidth(), image.getHeight());
            }
        } else {
            this.lastScreenshotBounds = region;
        }
    }

    public Region getLastScreenshotBounds() {
        return this.lastScreenshotBounds;
    }

    private static void collectAccessibilityRegions(ICheckSettingsInternal checkSettingsInternal, ImageMatchSettings imageMatchSettings, EyesScreenshot screenshot) {
        ArrayList<AccessibilityRegionByRectangle> accessibilityRegions = new ArrayList<AccessibilityRegionByRectangle>();
        for (GetAccessibilityRegion regionProvider : checkSettingsInternal.getAccessibilityRegions()) {
            accessibilityRegions.addAll(regionProvider.getRegions(screenshot));
        }
        imageMatchSettings.setAccessibility(accessibilityRegions.toArray(new AccessibilityRegionByRectangle[0]));
    }

    private static void logRegions(Logger logger, ImageMatchSettings ims) {
        MatchWindowTask.logTypedRegions(logger, "Ignore", ims.getIgnoreRegions());
        MatchWindowTask.logTypedRegions(logger, "Strict", ims.getStrictRegions());
        MatchWindowTask.logTypedRegions(logger, "Content", ims.getContentRegions());
        MatchWindowTask.logTypedRegions(logger, "Layout", ims.getLayoutRegions());
        MatchWindowTask.logTypedRegions(logger, "Floating", ims.getFloatingRegions());
        MatchWindowTask.logTypedRegions(logger, "Accessibility", ims.getAccessibility());
    }

    private static void logTypedRegions(Logger logger, String regionType, Object[] regions) {
        if (regions == null || regions.length == 0) {
            logger.verbose(regionType + " Regions list is null or empty");
            return;
        }
        logger.verbose(regionType + " Regions:");
        for (Object region : regions) {
            logger.verbose("    " + region);
        }
    }
}

