/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.config;

import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.AccessibilitySettings;
import com.applitools.eyes.BatchInfo;
import com.applitools.eyes.FailureReports;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.SessionType;
import com.applitools.eyes.config.Feature;
import com.applitools.eyes.config.IConfiguration;
import com.applitools.eyes.selenium.BrowserType;
import com.applitools.eyes.selenium.StitchMode;
import com.applitools.eyes.visualgrid.model.ChromeEmulationInfo;
import com.applitools.eyes.visualgrid.model.DesktopBrowserInfo;
import com.applitools.eyes.visualgrid.model.DeviceName;
import com.applitools.eyes.visualgrid.model.IRenderingBrowserInfo;
import com.applitools.eyes.visualgrid.model.IosDeviceInfo;
import com.applitools.eyes.visualgrid.model.RenderBrowserInfo;
import com.applitools.eyes.visualgrid.model.ScreenOrientation;
import com.applitools.utils.GeneralUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Configuration
implements IConfiguration {
    private static final int DEFAULT_MATCH_TIMEOUT = 2000;
    private static final int DEFAULT_WAIT_BEFORE_SCREENSHOTS = 100;
    private String branchName = GeneralUtils.getEnvString("APPLITOOLS_BRANCH");
    private String parentBranchName = GeneralUtils.getEnvString("APPLITOOLS_PARENT_BRANCH");
    private String baselineBranchName = GeneralUtils.getEnvString("APPLITOOLS_BASELINE_BRANCH");
    private String agentId;
    private String environmentName;
    private Boolean saveDiffs;
    private SessionType sessionType;
    protected BatchInfo batch = new BatchInfo(null);
    protected String baselineEnvName;
    protected String appName;
    protected String testName;
    protected RectangleSize viewportSize;
    protected boolean ignoreDisplacements = false;
    protected ImageMatchSettings defaultMatchSettings = new ImageMatchSettings();
    private int matchTimeout = 2000;
    private String hostApp;
    private String hostOS;
    private boolean saveNewTests;
    private boolean saveFailedTests;
    private int stitchOverlap = 10;
    private Boolean isSendDom = true;
    private String apiKey = null;
    private String serverUrl = null;
    private AbstractProxySettings proxy = null;
    private FailureReports failureReports = FailureReports.ON_CLOSE;
    private AccessibilitySettings accessibilitySettings = null;
    private boolean enablePatterns;
    private boolean useDom;
    private Boolean forceFullPageScreenshot;
    private int waitBeforeScreenshots = 100;
    private StitchMode stitchMode = StitchMode.SCROLL;
    private boolean hideScrollbars = true;
    private boolean hideCaret = true;
    private boolean isVisualGrid = false;
    private Boolean isRenderingConfig = false;
    private List<RenderBrowserInfo> browsersInfo = new ArrayList<RenderBrowserInfo>();
    private Set<Feature> features = new HashSet<Feature>();

    public Configuration(Configuration other) {
        this.branchName = other.getBranchName();
        this.parentBranchName = other.getParentBranchName();
        this.baselineBranchName = other.getBaselineBranchName();
        this.agentId = other.getAgentId();
        this.environmentName = other.getEnvironmentName();
        this.saveDiffs = other.getSaveDiffs();
        this.sessionType = other.getSessionType();
        this.batch = other.getBatch();
        this.baselineEnvName = other.getBaselineEnvName();
        this.appName = other.getAppName();
        this.testName = other.getTestName();
        this.viewportSize = other.getViewportSize();
        this.defaultMatchSettings = new ImageMatchSettings(other.getDefaultMatchSettings());
        this.matchTimeout = other.getMatchTimeout();
        this.hostApp = other.getHostApp();
        this.hostOS = other.getHostOS();
        this.saveNewTests = other.getSaveNewTests();
        this.saveFailedTests = other.getSaveFailedTests();
        this.stitchOverlap = other.getStitchOverlap();
        this.isSendDom = other.isSendDom();
        this.apiKey = other.getApiKey();
        this.useDom = other.getUseDom();
        this.enablePatterns = other.getEnablePatterns();
        URI serverUrl = other.getServerUrl();
        if (serverUrl != null) {
            this.serverUrl = serverUrl.toString();
        }
        this.failureReports = other.getFailureReports();
        this.proxy = other.getProxy();
        if (other.getMatchLevel() != null) {
            this.defaultMatchSettings.setMatchLevel(other.getMatchLevel());
        }
        this.ignoreDisplacements = other.getIgnoreDisplacements();
        this.accessibilitySettings = other.getAccessibilityValidation();
        this.forceFullPageScreenshot = other.getForceFullPageScreenshot();
        this.waitBeforeScreenshots = other.getWaitBeforeScreenshots();
        this.stitchMode = other.getStitchMode();
        this.hideScrollbars = other.getHideScrollbars();
        this.hideCaret = other.getHideCaret();
        this.isRenderingConfig = other.isRenderingConfig();
        this.browsersInfo.addAll(other.getBrowsersInfo());
        this.defaultMatchSettings = new ImageMatchSettings(other.getDefaultMatchSettings());
        this.isVisualGrid = other.isVisualGrid();
        this.features = other.features;
    }

    public Configuration() {
        this.defaultMatchSettings.setIgnoreCaret(true);
        this.agentId = null;
        this.saveNewTests = true;
        this.saveFailedTests = false;
    }

    public Configuration(RectangleSize viewportSize) {
        this();
        ArrayList<RenderBrowserInfo> browsersInfo = new ArrayList<RenderBrowserInfo>();
        browsersInfo.add(new RenderBrowserInfo(viewportSize.getWidth(), viewportSize.getHeight(), BrowserType.CHROME, null));
        this.browsersInfo = browsersInfo;
    }

    public Configuration(String testName) {
        this.testName = testName;
    }

    public Configuration(String appName, String testName, RectangleSize viewportSize) {
        this();
        ArrayList<RenderBrowserInfo> browsersInfo = new ArrayList<RenderBrowserInfo>();
        if (viewportSize != null) {
            browsersInfo.add(new RenderBrowserInfo(viewportSize.getWidth(), viewportSize.getHeight(), BrowserType.CHROME, null));
        }
        this.browsersInfo = browsersInfo;
        this.testName = testName;
        this.viewportSize = viewportSize;
        this.setAppName(appName);
    }

    @Override
    public boolean getSaveNewTests() {
        return this.saveNewTests;
    }

    @Override
    public Configuration setSaveNewTests(boolean saveNewTests) {
        this.saveNewTests = saveNewTests;
        return this;
    }

    @Override
    public boolean getSaveFailedTests() {
        return this.saveFailedTests;
    }

    @Override
    public Configuration setSaveFailedTests(boolean saveFailedTests) {
        this.saveFailedTests = saveFailedTests;
        return this;
    }

    @Override
    public ImageMatchSettings getDefaultMatchSettings() {
        return this.defaultMatchSettings;
    }

    @Override
    public Configuration setDefaultMatchSettings(ImageMatchSettings defaultMatchSettings) {
        this.defaultMatchSettings = defaultMatchSettings;
        return this;
    }

    @Override
    public int getMatchTimeout() {
        return this.matchTimeout;
    }

    @Override
    public Configuration setMatchTimeout(int matchTimeout) {
        this.matchTimeout = matchTimeout;
        return this;
    }

    @Override
    public String getHostApp() {
        return this.hostApp;
    }

    @Override
    public Configuration setHostApp(String hostApp) {
        this.hostApp = hostApp;
        return this;
    }

    @Override
    public String getHostOS() {
        return this.hostOS;
    }

    @Override
    public Configuration setHostOS(String hostOS) {
        this.hostOS = hostOS;
        return this;
    }

    @Override
    public int getStitchOverlap() {
        return this.stitchOverlap;
    }

    @Override
    public Configuration setStitchOverlap(int stitchOverlap) {
        this.stitchOverlap = stitchOverlap;
        return this;
    }

    @Override
    public Configuration setBatch(BatchInfo batch) {
        this.batch = batch;
        return this;
    }

    @Override
    public BatchInfo getBatch() {
        return this.batch;
    }

    @Override
    public Configuration setBranchName(String branchName) {
        this.branchName = branchName;
        return this;
    }

    @Override
    public String getBranchName() {
        return this.branchName;
    }

    @Override
    public String getAgentId() {
        return this.agentId;
    }

    @Override
    public Configuration setAgentId(String agentId) {
        this.agentId = agentId;
        return this;
    }

    @Override
    public String getParentBranchName() {
        return this.parentBranchName;
    }

    @Override
    public Configuration setParentBranchName(String parentBranchName) {
        this.parentBranchName = parentBranchName;
        return this;
    }

    @Override
    public String getBaselineBranchName() {
        return this.baselineBranchName;
    }

    @Override
    public Configuration setBaselineBranchName(String baselineBranchName) {
        this.baselineBranchName = baselineBranchName;
        return this;
    }

    @Override
    public String getBaselineEnvName() {
        return this.baselineEnvName;
    }

    @Override
    public Configuration setBaselineEnvName(String baselineEnvName) {
        this.baselineEnvName = baselineEnvName;
        return this;
    }

    @Override
    public String getEnvironmentName() {
        return this.environmentName;
    }

    @Override
    public Configuration setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
        return this;
    }

    @Override
    public Boolean getSaveDiffs() {
        return this.saveDiffs;
    }

    @Override
    public Configuration setSaveDiffs(Boolean saveDiffs) {
        this.saveDiffs = saveDiffs;
        return this;
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public Configuration setAppName(String appName) {
        this.appName = appName;
        return this;
    }

    @Override
    public String getTestName() {
        return this.testName;
    }

    @Override
    public Configuration setTestName(String testName) {
        this.testName = testName;
        return this;
    }

    @Override
    public RectangleSize getViewportSize() {
        if (this.isRenderingConfig.booleanValue()) {
            RenderBrowserInfo renderBrowserInfo = this.browsersInfo.get(0);
            return new RectangleSize(renderBrowserInfo.getWidth(), renderBrowserInfo.getHeight());
        }
        return this.viewportSize;
    }

    @Override
    public Configuration setViewportSize(RectangleSize viewportSize) {
        this.viewportSize = viewportSize;
        return this;
    }

    @Override
    public SessionType getSessionType() {
        return this.sessionType;
    }

    @Override
    public Configuration setSessionType(SessionType sessionType) {
        this.sessionType = sessionType;
        return this;
    }

    @Override
    public Configuration setFailureReports(FailureReports failureReports) {
        this.failureReports = failureReports;
        return this;
    }

    @Override
    public FailureReports getFailureReports() {
        return this.failureReports;
    }

    public String toString() {
        return super.toString() + "\n\tbatch = " + this.batch + "\n\tbranchName = " + this.branchName + "\n\tparentBranchName = " + this.parentBranchName + "\n\tagentId = " + this.agentId + "\n\tbaselineEnvName = " + this.baselineEnvName + "\n\tenvironmentName = " + this.environmentName + "\n\tsaveDiffs = " + this.saveDiffs + "\n\tappName = " + this.appName + "\n\ttestName = " + this.testName + "\n\tviewportSize = " + this.viewportSize + "\n\tsessionType = " + (Object)((Object)this.sessionType) + "\n\tforceFullPageScreenshot = " + this.forceFullPageScreenshot + "\n\twaitBeforeScreenshots = " + this.waitBeforeScreenshots + "\n\tstitchMode = " + (Object)((Object)this.stitchMode) + "\n\thideScrollbars = " + this.hideScrollbars + "\n\thideCaret = " + this.hideCaret;
    }

    @Override
    public Boolean isSendDom() {
        return this.isSendDom;
    }

    @Override
    public Configuration setSendDom(boolean sendDom) {
        this.isSendDom = sendDom;
        return this;
    }

    @Override
    public boolean getIgnoreCaret() {
        Boolean ignoreCaret = this.getDefaultMatchSettings().getIgnoreCaret();
        return ignoreCaret == null ? true : ignoreCaret;
    }

    @Override
    public Configuration setIgnoreCaret(boolean value) {
        this.defaultMatchSettings.setIgnoreCaret(value);
        return this;
    }

    @Override
    public String getApiKey() {
        return this.apiKey;
    }

    @Override
    public Configuration setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @Override
    public URI getServerUrl() {
        if (this.serverUrl != null) {
            return URI.create(this.serverUrl);
        }
        return null;
    }

    @Override
    public Configuration setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
        return this;
    }

    @Override
    public AbstractProxySettings getProxy() {
        return this.proxy;
    }

    @Override
    public Configuration setProxy(AbstractProxySettings proxy) {
        this.proxy = proxy;
        return this;
    }

    @Override
    public MatchLevel getMatchLevel() {
        return this.defaultMatchSettings.getMatchLevel();
    }

    @Override
    public boolean getIgnoreDisplacements() {
        return this.ignoreDisplacements;
    }

    @Override
    public Configuration setMatchLevel(MatchLevel matchLevel) {
        this.defaultMatchSettings.setMatchLevel(matchLevel);
        return this;
    }

    @Override
    public Configuration setIgnoreDisplacements(boolean isIgnoreDisplacements) {
        this.defaultMatchSettings.setIgnoreDisplacements(isIgnoreDisplacements);
        this.ignoreDisplacements = isIgnoreDisplacements;
        return this;
    }

    @Override
    public AccessibilitySettings getAccessibilityValidation() {
        return this.accessibilitySettings != null ? this.accessibilitySettings : this.getDefaultMatchSettings().getAccessibilitySettings();
    }

    @Override
    public Configuration setAccessibilityValidation(AccessibilitySettings accessibilitySettings) {
        if (accessibilitySettings == null) {
            this.defaultMatchSettings.setAccessibilitySettings(null);
            this.accessibilitySettings = null;
            return this;
        }
        if (accessibilitySettings.getLevel() == null || accessibilitySettings.getGuidelinesVersion() == null) {
            throw new IllegalArgumentException("AccessibilitySettings should have the following properties: \u2018level,version\u2019");
        }
        this.defaultMatchSettings.setAccessibilitySettings(accessibilitySettings);
        this.accessibilitySettings = accessibilitySettings;
        return this;
    }

    @Override
    public Configuration setUseDom(boolean useDom) {
        this.defaultMatchSettings.setUseDom(useDom);
        this.useDom = useDom;
        return this;
    }

    @Override
    public boolean getUseDom() {
        return this.useDom;
    }

    @Override
    public Configuration setEnablePatterns(boolean enablePatterns) {
        this.defaultMatchSettings.setEnablePatterns(enablePatterns);
        this.enablePatterns = enablePatterns;
        return this;
    }

    @Override
    public boolean getEnablePatterns() {
        return this.enablePatterns;
    }

    public Boolean getForceFullPageScreenshot() {
        return this.forceFullPageScreenshot;
    }

    public int getWaitBeforeScreenshots() {
        return this.waitBeforeScreenshots;
    }

    public Configuration setWaitBeforeScreenshots(int waitBeforeScreenshots) {
        this.waitBeforeScreenshots = waitBeforeScreenshots <= 0 ? 100 : waitBeforeScreenshots;
        return this;
    }

    public StitchMode getStitchMode() {
        return this.stitchMode;
    }

    public Configuration setStitchMode(StitchMode stitchMode) {
        this.stitchMode = stitchMode;
        return this;
    }

    public boolean getHideScrollbars() {
        return this.hideScrollbars;
    }

    public Configuration setHideScrollbars(boolean hideScrollbars) {
        this.hideScrollbars = hideScrollbars;
        return this;
    }

    public boolean getHideCaret() {
        return this.hideCaret;
    }

    public Configuration setHideCaret(boolean hideCaret) {
        this.hideCaret = hideCaret;
        return this;
    }

    public Configuration addBrowsers(IRenderingBrowserInfo ... browserInfos) {
        for (IRenderingBrowserInfo browserInfo : browserInfos) {
            this.addBrowser(browserInfo);
        }
        return this;
    }

    private void addBrowser(IRenderingBrowserInfo browserInfo) {
        if (browserInfo instanceof DesktopBrowserInfo) {
            this.addBrowser((DesktopBrowserInfo)browserInfo);
        } else if (browserInfo instanceof ChromeEmulationInfo) {
            this.addBrowser((ChromeEmulationInfo)browserInfo);
        } else if (browserInfo instanceof IosDeviceInfo) {
            this.addBrowser((IosDeviceInfo)browserInfo);
        }
    }

    public Configuration addBrowser(RenderBrowserInfo renderBrowserInfo) {
        this.browsersInfo.add(renderBrowserInfo);
        return this;
    }

    public Configuration addBrowser(DesktopBrowserInfo desktopBrowserInfo) {
        this.browsersInfo.add(desktopBrowserInfo.getRenderBrowserInfo());
        return this;
    }

    public Configuration addBrowser(ChromeEmulationInfo chromeEmulationInfo) {
        RenderBrowserInfo renderBrowserInfo = new RenderBrowserInfo(chromeEmulationInfo);
        this.browsersInfo.add(renderBrowserInfo);
        return this;
    }

    public Configuration addBrowser(IosDeviceInfo iosDeviceInfo) {
        RenderBrowserInfo renderBrowserInfo = new RenderBrowserInfo(iosDeviceInfo);
        this.browsersInfo.add(renderBrowserInfo);
        return this;
    }

    public Configuration addBrowser(int width, int height, BrowserType browserType, String baselineEnvName) {
        RenderBrowserInfo browserInfo = new RenderBrowserInfo(width, height, browserType, baselineEnvName);
        this.addBrowser(browserInfo);
        return this;
    }

    public Configuration addBrowser(int width, int height, BrowserType browserType) {
        return this.addBrowser(width, height, browserType, this.baselineEnvName);
    }

    public Configuration addDeviceEmulation(DeviceName deviceName, ScreenOrientation orientation) {
        ChromeEmulationInfo emulationInfo = new ChromeEmulationInfo(deviceName, orientation);
        RenderBrowserInfo browserInfo = new RenderBrowserInfo(emulationInfo, this.baselineEnvName);
        this.browsersInfo.add(browserInfo);
        return this;
    }

    public Configuration addDeviceEmulation(DeviceName deviceName) {
        ChromeEmulationInfo emulationInfo = new ChromeEmulationInfo(deviceName, ScreenOrientation.PORTRAIT);
        RenderBrowserInfo browserInfo = new RenderBrowserInfo(emulationInfo, this.baselineEnvName);
        this.browsersInfo.add(browserInfo);
        return this;
    }

    public Configuration addDeviceEmulation(DeviceName deviceName, String baselineEnvName) {
        ChromeEmulationInfo emulationInfo = new ChromeEmulationInfo(deviceName, ScreenOrientation.PORTRAIT);
        RenderBrowserInfo browserInfo = new RenderBrowserInfo(emulationInfo, baselineEnvName);
        this.browsersInfo.add(browserInfo);
        return this;
    }

    public Configuration addDeviceEmulation(DeviceName deviceName, ScreenOrientation orientation, String baselineEnvName) {
        ChromeEmulationInfo emulationInfo = new ChromeEmulationInfo(deviceName, orientation);
        RenderBrowserInfo browserInfo = new RenderBrowserInfo(emulationInfo, baselineEnvName);
        this.browsersInfo.add(browserInfo);
        return this;
    }

    public List<RenderBrowserInfo> getBrowsersInfo() {
        if (this.browsersInfo != null && !this.browsersInfo.isEmpty()) {
            return this.browsersInfo;
        }
        if (this.viewportSize != null) {
            RenderBrowserInfo renderBrowserInfo = new RenderBrowserInfo(this.viewportSize.getWidth(), this.viewportSize.getHeight(), BrowserType.CHROME, this.baselineEnvName);
            return Collections.singletonList(renderBrowserInfo);
        }
        return this.browsersInfo;
    }

    public Configuration setBrowsersInfo(List<RenderBrowserInfo> browsersInfo) {
        this.browsersInfo = browsersInfo;
        return this;
    }

    public Boolean isForceFullPageScreenshot() {
        return this.forceFullPageScreenshot;
    }

    public Configuration setForceFullPageScreenshot(boolean forceFullPageScreenshot) {
        this.forceFullPageScreenshot = forceFullPageScreenshot;
        return this;
    }

    public boolean isRenderingConfig() {
        return this.isRenderingConfig;
    }

    public Configuration setRenderingConfig(boolean renderingConfig) {
        this.isRenderingConfig = renderingConfig;
        return this;
    }

    public Configuration setIsVisualGrid(boolean isVisualGrid) {
        this.isVisualGrid = isVisualGrid;
        return this;
    }

    public boolean isVisualGrid() {
        return this.isVisualGrid;
    }

    public void setFeatures(Feature feature, Feature ... features) {
        this.features.clear();
        this.features.add(feature);
        this.features.addAll(Arrays.asList(features));
        this.features.remove(null);
    }

    public List<Feature> getFeatures() {
        return new ArrayList<Feature>(this.features);
    }

    public boolean isFeatureActivated(Feature feature) {
        return this.features.contains((Object)feature);
    }
}

