/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.model;

import com.applitools.eyes.selenium.BrowserType;
import com.applitools.eyes.visualgrid.model.RGridDom;
import com.applitools.eyes.visualgrid.model.RGridResource;
import com.applitools.eyes.visualgrid.model.RenderInfo;
import com.applitools.eyes.visualgrid.model.VisualGridSelector;
import com.applitools.eyes.visualgrid.services.VisualGridTask;
import com.applitools.utils.ClassVersionGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RenderRequest {
    @JsonInclude
    private String renderId;
    @JsonIgnore
    private final VisualGridTask visualGridTask;
    @JsonInclude
    private String agentId;
    @JsonInclude
    private String stitchingService;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String webhook;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String url;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private RGridDom dom;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, RGridResource> resources;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private RenderInfo renderInfo;
    @JsonIgnore
    private String platform;
    @JsonIgnore
    private BrowserType browserName;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Object scriptHooks;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<VisualGridSelector> selectorsToFindRegionsFor;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private boolean sendDom;

    public RenderRequest(String webHook, String url, RGridDom dom, Map<String, RGridResource> resources, RenderInfo renderInfo, String platform, BrowserType browserName, Object scriptHooks, List<VisualGridSelector> selectorsToFindRegionsFor, boolean sendDom, VisualGridTask visualGridTask, String stitchingService) {
        this.webhook = webHook;
        this.url = url;
        this.dom = dom;
        this.resources = resources;
        this.renderInfo = renderInfo;
        this.platform = platform;
        this.browserName = browserName;
        this.scriptHooks = scriptHooks;
        this.selectorsToFindRegionsFor = selectorsToFindRegionsFor;
        this.sendDom = sendDom;
        this.visualGridTask = visualGridTask;
        this.stitchingService = stitchingService;
        this.agentId = "eyes.selenium.visualgrid.java/" + ClassVersionGetter.CURRENT_VERSION;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public RGridDom getDom() {
        return this.dom;
    }

    public void setDom(RGridDom dom) {
        this.dom = dom;
    }

    public Map<String, RGridResource> getResources() {
        return this.resources;
    }

    public void setResources(Map<String, RGridResource> resources) {
        this.resources = resources;
    }

    public RenderInfo getRenderInfo() {
        return this.renderInfo;
    }

    public void setRenderInfo(RenderInfo renderInfo) {
        this.renderInfo = renderInfo;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setBrowserName(BrowserType browserName) {
        this.browserName = browserName;
    }

    public Object getScriptHooks() {
        return this.scriptHooks;
    }

    public void setScriptHooks(Object scriptHooks) {
        this.scriptHooks = scriptHooks;
    }

    public List<VisualGridSelector> getSelectorsToFindRegionsFor() {
        return this.selectorsToFindRegionsFor;
    }

    public void setSelectorsToFindRegionsFor(List<VisualGridSelector> selectorsToFindRegionsFor) {
        this.selectorsToFindRegionsFor = selectorsToFindRegionsFor;
    }

    public boolean isSendDom() {
        return this.sendDom;
    }

    public void setSendDom(boolean sendDom) {
        this.sendDom = sendDom;
    }

    @JsonProperty(value="browser")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, Object> getBrowser() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", (Object)this.browserName);
        return map;
    }

    @JsonProperty(value="platform")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, Object> getPlatform() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.platform);
        return map;
    }

    public VisualGridTask getVisualGridTask() {
        return this.visualGridTask;
    }

    public String getWebhook() {
        return this.webhook;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public String getRenderId() {
        return this.renderId;
    }

    public void setRenderId(String renderId) {
        this.renderId = renderId;
    }

    public String getStitchingService() {
        return this.stitchingService;
    }

    public void setStitchingService(String stitchingService) {
        this.stitchingService = stitchingService;
    }

    public String toString() {
        return "RenderRequest{renderId='" + this.renderId + '\'' + ", visualGridTask=" + this.visualGridTask + ", agentId='" + this.agentId + '\'' + ", webhook='" + this.webhook + '\'' + ", url='" + this.url + '\'' + ", dom=" + this.dom + ", resources=" + this.resources + ", renderInfo=" + this.renderInfo + ", platform='" + this.platform + '\'' + ", browserName='" + (Object)((Object)this.browserName) + '\'' + ", scriptHooks=" + this.scriptHooks + ", selectorsToFindRegionsFor=" + this.selectorsToFindRegionsFor + ", sendDom=" + this.sendDom + '}';
    }
}

