/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.model;

import com.applitools.ICheckSettings;
import com.applitools.ICheckSettingsInternal;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.TaskListener;
import com.applitools.eyes.UserAgent;
import com.applitools.eyes.visualgrid.model.BlobData;
import com.applitools.eyes.visualgrid.model.CdtData;
import com.applitools.eyes.visualgrid.model.CompletableTask;
import com.applitools.eyes.visualgrid.model.FrameData;
import com.applitools.eyes.visualgrid.model.IDebugResourceWriter;
import com.applitools.eyes.visualgrid.model.NullDebugResourceWriter;
import com.applitools.eyes.visualgrid.model.RGridDom;
import com.applitools.eyes.visualgrid.model.RGridResource;
import com.applitools.eyes.visualgrid.model.RenderBrowserInfo;
import com.applitools.eyes.visualgrid.model.RenderInfo;
import com.applitools.eyes.visualgrid.model.RenderRequest;
import com.applitools.eyes.visualgrid.model.RenderStatus;
import com.applitools.eyes.visualgrid.model.RenderStatusResults;
import com.applitools.eyes.visualgrid.model.RenderingInfo;
import com.applitools.eyes.visualgrid.model.RunningRender;
import com.applitools.eyes.visualgrid.model.VisualGridSelector;
import com.applitools.eyes.visualgrid.services.IEyesConnector;
import com.applitools.eyes.visualgrid.services.VisualGridRunner;
import com.applitools.eyes.visualgrid.services.VisualGridTask;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.css.ECSSVersion;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSExpression;
import com.helger.css.decl.CSSExpressionMemberTermURI;
import com.helger.css.decl.CSSFontFaceRule;
import com.helger.css.decl.CSSImportRule;
import com.helger.css.decl.CSSStyleRule;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.decl.IHasCSSDeclarations;
import com.helger.css.reader.CSSReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.codec.binary.Base64;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

public class RenderingTask
implements Callable<RenderStatusResults>,
CompletableTask {
    private static final int FETCH_TIMEOUT_SECONDS = 60;
    public static final String FULLPAGE = "full-page";
    public static final String VIEWPORT = "viewport";
    public static final int HOUR = 3600000;
    public static final String TEXT_CSS = "text/css";
    public static final String IMAGE_SVG_XML = "image/svg+xml";
    private final List<RenderTaskListener> listeners = new ArrayList<RenderTaskListener>();
    private IEyesConnector eyesConnector;
    private ICheckSettings checkSettings;
    private List<VisualGridTask> visualGridTaskList;
    private List<VisualGridTask> openVisualGridTaskList;
    private RenderingInfo renderingInfo;
    private UserAgent userAgent;
    final Map<String, RGridResource> fetchedCacheMap;
    final Map<String, RGridResource> putResourceCache;
    private Logger logger;
    private AtomicBoolean isTaskComplete = new AtomicBoolean(false);
    private AtomicBoolean isForcePutNeeded;
    private final List<VisualGridSelector[]> regionSelectors;
    private IDebugResourceWriter debugResourceWriter;
    private FrameData domData;
    private AtomicInteger framesLevel = new AtomicInteger();
    private RGridDom dom = null;
    private Timer timer = new Timer("VG_StopWatch", true);
    private AtomicBoolean isTimeElapsed = new AtomicBoolean(false);
    Phaser resourcesPhaser = new Phaser();
    final TaskListener<Boolean> putListener = new TaskListener<Boolean>(){

        @Override
        public void onComplete(Boolean isSucceeded) {
            try {
                if (!isSucceeded.booleanValue()) {
                    RenderingTask.this.logger.log("Failed putting resource");
                }
            }
            finally {
                RenderingTask.this.resourcesPhaser.arriveAndDeregister();
            }
        }

        @Override
        public void onFail() {
            RenderingTask.this.resourcesPhaser.arriveAndDeregister();
            RenderingTask.this.logger.log("Failed putting resource");
        }
    };
    private boolean isTaskStarted = false;
    private boolean isTaskCompleted = false;
    private boolean isTaskInException = false;

    RenderingTask(IEyesConnector eyesConnector, List<VisualGridTask> visualGridTaskList, UserAgent userAgent) {
        this(eyesConnector, visualGridTaskList, userAgent, null);
    }

    RenderingTask(IEyesConnector eyesConnector, List<VisualGridTask> visualGridTaskList, UserAgent userAgent, ICheckSettings checkSettings) {
        this.eyesConnector = eyesConnector;
        this.visualGridTaskList = visualGridTaskList;
        this.userAgent = userAgent;
        this.fetchedCacheMap = new HashMap<String, RGridResource>();
        this.logger = new Logger();
        this.regionSelectors = new ArrayList<VisualGridSelector[]>();
        this.putResourceCache = new HashMap<String, RGridResource>();
        this.checkSettings = checkSettings;
        this.renderingInfo = new RenderingInfo();
    }

    public RenderingTask(IEyesConnector eyesConnector, FrameData domData, ICheckSettings checkSettings, List<VisualGridTask> visualGridTaskList, List<VisualGridTask> openVisualGridTasks, VisualGridRunner renderingGridManager, IDebugResourceWriter debugResourceWriter, RenderTaskListener listener, UserAgent userAgent, List<VisualGridSelector[]> regionSelectors) {
        this.eyesConnector = eyesConnector;
        this.domData = domData;
        this.checkSettings = checkSettings;
        this.visualGridTaskList = visualGridTaskList;
        this.openVisualGridTaskList = openVisualGridTasks;
        this.renderingInfo = renderingGridManager.getRenderingInfo();
        this.fetchedCacheMap = renderingGridManager.getCachedResources();
        this.putResourceCache = renderingGridManager.getPutResourceCache();
        this.logger = renderingGridManager.getLogger();
        this.debugResourceWriter = debugResourceWriter;
        this.userAgent = userAgent;
        this.regionSelectors = regionSelectors;
        this.listeners.add(listener);
        String renderingGridForcePut = GeneralUtils.getEnvString("APPLITOOLS_RENDERING_GRID_FORCE_PUT");
        this.isForcePutNeeded = new AtomicBoolean(renderingGridForcePut != null && renderingGridForcePut.equalsIgnoreCase("true"));
    }

    @Override
    public RenderStatusResults call() {
        try {
            List<RunningRender> runningRenders;
            boolean stillRunning;
            this.isTaskStarted = true;
            this.addRenderingTaskToOpenTasks();
            this.logger.verbose("enter");
            boolean isSecondRequestAlreadyHappened = false;
            this.logger.verbose("step 1");
            RenderRequest[] requests = this.prepareDataForRG(this.domData);
            this.logger.verbose("step 2");
            long elapsedTimeStart = System.currentTimeMillis();
            boolean isForcePutAlreadyDone = false;
            do {
                try {
                    runningRenders = this.eyesConnector.render(requests);
                }
                catch (Exception e) {
                    GeneralUtils.logExceptionStackTrace(this.logger, e);
                    this.logger.verbose("/render throws exception... sleeping for 1.5s");
                    this.logger.verbose("ERROR " + e.getMessage());
                    Thread.sleep(1500L);
                    try {
                        runningRenders = this.eyesConnector.render(requests);
                    }
                    catch (Exception e1) {
                        this.setRenderErrorToTasks(requests);
                        throw new EyesException("Invalid response for render request", (Throwable)e1);
                    }
                }
                this.logger.verbose("step 3.1");
                if (runningRenders == null || runningRenders.size() == 0) {
                    this.setRenderErrorToTasks(requests);
                    throw new EyesException("Invalid response for render request");
                }
                for (int i = 0; i < requests.length; ++i) {
                    RenderRequest request = requests[i];
                    request.setRenderId(runningRenders.get(i).getRenderId());
                    this.logger.verbose(String.format("RunningRender: %s", runningRenders.get(i)));
                }
                this.logger.verbose("step 3.2");
                RunningRender runningRender = runningRenders.get(0);
                RenderStatus worstStatus = runningRender.getRenderStatus();
                worstStatus = this.calcWorstStatus(runningRenders, worstStatus);
                boolean isNeedMoreDom = runningRender.isNeedMoreDom();
                if (this.isForcePutNeeded.get() && !isForcePutAlreadyDone) {
                    this.forcePutAllResources(requests[0].getResources(), requests[0].getDom(), runningRender);
                    isForcePutAlreadyDone = true;
                    try {
                        if (this.resourcesPhaser.getRegisteredParties() > 0) {
                            this.resourcesPhaser.awaitAdvanceInterruptibly(0, 30L, TimeUnit.SECONDS);
                        }
                    }
                    catch (InterruptedException | TimeoutException e) {
                        GeneralUtils.logExceptionStackTrace(this.logger, e);
                        this.resourcesPhaser.forceTermination();
                    }
                }
                this.logger.verbose("step 3.3");
                double elapsedTime = (System.currentTimeMillis() - elapsedTimeStart) / 1000L;
                boolean bl = stillRunning = (worstStatus == RenderStatus.NEED_MORE_RESOURCE || isNeedMoreDom) && elapsedTime < 60.0;
                if (stillRunning) {
                    this.sendMissingResources(runningRenders, requests[0].getDom(), requests[0].getResources(), isNeedMoreDom);
                    try {
                        if (this.resourcesPhaser.getRegisteredParties() > 0) {
                            this.resourcesPhaser.awaitAdvanceInterruptibly(0, 30L, TimeUnit.SECONDS);
                        }
                    }
                    catch (InterruptedException | TimeoutException e) {
                        GeneralUtils.logExceptionStackTrace(this.logger, e);
                        this.resourcesPhaser.forceTermination();
                    }
                }
                this.logger.verbose("step 3.4");
            } while (stillRunning);
            Map<RunningRender, RenderRequest> mapping = this.mapRequestToRunningRender(runningRenders, requests);
            this.logger.verbose("step 4");
            this.pollRenderingStatus(mapping);
            this.isTaskCompleted = true;
        }
        catch (Throwable e) {
            GeneralUtils.logExceptionStackTrace(this.logger, e);
            for (VisualGridTask visualGridTask : this.visualGridTaskList) {
                visualGridTask.setExceptionAndAbort(e);
            }
        }
        this.logger.verbose("Finished rendering task - exit");
        return null;
    }

    private void addRenderingTaskToOpenTasks() {
        if (this.openVisualGridTaskList != null) {
            for (VisualGridTask visualGridTask : this.openVisualGridTaskList) {
                visualGridTask.setRenderingTask(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forcePutAllResources(Map<String, RGridResource> resources, RGridDom dom, RunningRender runningRender) {
        this.resourcesPhaser = new Phaser();
        Set<String> strings = resources.keySet();
        try {
            this.resourcesPhaser.register();
            this.eyesConnector.renderPutResource(runningRender, dom.asResource(), this.userAgent.getOriginalUserAgentString(), this.putListener);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        for (String url : strings) {
            try {
                this.logger.verbose("trying to get url from map - " + url);
                RGridResource resource = null;
                if (!this.fetchedCacheMap.containsKey(url)) {
                    if (url.equals(this.dom.getUrl())) {
                        resource = this.dom.asResource();
                    }
                } else {
                    resource = this.fetchedCacheMap.get(url);
                }
                if (resource == null) {
                    this.logger.log(String.format("Illegal state: resource is null for url %s", url));
                    continue;
                }
                this.resourcesPhaser.register();
                this.eyesConnector.renderPutResource(runningRender, resource, this.userAgent.getOriginalUserAgentString(), this.putListener);
                this.logger.verbose("locking putResourceCache");
                Map<String, RGridResource> map = this.putResourceCache;
                synchronized (map) {
                    String contentType = resource.getContentType();
                    if (contentType != null && !contentType.equalsIgnoreCase("x-applitools-html/cdt")) {
                        this.putResourceCache.put(url, resource);
                    }
                }
            }
            catch (Exception e) {
                GeneralUtils.logExceptionStackTrace(this.logger, e);
            }
        }
    }

    private void setRenderErrorToTasks(RenderRequest[] requests) {
        for (RenderRequest renderRequest : requests) {
            for (VisualGridTask openTask : this.openVisualGridTaskList) {
                if (openTask.getRunningTest() != renderRequest.getVisualGridTask().getRunningTest()) continue;
                openTask.setRenderError(null, "Invalid response for render request", renderRequest);
            }
            renderRequest.getVisualGridTask().setRenderError(null, "Invalid response for render request", renderRequest);
        }
    }

    private void notifySuccessAllListeners() {
        for (RenderTaskListener listener : this.listeners) {
            listener.onRenderSuccess();
        }
    }

    private Map<RunningRender, RenderRequest> mapRequestToRunningRender(List<RunningRender> runningRenders, RenderRequest[] requests) {
        HashMap<RunningRender, RenderRequest> mapping = new HashMap<RunningRender, RenderRequest>();
        for (int i = 0; i < requests.length; ++i) {
            RenderRequest request = requests[i];
            RunningRender runningRender = runningRenders.get(i);
            mapping.put(runningRender, request);
        }
        return mapping;
    }

    /*
     * Enabled aggressive block sorting
     */
    private RenderStatus calcWorstStatus(List<RunningRender> runningRenders, RenderStatus worstStatus) {
        Iterator<RunningRender> iterator = runningRenders.iterator();
        while (iterator.hasNext()) {
            RunningRender runningRender = iterator.next();
            switch (runningRender.getRenderStatus()) {
                case NEED_MORE_RESOURCE: {
                    if (worstStatus != RenderStatus.RENDERED && worstStatus != RenderStatus.RENDERING) break;
                    worstStatus = RenderStatus.NEED_MORE_RESOURCE;
                    break;
                }
                case ERROR: {
                    return RenderStatus.ERROR;
                }
            }
        }
        return worstStatus;
    }

    private List<String> getRenderIds(Collection<RunningRender> runningRenders) {
        ArrayList<String> ids = new ArrayList<String>();
        for (RunningRender runningRender : runningRenders) {
            ids.add(runningRender.getRenderId());
        }
        return ids;
    }

    private void sendMissingResources(List<RunningRender> runningRenders, RGridDom dom, Map<String, RGridResource> resources, boolean isNeedMoreDom) {
        this.logger.verbose("enter");
        this.resourcesPhaser = new Phaser();
        if (isNeedMoreDom) {
            RunningRender runningRender = runningRenders.get(0);
            try {
                this.resourcesPhaser.register();
                this.eyesConnector.renderPutResource(runningRender, dom.asResource(), this.userAgent.getOriginalUserAgentString(), this.putListener);
            }
            catch (Throwable e) {
                GeneralUtils.logExceptionStackTrace(this.logger, e);
            }
        }
        this.logger.verbose("creating PutFutures for " + runningRenders.size() + " runningRenders");
        for (RunningRender runningRender : runningRenders) {
            this.createPutFutures(runningRender, resources);
        }
        this.logger.verbose("exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createPutFutures(RunningRender runningRender, Map<String, RGridResource> resources) {
        List<String> needMoreResources = runningRender.getNeedMoreResources();
        for (String url : needMoreResources) {
            RGridResource resource;
            if (this.putResourceCache.containsKey(url)) continue;
            if (!this.fetchedCacheMap.containsKey(url)) {
                this.logger.verbose(String.format("Resource %s requested but never downloaded (maybe a Frame)", url));
                resource = resources.get(url);
            } else {
                resource = this.fetchedCacheMap.get(url);
            }
            if (resource == null) {
                this.logger.log(String.format("Illegal state: resource is null for url %s", url));
                continue;
            }
            this.logger.verbose("resource(" + resource.getUrl() + ") hash : " + resource.getSha256());
            this.resourcesPhaser.register();
            this.eyesConnector.renderPutResource(runningRender, resource, this.userAgent.getOriginalUserAgentString(), this.putListener);
            String contentType = resource.getContentType();
            if (this.putResourceCache.containsKey(url) || contentType == null || contentType.equalsIgnoreCase("x-applitools-html/cdt")) continue;
            Map<String, RGridResource> map = this.putResourceCache;
            synchronized (map) {
                this.putResourceCache.put(url, resource);
            }
        }
    }

    RenderRequest[] prepareDataForRG(FrameData domData) {
        Map<String, RGridResource> allBlobs = Collections.synchronizedMap(new HashMap());
        HashSet<URI> resourceUrls = new HashSet<URI>();
        this.writeFrameDataAsResource(domData);
        this.parseScriptResult(domData, allBlobs, resourceUrls);
        this.logger.verbose(String.format("fetching %d resources: %s", resourceUrls.size(), resourceUrls));
        this.resourcesPhaser = new Phaser();
        this.fetchAllResources(allBlobs, resourceUrls, domData);
        try {
            if (this.resourcesPhaser.getRegisteredParties() > 0) {
                this.resourcesPhaser.awaitAdvanceInterruptibly(0, 30L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException | TimeoutException e) {
            GeneralUtils.logExceptionStackTrace(this.logger, e);
            this.resourcesPhaser.forceTermination();
        }
        this.logger.verbose("done fetching resources.");
        List<RGridResource> unparsedResources = this.addBlobsToCache(allBlobs);
        resourceUrls = new HashSet();
        this.parseAndCollectExternalResources(unparsedResources, domData.getUrl(), resourceUrls);
        HashMap<String, RGridResource> resourceMapping = new HashMap<String, RGridResource>();
        for (String url : allBlobs.keySet()) {
            try {
                this.logger.verbose("trying to fetch - " + url);
                RGridResource resource = this.fetchedCacheMap.get(url);
                if (resource == null) {
                    this.logger.log(String.format("Illegal state: resource is null for url %s", url));
                    continue;
                }
                this.logger.verbose("adding url to map: " + url);
                resourceMapping.put(url, resource);
            }
            catch (Exception e) {
                this.logger.verbose("Couldn't download url = " + url);
            }
        }
        this.buildAllRGDoms(resourceMapping, domData);
        List<RenderRequest> allRequestsForRG = this.buildRenderRequests(domData, resourceMapping);
        RenderRequest[] asArray = allRequestsForRG.toArray(new RenderRequest[0]);
        if (this.debugResourceWriter != null && !(this.debugResourceWriter instanceof NullDebugResourceWriter)) {
            for (RenderRequest renderRequest : asArray) {
                try {
                    this.debugResourceWriter.write(renderRequest.getDom().asResource());
                }
                catch (JsonProcessingException e) {
                    GeneralUtils.logExceptionStackTrace(this.logger, e);
                }
                for (RGridResource value : renderRequest.getResources().values()) {
                    this.debugResourceWriter.write(value);
                }
            }
        }
        this.logger.verbose("exit - returning renderRequest array of length: " + asArray.length);
        return asArray;
    }

    private void buildAllRGDoms(Map<String, RGridResource> resourceMapping, FrameData domData) {
        URL baseUrl = null;
        String domDataUrl = domData.getUrl();
        this.logger.verbose("url in DOM: " + domDataUrl);
        try {
            baseUrl = new URL(domDataUrl);
        }
        catch (MalformedURLException e) {
            GeneralUtils.logExceptionStackTrace(this.logger, e);
        }
        this.logger.verbose("baseUrl: " + baseUrl);
        List<FrameData> allFrame = domData.getFrames();
        this.logger.verbose("FrameData count: " + allFrame.size());
        HashMap<String, RGridResource> mapping = new HashMap<String, RGridResource>();
        for (FrameData frameObj : allFrame) {
            URL frameUrl;
            List<BlobData> allFramesBlobs = frameObj.getBlobs();
            List<String> allResourceUrls = frameObj.getResourceUrls();
            try {
                frameUrl = new URL(baseUrl, frameObj.getUrl());
            }
            catch (MalformedURLException e) {
                GeneralUtils.logExceptionStackTrace(this.logger, e);
                continue;
            }
            for (BlobData blob : allFramesBlobs) {
                String blobUrl = blob.getUrl();
                RGridResource rGridResource = resourceMapping.get(blobUrl);
                mapping.put(blobUrl, rGridResource);
            }
            for (String resourceUrl : allResourceUrls) {
                RGridResource rGridResource = resourceMapping.get(resourceUrl);
                mapping.put(resourceUrl, rGridResource);
            }
            List<CdtData> cdt = frameObj.getCdt();
            RGridDom rGridDom = new RGridDom(cdt, mapping, frameUrl.toString(), this.logger, "buildAllRGDoms");
            try {
                resourceMapping.put(frameUrl.toString(), rGridDom.asResource());
                this.buildAllRGDoms(resourceMapping, frameObj);
            }
            catch (JsonProcessingException e) {
                GeneralUtils.logExceptionStackTrace(this.logger, e);
            }
        }
    }

    private void writeFrameDataAsResource(FrameData domData) {
        if (this.debugResourceWriter == null || this.debugResourceWriter instanceof NullDebugResourceWriter) {
            return;
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            byte[] content = objectMapper.writeValueAsBytes((Object)domData);
            RGridResource resource = new RGridResource(domData.getUrl(), "x-applitools-html/cdt", content);
            this.debugResourceWriter.write(resource);
        }
        catch (JsonProcessingException e) {
            GeneralUtils.logExceptionStackTrace(this.logger, e);
        }
    }

    private void parseScriptResult(FrameData domData, Map<String, RGridResource> allBlobs, Set<URI> resourceUrls) {
        Base64 codec = new Base64();
        String baseUrlStr = domData.getUrl();
        this.logger.verbose("baseUrl: " + baseUrlStr);
        URI baseUrl = null;
        try {
            baseUrl = new URI(baseUrlStr);
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace(this.logger, e);
        }
        this.parseBlobs(allBlobs, codec, baseUrl, domData.getBlobs());
        this.parseResourceUrls(domData, resourceUrls, baseUrl);
        this.parseFrames(domData, allBlobs, resourceUrls);
        List<RGridResource> unparsedResources = this.addBlobsToCache(allBlobs);
        String baseUrlAsString = null;
        if (baseUrl != null) {
            baseUrlAsString = baseUrl.toString();
        }
        this.parseAndCollectExternalResources(unparsedResources, baseUrlAsString, resourceUrls);
    }

    private void parseFrames(FrameData frameData, Map<String, RGridResource> allBlobs, Set<URI> resourceUrls) {
        this.logger.verbose("handling 'frames' key (level: " + this.framesLevel.incrementAndGet() + ")");
        for (FrameData frameObj : frameData.getFrames()) {
            this.parseScriptResult(frameObj, allBlobs, resourceUrls);
        }
        this.logger.verbose("done handling 'frames' key (level: " + this.framesLevel.getAndDecrement() + ")");
    }

    private void parseResourceUrls(FrameData result, Set<URI> resourceUrls, URI baseUrl) {
        List<String> list = result.getResourceUrls();
        for (String url : list) {
            try {
                resourceUrls.add(baseUrl.resolve(url));
            }
            catch (Exception e) {
                this.logger.log("Error resolving url:" + url);
                GeneralUtils.logExceptionStackTrace(this.logger, e);
            }
        }
        this.logger.verbose("exit");
    }

    private void parseBlobs(Map<String, RGridResource> allBlobs, Base64 codec, URI baseUrl, List<BlobData> value) {
        for (BlobData blob : value) {
            RGridResource resource = this.parseBlobToGridResource(codec, baseUrl, blob);
            if (allBlobs.containsKey(resource.getUrl())) continue;
            allBlobs.put(resource.getUrl(), resource);
        }
    }

    private List<RenderRequest> buildRenderRequests(FrameData result, Map<String, RGridResource> resourceMapping) {
        RGridDom dom;
        this.dom = dom = new RGridDom(result.getCdt(), resourceMapping, result.getUrl(), this.logger, "buildRenderRequests");
        ArrayList<RenderRequest> allRequestsForRG = new ArrayList<RenderRequest>();
        ICheckSettingsInternal checkSettingsInternal = (ICheckSettingsInternal)((Object)this.checkSettings);
        ArrayList<VisualGridSelector> regionSelectorsList = new ArrayList<VisualGridSelector>();
        for (VisualGridSelector[] regionSelector : this.regionSelectors) {
            regionSelectorsList.addAll(Arrays.asList(regionSelector));
        }
        this.logger.verbose("region selectors count: " + regionSelectorsList.size());
        this.logger.verbose("this.visualGridTaskList count: " + this.visualGridTaskList.size());
        for (VisualGridTask visualGridTask : this.visualGridTaskList) {
            RenderBrowserInfo browserInfo = visualGridTask.getBrowserInfo();
            String sizeMode = checkSettingsInternal.getSizeMode();
            if (sizeMode.equalsIgnoreCase(VIEWPORT) && checkSettingsInternal.isStitchContent().booleanValue()) {
                sizeMode = FULLPAGE;
            }
            RenderInfo renderInfo = new RenderInfo(browserInfo.getWidth(), browserInfo.getHeight(), sizeMode, checkSettingsInternal.getTargetRegion(), checkSettingsInternal.getVGTargetSelector(), browserInfo.getEmulationInfo(), browserInfo.getIosDeviceInfo());
            RenderRequest request = new RenderRequest(this.renderingInfo.getResultsUrl(), result.getUrl(), dom, resourceMapping, renderInfo, browserInfo.getPlatform(), browserInfo.getBrowserType(), checkSettingsInternal.getScriptHooks(), regionSelectorsList, checkSettingsInternal.isSendDom(), visualGridTask, this.renderingInfo.getStitchingServiceUrl());
            allRequestsForRG.add(request);
        }
        this.logger.verbose("count of all requests for RG: " + allRequestsForRG.size());
        return allRequestsForRG;
    }

    private RGridResource parseBlobToGridResource(Base64 codec, URI baseUrl, BlobData blobAsMap) {
        String contentAsString = blobAsMap.getValue();
        byte[] content = codec.decode(contentAsString);
        String urlAsString = blobAsMap.getUrl();
        Integer errorStatusCode = blobAsMap.getErrorStatusCode();
        try {
            URI url = baseUrl.resolve(urlAsString);
            urlAsString = url.toString();
        }
        catch (Exception e) {
            this.logger.log("Error resolving uri:" + urlAsString);
            GeneralUtils.logExceptionStackTrace(this.logger, e);
        }
        return new RGridResource(urlAsString, blobAsMap.getType(), content, errorStatusCode);
    }

    private void parseAndCollectExternalResources(List<RGridResource> allBlobs, String baseUrl, Set<URI> resourceUrls) {
        for (RGridResource blob : allBlobs) {
            this.getAndParseResource(blob, baseUrl, resourceUrls);
        }
    }

    private void getAndParseResource(RGridResource blob, String baseUrl, Set<URI> resourceUrls) {
        URI baseUri = URI.create(baseUrl);
        TextualDataResource tdr = this.tryGetTextualData(blob, baseUri);
        if (tdr == null) {
            return;
        }
        switch (tdr.mimeType) {
            case "text/css": {
                this.parseCSS(tdr, resourceUrls);
                break;
            }
            case "image/svg+xml": {
                this.parseSVG(tdr, resourceUrls);
            }
        }
    }

    private void parseSVG(TextualDataResource tdr, Set<URI> allResourceUris) {
        try {
            Document doc = Jsoup.parse((String)new String(tdr.originalData), (String)tdr.uri.toString(), (Parser)Parser.xmlParser());
            Elements links = doc.select("[href]");
            links.addAll((Collection)doc.select("[xlink:href]"));
            for (Element element : links) {
                String href = element.attr("href");
                if (href.isEmpty() && (href = element.attr("xlink:href")).startsWith("#")) continue;
                this.createUriAndAddToList(allResourceUris, tdr.uri, href);
            }
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace(this.logger, e);
        }
    }

    private TextualDataResource tryGetTextualData(RGridResource blob, URI baseUrl) {
        byte[] contentBytes = blob.getContent();
        String contentTypeStr = blob.getContentType();
        if (contentTypeStr == null) {
            return null;
        }
        if (contentBytes.length == 0) {
            return null;
        }
        String[] parts = contentTypeStr.split(";");
        TextualDataResource tdr = new TextualDataResource();
        if (parts.length > 0) {
            tdr.mimeType = parts[0].toLowerCase();
        }
        String charset = "UTF-8";
        if (parts.length > 1) {
            String[] keyVal = parts[1].split("=");
            String key = keyVal[0].trim();
            String val = keyVal[1].trim();
            if (key.equalsIgnoreCase("charset")) {
                charset = val.toUpperCase();
            }
        }
        charset = charset.replaceAll("\"", "");
        try {
            tdr.data = new String(contentBytes, charset);
        }
        catch (UnsupportedEncodingException e) {
            GeneralUtils.logExceptionStackTrace(this.logger, e);
        }
        URI uri = null;
        try {
            uri = new URI(GeneralUtils.sanitizeURL(blob.getUrl(), this.logger));
            tdr.uri = baseUrl.resolve(uri);
        }
        catch (Exception e) {
            this.logger.log("Error resolving uri:" + uri);
            GeneralUtils.logExceptionStackTrace(this.logger, e);
        }
        tdr.originalData = blob.getContent();
        this.logger.verbose("exit");
        return tdr;
    }

    private void parseCSS(TextualDataResource css, Set<URI> resourceUrls) {
        try {
            String data = css.data;
            if (data == null) {
                return;
            }
            CascadingStyleSheet cascadingStyleSheet = CSSReader.readFromString((String)data, (ECSSVersion)ECSSVersion.CSS30);
            if (cascadingStyleSheet == null) {
                this.logger.verbose("exit - failed to read CSS String");
                return;
            }
            this.collectAllImportUris(cascadingStyleSheet, resourceUrls, css.uri);
            this.collectAllFontFaceUris(cascadingStyleSheet, resourceUrls, css.uri);
            this.collectAllBackgroundImageUris(cascadingStyleSheet, resourceUrls, css.uri);
        }
        catch (Throwable e) {
            GeneralUtils.logExceptionStackTrace(this.logger, e);
        }
    }

    private void collectAllFontFaceUris(CascadingStyleSheet cascadingStyleSheet, Set<URI> allResourceUris, URI baseUrl) {
        this.logger.verbose("enter");
        ICommonsList allFontFaceRules = cascadingStyleSheet.getAllFontFaceRules();
        for (CSSFontFaceRule fontFaceRule : allFontFaceRules) {
            this.getAllResourcesUrisFromDeclarations(allResourceUris, (IHasCSSDeclarations)fontFaceRule, "src", baseUrl);
        }
        this.logger.verbose("exit");
    }

    private void collectAllBackgroundImageUris(CascadingStyleSheet cascadingStyleSheet, Set<URI> allResourceUris, URI baseUrl) {
        this.logger.verbose("enter");
        ICommonsList allStyleRules = cascadingStyleSheet.getAllStyleRules();
        for (CSSStyleRule styleRule : allStyleRules) {
            this.getAllResourcesUrisFromDeclarations(allResourceUris, (IHasCSSDeclarations)styleRule, "background", baseUrl);
            this.getAllResourcesUrisFromDeclarations(allResourceUris, (IHasCSSDeclarations)styleRule, "background-image", baseUrl);
        }
        this.logger.verbose("exit");
    }

    private void collectAllImportUris(CascadingStyleSheet cascadingStyleSheet, Set<URI> allResourceUris, URI baseUrl) {
        this.logger.verbose("enter");
        ICommonsList allImportRules = cascadingStyleSheet.getAllImportRules();
        for (CSSImportRule importRule : allImportRules) {
            String uri = importRule.getLocation().getURI();
            this.createUriAndAddToList(allResourceUris, baseUrl, uri);
        }
        this.logger.verbose("exit");
    }

    private void createUriAndAddToList(Set<URI> allResourceUris, URI baseUrl, String uri) {
        if (uri.toLowerCase().startsWith("data:") || uri.toLowerCase().startsWith("javascript:")) {
            return;
        }
        try {
            URI url = baseUrl.resolve(uri);
            allResourceUris.add(url);
        }
        catch (Exception e) {
            this.logger.log("Error resolving uri:" + uri);
            GeneralUtils.logExceptionStackTrace(this.logger, e);
        }
    }

    private <T extends IHasCSSDeclarations<T>> void getAllResourcesUrisFromDeclarations(Set<URI> allResourceUris, IHasCSSDeclarations<T> rule, String propertyName, URI baseUrl) {
        ICommonsList sourcesList = rule.getAllDeclarationsOfPropertyName(propertyName);
        for (CSSDeclaration cssDeclaration : sourcesList) {
            CSSExpression cssDeclarationExpression = cssDeclaration.getExpression();
            ICommonsList allExpressionMembers = cssDeclarationExpression.getAllMembers();
            ICommonsList allUriExpressions = allExpressionMembers.getAllInstanceOf(CSSExpressionMemberTermURI.class);
            for (CSSExpressionMemberTermURI uriExpression : allUriExpressions) {
                String uri = uriExpression.getURIString();
                this.createUriAndAddToList(allResourceUris, baseUrl, uri);
            }
        }
    }

    private List<RGridResource> addBlobsToCache(Map<String, RGridResource> allBlobs) {
        this.logger.verbose(String.format("trying to add %d blobs to cache", allBlobs.size()));
        this.logger.verbose(String.format("current fetchedCacheMap size: %d", this.fetchedCacheMap.size()));
        ArrayList<RGridResource> unparsedResources = new ArrayList<RGridResource>();
        for (RGridResource blob : allBlobs.values()) {
            String url = blob.getUrl();
            if (this.fetchedCacheMap.containsKey(url)) {
                allBlobs.put(url, this.fetchedCacheMap.get(url));
                continue;
            }
            String contentType = blob.getContentType();
            try {
                if (contentType == null || !contentType.equalsIgnoreCase("x-applitools-html/cdt")) {
                    this.fetchedCacheMap.put(url, blob);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            unparsedResources.add(blob);
        }
        return unparsedResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fetchAllResources(final Map<String, RGridResource> allBlobs, Set<URI> resourceUrls, final FrameData result) {
        this.logger.verbose("enter");
        if (resourceUrls.isEmpty()) {
            return;
        }
        for (final URI uri : resourceUrls) {
            final String uriStr = GeneralUtils.sanitizeURL(uri.toString(), this.logger);
            Map<String, RGridResource> map = this.fetchedCacheMap;
            synchronized (map) {
                if (this.fetchedCacheMap.containsKey(uriStr)) {
                    this.logger.verbose("this.fetchedCacheMap.containsKey(" + uriStr + ")");
                    allBlobs.put(uriStr, this.fetchedCacheMap.get(uriStr));
                    continue;
                }
                IEyesConnector eyesConnector = this.visualGridTaskList.get(0).getEyesConnector();
                try {
                    this.resourcesPhaser.register();
                    eyesConnector.getResource(uri, this.userAgent.getOriginalUserAgentString(), result.getUrl(), new TaskListener<RGridResource>(){

                        @Override
                        public void onComplete(RGridResource taskResponse) {
                            try {
                                if (taskResponse == null) {
                                    RenderingTask.this.logger.log(String.format("Resource is null for url %s", uriStr));
                                    return;
                                }
                                Set newResourceUrls = RenderingTask.this.handleCollectedResource(uri, taskResponse, allBlobs, result);
                                if (newResourceUrls.isEmpty()) {
                                    return;
                                }
                                RenderingTask.this.fetchAllResources(allBlobs, newResourceUrls, result);
                            }
                            finally {
                                RenderingTask.this.resourcesPhaser.arriveAndDeregister();
                            }
                        }

                        @Override
                        public void onFail() {
                            RenderingTask.this.resourcesPhaser.arriveAndDeregister();
                            RenderingTask.this.logger.log(String.format("Failed downloading from uri %s", uriStr));
                        }
                    });
                }
                catch (Exception e) {
                    this.logger.log("error converting " + uri + " to url");
                    GeneralUtils.logExceptionStackTrace(this.logger, e);
                }
            }
        }
        this.logger.verbose("exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<URI> handleCollectedResource(URI url, RGridResource resource, Map<String, RGridResource> allBlobs, FrameData result) {
        HashSet<URI> newResourceUrls = new HashSet<URI>();
        try {
            Map<String, RGridResource> map = this.fetchedCacheMap;
            synchronized (map) {
                this.fetchedCacheMap.put(url.toString(), resource);
            }
            this.debugResourceWriter.write(resource);
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace(this.logger, e);
        }
        this.logger.verbose("done writing to debugWriter");
        allBlobs.put(resource.getUrl(), resource);
        String contentType = resource.getContentType();
        this.logger.verbose("handling " + contentType + " resource from URL: " + url);
        this.getAndParseResource(resource, result.getUrl(), newResourceUrls);
        resource.setIsResourceParsed(true);
        return newResourceUrls;
    }

    private void pollRenderingStatus(Map<RunningRender, RenderRequest> runningRenders) {
        this.logger.verbose("enter");
        List<String> ids = this.getRenderIds(runningRenders.keySet());
        this.logger.verbose("render ids : " + ids);
        this.timer.schedule((TimerTask)new TimeoutTask(), 3600000L);
        do {
            List<RenderStatusResults> renderStatusResultsList;
            try {
                renderStatusResultsList = this.eyesConnector.renderStatusById(ids.toArray(new String[0]));
            }
            catch (Exception e) {
                GeneralUtils.logExceptionStackTrace(this.logger, e);
                continue;
            }
            if (renderStatusResultsList == null || renderStatusResultsList.isEmpty() || renderStatusResultsList.get(0) == null) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    GeneralUtils.logExceptionStackTrace(this.logger, e);
                }
                continue;
            }
            this.sampleRenderingStatus(runningRenders, ids, renderStatusResultsList);
            if (ids.size() <= 0) continue;
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException e) {
                GeneralUtils.logExceptionStackTrace(this.logger, e);
            }
        } while (!ids.isEmpty() && !this.isTimeElapsed.get());
        this.timer.cancel();
        if (!ids.isEmpty()) {
            this.logger.verbose("Render ids that didn't complete in time : ");
            this.logger.verbose(ids.toString());
        }
        block7: for (String id : ids) {
            for (Map.Entry<RunningRender, RenderRequest> kvp : runningRenders.entrySet()) {
                RunningRender renderedRender = kvp.getKey();
                RenderRequest renderRequest = kvp.getValue();
                String renderId = renderedRender.getRenderId();
                if (!renderId.equalsIgnoreCase(id)) continue;
                this.logger.verbose("removing failed render id: " + id);
                VisualGridTask visualGridTask = runningRenders.get(renderedRender).getVisualGridTask();
                visualGridTask.setRenderError(id, "too long rendering(rendering exceeded 150 sec)", renderRequest);
                continue block7;
            }
        }
        ICheckSettingsInternal rcInternal = (ICheckSettingsInternal)((Object)this.checkSettings);
        this.logger.verbose("marking task as complete: " + rcInternal.getName());
        this.isTaskComplete.set(true);
        this.notifySuccessAllListeners();
        this.logger.verbose("exit");
    }

    private void sampleRenderingStatus(Map<RunningRender, RenderRequest> runningRenders, List<String> ids, List<RenderStatusResults> renderStatusResultsList) {
        this.logger.verbose("enter - renderStatusResultsList.size: " + renderStatusResultsList.size());
        int j = 0;
        block0: for (int i = 0; i < renderStatusResultsList.size(); ++i) {
            RenderStatusResults renderStatusResults = renderStatusResultsList.get(i);
            if (renderStatusResults == null) continue;
            RenderStatus renderStatus = renderStatusResults.getStatus();
            boolean isRenderedStatus = renderStatus == RenderStatus.RENDERED;
            boolean isErrorStatus = renderStatus == RenderStatus.ERROR;
            this.logger.verbose("renderStatusResults - " + renderStatusResults);
            if (isRenderedStatus || isErrorStatus) {
                String removedId = ids.remove(j);
                for (Map.Entry<RunningRender, RenderRequest> kvp : runningRenders.entrySet()) {
                    RunningRender renderedRender = kvp.getKey();
                    RenderRequest renderRequest = kvp.getValue();
                    String renderId = renderedRender.getRenderId();
                    if (!renderId.equalsIgnoreCase(removedId)) continue;
                    VisualGridTask visualGridTask = runningRenders.get(renderedRender).getVisualGridTask();
                    Iterator<VisualGridTask> iterator = this.openVisualGridTaskList.iterator();
                    while (iterator.hasNext()) {
                        VisualGridTask openVisualGridTask = iterator.next();
                        if (openVisualGridTask.getRunningTest() != visualGridTask.getRunningTest()) continue;
                        if (isRenderedStatus) {
                            this.logger.verbose("setting openVisualGridTask " + openVisualGridTask + " render result: " + renderStatusResults + " to url " + this.domData.getUrl());
                            openVisualGridTask.setRenderResult(renderStatusResults);
                        } else {
                            this.logger.verbose("setting openVisualGridTask " + openVisualGridTask + " render error: " + removedId + " to url " + this.domData.getUrl());
                            openVisualGridTask.setRenderError(removedId, renderStatusResults.getError(), renderRequest);
                        }
                        iterator.remove();
                    }
                    this.logger.verbose("setting visualGridTask " + visualGridTask + " render result: " + renderStatusResults + " to url " + this.domData.getUrl());
                    String error = renderStatusResults.getError();
                    if (error != null) {
                        GeneralUtils.logExceptionStackTrace(this.logger, new Exception(error));
                        visualGridTask.setRenderError(renderId, error, renderRequest);
                    }
                    visualGridTask.setRenderResult(renderStatusResults);
                    continue block0;
                }
                continue;
            }
            ++j;
        }
        this.logger.verbose("exit");
    }

    @Override
    public boolean getIsTaskComplete() {
        return this.isTaskComplete.get();
    }

    public void addListener(RenderTaskListener listener) {
        this.listeners.add(listener);
    }

    private class TimeoutTask
    extends TimerTask {
        private TimeoutTask() {
        }

        @Override
        public void run() {
            RenderingTask.this.logger.verbose("VG is Timed out!");
            RenderingTask.this.isTimeElapsed.set(true);
        }
    }

    static class TextualDataResource {
        String mimeType;
        URI uri;
        String data;
        byte[] originalData;

        TextualDataResource() {
        }
    }

    public static interface RenderTaskListener {
        public void onRenderSuccess();

        public void onRenderFailed(Exception var1);
    }
}

