/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.services;

import com.applitools.eyes.Logger;
import com.applitools.eyes.TestResultContainer;
import com.applitools.utils.GeneralUtils;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class EyesService
extends Thread {
    protected final int threadPoolSize;
    protected ExecutorService executor;
    protected final EyesServiceListener listener;
    private final Object debugLock;
    protected final Tasker tasker;
    protected boolean isServiceOn = true;
    private boolean isPaused;
    protected Logger logger;

    public void setLogger(Logger logger) {
        if (this.logger == null) {
            this.logger = logger;
        } else {
            this.logger.setLogHandler(logger.getLogHandler());
        }
    }

    public EyesService(String serviceName, ThreadGroup servicesGroup, Logger logger, int threadPoolSize, Object debugLock, EyesServiceListener listener, Tasker tasker) {
        super(servicesGroup, serviceName);
        this.threadPoolSize = threadPoolSize;
        this.executor = new ThreadPoolExecutor(this.threadPoolSize, threadPoolSize, 1L, TimeUnit.DAYS, new ArrayBlockingQueue<Runnable>(20));
        this.listener = listener;
        this.logger = logger;
        this.debugLock = debugLock;
        this.tasker = tasker;
        this.isPaused = debugLock != null;
    }

    @Override
    public void run() {
        try {
            this.logger.log("Service '" + this.getName() + "' had started");
            while (this.isServiceOn) {
                this.pauseIfNeeded();
                this.runNextTask();
            }
            if (this.executor != null) {
                this.executor.shutdown();
            }
            this.logger.log("Service '" + this.getName() + "' is finished");
        }
        catch (Throwable e) {
            GeneralUtils.logExceptionStackTrace(this.logger, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pauseIfNeeded() {
        if (this.isPaused) {
            Object object = this.debugLock;
            synchronized (object) {
                try {
                    this.debugLock.wait();
                    this.isPaused = false;
                }
                catch (InterruptedException e) {
                    GeneralUtils.logExceptionStackTrace(this.logger, e);
                }
            }
        }
    }

    void runNextTask() {
        if (!this.isServiceOn) {
            return;
        }
        FutureTask<TestResultContainer> task = this.listener.getNextTask(this.tasker);
        if (task != null) {
            this.pauseIfNeeded();
            this.executor.submit(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debugNotify() {
        if (this.debugLock != null) {
            Object object = this.debugLock;
            synchronized (object) {
                this.debugLock.notify();
            }
        }
    }

    public void debugPauseService() {
        this.isPaused = true;
    }

    void stopService() {
        this.logger.verbose(this.getName() + " service is Stopped");
        this.isServiceOn = false;
    }

    public static interface EyesServiceListener {
        public FutureTask<TestResultContainer> getNextTask(Tasker var1);
    }

    static interface Tasker {
        public FutureTask<TestResultContainer> getNextTask();
    }
}

