/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.services;

import com.applitools.eyes.Logger;
import com.applitools.eyes.visualgrid.model.RenderingTask;
import com.applitools.utils.GeneralUtils;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class RenderingGridService
extends Thread {
    private static final int FACTOR = 5;
    private final Object debugLock;
    private final RGServiceListener listener;
    private final int maximumPoolSize;
    private boolean isServiceOn = true;
    private ExecutorService executor;
    protected Logger logger;
    private boolean isPaused;
    private AtomicInteger concurrentSession = new AtomicInteger(0);
    private final Object concurrencyLock;

    public void setLogger(Logger logger) {
        if (this.logger == null) {
            this.logger = logger;
        } else {
            this.logger.setLogHandler(logger.getLogHandler());
        }
    }

    RenderingGridService(String serviceName, ThreadGroup servicesGroup, Logger logger, int threadPoolSize, Object debugLock, RGServiceListener listener, Object concurrencyLock) {
        super(servicesGroup, serviceName);
        this.maximumPoolSize = threadPoolSize * 5;
        this.executor = new ThreadPoolExecutor(threadPoolSize, this.maximumPoolSize, 1L, TimeUnit.DAYS, new ArrayBlockingQueue<Runnable>(20));
        this.debugLock = debugLock;
        this.listener = listener;
        this.logger = logger;
        this.isPaused = debugLock != null;
        this.concurrencyLock = concurrencyLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.logger.log("Service '" + this.getName() + "' had started");
            while (this.isServiceOn) {
                if (this.isPaused) {
                    Object object = this.debugLock;
                    synchronized (object) {
                        try {
                            this.debugLock.wait();
                            this.isPaused = false;
                        }
                        catch (InterruptedException e) {
                            GeneralUtils.logExceptionStackTrace(this.logger, e);
                        }
                    }
                }
                this.runNextTask();
            }
            if (this.executor != null) {
                this.executor.shutdown();
            }
            this.logger.log("Service '" + this.getName() + "' is finished");
        }
        catch (Throwable e) {
            this.logger.verbose("Rendering Service Error : " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runNextTask() {
        if (!this.isServiceOn) {
            return;
        }
        if (this.maximumPoolSize > this.concurrentSession.get()) {
            RenderingTask task = this.listener.getNextTask();
            if (task != null) {
                task.addListener(new RenderingTask.RenderTaskListener(){

                    @Override
                    public void onRenderSuccess() {
                        RenderingGridService.this.debugNotify();
                        RenderingGridService.this.onRenderFinish();
                    }

                    @Override
                    public void onRenderFailed(Exception e) {
                        RenderingGridService.this.debugNotify();
                        RenderingGridService.this.onRenderFinish();
                    }
                });
                try {
                    this.concurrentSession.incrementAndGet();
                    this.executor.submit(task);
                }
                catch (Exception e) {
                    this.logger.verbose("Exception in - this.executor.submit(task); ");
                    if (e.getMessage().contains("Read timed out")) {
                        this.logger.verbose("Read timed out");
                    }
                    e.printStackTrace();
                    GeneralUtils.logExceptionStackTrace(this.logger, e);
                }
            }
        } else {
            this.logger.verbose("trying to sync lock");
            Object object = this.concurrencyLock;
            synchronized (object) {
                try {
                    this.logger.verbose("Waiting for concurrency to be free");
                    this.concurrencyLock.wait();
                    this.logger.verbose("concurrency free");
                }
                catch (InterruptedException e) {
                    GeneralUtils.logExceptionStackTrace(this.logger, e);
                }
            }
            this.logger.verbose("releasing lock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRenderFinish() {
        this.concurrentSession.decrementAndGet();
        this.logger.verbose("trying to sync lock");
        Object object = this.concurrencyLock;
        synchronized (object) {
            this.concurrencyLock.notify();
        }
        this.logger.verbose("releasing lock");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debugNotify() {
        if (this.debugLock != null) {
            Object object = this.debugLock;
            synchronized (object) {
                this.debugLock.notify();
            }
        }
    }

    public void debugPauseService() {
        this.isPaused = true;
    }

    public void stopService() {
        this.isServiceOn = false;
    }

    public static interface RGServiceListener {
        public RenderingTask getNextTask();
    }
}

