/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.connectivity;

import com.applitools.connectivity.ResponseParsingCallback;
import com.applitools.connectivity.RestClient;
import com.applitools.connectivity.UfgConnector;
import com.applitools.connectivity.UploadCallback;
import com.applitools.connectivity.api.AsyncRequest;
import com.applitools.connectivity.api.AsyncRequestCallback;
import com.applitools.connectivity.api.HttpClient;
import com.applitools.connectivity.api.Response;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.MobileDeviceInfo;
import com.applitools.eyes.Region;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.SessionStartInfo;
import com.applitools.eyes.SessionStopInfo;
import com.applitools.eyes.SyncTaskListener;
import com.applitools.eyes.TaskListener;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.locators.BaseOcrRegion;
import com.applitools.eyes.locators.TextRegion;
import com.applitools.eyes.locators.TextRegionSettings;
import com.applitools.eyes.locators.VisualLocatorsData;
import com.applitools.eyes.logging.LogSessionsClientEvents;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.logging.Type;
import com.applitools.eyes.visualgrid.model.HashObject;
import com.applitools.eyes.visualgrid.model.JobInfo;
import com.applitools.eyes.visualgrid.model.RenderRequest;
import com.applitools.eyes.visualgrid.model.RenderStatusResults;
import com.applitools.eyes.visualgrid.model.RenderingInfo;
import com.applitools.eyes.visualgrid.model.RunningRender;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;

public class ServerConnector
extends UfgConnector {
    static final String CLOSE_BATCH = "api/sessions/batches/%s/close/bypointerid";
    static final String RENDER_STATUS = "/render-status";
    static final String RENDER = "/render";
    static final String RESOURCE_STATUS = "/query/resources-exist";
    static final String RENDERER_INFO = "/job-info";
    static final String MOBILE_DEVICES_PATH = "/app/info/mobile/devices";
    public static final String API_PATH = "/api/sessions/running";
    private static final String LOG_PATH = "/api/sessions/log";
    private static Map<String, MobileDeviceInfo> mobileDevicesInfo = null;

    public ServerConnector(Logger logger, URI serverUrl, int timeout) {
        super(logger, serverUrl, timeout);
    }

    public ServerConnector(Logger logger, URI serverUrl) {
        this(logger, serverUrl, 300000);
    }

    public ServerConnector(Logger logger) {
        this(logger, GeneralUtils.getServerUrl());
    }

    public ServerConnector() {
        this(new Logger());
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
        this.logger.setAgentId(agentId);
    }

    public String getAgentId() {
        return this.agentId;
    }

    public void setServerUrl(URI serverUrl) {
        this.setServerUrlBase(serverUrl);
    }

    public URI getServerUrl() {
        return this.getServerUrlBase();
    }

    public void updateClient(HttpClient client) {
        this.restClient = client;
    }

    public void sendLogs(AsyncRequestCallback callback, LogSessionsClientEvents clientEvents) {
        ArgumentGuard.notNull((Object)clientEvents, (String)"clientEvents");
        AsyncRequest request = this.makeEyesRequest(new RestClient.HttpRequestBuilder(){

            public AsyncRequest build() {
                return ServerConnector.this.restClient.target(ServerConnector.this.serverUrl).path(ServerConnector.LOG_PATH).queryParam("apiKey", ServerConnector.this.getApiKey()).asyncRequest(new String[]{"application/json"});
            }
        });
        try {
            String data = this.jsonMapper.writeValueAsString((Object)clientEvents);
            this.sendAsyncRequest(request, "POST", callback, data, "application/json");
        }
        catch (JsonProcessingException e) {
            throw new EyesException("Failed converting client events to string", (Throwable)e);
        }
    }

    public void startSession(final TaskListener<RunningSession> listener, final SessionStartInfo sessionStartInfo) throws EyesException {
        String postData;
        ArgumentGuard.notNull((Object)sessionStartInfo, (String)"sessionStartInfo");
        this.initClient();
        try {
            this.jsonMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
            postData = this.jsonMapper.writeValueAsString((Object)sessionStartInfo);
            this.jsonMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        }
        catch (IOException e) {
            throw new EyesException("Failed to convert sessionStartInfo into Json string!", (Throwable)e);
        }
        AsyncRequest request = this.makeEyesRequest(new RestClient.HttpRequestBuilder(){

            public AsyncRequest build() {
                return ServerConnector.this.restClient.target(ServerConnector.this.serverUrl).path(ServerConnector.API_PATH).queryParam("apiKey", ServerConnector.this.getApiKey()).asyncRequest(new String[]{"application/json"});
            }
        });
        AsyncRequestCallback callback = new AsyncRequestCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(Response response) {
                try {
                    if (response.getStatusCode() == 503) {
                        RunningSession runningSession = new RunningSession();
                        runningSession.setConcurrencyFull(true);
                        listener.onComplete((Object)runningSession);
                        return;
                    }
                    ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
                    validStatusCodes.add(200);
                    validStatusCodes.add(201);
                    RunningSession runningSession = (RunningSession)ServerConnector.this.parseResponseWithJsonData(response, validStatusCodes, (TypeReference)new TypeReference<RunningSession>(){});
                    if (runningSession.getIsNew() == null) {
                        runningSession.setIsNew(response.getStatusCode() == 201);
                    }
                    runningSession.setConcurrencyFull(false);
                    listener.onComplete((Object)runningSession);
                }
                catch (Throwable t) {
                    this.onFail(t);
                }
                finally {
                    response.close();
                }
            }

            public void onFail(Throwable throwable) {
                GeneralUtils.logExceptionStackTrace((Logger)ServerConnector.this.logger, (Stage)Stage.OPEN, (Throwable)throwable, (String[])new String[]{sessionStartInfo.getTestId()});
                listener.onFail();
            }
        };
        this.sendLongRequest(request, "POST", callback, postData, "application/json");
    }

    public void stopSession(TaskListener<TestResults> listener, final SessionStopInfo sessionStopInfo) throws EyesException {
        ArgumentGuard.notNull((Object)sessionStopInfo, (String)"sessionStopInfo");
        ArgumentGuard.notNull((Object)sessionStopInfo.getRunningSession(), (String)"runningSession");
        AsyncRequest request = this.makeEyesRequest(new RestClient.HttpRequestBuilder(){

            public AsyncRequest build() {
                return ServerConnector.this.restClient.target(ServerConnector.this.serverUrl).path(ServerConnector.API_PATH).path(sessionStopInfo.getRunningSession().getId()).queryParam("apiKey", ServerConnector.this.getApiKey()).queryParam("aborted", String.valueOf(sessionStopInfo.isAborted())).queryParam("updateBaseline", String.valueOf(sessionStopInfo.shouldSave())).asyncRequest(new String[]{"application/json"});
            }
        });
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
        validStatusCodes.add(200);
        ResponseParsingCallback callback = new ResponseParsingCallback((RestClient)this, validStatusCodes, listener, (TypeReference)new TypeReference<TestResults>(){});
        this.sendLongRequest(request, "DELETE", (AsyncRequestCallback)callback, null, null);
    }

    public void deleteSession(final TaskListener<Void> listener, final TestResults testResults) {
        ArgumentGuard.notNull((Object)testResults, (String)"testResults");
        if (testResults.getId() == null || testResults.getBatchId() == null || testResults.getSecretToken() == null) {
            return;
        }
        this.initClient();
        AsyncRequest request = this.makeEyesRequest(new RestClient.HttpRequestBuilder(){

            public AsyncRequest build() {
                return ServerConnector.this.restClient.target(ServerConnector.this.serverUrl).path("/api/sessions/batches/").path(testResults.getBatchId()).path("/").path(testResults.getId()).queryParam("apiKey", ServerConnector.this.getApiKey()).queryParam("AccessToken", testResults.getSecretToken()).asyncRequest(new String[]{"application/json"});
            }
        });
        this.sendAsyncRequest(request, "DELETE", new AsyncRequestCallback(){

            public void onComplete(Response response) {
                listener.onComplete(null);
            }

            public void onFail(Throwable throwable) {
                listener.onFail();
            }
        });
    }

    public void matchWindow(TaskListener<MatchResult> listener, final MatchWindowData matchData) throws EyesException {
        String jsonData;
        ArgumentGuard.notNull((Object)matchData, (String)"matchData");
        ArgumentGuard.notNull((Object)matchData.getRunningSession(), (String)"runningSession");
        try {
            jsonData = this.jsonMapper.writeValueAsString((Object)matchData);
        }
        catch (IOException e) {
            throw new EyesException("Failed to serialize model for matchWindow!", (Throwable)e);
        }
        AsyncRequest request = this.makeEyesRequest(new RestClient.HttpRequestBuilder(){

            public AsyncRequest build() {
                return ServerConnector.this.restClient.target(ServerConnector.this.serverUrl).path(ServerConnector.API_PATH).path(matchData.getRunningSession().getId()).queryParam("apiKey", ServerConnector.this.getApiKey()).asyncRequest(new String[]{"application/json"});
            }
        });
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>(1);
        validStatusCodes.add(200);
        ResponseParsingCallback callback = new ResponseParsingCallback((RestClient)this, validStatusCodes, listener, (TypeReference)new TypeReference<MatchResult>(){});
        this.sendLongRequest(request, "POST", (AsyncRequestCallback)callback, jsonData, "application/json");
    }

    public void render(final TaskListener<List<RunningRender>> listener, List<RenderRequest> renderRequests) {
        ArgumentGuard.notNull(renderRequests, (String)"renderRequests");
        for (RenderRequest renderRequest : renderRequests) {
            this.logger.log(TraceLevel.Info, renderRequest.getTestId(), Stage.RENDER, new Pair[]{Pair.of((Object)"renderRequest", (Object)renderRequest)});
        }
        AsyncRequest request = this.restClient.target(this.getRenderInfo().getServiceUrl()).path(RENDER).asyncRequest(new String[]{"application/json"});
        request.header("X-Auth-Token", this.getRenderInfo().getAccessToken());
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
        validStatusCodes.add(200);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            String json = objectMapper.writeValueAsString(renderRequests);
            ResponseParsingCallback callback = new ResponseParsingCallback((RestClient)this, validStatusCodes, (TaskListener)new TaskListener<RunningRender[]>(){

                public void onComplete(RunningRender[] runningRenders) {
                    listener.onComplete((Object)(runningRenders == null ? null : new ArrayList<RunningRender>(Arrays.asList(runningRenders))));
                }

                public void onFail() {
                    listener.onFail();
                }
            }, (TypeReference)new TypeReference<RunningRender[]>(){});
            this.sendAsyncRequest(request, "POST", (AsyncRequestCallback)callback, json, "application/json");
        }
        catch (JsonProcessingException e) {
            throw new EyesException("Render failed", (Throwable)e);
        }
    }

    public void renderStatusById(final TaskListener<List<RenderStatusResults>> listener, List<String> testIds, List<String> renderIds) {
        try {
            ArgumentGuard.notNull(testIds, (String)"testIds");
            ArgumentGuard.notNull(renderIds, (String)"renderIds");
            for (int i = 0; i < testIds.size(); ++i) {
                this.logger.log(TraceLevel.Info, Collections.singleton(testIds.get(i)), Stage.RENDER, Type.RENDER_STATUS, new Pair[]{Pair.of((Object)"renderId", (Object)renderIds.get(i))});
            }
            AsyncRequest request = this.makeEyesRequest(new RestClient.HttpRequestBuilder(){

                public AsyncRequest build() {
                    return ServerConnector.this.restClient.target(ServerConnector.this.getRenderInfo().getServiceUrl()).path(ServerConnector.RENDER_STATUS).asyncRequest(new String[]{"text/plain"});
                }
            });
            request.header("X-Auth-Token", this.getRenderInfo().getAccessToken());
            ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
            validStatusCodes.add(200);
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            String json = objectMapper.writeValueAsString(renderIds);
            ResponseParsingCallback callback = new ResponseParsingCallback((RestClient)this, validStatusCodes, (TaskListener)new TaskListener<RenderStatusResults[]>(){

                public void onComplete(RenderStatusResults[] renderStatusResults) {
                    if (renderStatusResults == null) {
                        listener.onComplete(null);
                        return;
                    }
                    listener.onComplete(new ArrayList<RenderStatusResults>(Arrays.asList(renderStatusResults)));
                }

                public void onFail() {
                    listener.onFail();
                }
            }, (TypeReference)new TypeReference<RenderStatusResults[]>(){});
            this.sendAsyncRequest(request, "POST", (AsyncRequestCallback)callback, json, "application/json");
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.RENDER, (Type)Type.RENDER_STATUS, (Throwable)e, (String[])testIds.toArray(new String[0]));
            listener.onComplete(null);
        }
    }

    public void checkResourceStatus(TaskListener<Boolean[]> listener, Set<String> testIds, String renderId, HashObject ... hashes) {
        try {
            ArgumentGuard.notNull((Object)hashes, (String)"hashes");
            this.logger.log(TraceLevel.Info, testIds, Stage.RESOURCE_COLLECTION, Type.CHECK_RESOURCE, new Pair[]{Pair.of((Object)"hashes", (Object)hashes)});
            renderId = renderId == null ? "NONE" : renderId;
            AsyncRequest request = this.restClient.target(this.getRenderInfo().getServiceUrl()).queryParam("rg_render-id", renderId).path(RESOURCE_STATUS).asyncRequest(new String[]{"application/json"});
            request.header("X-Auth-Token", this.getRenderInfo().getAccessToken());
            ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
            validStatusCodes.add(200);
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            String json = objectMapper.writeValueAsString((Object)hashes);
            ResponseParsingCallback callback = new ResponseParsingCallback((RestClient)this, validStatusCodes, listener, (TypeReference)new TypeReference<Boolean[]>(){});
            this.sendAsyncRequest(request, "POST", (AsyncRequestCallback)callback, json, "application/json");
        }
        catch (Throwable e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.RESOURCE_COLLECTION, (Type)Type.CHECK_RESOURCE, (Throwable)e, (String[])testIds.toArray(new String[0]));
            listener.onComplete(null);
        }
    }

    public void getJobInfo(TaskListener<JobInfo[]> listener, RenderRequest[] browserInfos) {
        try {
            AsyncRequest request = this.restClient.target(this.getRenderInfo().getServiceUrl()).path(RENDERER_INFO).asyncRequest(new String[]{"application/json"});
            request.header("X-Auth-Token", this.getRenderInfo().getAccessToken());
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
            String json = objectMapper.writeValueAsString((Object)browserInfos);
            ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
            validStatusCodes.add(200);
            ResponseParsingCallback callback = new ResponseParsingCallback((RestClient)this, validStatusCodes, listener, (TypeReference)new TypeReference<JobInfo[]>(){});
            this.sendAsyncRequest(request, "POST", (AsyncRequestCallback)callback, json, "application/json");
        }
        catch (Throwable t) {
            HashSet<String> testIds = new HashSet<String>();
            for (RenderRequest renderRequest : browserInfos) {
                testIds.add(renderRequest.getTestId());
            }
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.OPEN, (Type)Type.JOB_INFO, (Throwable)t, (String[])testIds.toArray(new String[0]));
            listener.onFail();
        }
    }

    public void uploadData(TaskListener<String> listener, byte[] bytes, String contentType, String mediaType) {
        String targetUrl;
        RenderingInfo renderingInfo = this.getRenderInfo();
        if (renderingInfo == null || (targetUrl = renderingInfo.getResultsUrl()) == null) {
            listener.onComplete(null);
            return;
        }
        UUID uuid = UUID.randomUUID();
        String finalUrl = targetUrl.replace("__random__", uuid.toString());
        UploadCallback callback = new UploadCallback(listener, this, finalUrl, bytes, contentType, mediaType);
        callback.uploadDataAsync();
    }

    public void uploadImage(TaskListener<String> listener, byte[] bytes) {
        this.uploadData(listener, bytes, "image/png", "image/png");
    }

    public void postLocators(TaskListener<Map<String, List<Region>>> listener, VisualLocatorsData visualLocatorsData) {
        String postData;
        try {
            this.jsonMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
            postData = this.jsonMapper.writeValueAsString((Object)visualLocatorsData);
        }
        catch (IOException e) {
            throw new EyesException("Failed to convert visualLocatorsData into Json string!", (Throwable)e);
        }
        AsyncRequest request = this.makeEyesRequest(new RestClient.HttpRequestBuilder(){

            public AsyncRequest build() {
                return ServerConnector.this.restClient.target(ServerConnector.this.serverUrl).path("api/locators/locate").queryParam("apiKey", ServerConnector.this.getApiKey()).asyncRequest(new String[]{"application/json"});
            }
        });
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
        validStatusCodes.add(200);
        ResponseParsingCallback callback = new ResponseParsingCallback((RestClient)this, validStatusCodes, listener, (TypeReference)new TypeReference<Map<String, List<Region>>>(){});
        this.sendLongRequest(request, "POST", (AsyncRequestCallback)callback, postData, "application/json");
    }

    public void postOcrRegions(TaskListener<List<String>> listener, BaseOcrRegion ocrRegion) {
        String postData;
        try {
            postData = this.jsonMapper.writeValueAsString((Object)ocrRegion);
        }
        catch (IOException e) {
            throw new EyesException("Failed serializing object to string", (Throwable)e);
        }
        AsyncRequest request = this.makeEyesRequest(new RestClient.HttpRequestBuilder(){

            public AsyncRequest build() {
                return ServerConnector.this.restClient.target(ServerConnector.this.serverUrl).path("/api/sessions/running/images/text").queryParam("apiKey", ServerConnector.this.getApiKey()).asyncRequest(new String[]{"application/json"});
            }
        });
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
        validStatusCodes.add(200);
        ResponseParsingCallback callback = new ResponseParsingCallback((RestClient)this, validStatusCodes, listener, (TypeReference)new TypeReference<List<String>>(){});
        this.sendLongRequest(request, "POST", (AsyncRequestCallback)callback, postData, "application/json");
    }

    public void postTextRegions(TaskListener<Map<String, List<TextRegion>>> listener, TextRegionSettings settings) {
        String postData;
        try {
            postData = this.jsonMapper.writeValueAsString((Object)settings);
        }
        catch (IOException e) {
            throw new EyesException("Failed serializing object to string", (Throwable)e);
        }
        AsyncRequest request = this.makeEyesRequest(new RestClient.HttpRequestBuilder(){

            public AsyncRequest build() {
                return ServerConnector.this.restClient.target(ServerConnector.this.serverUrl).path("/api/sessions/running/images/textregions").queryParam("apiKey", ServerConnector.this.getApiKey()).asyncRequest(new String[]{"application/json"});
            }
        });
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
        validStatusCodes.add(200);
        ResponseParsingCallback callback = new ResponseParsingCallback((RestClient)this, validStatusCodes, listener, (TypeReference)new TypeReference<Map<String, List<TextRegion>>>(){});
        this.sendLongRequest(request, "POST", (AsyncRequestCallback)callback, postData, "application/json");
    }

    public void closeBatch(String batchId) {
        this.closeBatch(batchId, this.serverUrl.toString());
    }

    public void closeBatch(String batchId, String url) {
        SyncTaskListener listener = new SyncTaskListener(this.logger, "closeBatch");
        this.closeBatchAsync((TaskListener<Void>)listener, batchId, url);
        listener.get();
    }

    public void closeBatchAsync(final TaskListener<Void> listener, String batchId, final String url) {
        ArgumentGuard.notNull((Object)batchId, (String)"batchId");
        if (this.getApiKey() == null) {
            this.logger.log(TraceLevel.Error, null, Stage.CLOSE, Type.CLOSE_BATCH, new Pair[]{Pair.of((Object)"apiKey", (Object)"null")});
            listener.onFail();
            return;
        }
        final String path = String.format(CLOSE_BATCH, batchId);
        this.initClient();
        AsyncRequest request = this.makeEyesRequest(new RestClient.HttpRequestBuilder(){

            public AsyncRequest build() {
                return ServerConnector.this.restClient.target(url).path(path).queryParam("apiKey", ServerConnector.this.getApiKey()).asyncRequest(new String[]{null});
            }
        });
        this.logger.log(new HashSet(), Stage.CLOSE, Type.CLOSE_BATCH, new Pair[]{Pair.of((Object)"batchId", (Object)batchId)});
        this.sendAsyncRequest(request, "DELETE", new AsyncRequestCallback(){

            public void onComplete(Response response) {
                try {
                    ServerConnector.this.closeConnector();
                }
                catch (Throwable t) {
                    GeneralUtils.logExceptionStackTrace((Logger)ServerConnector.this.logger, (Stage)Stage.CLOSE, (Type)Type.CLOSE_BATCH, (Throwable)t, (String[])new String[0]);
                }
                finally {
                    listener.onComplete(null);
                }
            }

            public void onFail(Throwable throwable) {
                try {
                    GeneralUtils.logExceptionStackTrace((Logger)ServerConnector.this.logger, (Stage)Stage.CLOSE, (Type)Type.CLOSE_BATCH, (Throwable)throwable, (String[])new String[0]);
                    ServerConnector.this.closeConnector();
                }
                finally {
                    listener.onFail();
                }
            }
        });
    }

    public void closeConnector() {
        if (this.restClient != null) {
            this.restClient.close();
        }
    }

    public Map<String, MobileDeviceInfo> getMobileDevicesInfo() {
        if (mobileDevicesInfo != null) {
            return mobileDevicesInfo;
        }
        try {
            mobileDevicesInfo = (Map)this.getFromServer(new RestClient.HttpRequestBuilder(){

                public AsyncRequest build() {
                    return ServerConnector.this.restClient.target(ServerConnector.this.serverUrl).path(ServerConnector.MOBILE_DEVICES_PATH).queryParam("apiKey", ServerConnector.this.getApiKey()).asyncRequest(new String[0]);
                }
            }, (TypeReference)new TypeReference<Map<String, MobileDeviceInfo>>(){});
        }
        catch (Throwable t) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.GENERAL, (Throwable)t, (String[])new String[0]);
            mobileDevicesInfo = new HashMap<String, MobileDeviceInfo>();
        }
        return mobileDevicesInfo;
    }
}

