/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.CutProvider;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;

public class FixedCutProvider
implements CutProvider {
    protected Logger logger = new Logger();
    protected final int header;
    protected final int footer;
    protected final int left;
    protected final int right;

    public FixedCutProvider(int header, int footer, int left, int right) {
        this.header = header;
        this.footer = footer;
        this.left = left;
        this.right = right;
    }

    @Override
    public BufferedImage cut(BufferedImage image) {
        if (this.header == 0 && this.footer == 0 && this.left == 0 && this.right == 0) {
            return image;
        }
        Region targetRegion = new Region(this.left, this.header, image.getWidth() - this.left - this.right, image.getHeight() - this.header - this.footer);
        return ImageUtils.cropImage(image, targetRegion);
    }

    @Override
    public CutProvider scale(double scaleRatio) {
        int scaledHeader = (int)Math.ceil((double)this.header * scaleRatio);
        int scaledFooter = (int)Math.ceil((double)this.footer * scaleRatio);
        int scaledLeft = (int)Math.ceil((double)this.left * scaleRatio);
        int scaledRight = (int)Math.ceil((double)this.right * scaleRatio);
        FixedCutProvider cutProvider = new FixedCutProvider(scaledHeader, scaledFooter, scaledLeft, scaledRight);
        cutProvider.setLogger(this.logger);
        return cutProvider;
    }

    @Override
    public void setLogger(Logger logger) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        this.logger = logger;
    }

    @Override
    public Region toRegion(RectangleSize size) {
        Region rect = new Region(this.left, this.header, size.getWidth() - this.left - this.right, size.getHeight() - this.header - this.footer);
        return rect;
    }
}

