/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.TestResultContainer;
import com.applitools.eyes.TestResults;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TestResultsSummary
implements Iterable<TestResultContainer> {
    private List<TestResultContainer> allResults;
    private int passed = 0;
    private int unresolved = 0;
    private int failed = 0;
    private int exceptions = 0;
    private int mismatches = 0;
    private int missing = 0;
    private int matches = 0;

    public TestResultsSummary(List<TestResultContainer> allResults) {
        this.allResults = allResults;
        for (TestResultContainer resultContainer : allResults) {
            TestResults result = null;
            if (resultContainer != null) {
                if (resultContainer.getException() != null) {
                    ++this.exceptions;
                }
                result = resultContainer.getTestResults();
            }
            if (result == null) continue;
            if (result.getStatus() != null) {
                switch (result.getStatus()) {
                    case Failed: {
                        ++this.failed;
                        break;
                    }
                    case Passed: {
                        ++this.passed;
                        break;
                    }
                    case Unresolved: {
                        ++this.unresolved;
                    }
                }
            }
            this.matches += result.getMatches();
            this.missing += result.getMissing();
            this.mismatches += result.getMismatches();
        }
    }

    public TestResultContainer[] getAllResults() {
        return this.allResults.toArray(new TestResultContainer[0]);
    }

    public String toString() {
        return "result summary {\n\tall results=\n\t\t" + StringUtils.join(this.allResults, (String)"\n\t\t") + "\n\tpassed=" + this.passed + "\n\tunresolved=" + this.unresolved + "\n\tfailed=" + this.failed + "\n\texceptions=" + this.exceptions + "\n\tmismatches=" + this.mismatches + "\n\tmissing=" + this.missing + "\n\tmatches=" + this.matches + "\n}";
    }

    @Override
    public Iterator<TestResultContainer> iterator() {
        return this.allResults.iterator();
    }

    public int size() {
        return this.allResults.size();
    }
}

