/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.visualgrid.services;

import com.applitools.ICheckSettings;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.visualgrid.model.RenderBrowserInfo;
import com.applitools.eyes.visualgrid.model.RenderStatusResults;
import com.applitools.eyes.visualgrid.model.VisualGridSelector;
import com.applitools.eyes.visualgrid.services.VisualGridRunningTest;
import java.util.List;
import java.util.UUID;

public class CheckTask {
    private final String stepId = UUID.randomUUID().toString();
    private final VisualGridRunningTest runningTest;
    private final ICheckSettings checkSettings;
    private final List<VisualGridSelector[]> regionSelectors;
    private final String source;
    private boolean isMatchStarted = false;
    private RenderStatusResults renderStatusResults;

    public CheckTask(VisualGridRunningTest runningTest, ICheckSettings checkSettings, List<VisualGridSelector[]> regionSelectors, String source) {
        this.runningTest = runningTest;
        this.checkSettings = checkSettings;
        this.regionSelectors = regionSelectors;
        this.source = source;
    }

    public String getStepId() {
        return this.stepId;
    }

    public ICheckSettings getCheckSettings() {
        return this.checkSettings;
    }

    public List<VisualGridSelector[]> getRegionSelectors() {
        return this.regionSelectors;
    }

    public String getSource() {
        return this.source;
    }

    public String getRenderer() {
        return this.runningTest.getRenderer();
    }

    public RenderStatusResults getRenderStatusResults() {
        return this.renderStatusResults;
    }

    public void setRenderStatusResults(RenderStatusResults renderStatusResults) {
        this.renderStatusResults = renderStatusResults;
    }

    public boolean isRenderFinished() {
        return this.renderStatusResults != null;
    }

    public boolean isReadyForRender() {
        return this.runningTest.getIsOpen() && this.runningTest.isCheckTaskReadyForRender(this);
    }

    public boolean isReadyForMatch() {
        return this.isRenderFinished() && !this.isMatchStarted && !this.runningTest.checkTasks.isEmpty() && this.runningTest.checkTasks.get(0).equals(this);
    }

    public MatchWindowData startMatch() {
        this.isMatchStarted = true;
        return this.runningTest.prepareForMatch(this);
    }

    public boolean isMatchStarted() {
        return this.isMatchStarted;
    }

    public String getTestId() {
        return this.runningTest.getTestId();
    }

    public RenderBrowserInfo getBrowserInfo() {
        return this.runningTest.getBrowserInfo();
    }

    public boolean isTestActive() {
        return !this.runningTest.isTestReadyToClose() && !this.runningTest.isTestAborted();
    }

    public void onComplete(MatchResult matchResult) {
        this.runningTest.checkCompleted(this, matchResult);
    }

    public void onFail(Throwable e) {
        this.runningTest.setTestInExceptionMode(e);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckTask that = (CheckTask)o;
        return this.stepId.equals(that.stepId) && this.runningTest.equals(that.runningTest);
    }
}

