/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.connectivity;

import com.applitools.connectivity.RestClient;
import com.applitools.connectivity.api.AsyncRequest;
import com.applitools.connectivity.api.AsyncRequestCallback;
import com.applitools.connectivity.api.ConnectivityTarget;
import com.applitools.connectivity.api.HttpClient;
import com.applitools.connectivity.api.Request;
import com.applitools.connectivity.api.Response;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.IServerConnector;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.Region;
import com.applitools.eyes.RenderingInfo;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.SessionStartInfo;
import com.applitools.eyes.TaskListener;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.VisualLocatorsData;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.brotli.dec.BrotliInputStream;

public class ServerConnector
extends RestClient
implements IServerConnector {
    public static final int DEFAULT_CLIENT_TIMEOUT = 300000;
    public static final int MAX_CONNECTION_RETRIES = 3;
    String API_SESSIONS = "api/sessions";
    String CLOSE_BATCH = "api/sessions/batches/%s/close/bypointerid";
    String RENDER_INFO_PATH = this.API_SESSIONS + "/renderinfo";
    public static final String API_PATH = "/api/sessions/running";
    private String apiKey = null;
    private RenderingInfo renderingInfo;

    public ServerConnector(Logger logger, URI serverUrl, int timeout) {
        super(logger, serverUrl, timeout);
    }

    public ServerConnector(Logger logger, URI serverUrl) {
        this(logger, serverUrl, 300000);
    }

    public ServerConnector(Logger logger) {
        this(logger, GeneralUtils.getServerUrl());
    }

    public ServerConnector() {
        this(new Logger());
    }

    public void setApiKey(String apiKey) {
        ArgumentGuard.notNull((Object)apiKey, (String)"apiKey");
        this.apiKey = apiKey;
    }

    public String getApiKey() {
        return this.apiKey != null ? this.apiKey : GeneralUtils.getEnvString((String)"APPLITOOLS_API_KEY");
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public void setServerUrl(URI serverUrl) {
        this.setServerUrlBase(serverUrl);
    }

    public URI getServerUrl() {
        return this.getServerUrlBase();
    }

    void updateClient(HttpClient client) {
        this.restClient = client;
    }

    @Override
    public Response sendHttpWebRequest(final String url, String method, final String ... accept) {
        Request request = this.makeEyesRequest(new RestClient.HttpRequestBuilder(){

            @Override
            public Request build() {
                return ServerConnector.this.restClient.target(url).queryParam("apiKey", ServerConnector.this.getApiKey()).request(accept);
            }
        });
        String currentTime = GeneralUtils.toRfc1123((Calendar)Calendar.getInstance(TimeZone.getTimeZone("UTC")));
        return request.header("Eyes-Date", currentTime).method(method, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunningSession startSession(SessionStartInfo sessionStartInfo) throws EyesException {
        Response response;
        String postData;
        ArgumentGuard.notNull((Object)sessionStartInfo, (String)"sessionStartInfo");
        this.initClient();
        try {
            this.jsonMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
            postData = this.jsonMapper.writeValueAsString((Object)sessionStartInfo);
            this.jsonMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        }
        catch (IOException e) {
            throw new EyesException("Failed to convert sessionStartInfo into Json string!", (Throwable)e);
        }
        try {
            Request request = this.makeEyesRequest(new RestClient.HttpRequestBuilder(){

                @Override
                public Request build() {
                    return ServerConnector.this.restClient.target(ServerConnector.this.serverUrl).path(ServerConnector.API_PATH).queryParam("apiKey", ServerConnector.this.getApiKey()).request(new String[]{"application/json"});
                }
            });
            response = this.sendLongRequest(request, "POST", postData, "application/json");
        }
        catch (RuntimeException e) {
            this.logger.log("startSession(): Server request failed: " + e.getMessage());
            throw e;
        }
        try {
            ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
            validStatusCodes.add(200);
            validStatusCodes.add(201);
            RunningSession runningSession = this.parseResponseWithJsonData(response, validStatusCodes, new TypeReference<RunningSession>(){});
            if (runningSession.getIsNew() == null) {
                runningSession.setIsNew(Boolean.valueOf(response.getStatusCode() == 201));
            }
            RunningSession runningSession2 = runningSession;
            return runningSession2;
        }
        finally {
            response.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResults stopSession(final RunningSession runningSession, final boolean isAborted, final boolean save) throws EyesException {
        ArgumentGuard.notNull((Object)runningSession, (String)"runningSession");
        Request request = this.makeEyesRequest(new RestClient.HttpRequestBuilder(){

            @Override
            public Request build() {
                return ServerConnector.this.restClient.target(ServerConnector.this.serverUrl).path(ServerConnector.API_PATH).path(runningSession.getId()).queryParam("apiKey", ServerConnector.this.getApiKey()).queryParam("aborted", String.valueOf(isAborted)).queryParam("updateBaseline", String.valueOf(save)).request(new String[]{"application/json"});
            }
        });
        try (Response response = this.sendLongRequest(request, "DELETE", null, null);){
            ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
            validStatusCodes.add(200);
            TestResults testResults = this.parseResponseWithJsonData(response, validStatusCodes, new TypeReference<TestResults>(){});
            return testResults;
        }
    }

    public void deleteSession(final TestResults testResults) {
        ArgumentGuard.notNull((Object)testResults, (String)"testResults");
        Request request = this.makeEyesRequest(new RestClient.HttpRequestBuilder(){

            @Override
            public Request build() {
                return ServerConnector.this.restClient.target(ServerConnector.this.serverUrl).path("/api/sessions/batches/").path(testResults.getBatchId()).path("/").path(testResults.getId()).queryParam("apiKey", ServerConnector.this.getApiKey()).queryParam("AccessToken", testResults.getSecretToken()).request(new String[]{"application/json"});
            }
        });
        Response response = request.method("DELETE", null, null);
        response.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MatchResult matchWindow(final RunningSession runningSession, MatchWindowData matchData) throws EyesException {
        String jsonData;
        ArgumentGuard.notNull((Object)runningSession, (String)"runningSession");
        ArgumentGuard.notNull((Object)matchData, (String)"model");
        try {
            jsonData = this.jsonMapper.writeValueAsString((Object)matchData);
        }
        catch (IOException e) {
            throw new EyesException("Failed to serialize model for matchWindow!", (Throwable)e);
        }
        Request request = this.makeEyesRequest(new RestClient.HttpRequestBuilder(){

            @Override
            public Request build() {
                return ServerConnector.this.restClient.target(ServerConnector.this.serverUrl).path(ServerConnector.API_PATH).path(runningSession.getId()).queryParam("apiKey", ServerConnector.this.getApiKey()).request(new String[]{"application/json"});
            }
        });
        Response response = this.sendLongRequest(request, "POST", jsonData, "application/json");
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>(1);
        validStatusCodes.add(200);
        try {
            MatchResult matchResult = this.parseResponseWithJsonData(response, validStatusCodes, new TypeReference<MatchResult>(){});
            return matchResult;
        }
        finally {
            response.close();
        }
    }

    public Response uploadData(byte[] bytes, RenderingInfo renderingInfo, final String targetUrl, String contentType, final String mediaType) {
        Request request = this.makeEyesRequest(new RestClient.HttpRequestBuilder(){

            @Override
            public Request build() {
                return ServerConnector.this.restClient.target(targetUrl).request(new String[]{mediaType});
            }
        });
        request = request.header("X-Auth-Token", renderingInfo.getAccessToken()).header("x-ms-blob-type", "BlockBlob");
        return request.method("PUT", (Object)bytes, contentType);
    }

    public void downloadString(URL uri, TaskListener<String> listener) {
        this.downloadString(uri, listener, 1);
    }

    public void downloadString(final URL uri, final TaskListener<String> listener, final int attemptNumber) {
        AsyncRequest asyncRequest = this.restClient.target(uri.toString()).asyncRequest(new String[]{"*/*"});
        asyncRequest.method("GET", new AsyncRequestCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(Response response) {
                try {
                    int statusCode = response.getStatusCode();
                    if (statusCode >= 300) {
                        ServerConnector.this.logger.verbose("Got response status code - " + statusCode);
                        listener.onFail();
                        return;
                    }
                    byte[] fileContent = ServerConnector.this.downloadFile(response);
                    listener.onComplete((Object)new String(fileContent));
                }
                catch (Throwable t) {
                    ServerConnector.this.logger.verbose(t.getMessage());
                }
                finally {
                    response.close();
                }
            }

            public void onFail(Throwable throwable) {
                GeneralUtils.logExceptionStackTrace((Logger)ServerConnector.this.logger, (Throwable)throwable);
                if (attemptNumber < 3) {
                    ServerConnector.this.logger.verbose(String.format("Failed downloading resource %s - trying again", uri));
                    ServerConnector.this.downloadString(uri, (TaskListener<String>)listener, attemptNumber + 1);
                } else {
                    listener.onFail();
                }
            }
        }, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderingInfo getRenderInfo() {
        if (this.renderingInfo != null) {
            return this.renderingInfo;
        }
        Request request = this.makeEyesRequest(new RestClient.HttpRequestBuilder(){

            @Override
            public Request build() {
                return ServerConnector.this.restClient.target(ServerConnector.this.serverUrl).path(ServerConnector.this.RENDER_INFO_PATH).queryParam("apiKey", ServerConnector.this.getApiKey()).request(new String[0]);
            }
        });
        Response response = this.sendLongRequest(request, "GET", null, null);
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>(1);
        validStatusCodes.add(200);
        try {
            RenderingInfo renderingInfo = this.renderingInfo = this.parseResponseWithJsonData(response, validStatusCodes, new TypeReference<RenderingInfo>(){});
            return renderingInfo;
        }
        finally {
            response.close();
        }
    }

    public String postViewportImage(byte[] bytes) {
        String targetUrl;
        RenderingInfo renderingInfo = this.getRenderInfo();
        if (renderingInfo != null && (targetUrl = renderingInfo.getResultsUrl()) != null) {
            try {
                UUID uuid = UUID.randomUUID();
                targetUrl = targetUrl.replace("__random__", uuid.toString());
                this.logger.verbose("uploading viewport image to " + targetUrl);
                for (int i = 0; i < 3; ++i) {
                    Response response = this.uploadData(bytes, renderingInfo, targetUrl, "image/png", "image/png");
                    int statusCode = response.getStatusCode();
                    if (statusCode == 200 || statusCode == 201) {
                        return targetUrl;
                    }
                    String errorMessage = String.format("Status: %d %s.", statusCode, response.getStatusPhrase());
                    if (statusCode < 500) {
                        throw new IOException(String.format("Failed uploading image. %s", errorMessage));
                    }
                    this.logger.log(String.format("Failed uploading image, retrying. %s", errorMessage));
                    Thread.sleep(200L);
                }
            }
            catch (Exception e) {
                this.logger.log("Error uploading viewport image");
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            }
        }
        return null;
    }

    public Map<String, List<Region>> postLocators(VisualLocatorsData visualLocatorsData) {
        String postData;
        try {
            this.jsonMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, false);
            postData = this.jsonMapper.writeValueAsString((Object)visualLocatorsData);
        }
        catch (IOException e) {
            throw new EyesException("Failed to convert visualLocatorsData into Json string!", (Throwable)e);
        }
        ConnectivityTarget target = this.restClient.target(this.serverUrl).path("api/locators/locate").queryParam("apiKey", this.getApiKey());
        Request request = target.request(new String[]{"application/json"});
        Response response = this.sendLongRequest(request, "POST", postData, "application/json");
        ArrayList<Integer> validStatusCodes = new ArrayList<Integer>();
        validStatusCodes.add(Response.Status.OK.getStatusCode());
        return this.parseResponseWithJsonData(response, validStatusCodes, new TypeReference<Map<String, List<Region>>>(){});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeBatch(String batchId) {
        boolean dontCloseBatchesStr = GeneralUtils.getDontCloseBatches();
        if (dontCloseBatchesStr) {
            this.logger.log("APPLITOOLS_DONT_CLOSE_BATCHES environment variable set to true. Skipping batch close.");
            return;
        }
        ArgumentGuard.notNull((Object)batchId, (String)"batchId");
        this.logger.log("called with " + batchId);
        Response response = null;
        try {
            final String url = String.format(this.CLOSE_BATCH, batchId);
            this.initClient();
            Request request = this.makeEyesRequest(new RestClient.HttpRequestBuilder(){

                @Override
                public Request build() {
                    return ServerConnector.this.restClient.target(ServerConnector.this.serverUrl).path(url).queryParam("apiKey", ServerConnector.this.getApiKey()).request(new String[]{null});
                }
            });
            response = request.method("DELETE", null, null);
        }
        finally {
            if (response != null) {
                response.close();
            }
            this.restClient.close();
        }
    }

    public void closeConnector() {
        if (this.restClient != null) {
            this.restClient.close();
        }
    }

    private byte[] downloadFile(Response response) {
        byte[] responseBody = response.getBody();
        String contentEncoding = response.getHeader("Content-Encoding", false);
        if (!"br".equalsIgnoreCase(contentEncoding)) {
            return responseBody;
        }
        try {
            return IOUtils.toByteArray((InputStream)new BrotliInputStream((InputStream)new ByteArrayInputStream(responseBody)));
        }
        catch (IOException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            return new byte[0];
        }
    }
}

