/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.IDomCaptureListener;
import com.applitools.connectivity.ServerConnector;
import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.AppEnvironment;
import com.applitools.eyes.AppOutput;
import com.applitools.eyes.BatchInfo;
import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.FailureReports;
import com.applitools.eyes.IEyesBase;
import com.applitools.eyes.IServerConnector;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.Location;
import com.applitools.eyes.LogHandler;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowDataWithScreenshot;
import com.applitools.eyes.MatchWindowTask;
import com.applitools.eyes.NullCutProvider;
import com.applitools.eyes.OutOfBoundsException;
import com.applitools.eyes.PropertyData;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.ScaleProvider;
import com.applitools.eyes.SessionStartInfo;
import com.applitools.eyes.SessionType;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.TestResultsStatus;
import com.applitools.eyes.Trigger;
import com.applitools.eyes.capture.AppOutputProvider;
import com.applitools.eyes.capture.AppOutputWithScreenshot;
import com.applitools.eyes.config.Configuration;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import com.applitools.eyes.debug.FileDebugScreenshotsProvider;
import com.applitools.eyes.debug.NullDebugScreenshotProvider;
import com.applitools.eyes.diagnostics.ResponseTimeAlgorithm;
import com.applitools.eyes.events.ISessionEventHandler;
import com.applitools.eyes.events.SessionEventHandlers;
import com.applitools.eyes.events.ValidationInfo;
import com.applitools.eyes.exceptions.DiffsFoundException;
import com.applitools.eyes.exceptions.NewTestException;
import com.applitools.eyes.exceptions.TestFailedException;
import com.applitools.eyes.fluent.CheckSettings;
import com.applitools.eyes.fluent.ICheckSettings;
import com.applitools.eyes.fluent.ICheckSettingsInternal;
import com.applitools.eyes.locators.IVisualLocatorProvider;
import com.applitools.eyes.positioning.InvalidPositionProvider;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.positioning.RegionProvider;
import com.applitools.eyes.scaling.FixedScaleProvider;
import com.applitools.eyes.scaling.NullScaleProvider;
import com.applitools.eyes.triggers.MouseAction;
import com.applitools.eyes.triggers.MouseTrigger;
import com.applitools.eyes.triggers.TextTrigger;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.ImageDeltaCompressor;
import com.applitools.utils.ImageUtils;
import com.applitools.utils.PropertyHandler;
import com.applitools.utils.ReadOnlyPropertyHandler;
import com.applitools.utils.SimplePropertyHandler;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.apache.commons.codec.binary.Base64;

public abstract class EyesBase
implements IEyesBase {
    private static final int DEFAULT_MATCH_TIMEOUT = 2000;
    protected static final int USE_DEFAULT_TIMEOUT = -1;
    private boolean shouldMatchWindowRunOnceOnTimeout;
    private MatchWindowTask matchWindowTask;
    protected IServerConnector serverConnector;
    protected RunningSession runningSession;
    protected SessionStartInfo sessionStartInfo;
    protected PropertyHandler<RectangleSize> viewportSizeHandler;
    protected EyesScreenshot lastScreenshot;
    protected PropertyHandler<ScaleProvider> scaleProviderHandler;
    protected PropertyHandler<CutProvider> cutProviderHandler;
    protected PropertyHandler<PositionProvider> positionProviderHandler;
    private boolean isDisabled;
    protected Logger logger;
    private boolean isOpen;
    private String agentId;
    private ImageMatchSettings defaultMatchSettings;
    private int matchTimeout;
    private String hostApp;
    private String hostOS;
    protected Configuration config;
    private FailureReports failureReports;
    private final Queue<Trigger> userInputs;
    private final List<PropertyData> properties = new ArrayList<PropertyData>();
    private boolean saveNewTests;
    private boolean saveFailedTests;
    protected DebugScreenshotsProvider debugScreenshotsProvider;
    private boolean isViewportSizeSet;
    private int stitchingOverlap = 50;
    private final SessionEventHandlers sessionEventHandlers = new SessionEventHandlers();
    private int validationId;
    private boolean isSendDom;
    protected IDomCaptureListener domCaptureListener;
    protected IVisualLocatorProvider visualLocatorProvider;

    public EyesBase() {
        if (this.isDisabled) {
            this.userInputs = null;
            return;
        }
        this.ensureConfiguration();
        this.logger = new Logger();
        Region.initLogger((Logger)this.logger);
        ImageUtils.initLogger((Logger)this.logger);
        GeneralUtils.initLogger((Logger)this.logger);
        this.initProviders();
        this.setServerConnector(new ServerConnector());
        this.matchTimeout = 2000;
        this.runningSession = null;
        this.defaultMatchSettings = new ImageMatchSettings();
        this.defaultMatchSettings.setIgnoreCaret(Boolean.valueOf(true));
        this.failureReports = FailureReports.ON_CLOSE;
        this.userInputs = new ArrayDeque<Trigger>();
        this.saveNewTests = true;
        this.saveFailedTests = false;
        this.agentId = null;
        this.lastScreenshot = null;
        this.debugScreenshotsProvider = new NullDebugScreenshotProvider();
        this.isSendDom = true;
    }

    protected void ensureConfiguration() {
        this.config = new Configuration();
    }

    private void initProviders(boolean hardReset) {
        if (hardReset) {
            this.scaleProviderHandler = new SimplePropertyHandler();
            this.scaleProviderHandler.set((Object)new NullScaleProvider());
            this.positionProviderHandler = new SimplePropertyHandler();
            this.positionProviderHandler.set((Object)new InvalidPositionProvider());
            this.cutProviderHandler = new SimplePropertyHandler();
            this.cutProviderHandler.set((Object)new NullCutProvider());
            this.positionProviderHandler.set((Object)new InvalidPositionProvider());
            this.viewportSizeHandler = new SimplePropertyHandler();
            this.viewportSizeHandler.set(null);
            return;
        }
        if (this.scaleProviderHandler == null) {
            this.scaleProviderHandler = new SimplePropertyHandler();
            this.scaleProviderHandler.set((Object)new NullScaleProvider());
        }
        if (this.positionProviderHandler == null) {
            this.positionProviderHandler = new SimplePropertyHandler();
            this.positionProviderHandler.set((Object)new InvalidPositionProvider());
        }
        if (this.cutProviderHandler == null) {
            this.cutProviderHandler = new SimplePropertyHandler();
            this.cutProviderHandler.set((Object)new NullCutProvider());
        }
        if (this.viewportSizeHandler == null) {
            this.viewportSizeHandler = new SimplePropertyHandler();
            this.viewportSizeHandler.set(null);
        }
    }

    private void initProviders() {
        this.initProviders(false);
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public void setServerConnector(IServerConnector serverConnector) {
        ArgumentGuard.notNull((Object)serverConnector, (String)"serverConnector");
        if (serverConnector.getLogger() == null) {
            serverConnector.setLogger(this.logger);
        }
        this.serverConnector = serverConnector;
    }

    public void setApiKey(String apiKey) {
        ArgumentGuard.notNull((Object)apiKey, (String)"apiKey");
        if (this.serverConnector == null) {
            throw new EyesException("server connector not set.");
        }
        this.serverConnector.setApiKey(apiKey);
    }

    public String getApiKey() {
        if (this.serverConnector == null) {
            throw new EyesException("server connector not set.");
        }
        return this.serverConnector.getApiKey();
    }

    public void setServerUrl(String serverUrl) throws URISyntaxException {
        this.setServerUrl(new URI(serverUrl));
    }

    public void setServerUrl(URI serverUrl) {
        if (this.serverConnector == null) {
            throw new EyesException("server connector not set.");
        }
        if (serverUrl == null) {
            this.serverConnector.setServerUrl(EyesBase.getDefaultServerUrl());
        } else {
            this.serverConnector.setServerUrl(serverUrl);
        }
    }

    public URI getServerUrl() {
        if (this.serverConnector == null) {
            throw new EyesException("server connector not set.");
        }
        return this.serverConnector.getServerUrl();
    }

    public void setProxy(AbstractProxySettings abstractProxySettings) {
        if (this.serverConnector == null) {
            throw new EyesException("server connector not set.");
        }
        this.serverConnector.setProxy(abstractProxySettings);
    }

    public AbstractProxySettings getProxy() {
        if (this.serverConnector == null) {
            throw new EyesException("server connector not set.");
        }
        return this.serverConnector.getProxy();
    }

    public void setIsDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public boolean getIsDisabled() {
        return this.isDisabled;
    }

    public void setAppName(String appName) {
        this.config.setAppName(appName);
    }

    public String getAppName() {
        return this.config.getAppName();
    }

    public void setBranchName(String branchName) {
        this.config.setBranchName(branchName);
    }

    public String getBranchName() {
        return this.config.getBranchName();
    }

    public void setParentBranchName(String branchName) {
        this.config.setParentBranchName(branchName);
    }

    public String getParentBranchName() {
        return this.config.getParentBranchName();
    }

    public void setBaselineBranchName(String branchName) {
        this.config.setBaselineBranchName(branchName);
    }

    public String getBaselineBranchName() {
        return this.config.getBaselineBranchName();
    }

    public void setSaveDiffs(Boolean saveDiffs) {
        this.config.setSaveDiffs(saveDiffs);
    }

    public Boolean getSaveDiffs() {
        return this.config.getSaveDiffs();
    }

    protected void clearUserInputs() {
        if (this.isDisabled) {
            return;
        }
        this.userInputs.clear();
    }

    protected Trigger[] getUserInputs() {
        if (this.isDisabled) {
            return null;
        }
        Trigger[] result = new Trigger[this.userInputs.size()];
        return this.userInputs.toArray(result);
    }

    public void setMatchTimeout(int ms) {
        int MIN_MATCH_TIMEOUT = 500;
        if (this.getIsDisabled()) {
            this.logger.verbose("Ignored");
            return;
        }
        this.logger.verbose("Setting match timeout to: " + ms);
        if (ms != 0 && 500 > ms) {
            throw new IllegalArgumentException("Match timeout must be set in milliseconds, and must be > 500");
        }
        this.matchTimeout = ms;
    }

    public int getMatchTimeout() {
        return this.matchTimeout;
    }

    public void setSaveNewTests(boolean saveNewTests) {
        this.saveNewTests = saveNewTests;
    }

    public boolean getSaveNewTests() {
        return this.saveNewTests;
    }

    public void setSaveFailedTests(boolean saveFailedTests) {
        this.saveFailedTests = saveFailedTests;
    }

    public boolean getSaveFailedTests() {
        return this.saveFailedTests;
    }

    public void setBatch(BatchInfo batch) {
        if (this.isDisabled) {
            this.logger.verbose("Ignored");
            return;
        }
        this.logger.verbose("setBatch(" + batch + ")");
        this.config.setBatch(batch);
    }

    public BatchInfo getBatch() {
        return this.config.getBatch();
    }

    public void setFailureReports(FailureReports failureReports) {
        this.failureReports = failureReports;
    }

    public FailureReports getFailureReports() {
        return this.failureReports;
    }

    public void setDefaultMatchSettings(ImageMatchSettings defaultMatchSettings) {
        ArgumentGuard.notNull((Object)defaultMatchSettings, (String)"defaultMatchSettings");
        this.defaultMatchSettings = defaultMatchSettings;
    }

    public ImageMatchSettings getDefaultMatchSettings() {
        return this.defaultMatchSettings;
    }

    public void setMatchLevel(MatchLevel matchLevel) {
        this.defaultMatchSettings.setMatchLevel(matchLevel);
    }

    public MatchLevel getMatchLevel() {
        return this.defaultMatchSettings.getMatchLevel();
    }

    protected abstract String getBaseAgentId();

    public String getFullAgentId() {
        String agentId = this.getAgentId();
        if (agentId == null) {
            return this.getBaseAgentId();
        }
        return String.format("%s [%s]", agentId, this.getBaseAgentId());
    }

    public boolean getIsOpen() {
        return this.isOpen;
    }

    public static URI getDefaultServerUrl() {
        try {
            return new URI("https://eyesapi.applitools.com");
        }
        catch (URISyntaxException ex) {
            throw new EyesException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void setLogHandler(LogHandler logHandler) {
        this.logger.setLogHandler(logHandler);
    }

    public LogHandler getLogHandler() {
        return this.logger.getLogHandler();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setImageCut(CutProvider cutProvider) {
        if (cutProvider != null) {
            this.cutProviderHandler = new ReadOnlyPropertyHandler(this.logger, (Object)cutProvider);
        } else {
            this.cutProviderHandler = new SimplePropertyHandler();
            this.cutProviderHandler.set((Object)new NullCutProvider());
        }
    }

    public boolean getIsCutProviderExplicitlySet() {
        return this.cutProviderHandler != null && !(this.cutProviderHandler.get() instanceof NullCutProvider);
    }

    public void setScaleRatio(Double scaleRatio) {
        if (scaleRatio != null) {
            this.scaleProviderHandler = new ReadOnlyPropertyHandler(this.logger, (Object)new FixedScaleProvider(scaleRatio));
        } else {
            this.scaleProviderHandler = new SimplePropertyHandler();
            this.scaleProviderHandler.set((Object)new NullScaleProvider());
        }
    }

    public double getScaleRatio() {
        return ((ScaleProvider)this.scaleProviderHandler.get()).getScaleRatio();
    }

    public void addProperty(String name, String value) {
        PropertyData pd = new PropertyData(name, value);
        this.properties.add(pd);
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public void setSaveDebugScreenshots(boolean saveDebugScreenshots) {
        DebugScreenshotsProvider prev = this.debugScreenshotsProvider;
        this.debugScreenshotsProvider = saveDebugScreenshots ? new FileDebugScreenshotsProvider() : new NullDebugScreenshotProvider();
        this.debugScreenshotsProvider.setPrefix(prev.getPrefix());
        this.debugScreenshotsProvider.setPath(prev.getPath());
    }

    public boolean getSaveDebugScreenshots() {
        return !(this.debugScreenshotsProvider instanceof NullDebugScreenshotProvider);
    }

    public void setDebugScreenshotsPath(String pathToSave) {
        this.debugScreenshotsProvider.setPath(pathToSave);
    }

    public String getDebugScreenshotsPath() {
        return this.debugScreenshotsProvider.getPath();
    }

    public void setDebugScreenshotsPrefix(String prefix) {
        this.debugScreenshotsProvider.setPrefix(prefix);
    }

    public String getDebugScreenshotsPrefix() {
        return this.debugScreenshotsProvider.getPrefix();
    }

    public DebugScreenshotsProvider getDebugScreenshotsProvider() {
        return this.debugScreenshotsProvider;
    }

    public boolean getIgnoreCaret() {
        Boolean ignoreCaret = this.defaultMatchSettings.getIgnoreCaret();
        return ignoreCaret == null ? true : ignoreCaret;
    }

    public void setIgnoreCaret(boolean value) {
        this.defaultMatchSettings.setIgnoreCaret(Boolean.valueOf(value));
    }

    public int getStitchOverlap() {
        return this.stitchingOverlap;
    }

    public void setStitchOverlap(int pixels) {
        this.stitchingOverlap = pixels;
    }

    public TestResults close() {
        return this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResults close(boolean throwEx) {
        try {
            if (this.isDisabled) {
                this.logger.verbose("Ignored");
                TestResults testResults = null;
                return testResults;
            }
            this.logger.verbose(String.format("close(%b)", throwEx));
            ArgumentGuard.isValidState((boolean)this.isOpen, (String)"Eyes not open");
            this.isOpen = false;
            this.lastScreenshot = null;
            this.clearUserInputs();
            this.initProviders(true);
            if (this.runningSession == null) {
                this.logger.log("Server session was not started --- Empty test ended.");
                TestResults testResults = new TestResults();
                return testResults;
            }
            boolean isNewSession = this.runningSession.getIsNewSession();
            String sessionResultsUrl = this.runningSession.getUrl();
            this.logger.verbose("Ending server session...");
            boolean save = isNewSession && this.saveNewTests || !isNewSession && this.saveFailedTests;
            this.logger.verbose("Automatically save test? " + String.valueOf(save));
            TestResults results = this.serverConnector.stopSession(this.runningSession, false, save);
            results.setNew(isNewSession);
            results.setUrl(sessionResultsUrl);
            this.logger.verbose(results.toString());
            TestResultsStatus status = results.getStatus();
            this.sessionEventHandlers.testEnded(this.getAUTSessionId(), results);
            if (status == TestResultsStatus.Unresolved) {
                if (results.isNew()) {
                    this.logger.log("--- New test ended. Please approve the new baseline at " + sessionResultsUrl);
                    if (throwEx) {
                        throw new NewTestException(results, this.sessionStartInfo);
                    }
                } else {
                    this.logger.log("--- Failed test ended. See details at " + sessionResultsUrl);
                    if (throwEx) {
                        throw new DiffsFoundException(results, this.sessionStartInfo);
                    }
                }
            } else if (status == TestResultsStatus.Failed) {
                this.logger.log("--- Failed test ended. See details at " + sessionResultsUrl);
                if (throwEx) {
                    throw new TestFailedException(results, this.sessionStartInfo);
                }
            } else {
                this.logger.log("--- Test passed. See details at " + sessionResultsUrl);
            }
            results.setServerConnector(this.serverConnector);
            TestResults testResults = results;
            return testResults;
        }
        finally {
            this.runningSession = null;
            this.logger.getLogHandler().close();
            this.serverConnector.closeConnector();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeResponseTime(boolean isDeadlineExceeded) {
        try {
            if (this.isDisabled) {
                this.logger.verbose("Ignored");
            }
            this.logger.verbose(String.format("closeResponseTime(%b)", isDeadlineExceeded));
            ArgumentGuard.isValidState((boolean)this.isOpen, (String)"Eyes not open");
            this.isOpen = false;
            if (this.runningSession == null) {
                this.logger.verbose("Server session was not started");
                this.logger.log("--- Empty test ended.");
                return;
            }
            boolean isNewSession = this.runningSession.getIsNewSession();
            String sessionResultsUrl = this.runningSession.getUrl();
            this.logger.verbose("Ending server session...");
            boolean save = isNewSession && this.saveNewTests;
            this.logger.verbose("Automatically save test? " + String.valueOf(save));
            TestResults results = this.serverConnector.stopSession(this.runningSession, false, save);
            results.setNew(isNewSession);
            results.setUrl(sessionResultsUrl);
            this.logger.verbose(results.toString());
            if (isDeadlineExceeded && !isNewSession) {
                this.logger.log("--- Failed test ended. See details at " + sessionResultsUrl);
                String message = "'" + this.sessionStartInfo.getScenarioIdOrName() + "' of '" + this.sessionStartInfo.getAppIdOrName() + "'. See details at " + sessionResultsUrl;
                throw new TestFailedException(results, message);
            }
            if (isNewSession) {
                String instructions = "Please approve the new baseline at " + sessionResultsUrl;
                this.logger.log("--- New test ended. " + instructions);
                String message = "'" + this.sessionStartInfo.getScenarioIdOrName() + "' of '" + this.sessionStartInfo.getAppIdOrName() + "'. " + instructions;
                throw new NewTestException(results, message);
            }
            this.logger.log("--- Test passed. See details at " + sessionResultsUrl);
        }
        finally {
            this.runningSession = null;
            this.logger.getLogHandler().close();
        }
    }

    public void abortIfNotClosed() {
        try {
            if (this.isDisabled) {
                this.logger.verbose("Ignored");
                return;
            }
            this.isOpen = false;
            this.lastScreenshot = null;
            this.clearUserInputs();
            if (null == this.runningSession) {
                this.logger.verbose("Closed");
                return;
            }
            this.logger.verbose("Aborting server session...");
            try {
                this.serverConnector.stopSession(this.runningSession, true, false);
                this.logger.log("--- Test aborted.");
            }
            catch (EyesException ex) {
                this.logger.log("Failed to abort server session: " + ex.getMessage());
            }
        }
        finally {
            this.runningSession = null;
            this.logger.getLogHandler().close();
        }
    }

    public void setHostOS(String hostOS) {
        this.logger.log("Host OS: " + hostOS);
        this.hostOS = hostOS == null || hostOS.isEmpty() ? null : hostOS.trim();
    }

    public String getHostOS() {
        return this.hostOS;
    }

    public void setHostApp(String hostApp) {
        this.logger.log("Host App: " + hostApp);
        this.hostApp = hostApp == null || hostApp.isEmpty() ? null : hostApp.trim();
    }

    public String getHostApp() {
        return this.hostApp;
    }

    public void setBaselineName(String baselineName) {
        this.setBaselineEnvName(baselineName);
    }

    public String getBaselineName() {
        return this.getBaselineEnvName();
    }

    public void setBaselineEnvName(String baselineEnvName) {
        this.logger.log("Baseline environment name: " + baselineEnvName);
        if (baselineEnvName == null || baselineEnvName.isEmpty()) {
            this.config.setBaselineEnvName(null);
        } else {
            this.config.setBaselineEnvName(baselineEnvName.trim());
        }
    }

    public String getBaselineEnvName() {
        return this.config.getBaselineEnvName();
    }

    public void setEnvName(String envName) {
        this.logger.log("Environment name: " + envName);
        if (envName == null || envName.isEmpty()) {
            this.config.setEnvironmentName(null);
        } else {
            this.config.setEnvironmentName(envName.trim());
        }
    }

    public String getEnvName() {
        return this.config.getEnvironmentName();
    }

    @Deprecated
    public void setAppEnvironment(String hostOS, String hostApp) {
        if (this.isDisabled) {
            this.logger.verbose("Ignored");
            return;
        }
        this.logger.log("Warning: SetAppEnvironment is deprecated! Please use 'setHostOS' and 'setHostApp'");
        this.logger.verbose("setAppEnvironment(" + hostOS + ", " + hostApp + ")");
        this.setHostOS(hostOS);
        this.setHostApp(hostApp);
    }

    public PositionProvider getPositionProvider() {
        return (PositionProvider)this.positionProviderHandler.get();
    }

    public void setPositionProvider(PositionProvider positionProvider) {
        if (positionProvider != null) {
            this.positionProviderHandler = new ReadOnlyPropertyHandler(this.logger, (Object)positionProvider);
        } else {
            this.positionProviderHandler = new SimplePropertyHandler();
            this.positionProviderHandler.set((Object)new InvalidPositionProvider());
        }
    }

    protected MatchResult checkWindowBase(RegionProvider regionProvider, String tag, boolean ignoreMismatch) {
        return this.checkWindowBase(regionProvider, tag, ignoreMismatch, -1);
    }

    protected MatchResult checkWindowBase(RegionProvider regionProvider, String tag, boolean ignoreMismatch, int retryTimeout) {
        return this.checkWindowBase(regionProvider, tag, ignoreMismatch, new CheckSettings(retryTimeout));
    }

    protected void beforeMatchWindow() {
    }

    protected void afterMatchWindow() {
    }

    protected MatchResult checkWindowBase(RegionProvider regionProvider, String tag, boolean ignoreMismatch, ICheckSettings checkSettings) {
        if (this.getIsDisabled()) {
            this.logger.verbose("Ignored");
            MatchResult result = new MatchResult();
            result.setAsExpected(true);
            return result;
        }
        if (tag == null) {
            tag = "";
        }
        ArgumentGuard.isValidState((boolean)this.getIsOpen(), (String)"Eyes not open");
        ArgumentGuard.notNull((Object)regionProvider, (String)"regionProvider");
        this.ensureRunningSession();
        this.beforeMatchWindow();
        if (((ICheckSettingsInternal)((Object)checkSettings)).isIgnoreDisplacements() == null) {
            checkSettings = checkSettings.ignoreDisplacements(this.config.getIgnoreDisplacements());
        }
        if (((ICheckSettingsInternal)((Object)checkSettings)).isEnablePatterns() == null) {
            checkSettings = checkSettings.enablePatterns(this.config.getEnablePatterns());
        }
        MatchResult result = this.matchWindow(regionProvider, tag, ignoreMismatch, checkSettings);
        this.afterMatchWindow();
        this.logger.verbose("MatchWindow Done!");
        if (!ignoreMismatch) {
            this.clearUserInputs();
            this.lastScreenshot = result.getScreenshot();
        }
        this.validateResult(tag, result);
        this.logger.verbose("Done!");
        return result;
    }

    public abstract String tryCaptureDom();

    protected ValidationInfo fireValidationWillStartEvent(String tag) {
        String autSessionId = this.getAUTSessionId();
        ValidationInfo validationInfo = new ValidationInfo();
        validationInfo.setValidationId("" + ++this.validationId);
        validationInfo.setTag(tag);
        this.getSessionEventHandlers().validationWillStart(autSessionId, validationInfo);
        return validationInfo;
    }

    private MatchResult matchWindow(RegionProvider regionProvider, String tag, boolean ignoreMismatch, ICheckSettings checkSettings) {
        ICheckSettingsInternal checkSettingsInternal = checkSettings instanceof ICheckSettingsInternal ? (ICheckSettingsInternal)((Object)checkSettings) : null;
        int retryTimeout = -1;
        if (checkSettingsInternal != null) {
            retryTimeout = checkSettingsInternal.getTimeout();
        }
        ImageMatchSettings defaultMatchSettings = this.getDefaultMatchSettings();
        if (checkSettingsInternal != null) {
            if (checkSettingsInternal.getMatchLevel() == null) {
                checkSettings = checkSettings.matchLevel(defaultMatchSettings.getMatchLevel());
            }
            if (checkSettingsInternal.getIgnoreCaret() == null) {
                checkSettings = checkSettings.ignoreCaret(defaultMatchSettings.getIgnoreCaret());
            }
            checkSettingsInternal = (ICheckSettingsInternal)((Object)checkSettings);
        }
        Region region = regionProvider.getRegion();
        this.logger.verbose("params: ([" + region + "], " + tag + ", " + retryTimeout + ")");
        MatchResult result = this.matchWindowTask.matchWindow(this.getUserInputs(), region, tag, this.shouldMatchWindowRunOnceOnTimeout, ignoreMismatch, checkSettingsInternal, retryTimeout);
        return result;
    }

    private String tryPostDomCapture(String domJson) {
        if (domJson != null) {
            byte[] resultStream = GeneralUtils.getGzipByteArrayOutputStream((String)domJson);
            return this.matchWindowTask.tryUploadData(resultStream, "application/octet-stream", "application/json");
        }
        return null;
    }

    private void validateResult(String tag, MatchResult result) {
        if (result.getAsExpected()) {
            return;
        }
        this.shouldMatchWindowRunOnceOnTimeout = true;
        if (!this.runningSession.getIsNewSession()) {
            this.logger.log(String.format("Mismatch! (%s)", tag));
        }
        if (this.getFailureReports() == FailureReports.IMMEDIATE) {
            throw new TestFailedException(String.format("Mismatch found in '%s' of '%s'", this.sessionStartInfo.getScenarioIdOrName(), this.sessionStartInfo.getAppIdOrName()));
        }
    }

    protected MatchWindowDataWithScreenshot testResponseTimeBase(RegionProvider regionProvider, Runnable action, int deadline, int timeout, long matchInterval) {
        MatchWindowDataWithScreenshot result;
        if (this.getIsDisabled()) {
            this.logger.verbose("Ignored");
            return null;
        }
        ArgumentGuard.isValidState((boolean)this.getIsOpen(), (String)"Eyes not open");
        ArgumentGuard.notNull((Object)regionProvider, (String)"regionProvider");
        ArgumentGuard.greaterThanZero((long)deadline, (String)"deadline");
        ArgumentGuard.greaterThanZero((long)timeout, (String)"timeout");
        ArgumentGuard.greaterThanZero((long)matchInterval, (String)"matchInterval");
        this.logger.verbose(String.format("testResponseTimeBase(regionProvider, %d, %d, %d)", deadline, timeout, matchInterval));
        if (this.runningSession == null) {
            this.logger.verbose("No running session, calling start session..");
            this.startSession();
            this.logger.verbose("Done!");
        }
        Thread actionThread = null;
        if (action != null) {
            this.logger.verbose("Starting webdriver action.");
            actionThread = new Thread(action);
            actionThread.start();
        }
        long startTime = System.currentTimeMillis();
        AppOutputProvider appOutputProvider = new AppOutputProvider(){

            @Override
            public AppOutputWithScreenshot getAppOutput(Region region, EyesScreenshot lastScreenshot, ICheckSettingsInternal checkSettingsInternal) {
                return EyesBase.this.getAppOutputWithScreenshot(region, null, null);
            }
        };
        if (this.runningSession.getIsNewSession()) {
            ResponseTimeAlgorithm.runNewProgressionSession(this.logger, this.serverConnector, this.runningSession, appOutputProvider, regionProvider, startTime, deadline);
            result = null;
        } else {
            result = ResponseTimeAlgorithm.runProgressionSessionForExistingBaseline(this.logger, this.serverConnector, this.runningSession, appOutputProvider, regionProvider, startTime, deadline, timeout, matchInterval);
        }
        if (actionThread != null) {
            this.logger.verbose("Making sure 'action' thread had finished...");
            try {
                actionThread.join(30000L);
            }
            catch (InterruptedException e) {
                this.logger.verbose("Got interrupted while waiting for 'action' to finish!");
            }
        }
        this.logger.verbose("Done!");
        return result;
    }

    protected void beforeOpen() {
    }

    protected void afterOpen() {
    }

    protected void openBase(String appName, String testName, RectangleSize viewportSize, SessionType sessionType) {
        if (this.isDisabled) {
            this.logger.verbose("Ignored");
            return;
        }
        if (this.serverConnector == null) {
            throw new EyesException("server connector not set.");
        }
        if (this.config.getAppName() == null) {
            ArgumentGuard.notNull((Object)appName, (String)"appName");
            this.config.setAppName(appName);
        }
        ArgumentGuard.notNull((Object)testName, (String)"testName");
        this.config.setTestName(testName);
        this.config.setSessionType(sessionType != null ? sessionType : SessionType.SEQUENTIAL);
        this.config.setViewportSize(viewportSize);
        this.openBase();
    }

    protected void openBase() {
        this.logger.getLogHandler().open();
        try {
            if (this.isDisabled) {
                this.logger.verbose("Ignored");
                return;
            }
            this.sessionEventHandlers.testStarted(this.getAUTSessionId());
            this.validateApiKey();
            this.logOpenBase();
            this.validateSessionOpen();
            this.initProviders();
            this.initVisualLocatorProvider();
            this.isViewportSizeSet = false;
            this.sessionEventHandlers.initStarted();
            this.beforeOpen();
            this.viewportSizeHandler.set((Object)this.config.getViewportSize());
            if (this.config.getViewportSize() != null) {
                this.ensureRunningSession();
            }
            this.validationId = -1;
            this.isOpen = true;
            this.afterOpen();
        }
        catch (EyesException e) {
            this.logger.log(e.getMessage());
            this.logger.getLogHandler().close();
            throw e;
        }
    }

    private void ensureRunningSession() {
        if (this.runningSession != null) {
            this.logger.log("session already running.");
            return;
        }
        this.logger.log("No running session, calling start session...");
        this.startSession();
        this.logger.setSessionId(this.runningSession.getSessionId());
        this.logger.log("Done!");
        this.matchWindowTask = new MatchWindowTask(this.logger, this.serverConnector, this.runningSession, this.matchTimeout, this, new AppOutputProvider(){

            @Override
            public AppOutputWithScreenshot getAppOutput(Region region, EyesScreenshot lastScreenshot, ICheckSettingsInternal checkSettingsInternal) {
                return EyesBase.this.getAppOutputWithScreenshot(region, lastScreenshot, checkSettingsInternal);
            }
        });
    }

    private void validateApiKey() {
        if (this.getApiKey() == null) {
            String errMsg = "API key is missing! Please set it using setApiKey()";
            this.logger.log(errMsg);
            throw new EyesException(errMsg);
        }
    }

    private void logOpenBase() {
        this.logger.log(String.format("Eyes server URL is '%s'", this.serverConnector.getServerUrl()));
        this.logger.verbose(String.format("Timeout = '%d'", this.serverConnector.getTimeout()));
        this.logger.log(String.format("matchTimeout = '%d' ", this.matchTimeout));
        this.logger.log(String.format("Default match settings = '%s' ", this.defaultMatchSettings));
        this.logger.log(String.format("FailureReports = '%s' ", new Object[]{this.failureReports}));
        this.logger.log("Agent = " + this.getFullAgentId());
        this.logger.verbose(String.format("openBase('%s', '%s', '%s')", this.config.getAppName(), this.config.getTestName(), this.config.getViewportSize()));
    }

    private void validateSessionOpen() {
        if (this.isOpen) {
            this.abortIfNotClosed();
            String errMsg = "A test is already running";
            this.logger.log(errMsg);
            throw new EyesException(errMsg);
        }
    }

    protected abstract RectangleSize getViewportSize();

    protected abstract void setViewportSize(RectangleSize var1);

    public void setExplicitViewportSize(RectangleSize explicitViewportSize) {
        if (explicitViewportSize == null) {
            this.viewportSizeHandler = new SimplePropertyHandler();
            this.viewportSizeHandler.set(null);
            this.isViewportSizeSet = false;
            return;
        }
        this.logger.verbose("Viewport size explicitly set to " + explicitViewportSize);
        this.viewportSizeHandler = new ReadOnlyPropertyHandler(this.logger, (Object)new RectangleSize(explicitViewportSize.getWidth(), explicitViewportSize.getHeight()));
        this.isViewportSizeSet = true;
    }

    protected abstract String getInferredEnvironment();

    protected abstract EyesScreenshot getScreenshot();

    protected abstract String getTitle();

    protected void addUserInput(Trigger trigger) {
        if (this.isDisabled) {
            return;
        }
        ArgumentGuard.notNull((Object)trigger, (String)"trigger");
        this.userInputs.add(trigger);
    }

    protected void addTextTriggerBase(Region control, String text) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring '%s' (disabled)", text));
            return;
        }
        ArgumentGuard.notNull((Object)control, (String)"control");
        ArgumentGuard.notNull((Object)text, (String)"text");
        control = new Region(control);
        if (this.lastScreenshot == null) {
            this.logger.verbose(String.format("Ignoring '%s' (no screenshot)", text));
            return;
        }
        if ((control = this.lastScreenshot.getIntersectedRegion(control, CoordinatesType.SCREENSHOT_AS_IS)).isSizeEmpty()) {
            this.logger.verbose(String.format("Ignoring '%s' (out of bounds)", text));
            return;
        }
        TextTrigger trigger = new TextTrigger(control, text);
        this.addUserInput(trigger);
        this.logger.verbose(String.format("Added %s", new Object[]{trigger}));
    }

    protected void addMouseTriggerBase(MouseAction action, Region control, Location cursor) {
        if (this.getIsDisabled()) {
            this.logger.verbose(String.format("Ignoring %s (disabled)", new Object[]{action}));
            return;
        }
        ArgumentGuard.notNull((Object)((Object)action), (String)"action");
        ArgumentGuard.notNull((Object)control, (String)"control");
        ArgumentGuard.notNull((Object)cursor, (String)"cursor");
        if (this.lastScreenshot == null) {
            this.logger.verbose(String.format("Ignoring %s (no screenshot)", new Object[]{action}));
            return;
        }
        Location cursorInScreenshot = new Location(cursor);
        cursorInScreenshot.offset(control.getLocation());
        try {
            cursorInScreenshot = this.lastScreenshot.getLocationInScreenshot(cursorInScreenshot, CoordinatesType.CONTEXT_RELATIVE);
        }
        catch (OutOfBoundsException e) {
            this.logger.verbose(String.format("Ignoring %s (out of bounds)", new Object[]{action}));
            return;
        }
        Region controlScreenshotIntersect = this.lastScreenshot.getIntersectedRegion(control, CoordinatesType.SCREENSHOT_AS_IS);
        if (!controlScreenshotIntersect.isSizeEmpty()) {
            Location l = controlScreenshotIntersect.getLocation();
            cursorInScreenshot.offset(-l.getX(), -l.getY());
        }
        MouseTrigger trigger = new MouseTrigger(action, controlScreenshotIntersect, cursorInScreenshot);
        this.addUserInput(trigger);
        this.logger.verbose(String.format("Added %s", new Object[]{trigger}));
    }

    protected AppEnvironment getAppEnvironment() {
        AppEnvironment appEnv = new AppEnvironment();
        if (this.hostOS != null) {
            appEnv.setOs(this.hostOS);
        }
        if (this.hostApp != null) {
            appEnv.setHostingApp(this.hostApp);
        }
        appEnv.setInferred(this.getInferredEnvironment());
        appEnv.setDisplaySize((RectangleSize)this.viewportSizeHandler.get());
        return appEnv;
    }

    protected void startSession() {
        this.logger.verbose("startSession()");
        if (this.serverConnector == null) {
            throw new EyesException("server connector not set.");
        }
        this.ensureViewportSize();
        BatchInfo testBatch = this.config.getBatch();
        if (testBatch == null) {
            this.logger.verbose("No batch set");
            testBatch = new BatchInfo(null);
        } else {
            this.logger.verbose("Batch is " + testBatch);
        }
        AppEnvironment appEnv = this.getAppEnvironment();
        this.sessionEventHandlers.initEnded();
        this.logger.verbose("Application environment is " + appEnv);
        this.defaultMatchSettings.setAccessibilitySettings(this.config.getAccessibilityValidation());
        this.sessionStartInfo = new SessionStartInfo(this.config, this.getFullAgentId(), null, appEnv, this.defaultMatchSettings, this.properties);
        this.logger.verbose("Starting server session...");
        this.runningSession = this.serverConnector.startSession(this.sessionStartInfo);
        this.logger.verbose("Server session ID is " + this.runningSession.getId());
        String testInfo = "'" + this.config.getTestName() + "' of '" + this.getAppName() + "' " + appEnv;
        if (this.runningSession.getIsNewSession()) {
            this.logger.log("--- New test started - " + testInfo);
            this.shouldMatchWindowRunOnceOnTimeout = true;
        } else {
            this.logger.log("--- Test started - " + testInfo);
            this.shouldMatchWindowRunOnceOnTimeout = false;
        }
    }

    protected Object getAgentSetup() {
        return null;
    }

    private void ensureViewportSize() {
        if (!this.isViewportSizeSet) {
            try {
                if (this.viewportSizeHandler.get() == null) {
                    if (!(this.viewportSizeHandler instanceof ReadOnlyPropertyHandler)) {
                        RectangleSize targetSize = this.getViewportSize();
                        this.sessionEventHandlers.setSizeWillStart(targetSize);
                        this.viewportSizeHandler.set((Object)targetSize);
                    }
                } else {
                    RectangleSize targetSize = (RectangleSize)this.viewportSizeHandler.get();
                    this.sessionEventHandlers.setSizeWillStart(targetSize);
                    this.setViewportSize(targetSize);
                }
                this.isViewportSizeSet = true;
                this.sessionEventHandlers.setSizeEnded();
            }
            catch (NullPointerException e) {
                this.isViewportSizeSet = false;
            }
        }
    }

    protected EyesScreenshot getSubScreenshot(EyesScreenshot screenshot, Region region, ICheckSettingsInternal checkSettingsInternal) {
        return screenshot.getSubScreenshot(region, false);
    }

    private AppOutputWithScreenshot getAppOutputWithScreenshot(Region region, EyesScreenshot lastScreenshot, ICheckSettingsInternal checkSettingsInternal) {
        this.logger.verbose("getting screenshot...");
        EyesScreenshot screenshot = this.getScreenshot();
        this.logger.verbose("Done getting screenshot!");
        if (!region.isSizeEmpty()) {
            screenshot = this.getSubScreenshot(screenshot, region, checkSettingsInternal);
            this.debugScreenshotsProvider.save(screenshot.getImage(), "SUB_SCREENSHOT");
        }
        this.logger.verbose("Getting image bytes (encoded as PNG)...");
        BufferedImage screenshotImage = screenshot.getImage();
        byte[] screenshotBytes = ImageUtils.encodeAsPng((BufferedImage)screenshotImage);
        this.logger.verbose("Done! Getting title...");
        String title = this.getTitle();
        this.logger.verbose("Done!");
        String domJson = null;
        String domJsonUrl = null;
        try {
            if (this.isSendDom() && (domJson = this.tryCaptureDom()) != null) {
                long start = System.currentTimeMillis();
                domJsonUrl = this.tryPostDomCapture(domJson);
                this.logger.verbose("Send JSON to SERVER in " + (System.currentTimeMillis() - start) / 1000L);
            }
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace((Exception)e);
        }
        AppOutputWithScreenshot result = new AppOutputWithScreenshot(new AppOutput(title, screenshotBytes, domJsonUrl, null), screenshot);
        this.logger.verbose("Done!");
        return result;
    }

    private String compressScreenshot64(EyesScreenshot screenshot, EyesScreenshot lastScreenshot) {
        byte[] compressedScreenshot;
        ArgumentGuard.notNull((Object)screenshot, (String)"screenshot");
        BufferedImage screenshotImage = screenshot.getImage();
        byte[] uncompressed = ImageUtils.encodeAsPng((BufferedImage)screenshotImage);
        BufferedImage source = lastScreenshot != null ? lastScreenshot.getImage() : null;
        try {
            compressedScreenshot = ImageDeltaCompressor.compressByRawBlocks((BufferedImage)screenshotImage, (byte[])uncompressed, (BufferedImage)source);
        }
        catch (IOException e) {
            throw new EyesException("Failed to compress screenshot!", (Throwable)e);
        }
        return Base64.encodeBase64String((byte[])compressedScreenshot);
    }

    public void log(String message) {
        this.logger.log(message);
    }

    protected SessionEventHandlers getSessionEventHandlers() {
        return this.sessionEventHandlers;
    }

    public void addSessionEventHandler(ISessionEventHandler eventHandler) {
        this.sessionEventHandlers.addEventHandler(eventHandler);
    }

    public void removeSessionEventHandler(ISessionEventHandler eventHandler) {
        this.sessionEventHandlers.removeEventHandler(eventHandler);
    }

    public void clearSessionEventHandlers() {
        this.sessionEventHandlers.clearEventHandlers();
    }

    protected abstract String getAUTSessionId();

    public boolean isSendDom() {
        return this.isSendDom;
    }

    public void setOnDomCapture(IDomCaptureListener listener) {
        this.domCaptureListener = listener;
    }

    public void setSendDom(boolean isSendDom) {
        this.isSendDom = isSendDom;
    }

    protected void initVisualLocatorProvider() {
    }
}

