/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.connectivity.api.Response;
import com.applitools.eyes.AccessibilityRegionByRectangle;
import com.applitools.eyes.AppOutput;
import com.applitools.eyes.EyesBase;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.FloatingMatchSettings;
import com.applitools.eyes.IEyesBase;
import com.applitools.eyes.IGetAccessibilityRegion;
import com.applitools.eyes.IServerConnector;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.OutOfBoundsException;
import com.applitools.eyes.Region;
import com.applitools.eyes.RenderingInfo;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.Trigger;
import com.applitools.eyes.capture.AppOutputProvider;
import com.applitools.eyes.capture.AppOutputWithScreenshot;
import com.applitools.eyes.fluent.GetFloatingRegion;
import com.applitools.eyes.fluent.GetRegion;
import com.applitools.eyes.fluent.ICheckSettingsInternal;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.UUID;

public class MatchWindowTask {
    private static final int MATCH_INTERVAL = 500;
    private final Logger logger;
    private final IServerConnector serverConnector;
    private final RunningSession runningSession;
    private final int defaultRetryTimeout;
    private final AppOutputProvider appOutputProvider;
    private EyesScreenshot lastScreenshot = null;
    private MatchResult matchResult;
    private Region lastScreenshotBounds;
    private EyesBase eyes;

    public MatchWindowTask(Logger logger, IServerConnector serverConnector, RunningSession runningSession, int retryTimeout, EyesBase eyes, AppOutputProvider appOutputProvider) {
        ArgumentGuard.notNull((Object)serverConnector, (String)"serverConnector");
        ArgumentGuard.notNull((Object)runningSession, (String)"runningSession");
        ArgumentGuard.greaterThanOrEqualToZero((long)retryTimeout, (String)"retryTimeout");
        ArgumentGuard.notNull((Object)appOutputProvider, (String)"appOutputProvider");
        this.logger = logger;
        this.serverConnector = serverConnector;
        this.runningSession = runningSession;
        this.defaultRetryTimeout = retryTimeout;
        this.eyes = eyes;
        this.appOutputProvider = appOutputProvider;
    }

    public MatchWindowTask(Logger logger, IServerConnector serverConnector, RunningSession runningSession, int retryTimeout, EyesBase eyes) {
        ArgumentGuard.notNull((Object)serverConnector, (String)"serverConnector");
        ArgumentGuard.notNull((Object)runningSession, (String)"runningSession");
        ArgumentGuard.greaterThanOrEqualToZero((long)retryTimeout, (String)"retryTimeout");
        this.logger = logger;
        this.serverConnector = serverConnector;
        this.runningSession = runningSession;
        this.defaultRetryTimeout = retryTimeout;
        this.eyes = eyes;
        this.appOutputProvider = null;
    }

    public MatchResult performMatch(Trigger[] userInputs, AppOutputWithScreenshot appOutput, String tag, boolean ignoreMismatch, ImageMatchSettings imageMatchSettings) {
        MatchWindowData data;
        String agentSetupStr = "";
        if (this.eyes != null) {
            Object agentSetup = this.eyes.getAgentSetup();
            ObjectMapper jsonMapper = new ObjectMapper();
            try {
                agentSetupStr = jsonMapper.writeValueAsString(agentSetup);
            }
            catch (JsonProcessingException e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            }
        }
        if (!this.tryUploadImage(data = new MatchWindowData(userInputs, appOutput.getAppOutput(), tag, ignoreMismatch, new MatchWindowData.Options(tag, userInputs, ignoreMismatch, false, false, false, imageMatchSettings), (Object)agentSetupStr))) {
            throw new EyesException("matchWindow failed: could not upload image to storage service.");
        }
        return this.serverConnector.matchWindow(this.runningSession, data);
    }

    private boolean tryUploadImage(MatchWindowData data) {
        AppOutput appOutput = data.getAppOutput();
        if (appOutput.getScreenshotUrl() != null) {
            return true;
        }
        byte[] bytes = appOutput.getScreenshotBytes();
        String targetUrl = this.tryUploadData(bytes, "image/png", "image/png");
        appOutput.setScreenshotUrl(targetUrl);
        return targetUrl != null;
    }

    public String tryUploadData(byte[] bytes, String contentType, String mediaType) {
        String targetUrl;
        RenderingInfo renderingInfo = this.serverConnector.getRenderInfo();
        if (renderingInfo != null && (targetUrl = renderingInfo.getResultsUrl()) != null) {
            try {
                UUID uuid = UUID.randomUUID();
                targetUrl = targetUrl.replace("__random__", uuid.toString());
                this.logger.verbose("uploading " + mediaType + " to " + targetUrl);
                int retriesLeft = 3;
                int wait = 500;
                while (retriesLeft-- > 0) {
                    block7: {
                        try {
                            Response response = this.serverConnector.uploadData(bytes, renderingInfo, targetUrl, contentType, mediaType);
                            int statusCode = response.getStatusCode();
                            if (statusCode == 200 || statusCode == 201) {
                                this.logger.verbose("upload " + mediaType + " guid " + uuid + "complete.");
                                return targetUrl;
                            }
                            if (statusCode >= 500) break block7;
                            break;
                        }
                        catch (Exception e) {
                            if (retriesLeft != 0) break block7;
                            throw e;
                        }
                    }
                    Thread.sleep(wait);
                    wait *= 2;
                    wait = Math.min(10000, wait);
                }
            }
            catch (Exception e) {
                this.logger.log("Error uploading " + mediaType);
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Throwable)e);
            }
        }
        return null;
    }

    public MatchResult matchWindow(Trigger[] userInputs, Region region, String tag, boolean shouldRunOnceOnTimeout, boolean ignoreMismatch, ICheckSettingsInternal checkSettingsInternal, int retryTimeout) {
        if (retryTimeout < 0) {
            retryTimeout = this.defaultRetryTimeout;
        }
        this.logger.verbose(String.format("retryTimeout = %d", retryTimeout));
        EyesScreenshot screenshot = this.takeScreenshot(userInputs, region, tag, shouldRunOnceOnTimeout, ignoreMismatch, checkSettingsInternal, retryTimeout);
        if (ignoreMismatch) {
            return this.matchResult;
        }
        this.updateLastScreenshot(screenshot);
        this.updateBounds(region);
        return this.matchResult;
    }

    private void collectSimpleRegions(ICheckSettingsInternal checkSettingsInternal, ImageMatchSettings imageMatchSettings, EyesScreenshot screenshot) {
        imageMatchSettings.setIgnoreRegions(this.collectRegions(checkSettingsInternal.getIgnoreRegions(), screenshot, false));
        imageMatchSettings.setLayoutRegions(this.collectRegions(checkSettingsInternal.getLayoutRegions(), screenshot, true));
        imageMatchSettings.setStrictRegions(this.collectRegions(checkSettingsInternal.getStrictRegions(), screenshot, true));
        imageMatchSettings.setContentRegions(this.collectRegions(checkSettingsInternal.getContentRegions(), screenshot, true));
    }

    private Region[] collectRegions(GetRegion[] regionProviders, EyesScreenshot screenshot, boolean adjustLocation) {
        ArrayList<Region> regions = new ArrayList<Region>();
        for (GetRegion regionProvider : regionProviders) {
            try {
                regions.addAll(regionProvider.getRegions(this.eyes, screenshot, adjustLocation));
            }
            catch (OutOfBoundsException ex) {
                this.logger.log("WARNING - ignore region was out of bounds.");
            }
        }
        return regions.toArray(new Region[0]);
    }

    private void collectFloatingRegions(ICheckSettingsInternal checkSettingsInternal, ImageMatchSettings imageMatchSettings, EyesScreenshot screenshot) {
        ArrayList<FloatingMatchSettings> floatingRegions = new ArrayList<FloatingMatchSettings>();
        for (GetFloatingRegion floatingRegionProvider : checkSettingsInternal.getFloatingRegions()) {
            floatingRegions.addAll(floatingRegionProvider.getRegions(this.eyes, screenshot));
        }
        imageMatchSettings.setFloatingRegions(floatingRegions.toArray(new FloatingMatchSettings[0]));
    }

    public ImageMatchSettings createImageMatchSettings(ICheckSettingsInternal checkSettingsInternal, EyesScreenshot screenshot, EyesBase eyes) {
        ImageMatchSettings imageMatchSettings = MatchWindowTask.createImageMatchSettings(checkSettingsInternal, eyes);
        if (imageMatchSettings != null) {
            this.collectSimpleRegions(checkSettingsInternal, imageMatchSettings, screenshot);
            this.collectFloatingRegions(checkSettingsInternal, imageMatchSettings, screenshot);
            MatchWindowTask.collectAccessibilityRegions(checkSettingsInternal, imageMatchSettings, eyes, screenshot);
        }
        return imageMatchSettings;
    }

    public static ImageMatchSettings createImageMatchSettings(ICheckSettingsInternal checkSettingsInternal, EyesBase eyes) {
        ImageMatchSettings imageMatchSettings = null;
        if (checkSettingsInternal != null) {
            MatchLevel matchLevel = checkSettingsInternal.getMatchLevel();
            if (matchLevel == null) {
                matchLevel = eyes.getDefaultMatchSettings().getMatchLevel();
            }
            imageMatchSettings = new ImageMatchSettings(matchLevel, null, false);
            Boolean ignoreCaret = checkSettingsInternal.getIgnoreCaret();
            if (ignoreCaret == null) {
                ignoreCaret = eyes.getDefaultMatchSettings().getIgnoreCaret();
            }
            imageMatchSettings.setIgnoreCaret(ignoreCaret);
            imageMatchSettings.setUseDom(checkSettingsInternal.isUseDom() != null ? checkSettingsInternal.isUseDom() : false);
            imageMatchSettings.setAccessibilitySettings(eyes.getDefaultMatchSettings().getAccessibilitySettings());
            imageMatchSettings.setIgnoreDisplacements(checkSettingsInternal.isIgnoreDisplacements().booleanValue());
            imageMatchSettings.setEnablePatterns(checkSettingsInternal.isEnablePatterns().booleanValue());
        }
        return imageMatchSettings;
    }

    private EyesScreenshot takeScreenshot(Trigger[] userInputs, Region region, String tag, boolean shouldMatchWindowRunOnceOnTimeout, boolean ignoreMismatch, ICheckSettingsInternal checkSettingsInternal, int retryTimeout) {
        EyesScreenshot screenshot;
        long elapsedTimeStart = System.currentTimeMillis();
        if (0 == retryTimeout || shouldMatchWindowRunOnceOnTimeout) {
            if (shouldMatchWindowRunOnceOnTimeout) {
                GeneralUtils.sleep((long)retryTimeout);
            }
            screenshot = this.tryTakeScreenshot(userInputs, region, tag, ignoreMismatch, checkSettingsInternal);
        } else {
            screenshot = this.retryTakingScreenshot(userInputs, region, tag, ignoreMismatch, checkSettingsInternal, retryTimeout);
        }
        double elapsedTime = (System.currentTimeMillis() - elapsedTimeStart) / 1000L;
        this.logger.verbose(String.format("Completed in %.2f seconds", elapsedTime));
        return screenshot;
    }

    private EyesScreenshot retryTakingScreenshot(Trigger[] userInputs, Region region, String tag, boolean ignoreMismatch, ICheckSettingsInternal checkSettingsInternal, int retryTimeout) {
        long start = System.currentTimeMillis();
        EyesScreenshot screenshot = null;
        long retry = System.currentTimeMillis() - start;
        while (retry < (long)retryTimeout) {
            GeneralUtils.sleep((long)500L);
            screenshot = this.tryTakeScreenshot(userInputs, region, tag, true, checkSettingsInternal);
            if (this.matchResult.getAsExpected()) break;
            retry = System.currentTimeMillis() - start;
        }
        if (!this.matchResult.getAsExpected()) {
            screenshot = this.tryTakeScreenshot(userInputs, region, tag, ignoreMismatch, checkSettingsInternal);
        }
        return screenshot;
    }

    private EyesScreenshot tryTakeScreenshot(Trigger[] userInputs, Region region, String tag, boolean ignoreMismatch, ICheckSettingsInternal checkSettingsInternal) {
        AppOutputWithScreenshot appOutput = this.appOutputProvider.getAppOutput(region, this.lastScreenshot, checkSettingsInternal);
        EyesScreenshot screenshot = appOutput.getScreenshot();
        ImageMatchSettings matchSettings = this.createImageMatchSettings(checkSettingsInternal, screenshot, this.eyes);
        this.matchResult = this.performMatch(userInputs, appOutput, tag, ignoreMismatch, matchSettings);
        return screenshot;
    }

    private void updateLastScreenshot(EyesScreenshot screenshot) {
        if (screenshot != null) {
            this.lastScreenshot = screenshot;
        }
    }

    private void updateBounds(Region region) {
        if (region.isSizeEmpty()) {
            if (this.lastScreenshot == null) {
                this.lastScreenshotBounds = new Region(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
            } else {
                BufferedImage image = this.lastScreenshot.getImage();
                this.lastScreenshotBounds = new Region(0, 0, image.getWidth(), image.getHeight());
            }
        } else {
            this.lastScreenshotBounds = region;
        }
    }

    public Region getLastScreenshotBounds() {
        return this.lastScreenshotBounds;
    }

    private static void collectAccessibilityRegions(ICheckSettingsInternal checkSettingsInternal, ImageMatchSettings imageMatchSettings, EyesBase eyes, EyesScreenshot screenshot) {
        ArrayList accessibilityRegions = new ArrayList();
        for (IGetAccessibilityRegion regionProvider : checkSettingsInternal.getAccessibilityRegions()) {
            accessibilityRegions.addAll(regionProvider.getRegions((IEyesBase)eyes, screenshot));
        }
        imageMatchSettings.setAccessibility(accessibilityRegions.toArray(new AccessibilityRegionByRectangle[0]));
    }
}

