/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.ICheckSettings;
import com.applitools.connectivity.ServerConnector;
import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.AppEnvironment;
import com.applitools.eyes.AppOutput;
import com.applitools.eyes.BatchInfo;
import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.FailureReports;
import com.applitools.eyes.IEyesBase;
import com.applitools.eyes.IRegion;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.Location;
import com.applitools.eyes.LogHandler;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.MatchWindowTask;
import com.applitools.eyes.MobileDeviceInfo;
import com.applitools.eyes.NullCutProvider;
import com.applitools.eyes.OutOfBoundsException;
import com.applitools.eyes.PropertyData;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.ScaleProvider;
import com.applitools.eyes.SessionStartInfo;
import com.applitools.eyes.SessionStopInfo;
import com.applitools.eyes.SyncTaskListener;
import com.applitools.eyes.TaskListener;
import com.applitools.eyes.TestResultContainer;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.TestResultsStatus;
import com.applitools.eyes.Trigger;
import com.applitools.eyes.capture.AppOutputProvider;
import com.applitools.eyes.capture.ScreenshotProvider;
import com.applitools.eyes.config.Configuration;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import com.applitools.eyes.debug.FileDebugScreenshotsProvider;
import com.applitools.eyes.debug.NullDebugScreenshotProvider;
import com.applitools.eyes.events.ValidationInfo;
import com.applitools.eyes.exceptions.DiffsFoundException;
import com.applitools.eyes.exceptions.NewTestException;
import com.applitools.eyes.exceptions.TestFailedException;
import com.applitools.eyes.fluent.CheckSettings;
import com.applitools.eyes.fluent.ICheckSettingsInternal;
import com.applitools.eyes.locators.BaseOcrRegion;
import com.applitools.eyes.locators.TextRegion;
import com.applitools.eyes.locators.TextRegionSettings;
import com.applitools.eyes.logging.Message;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.logging.Type;
import com.applitools.eyes.positioning.InvalidPositionProvider;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.scaling.FixedScaleProvider;
import com.applitools.eyes.scaling.NullScaleProvider;
import com.applitools.eyes.selenium.ClassicRunner0;
import com.applitools.eyes.triggers.MouseAction;
import com.applitools.eyes.triggers.MouseTrigger;
import com.applitools.eyes.triggers.TextTrigger;
import com.applitools.eyes.visualgrid.model.DeviceSize;
import com.applitools.eyes.visualgrid.model.RenderingInfo;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.ImageUtils;
import com.applitools.utils.PropertyHandler;
import com.applitools.utils.ReadOnlyPropertyHandler;
import com.applitools.utils.SimplePropertyHandler;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;

public abstract class EyesBase
implements IEyesBase {
    protected static final int USE_DEFAULT_TIMEOUT = -1;
    private boolean shouldMatchWindowRunOnceOnTimeout;
    private MatchWindowTask matchWindowTask;
    private String testId = UUID.randomUUID().toString();
    protected String agentRunId = null;
    protected ClassicRunner0 runner;
    protected ServerConnector serverConnector;
    protected RunningSession runningSession;
    protected SessionStartInfo sessionStartInfo;
    protected TestResultContainer testResultContainer;
    protected EyesScreenshot lastScreenshot;
    protected PropertyHandler<ScaleProvider> scaleProviderHandler;
    protected PropertyHandler<CutProvider> cutProviderHandler;
    protected PropertyHandler<PositionProvider> positionProviderHandler;
    private boolean isScaleProviderSetByUser = false;
    private boolean isDisabled;
    protected Logger logger;
    protected boolean isOpen;
    private final Queue<Trigger> userInputs;
    private final List<PropertyData> properties = new ArrayList<PropertyData>();
    private boolean isViewportSizeSet;
    private int validationId;
    protected DebugScreenshotsProvider debugScreenshotsProvider;

    public EyesBase() {
        this(null);
    }

    public EyesBase(ClassicRunner0 runner) {
        this.runner = runner != null ? runner : new ClassicRunner0();
        this.logger = new Logger();
        this.initProviders();
        this.runningSession = null;
        this.userInputs = new ArrayDeque<Trigger>();
        this.lastScreenshot = null;
        this.debugScreenshotsProvider = new NullDebugScreenshotProvider();
    }

    private void initProviders(boolean hardReset) {
        if (this.scaleProviderHandler == null || hardReset) {
            this.scaleProviderHandler = new SimplePropertyHandler<ScaleProvider>();
            this.scaleProviderHandler.set(new NullScaleProvider(this.logger));
        }
        if (this.cutProviderHandler == null || hardReset) {
            this.cutProviderHandler = new SimplePropertyHandler<CutProvider>();
            this.cutProviderHandler.set(new NullCutProvider());
        }
        if (this.positionProviderHandler == null || hardReset) {
            this.positionProviderHandler = new SimplePropertyHandler<PositionProvider>();
            this.positionProviderHandler.set(new InvalidPositionProvider());
        }
    }

    private void initProviders() {
        this.initProviders(false);
    }

    public String getTestId() {
        return this.testId;
    }

    public void setTestId(String testId) {
        this.testId = testId;
    }

    public void setServerConnector(ServerConnector serverConnector) {
        ArgumentGuard.notNull((Object)((Object)serverConnector), (String)"serverConnector");
        this.serverConnector = serverConnector;
        serverConnector.setLogger(this.logger);
        this.runner.setServerConnector(serverConnector);
    }

    public ServerConnector getServerConnector() {
        if (this.serverConnector != null && this.serverConnector.getAgentId() == null) {
            this.serverConnector.setAgentId(this.getFullAgentId());
            this.runner.setServerConnector(this.serverConnector);
            this.logger.setAgentId(this.serverConnector.getAgentId());
        }
        return this.serverConnector;
    }

    public Configuration setApiKey(String apiKey) {
        ArgumentGuard.notNull((Object)apiKey, (String)"apiKey");
        this.getConfigurationInstance().setApiKey(apiKey);
        if (this.getServerConnector() == null) {
            throw new EyesException("server connector not set.");
        }
        this.getServerConnector().setApiKey(apiKey);
        this.runner.setApiKey(apiKey);
        return this.getConfigurationInstance();
    }

    @Override
    public String getApiKey() {
        if (this.getServerConnector() == null) {
            throw new EyesException("server connector not set.");
        }
        return this.getServerConnector().getApiKey();
    }

    public Configuration setServerUrl(String serverUrl) {
        this.setServerUrl(URI.create(serverUrl));
        return this.getConfigurationInstance();
    }

    public Configuration setServerUrl(URI serverUrl) {
        if (this.getServerConnector() == null) {
            throw new EyesException("server connector not set.");
        }
        if (serverUrl == null) {
            this.getServerConnector().setServerUrl(EyesBase.getDefaultServerUrl());
        } else {
            this.getServerConnector().setServerUrl(serverUrl);
        }
        this.runner.setServerUrl(this.getServerConnector().getServerUrl().toString());
        return this.getConfigurationInstance();
    }

    @Override
    public URI getServerUrl() {
        if (this.getServerConnector() == null) {
            throw new EyesException("server connector not set.");
        }
        return this.getServerConnector().getServerUrl();
    }

    public Configuration setProxy(AbstractProxySettings abstractProxySettings) {
        if (this.getServerConnector() == null) {
            throw new EyesException("server connector not set.");
        }
        this.getServerConnector().setProxy(abstractProxySettings);
        this.runner.setProxy(abstractProxySettings);
        return this.getConfigurationInstance();
    }

    public AbstractProxySettings getProxy() {
        if (this.getServerConnector() == null) {
            throw new EyesException("server connector not set.");
        }
        return this.getServerConnector().getProxy();
    }

    public void setIsDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    @Override
    public Boolean getIsDisabled() {
        return this.isDisabled;
    }

    protected void clearUserInputs() {
        if (this.isDisabled) {
            return;
        }
        this.userInputs.clear();
    }

    protected Trigger[] getUserInputs() {
        if (this.isDisabled) {
            return null;
        }
        Trigger[] result = new Trigger[this.userInputs.size()];
        return this.userInputs.toArray(result);
    }

    protected abstract String getBaseAgentId();

    @Override
    public String getFullAgentId() {
        String agentId = this.getConfigurationInstance().getAgentId();
        if (agentId == null) {
            return this.getBaseAgentId();
        }
        return String.format("%s [%s]", agentId, this.getBaseAgentId());
    }

    @Override
    public boolean getIsOpen() {
        return this.isOpen;
    }

    public static URI getDefaultServerUrl() {
        try {
            return new URI("https://eyesapi.applitools.com");
        }
        catch (URISyntaxException ex) {
            throw new EyesException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void setLogHandler(LogHandler logHandler) {
        this.logger.setLogHandler(logHandler);
        this.serverConnector.setLogger(this.logger);
        this.runner.setLogHandler(logHandler);
    }

    @Override
    public LogHandler getLogHandler() {
        return this.logger.getLogHandler();
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public void setImageCut(CutProvider cutProvider) {
        if (cutProvider != null) {
            cutProvider.setLogger(this.logger);
            this.cutProviderHandler = new ReadOnlyPropertyHandler<CutProvider>(cutProvider);
        } else {
            this.cutProviderHandler = new SimplePropertyHandler<CutProvider>();
            this.cutProviderHandler.set(new NullCutProvider());
        }
    }

    public boolean getIsCutProviderExplicitlySet() {
        return this.cutProviderHandler != null && !(this.cutProviderHandler.get() instanceof NullCutProvider);
    }

    public boolean getIsScaleProviderExplicitlySet() {
        return this.isScaleProviderSetByUser;
    }

    public void setScaleRatio(Double scaleRatio) {
        if (scaleRatio != null) {
            this.isScaleProviderSetByUser = true;
            FixedScaleProvider scaleProvider = new FixedScaleProvider(this.logger, scaleRatio);
            this.scaleProviderHandler = new ReadOnlyPropertyHandler<FixedScaleProvider>(scaleProvider);
        } else {
            this.isScaleProviderSetByUser = false;
            this.scaleProviderHandler = new SimplePropertyHandler<ScaleProvider>();
            this.scaleProviderHandler.set(new NullScaleProvider(this.logger));
        }
    }

    public double getScaleRatio() {
        return this.scaleProviderHandler.get().getScaleRatio();
    }

    @Override
    public void addProperty(String name, String value) {
        PropertyData pd = new PropertyData(name, value);
        this.properties.add(pd);
    }

    protected void addProperty(PropertyData property) {
        this.properties.add(property);
    }

    @Override
    public void clearProperties() {
        this.properties.clear();
    }

    public void setSaveDebugScreenshots(boolean saveDebugScreenshots) {
        DebugScreenshotsProvider prev = this.debugScreenshotsProvider;
        this.debugScreenshotsProvider = saveDebugScreenshots ? new FileDebugScreenshotsProvider(this.logger) : new NullDebugScreenshotProvider();
        this.debugScreenshotsProvider.setPrefix(prev.getPrefix());
        this.debugScreenshotsProvider.setPath(prev.getPath());
    }

    public boolean getSaveDebugScreenshots() {
        return !(this.debugScreenshotsProvider instanceof NullDebugScreenshotProvider);
    }

    public void setDebugScreenshotsPath(String pathToSave) {
        this.debugScreenshotsProvider.setPath(pathToSave);
    }

    public String getDebugScreenshotsPath() {
        return this.debugScreenshotsProvider.getPath();
    }

    public void setDebugScreenshotsPrefix(String prefix) {
        this.debugScreenshotsProvider.setPrefix(prefix);
    }

    public String getDebugScreenshotsPrefix() {
        return this.debugScreenshotsProvider.getPrefix();
    }

    public DebugScreenshotsProvider getDebugScreenshotsProvider() {
        return this.debugScreenshotsProvider;
    }

    public SessionStopInfo prepareStopSession(boolean isAborted) {
        if (this.runningSession == null || !this.isOpen) {
            this.logger.log(this.getTestId(), Stage.CLOSE, "Tried to close a non opened test");
            return null;
        }
        this.isOpen = false;
        this.lastScreenshot = null;
        this.clearUserInputs();
        this.initProviders(true);
        boolean isNewSession = this.runningSession.getIsNew();
        boolean save = isNewSession && this.getConfigurationInstance().getSaveNewTests() != false || !isNewSession && this.getConfigurationInstance().getSaveFailedTests() != false;
        return new SessionStopInfo(this.runningSession, isAborted, save);
    }

    public TestResults close() {
        return this.close(true);
    }

    @Override
    public TestResults abort() {
        return this.abortIfNotClosed();
    }

    public TestResults close(boolean throwEx) {
        TestResults results = this.stopSession(false);
        this.logSessionResultsAndThrowException(throwEx, results);
        return results;
    }

    @Override
    public TestResults abortIfNotClosed() {
        this.logger.log(this.getTestId(), Stage.CLOSE, Type.CALLED, new Pair[0]);
        return this.stopSession(true);
    }

    protected TestResults stopSession(boolean isAborted) {
        if (this.isDisabled) {
            TestResults testResults = new TestResults();
            testResults.setStatus(TestResultsStatus.Disabled);
            return testResults;
        }
        SessionStopInfo sessionStopInfo = this.prepareStopSession(isAborted);
        if (sessionStopInfo == null) {
            TestResults testResults = new TestResults();
            testResults.setStatus(TestResultsStatus.NotOpened);
            return testResults;
        }
        TestResults testResults = this.runner.close(this.getTestId(), sessionStopInfo);
        this.runningSession = null;
        if (testResults == null) {
            throw new EyesException("Failed stopping session");
        }
        return testResults;
    }

    public void logSessionResultsAndThrowException(boolean throwEx, TestResults results) {
        TestResultsStatus status = results.getStatus();
        String sessionResultsUrl = results.getUrl();
        String scenarioIdOrName = results.getName();
        String appIdOrName = results.getAppName();
        if (status == null) {
            throw new EyesException("Status is null in the test results");
        }
        this.logger.log(this.getTestId(), Stage.CLOSE, Type.TEST_RESULTS, new Pair[]{Pair.of((Object)"status", (Object)((Object)status)), Pair.of((Object)"url", (Object)sessionResultsUrl)});
        switch (status) {
            case Failed: {
                if (!throwEx) break;
                throw new TestFailedException(results, scenarioIdOrName, appIdOrName);
            }
            case Passed: {
                break;
            }
            case NotOpened: {
                if (!throwEx) break;
                throw new EyesException("Called close before calling open");
            }
            case Unresolved: {
                if (results.isNew()) {
                    if (!throwEx) break;
                    throw new NewTestException(results, scenarioIdOrName, appIdOrName);
                }
                if (!throwEx) break;
                throw new DiffsFoundException(results, scenarioIdOrName, appIdOrName);
            }
        }
    }

    protected void openLogger() {
        this.logger.getLogHandler().open();
    }

    public PositionProvider getPositionProvider() {
        return this.positionProviderHandler.get();
    }

    public void setPositionProvider(PositionProvider positionProvider) {
        if (positionProvider != null) {
            this.positionProviderHandler = new ReadOnlyPropertyHandler<PositionProvider>(positionProvider);
        } else {
            this.positionProviderHandler = new SimplePropertyHandler<PositionProvider>();
            this.positionProviderHandler.set(new InvalidPositionProvider());
        }
    }

    public List<String> extractText(BaseOcrRegion ... ocrRegions) {
        ArgumentGuard.notNull((Object)ocrRegions, (String)"ocrRegions");
        ArgumentGuard.notContainsNull((Object[])ocrRegions, (String)"ocrRegions");
        ArrayList<String> result = new ArrayList<String>();
        for (BaseOcrRegion ocrRegion : ocrRegions) {
            this.logger.log(this.getTestId(), Stage.OCR, new Pair[]{Pair.of((Object)"ocrRegion", (Object)ocrRegion)});
            this.getAppOutputForOcr(ocrRegion);
            if (ocrRegion.getAppOutput() == null) {
                return Collections.emptyList();
            }
            this.debugScreenshotsProvider.save(ocrRegion.getAppOutput().getScreenshot().getImage(), "ocr_regions");
            SyncTaskListener listener = new SyncTaskListener(this.logger, "getTextRegions");
            this.serverConnector.uploadImage((TaskListener<String>)listener, ocrRegion.getAppOutput().getScreenshotBytes());
            String screenshotUrl = (String)listener.get();
            if (screenshotUrl == null) {
                throw new EyesException("Failed posting image");
            }
            this.logger.log(this.getTestId(), Stage.OCR, new Pair[]{Pair.of((Object)"screenshotUrl", (Object)screenshotUrl)});
            ocrRegion.getAppOutput().setScreenshotUrl(screenshotUrl);
            SyncTaskListener postListener = new SyncTaskListener(this.logger, "getText");
            this.serverConnector.postOcrRegions((TaskListener<List<String>>)postListener, ocrRegion);
            List serverResult = (List)postListener.get();
            if (serverResult == null) {
                throw new EyesException("Failed posting ocr region");
            }
            this.logger.log(this.testId, Stage.OCR, new Pair[]{Pair.of((Object)"result", result)});
            if (serverResult.isEmpty()) {
                result.add(null);
                continue;
            }
            result.add((String)serverResult.get(0));
        }
        return result;
    }

    protected abstract void getAppOutputForOcr(BaseOcrRegion var1);

    public Map<String, List<TextRegion>> extractTextRegions(TextRegionSettings textRegionSettings) {
        BufferedImage viewPortScreenshot;
        ArgumentGuard.notNull((Object)textRegionSettings, (String)"textRegionSettings");
        ScreenshotProvider screenshotProvider = this.getScreenshotProvider();
        if (textRegionSettings.getImage() != null) {
            viewPortScreenshot = textRegionSettings.getImage();
        } else if (screenshotProvider != null) {
            viewPortScreenshot = screenshotProvider.getViewPortScreenshot(Stage.OCR);
        } else {
            throw new IllegalArgumentException("No image for the text region settings");
        }
        this.logger.log(this.getTestId(), Stage.OCR, new Pair[]{Pair.of((Object)"textRegionSettings", (Object)textRegionSettings), Pair.of((Object)"scaledImageSize", (Object)new RectangleSize(viewPortScreenshot.getWidth(), viewPortScreenshot.getHeight()))});
        this.debugScreenshotsProvider.save(viewPortScreenshot, "text_regions_final");
        byte[] image = ImageUtils.encodeAsPng(viewPortScreenshot);
        SyncTaskListener listener = new SyncTaskListener(this.logger, "getTextRegions");
        this.serverConnector.uploadImage((TaskListener<String>)listener, image);
        String viewportScreenshotUrl = (String)listener.get();
        if (viewportScreenshotUrl == null) {
            throw new EyesException("Failed posting viewport image");
        }
        this.logger.log(this.getTestId(), Stage.OCR, new Pair[]{Pair.of((Object)"screenshotUrl", (Object)viewportScreenshotUrl)});
        String domUrl = null;
        if (this.shouldCaptureDom(null)) {
            domUrl = this.tryCaptureAndPostDom();
        }
        textRegionSettings.setAppOutput(new AppOutput(this.getTitle(), null, domUrl, viewportScreenshotUrl, null));
        SyncTaskListener postListener = new SyncTaskListener(this.logger, "getTextRegions");
        this.serverConnector.postTextRegions((TaskListener<Map<String, List<TextRegion>>>)postListener, textRegionSettings);
        Map result = (Map)postListener.get();
        if (result == null) {
            throw new EyesException("Failed posting text regions");
        }
        this.logger.log(this.testId, Stage.OCR, new Pair[]{Pair.of((Object)"result", (Object)result)});
        return result;
    }

    protected abstract ScreenshotProvider getScreenshotProvider();

    protected MatchWindowData prepareForMatch(ICheckSettingsInternal checkSettingsInternal, List<Trigger> userInputs, AppOutput appOutput, String tag, boolean replaceLast, ImageMatchSettings imageMatchSettings, String renderId, String source) {
        String agentSetupStr = "";
        Message agentSetup = this.logger.createMessageFromLog(Collections.singleton(this.getTestId()), Stage.CHECK, null, new Pair[]{Pair.of((Object)"configuration", (Object)this.getConfiguration()), Pair.of((Object)"checkSettings", (Object)checkSettingsInternal)});
        ObjectMapper jsonMapper = new ObjectMapper();
        try {
            agentSetupStr = jsonMapper.writeValueAsString((Object)agentSetup);
        }
        catch (JsonProcessingException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Throwable)e, (String[])new String[]{this.getTestId()});
        }
        MatchWindowData.Options options = new MatchWindowData.Options(tag, userInputs.toArray(new Trigger[0]), replaceLast, false, false, false, false, imageMatchSettings, source, checkSettingsInternal.getVariationGroupId(), renderId);
        return new MatchWindowData(this.runningSession, userInputs.toArray(new Trigger[0]), appOutput, tag, false, options, agentSetupStr, renderId);
    }

    public MatchResult performMatch(MatchWindowData data) {
        MatchResult result = this.runner.check(this.getTestId(), data);
        if (result == null) {
            throw new EyesException("Failed performing match with the server");
        }
        return result;
    }

    protected MatchResult checkWindowBase(Region region, String tag, String source) {
        return this.checkWindowBase(region, tag, -1, source);
    }

    protected MatchResult checkWindowBase(Region region, String tag, int retryTimeout, String source) {
        return this.checkWindowBase(region, new CheckSettings(retryTimeout).withName(tag), source);
    }

    protected MatchResult checkWindowBase(Region region, String tag, ICheckSettings checkSettings) {
        return this.checkWindowBase(region, checkSettings.withName(tag), this.getAppName());
    }

    protected MatchResult checkWindowBase(Region region, ICheckSettings checkSettings, String source) {
        ICheckSettingsInternal checkSettingsInternal = (ICheckSettingsInternal)((Object)checkSettings);
        return this.checkWindowBase(region, checkSettingsInternal, source);
    }

    protected MatchResult checkWindowBase(Region region, ICheckSettingsInternal checkSettingsInternal, String source) {
        if (this.getIsDisabled().booleanValue()) {
            MatchResult result = new MatchResult();
            result.setAsExpected(true);
            return result;
        }
        String tag = checkSettingsInternal.getName();
        if (tag == null) {
            tag = "";
        }
        ArgumentGuard.isValidState((boolean)this.getIsOpen(), (String)"Eyes not open");
        if (checkSettingsInternal.getOcrRegion() != null) {
            AppOutput appOutput = this.getAppOutputWithScreenshot(region, checkSettingsInternal);
            checkSettingsInternal.getOcrRegion().setAppOutput(appOutput);
            MatchResult result = new MatchResult();
            result.setAsExpected(true);
            return result;
        }
        MatchResult result = this.matchWindowTask.matchWindow(this.getUserInputs(), region, tag, this.shouldMatchWindowRunOnceOnTimeout, checkSettingsInternal, source);
        this.validateResult(result);
        return result;
    }

    protected abstract String tryCaptureDom();

    protected String tryCaptureAndPostDom() {
        String domUrl = null;
        try {
            String domJson = this.tryCaptureDom();
            domUrl = this.tryPostDomCapture(domJson);
            this.logger.log(this.getTestId(), Stage.CHECK, Type.DOM_SCRIPT, new Pair[]{Pair.of((Object)"domUrl", (Object)domUrl)});
        }
        catch (Exception ex) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Type)Type.DOM_SCRIPT, (Throwable)ex, (String[])new String[]{this.getTestId()});
        }
        return domUrl;
    }

    protected boolean shouldCaptureDom(Boolean sendDomFromCheckSettings) {
        boolean sendDomFromConfig = this.getConfigurationInstance().isSendDom() == null || this.getConfigurationInstance().isSendDom() != false;
        return sendDomFromCheckSettings != null && sendDomFromCheckSettings != false || sendDomFromCheckSettings == null && sendDomFromConfig;
    }

    protected ValidationInfo fireValidationWillStartEvent(String tag) {
        ValidationInfo validationInfo = new ValidationInfo();
        validationInfo.setValidationId("" + ++this.validationId);
        validationInfo.setTag(tag);
        return validationInfo;
    }

    private String tryPostDomCapture(String domJson) {
        if (domJson != null) {
            byte[] resultStream = GeneralUtils.getGzipByteArrayOutputStream((String)domJson);
            SyncTaskListener listener = new SyncTaskListener(this.logger, String.format("tryUploadData %s", this.runningSession));
            this.serverConnector.uploadData((TaskListener<String>)listener, resultStream, "application/octet-stream", "application/json");
            return (String)listener.get();
        }
        return null;
    }

    protected void validateResult(MatchResult result) {
        if (result.getAsExpected()) {
            return;
        }
        this.shouldMatchWindowRunOnceOnTimeout = true;
        if (this.getConfigurationInstance().getFailureReports() == FailureReports.IMMEDIATE) {
            throw new TestFailedException(String.format("Mismatch found in '%s' of '%s'", this.sessionStartInfo.getScenarioIdOrName(), this.sessionStartInfo.getAppIdOrName()));
        }
    }

    @Override
    public void setIsDisabled(Boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public SessionStartInfo prepareForOpen() {
        this.openLogger();
        if (this.isDisabled) {
            return null;
        }
        this.validateApiKey();
        this.validateSessionOpen();
        this.isViewportSizeSet = false;
        RectangleSize viewportSize = this.getViewportSizeForOpen();
        if (viewportSize == null) {
            viewportSize = RectangleSize.EMPTY;
        }
        this.getConfigurationInstance().setViewportSize(viewportSize);
        if (this.getServerConnector() == null) {
            throw new EyesException("server connector not set.");
        }
        this.ensureViewportSize();
        Configuration configGetter = this.getConfigurationInstance();
        BatchInfo testBatch = configGetter.getBatch();
        if (testBatch == null) {
            this.getConfigurationInstance().setBatch(new BatchInfo(null));
        }
        String agentSessionId = UUID.randomUUID().toString();
        Object appEnv = this.getAppEnvironment();
        this.sessionStartInfo = new SessionStartInfo(this.getTestId(), this.getFullAgentId(), configGetter.getSessionType(), this.getAppName(), null, this.getTestName(), configGetter.getBatch(), this.getBaselineEnvName(), configGetter.getEnvironmentName(), appEnv, configGetter.getDefaultMatchSettings(), configGetter.getBranchName(), configGetter.getParentBranchName(), configGetter.getBaselineBranchName(), configGetter.getSaveDiffs(), this.properties, agentSessionId, this.agentRunId, configGetter.getAbortIdleTestTimeout());
        this.logger.log(TraceLevel.Info, this.getTestId(), Stage.OPEN, new Pair[]{Pair.of((Object)"configuration", (Object)this.getConfiguration())});
        return this.sessionStartInfo;
    }

    protected void openBase() throws EyesException {
        SessionStartInfo startInfo = this.prepareForOpen();
        if (startInfo == null) {
            return;
        }
        RunningSession runningSession = this.runner.open(this.getTestId(), startInfo);
        if (runningSession == null) {
            throw new EyesException("Failed starting session with the server");
        }
        this.openCompleted(runningSession);
    }

    public void openCompleted(RunningSession result) {
        this.runningSession = result;
        this.shouldMatchWindowRunOnceOnTimeout = this.runningSession.getIsNew();
        this.matchWindowTask = new MatchWindowTask(this.logger, this.getServerConnector(), this.runningSession, this.getConfigurationInstance().getMatchTimeout(), this, new AppOutputProvider(){

            @Override
            public AppOutput getAppOutput(Region region, ICheckSettingsInternal checkSettingsInternal) {
                return EyesBase.this.getAppOutputWithScreenshot(region, checkSettingsInternal);
            }
        });
        this.validationId = -1;
        this.isOpen = true;
    }

    protected RectangleSize getViewportSizeForOpen() {
        return this.getConfigurationInstance().getViewportSize();
    }

    private void validateApiKey() {
        if (this.getApiKey() == null) {
            throw new EyesException("API key is missing! Please set it using setApiKey()");
        }
    }

    private void validateSessionOpen() {
        if (this.isOpen || this.runningSession != null) {
            this.abortIfNotClosed();
            throw new EyesException("A test is already running");
        }
    }

    protected abstract RectangleSize getViewportSize();

    protected abstract Configuration setViewportSize(RectangleSize var1);

    protected void setEffectiveViewportSize(RectangleSize size) {
    }

    public void setExplicitViewportSize(RectangleSize explicitViewportSize) {
        if (explicitViewportSize == null) {
            return;
        }
        this.getConfigurationInstance().setViewportSize(explicitViewportSize);
        this.isViewportSizeSet = true;
    }

    protected abstract String getInferredEnvironment();

    protected abstract EyesScreenshot getScreenshot(Region var1, ICheckSettingsInternal var2);

    protected abstract String getTitle();

    protected void addUserInput(Trigger trigger) {
        if (this.isDisabled) {
            return;
        }
        ArgumentGuard.notNull((Object)trigger, (String)"trigger");
        this.userInputs.add(trigger);
    }

    protected void addTextTriggerBase(Region control, String text) {
        if (this.getIsDisabled().booleanValue()) {
            return;
        }
        ArgumentGuard.notNull((Object)control, (String)"control");
        ArgumentGuard.notNull((Object)text, (String)"text");
        control = new Region((IRegion)control);
        if (this.lastScreenshot == null) {
            return;
        }
        if ((control = this.lastScreenshot.getIntersectedRegion(control, CoordinatesType.SCREENSHOT_AS_IS)).isSizeEmpty()) {
            return;
        }
        TextTrigger trigger = new TextTrigger(control, text);
        this.addUserInput(trigger);
    }

    protected void addMouseTriggerBase(MouseAction action, Region control, Location cursor) {
        if (this.getIsDisabled().booleanValue()) {
            return;
        }
        ArgumentGuard.notNull((Object)((Object)action), (String)"action");
        ArgumentGuard.notNull((Object)control, (String)"control");
        ArgumentGuard.notNull((Object)cursor, (String)"cursor");
        if (this.lastScreenshot == null) {
            return;
        }
        Location cursorInScreenshot = new Location(cursor);
        cursorInScreenshot = cursorInScreenshot.offset(control.getLocation());
        try {
            cursorInScreenshot = this.lastScreenshot.getLocationInScreenshot(cursorInScreenshot, CoordinatesType.CONTEXT_RELATIVE);
        }
        catch (OutOfBoundsException e) {
            return;
        }
        Region controlScreenshotIntersect = this.lastScreenshot.getIntersectedRegion(control, CoordinatesType.SCREENSHOT_AS_IS);
        if (!controlScreenshotIntersect.isSizeEmpty()) {
            Location l = controlScreenshotIntersect.getLocation();
            cursorInScreenshot = cursorInScreenshot.offset(-l.getX(), -l.getY());
        }
        MouseTrigger trigger = new MouseTrigger(action, controlScreenshotIntersect, cursorInScreenshot);
        this.addUserInput(trigger);
    }

    protected Object getAppEnvironment() {
        AppEnvironment appEnv = new AppEnvironment();
        if (this.getConfigurationInstance().getHostOS() != null) {
            appEnv.setOs(this.getConfigurationInstance().getHostOS());
        }
        if (this.getConfigurationInstance().getHostApp() != null) {
            appEnv.setHostingApp(this.getConfigurationInstance().getHostApp());
        }
        if (this.getConfigurationInstance().getHostingAppInfo() != null) {
            appEnv.setHostingAppInfo(this.getConfigurationInstance().getHostingAppInfo());
        }
        if (this.getConfigurationInstance().getOsInfo() != null) {
            appEnv.setOsInfo(this.getConfigurationInstance().getOsInfo());
        }
        if (this.getConfigurationInstance().getDeviceInfo() != null) {
            appEnv.setDeviceInfo(this.getConfigurationInstance().getDeviceInfo());
        }
        appEnv.setInferred(this.getInferredEnvironment());
        appEnv.setDisplaySize(this.getConfigurationInstance().getViewportSize());
        return appEnv;
    }

    protected String getTestName() {
        return this.getConfigurationInstance().getTestName();
    }

    protected String getAppName() {
        return this.getConfigurationInstance().getAppName();
    }

    protected String getBaselineEnvName() {
        return this.getConfigurationInstance().getBaselineEnvName();
    }

    public Object getAgentSetup() {
        return null;
    }

    private void ensureViewportSize() {
        if (this.isViewportSizeSet) {
            return;
        }
        RectangleSize viewportSize = this.getConfigurationInstance().getViewportSize();
        if (viewportSize == null || viewportSize.isEmpty()) {
            try {
                viewportSize = this.getViewportSize();
                this.setEffectiveViewportSize(viewportSize);
                this.getConfigurationInstance().setViewportSize(viewportSize);
            }
            catch (NullPointerException e) {
                this.isViewportSizeSet = false;
            }
        } else {
            try {
                this.setViewportSize(viewportSize);
                this.isViewportSizeSet = true;
            }
            catch (Exception ex) {
                this.isViewportSizeSet = false;
                throw ex;
            }
        }
    }

    private AppOutput getAppOutputWithScreenshot(Region region, ICheckSettingsInternal checkSettingsInternal) {
        Location location;
        EyesScreenshot screenshot = this.getScreenshot(region, checkSettingsInternal);
        String domUrl = null;
        if (screenshot != null) {
            domUrl = screenshot.domUrl;
        }
        String title = this.getTitle();
        Location location2 = location = region == null ? null : region.getLocation();
        if (screenshot != null && screenshot.getOriginalLocation() != null) {
            location = screenshot.getOriginalLocation();
        }
        return new AppOutput(title, screenshot, domUrl, null, location);
    }

    public Boolean isSendDom() {
        return this.getConfigurationInstance().isSendDom();
    }

    public Configuration setSendDom(boolean isSendDom) {
        this.getConfigurationInstance().setSendDom(isSendDom);
        return this.getConfigurationInstance();
    }

    public RenderingInfo getRenderingInfo() {
        return this.getServerConnector().getRenderInfo();
    }

    public Map<String, DeviceSize> getDevicesSizes(String path) {
        return this.getServerConnector().getDevicesSizes(path);
    }

    public Map<String, String> getUserAgents() {
        return this.getServerConnector().getUserAgents();
    }

    public Map<String, MobileDeviceInfo> getMobileDeviceInfo() {
        return this.getServerConnector().getMobileDevicesInfo();
    }

    public Configuration setBatch(BatchInfo batch) {
        if (this.isDisabled) {
            return this.getConfigurationInstance();
        }
        this.getConfigurationInstance().setBatch(batch);
        return this.getConfigurationInstance();
    }

    protected abstract Configuration getConfigurationInstance();

    public Configuration getConfiguration() {
        return new Configuration(this.getConfigurationInstance());
    }

    @Override
    public void closeAsync() {
        this.close(false);
    }

    @Override
    public void abortAsync() {
        this.abort();
    }

    public boolean isCompleted() {
        return this.testResultContainer != null;
    }
}

