/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.fluent;

import com.applitools.ICheckSettings;
import com.applitools.eyes.AccessibilityRegionByRectangle;
import com.applitools.eyes.AccessibilityRegionType;
import com.applitools.eyes.GetAccessibilityRegion;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.Region;
import com.applitools.eyes.fluent.FloatingRegionByRectangle;
import com.applitools.eyes.fluent.GetFloatingRegion;
import com.applitools.eyes.fluent.GetSimpleRegion;
import com.applitools.eyes.fluent.ICheckSettingsInternal;
import com.applitools.eyes.fluent.SimpleRegionByRectangle;
import com.applitools.eyes.locators.BaseOcrRegion;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.visualgrid.model.VisualGridOption;
import com.applitools.eyes.visualgrid.model.VisualGridSelector;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CheckSettings
implements ICheckSettings,
ICheckSettingsInternal {
    protected static final String BEFORE_CAPTURE_SCREENSHOT = "beforeCaptureScreenshot";
    private Region targetRegion;
    private MatchLevel matchLevel = null;
    private Boolean ignoreCaret = null;
    private Boolean stitchContent = null;
    protected final List<GetSimpleRegion> ignoreRegions = new ArrayList<GetSimpleRegion>();
    protected final List<GetSimpleRegion> layoutRegions = new ArrayList<GetSimpleRegion>();
    protected final List<GetSimpleRegion> strictRegions = new ArrayList<GetSimpleRegion>();
    protected final List<GetSimpleRegion> contentRegions = new ArrayList<GetSimpleRegion>();
    protected final List<GetFloatingRegion> floatingRegions = new ArrayList<GetFloatingRegion>();
    protected List<GetAccessibilityRegion> accessibilityRegions = new ArrayList<GetAccessibilityRegion>();
    private Integer timeout = null;
    protected String name;
    protected Boolean enablePatterns;
    protected Boolean sendDom = null;
    protected Boolean useDom;
    protected Map<String, String> scriptHooks = new HashMap<String, String>();
    protected Boolean ignoreDisplacements;
    private List<VisualGridOption> visualGridOptions = new ArrayList<VisualGridOption>();
    private BaseOcrRegion ocrRegion = null;
    private String variationGroupId = null;
    private Boolean disableBrowserFetching;
    private Integer waitBeforeCapture;

    protected CheckSettings() {
    }

    protected CheckSettings(Region region) {
        this.targetRegion = region;
    }

    public CheckSettings(Integer timeout) {
        this.timeout = timeout;
    }

    protected void ignore_(Region region) {
        this.ignore_(new SimpleRegionByRectangle(region));
    }

    protected void ignore_(GetSimpleRegion regionProvider) {
        this.ignoreRegions.add(regionProvider);
    }

    protected void layout_(Region region) {
        this.layout_(new SimpleRegionByRectangle(region));
    }

    protected void layout_(GetSimpleRegion regionProvider) {
        this.layoutRegions.add(regionProvider);
    }

    protected void content_(Region region) {
        this.content_(new SimpleRegionByRectangle(region));
    }

    protected void content_(GetSimpleRegion regionProvider) {
        this.contentRegions.add(regionProvider);
    }

    protected void strict_(Region region) {
        this.strict_(new SimpleRegionByRectangle(region));
    }

    protected void strict_(GetSimpleRegion regionProvider) {
        this.strictRegions.add(regionProvider);
    }

    protected void floating_(Region region, int maxUpOffset, int maxDownOffset, int maxLeftOffset, int maxRightOffset) {
        this.floatingRegions.add(new FloatingRegionByRectangle(region, maxUpOffset, maxDownOffset, maxLeftOffset, maxRightOffset));
    }

    protected void floating(GetFloatingRegion regionProvider) {
        this.floatingRegions.add(regionProvider);
    }

    @Override
    public CheckSettings clone() {
        CheckSettings clone = new CheckSettings();
        this.populateClone(clone);
        return clone;
    }

    @Override
    public Boolean isStitchContent() {
        return this.stitchContent;
    }

    @Override
    public ICheckSettings ignore(Region region, Region ... regions) {
        CheckSettings clone = this.clone();
        clone.ignore_(region);
        for (Region r : regions) {
            clone.ignore_(r);
        }
        return clone;
    }

    @Override
    public ICheckSettings ignore(Region[] regions) {
        CheckSettings clone = this.clone();
        for (Region r : regions) {
            clone.ignore_(r);
        }
        return clone;
    }

    @Override
    public ICheckSettings layout(Region region, Region ... regions) {
        CheckSettings clone = this.clone();
        clone.layout_(region);
        for (Region r : regions) {
            clone.layout_(r);
        }
        return clone;
    }

    @Override
    public ICheckSettings layout(Region[] regions) {
        CheckSettings clone = this.clone();
        for (Region r : regions) {
            clone.layout_(r);
        }
        return clone;
    }

    @Override
    public ICheckSettings strict(Region region, Region ... regions) {
        CheckSettings clone = this.clone();
        clone.strict_(region);
        for (Region r : regions) {
            clone.strict_(r);
        }
        return clone;
    }

    @Override
    public ICheckSettings strict(Region[] regions) {
        CheckSettings clone = this.clone();
        for (Region r : regions) {
            clone.strict_(r);
        }
        return clone;
    }

    @Override
    public ICheckSettings content(Region region, Region ... regions) {
        CheckSettings clone = this.clone();
        clone.content_(region);
        for (Region r : regions) {
            clone.content_(r);
        }
        return clone;
    }

    @Override
    public ICheckSettings content(Region[] regions) {
        CheckSettings clone = this.clone();
        for (Region r : regions) {
            clone.content_(r);
        }
        return clone;
    }

    @Override
    public ICheckSettings fully() {
        CheckSettings clone = this.clone();
        clone.stitchContent = true;
        return clone;
    }

    @Override
    public ICheckSettings fully(Boolean fully) {
        CheckSettings clone = this.clone();
        clone.stitchContent = fully;
        return clone;
    }

    @Override
    public ICheckSettings floating(int maxOffset, Region ... regions) {
        CheckSettings clone = this.clone();
        for (Region r : regions) {
            clone.floating_(r, maxOffset, maxOffset, maxOffset, maxOffset);
        }
        return clone;
    }

    @Override
    public ICheckSettings floating(Region region, int maxUpOffset, int maxDownOffset, int maxLeftOffset, int maxRightOffset) {
        CheckSettings clone = this.clone();
        clone.floating_(region, maxUpOffset, maxDownOffset, maxLeftOffset, maxRightOffset);
        return clone;
    }

    @Override
    public ICheckSettings timeout(Integer timeoutMilliseconds) {
        CheckSettings clone = this.clone();
        clone.timeout = timeoutMilliseconds;
        return clone;
    }

    @Override
    public ICheckSettings layout() {
        CheckSettings clone = this.clone();
        clone.matchLevel = MatchLevel.LAYOUT;
        return clone;
    }

    @Override
    public ICheckSettings exact() {
        CheckSettings clone = this.clone();
        clone.matchLevel = MatchLevel.EXACT;
        return clone;
    }

    @Override
    public ICheckSettings strict() {
        CheckSettings clone = this.clone();
        clone.matchLevel = MatchLevel.STRICT;
        return clone;
    }

    @Override
    public ICheckSettings content() {
        CheckSettings clone = this.clone();
        clone.matchLevel = MatchLevel.CONTENT;
        return clone;
    }

    @Override
    public ICheckSettings matchLevel(MatchLevel matchLevel) {
        CheckSettings clone = this.clone();
        clone.matchLevel = matchLevel;
        return clone;
    }

    @Override
    public ICheckSettings ignoreCaret(Boolean ignoreCaret) {
        CheckSettings clone = this.clone();
        clone.ignoreCaret = ignoreCaret;
        return clone;
    }

    @Override
    public ICheckSettings ignoreCaret() {
        CheckSettings clone = this.clone();
        clone.ignoreCaret = true;
        return clone;
    }

    @Override
    public ICheckSettings withName(String name) {
        CheckSettings clone = this.clone();
        clone.name = name;
        return clone;
    }

    @Override
    public Boolean isSendDom() {
        return this.sendDom;
    }

    @Override
    public Boolean isIgnoreDisplacements() {
        return this.ignoreDisplacements;
    }

    @Override
    public Boolean isUseDom() {
        return this.useDom;
    }

    @Override
    public ICheckSettings useDom(Boolean useDom) {
        CheckSettings clone = this.clone();
        clone.useDom = useDom;
        return clone;
    }

    @Override
    public ICheckSettings sendDom(Boolean sendDom) {
        CheckSettings clone = this.clone();
        clone.sendDom = sendDom;
        return clone;
    }

    @Override
    public ICheckSettings sendDom() {
        return this.sendDom(true);
    }

    @Override
    public Region getTargetRegion() {
        return this.targetRegion;
    }

    @Override
    public Integer getTimeout() {
        return this.timeout;
    }

    @Override
    public Boolean getStitchContent() {
        return this.stitchContent;
    }

    @Override
    public MatchLevel getMatchLevel() {
        return this.matchLevel;
    }

    @Override
    public GetSimpleRegion[] getIgnoreRegions() {
        return this.ignoreRegions.toArray(new GetSimpleRegion[0]);
    }

    @Override
    public GetSimpleRegion[] getStrictRegions() {
        return this.strictRegions.toArray(new GetSimpleRegion[0]);
    }

    @Override
    public GetSimpleRegion[] getLayoutRegions() {
        return this.layoutRegions.toArray(new GetSimpleRegion[0]);
    }

    @Override
    public GetSimpleRegion[] getContentRegions() {
        return this.contentRegions.toArray(new GetSimpleRegion[0]);
    }

    @Override
    public GetFloatingRegion[] getFloatingRegions() {
        return this.floatingRegions.toArray(new GetFloatingRegion[0]);
    }

    @Override
    public Boolean getIgnoreCaret() {
        return this.ignoreCaret;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, String> getScriptHooks() {
        return this.scriptHooks;
    }

    @Override
    public String getSizeMode() {
        return null;
    }

    protected void updateTargetRegion(Region region) {
        this.targetRegion = region;
    }

    protected void populateClone(CheckSettings clone) {
        clone.targetRegion = this.targetRegion;
        clone.matchLevel = this.matchLevel;
        clone.stitchContent = this.stitchContent;
        clone.timeout = this.timeout;
        clone.ignoreCaret = this.ignoreCaret;
        clone.name = this.name;
        clone.ignoreRegions.addAll(this.ignoreRegions);
        clone.contentRegions.addAll(this.contentRegions);
        clone.layoutRegions.addAll(this.layoutRegions);
        clone.strictRegions.addAll(this.strictRegions);
        clone.floatingRegions.addAll(this.floatingRegions);
        clone.scriptHooks.putAll(this.scriptHooks);
        clone.enablePatterns = this.enablePatterns;
        clone.ignoreDisplacements = this.ignoreDisplacements;
        clone.accessibilityRegions = this.accessibilityRegions;
        clone.useDom = this.useDom;
        clone.visualGridOptions = this.visualGridOptions;
        clone.ocrRegion = this.ocrRegion;
        clone.variationGroupId = this.variationGroupId;
        clone.disableBrowserFetching = this.disableBrowserFetching;
        clone.waitBeforeCapture = this.waitBeforeCapture;
    }

    public void setStitchContent(boolean stitchContent) {
        this.stitchContent = stitchContent;
    }

    @Override
    public Boolean isEnablePatterns() {
        return this.enablePatterns;
    }

    @Override
    public VisualGridSelector getVGTargetSelector() {
        return null;
    }

    @Override
    public ICheckSettings enablePatterns(Boolean enablePatterns) {
        CheckSettings clone = this.clone();
        clone.enablePatterns = enablePatterns;
        return clone;
    }

    @Override
    public ICheckSettings enablePatterns() {
        CheckSettings clone = this.clone();
        clone.enablePatterns = true;
        return clone;
    }

    @Override
    @Deprecated
    public ICheckSettings scriptHook(String hook) {
        return this.beforeRenderScreenshotHook(hook);
    }

    @Override
    public ICheckSettings beforeRenderScreenshotHook(String hook) {
        CheckSettings clone = this.clone();
        clone.scriptHooks.put(BEFORE_CAPTURE_SCREENSHOT, hook);
        return clone;
    }

    @Override
    public ICheckSettings ignoreDisplacements(Boolean ignoreDisplacements) {
        CheckSettings clone = this.clone();
        clone.ignoreDisplacements = ignoreDisplacements;
        return clone;
    }

    @Override
    public ICheckSettings ignoreDisplacements() {
        return this.ignoreDisplacements(true);
    }

    protected void accessibility_(GetAccessibilityRegion accessibilityRegionProvider) {
        this.accessibilityRegions.add(accessibilityRegionProvider);
    }

    protected void accessibility_(Region rect, AccessibilityRegionType regionType) {
        this.accessibility_(new AccessibilityRegionByRectangle(rect, regionType));
    }

    @Override
    public ICheckSettings accessibility(Region region, AccessibilityRegionType regionType) {
        CheckSettings clone = this.clone();
        clone.accessibility_(region, regionType);
        return clone;
    }

    protected void accessibility(GetAccessibilityRegion accessibilityRegionProvider) {
        this.accessibilityRegions.add(accessibilityRegionProvider);
    }

    @Override
    public GetAccessibilityRegion[] getAccessibilityRegions() {
        return this.accessibilityRegions.toArray(new GetAccessibilityRegion[0]);
    }

    public ICheckSettings ocrRegion(BaseOcrRegion ocrRegion) {
        CheckSettings clone = this.clone();
        clone.ocrRegion = ocrRegion;
        return clone;
    }

    @Override
    public BaseOcrRegion getOcrRegion() {
        return this.ocrRegion;
    }

    public ICheckSettings variationGroupId(String variationGroupId) {
        CheckSettings clone = this.clone();
        clone.variationGroupId = variationGroupId;
        return clone;
    }

    @Override
    public String getVariationGroupId() {
        return this.variationGroupId;
    }

    @Override
    @JsonIgnore
    public PositionProvider getStepPositionProvider() {
        return null;
    }

    @Override
    public ICheckSettings visualGridOptions(VisualGridOption ... options) {
        CheckSettings clone = this.clone();
        clone.visualGridOptions.clear();
        if (options != null) {
            clone.visualGridOptions.addAll(Arrays.asList(options));
            clone.visualGridOptions.remove(null);
        }
        return clone;
    }

    @Override
    public Boolean isCheckWindow() {
        return this.getTargetRegion() == null && this.getVGTargetSelector() == null;
    }

    @Override
    public ICheckSettings waitBeforeCapture(Integer milliSec) {
        CheckSettings clone = this.clone();
        clone.waitBeforeCapture = milliSec;
        return clone;
    }

    @Override
    public List<VisualGridOption> getVisualGridOptions() {
        return this.visualGridOptions;
    }

    @Override
    public Boolean isDisableBrowserFetching() {
        return this.disableBrowserFetching;
    }

    @Override
    public ICheckSettings setDisableBrowserFetching(Boolean disableBrowserFetching) {
        CheckSettings clone = this.clone();
        clone.disableBrowserFetching = disableBrowserFetching;
        return clone;
    }

    public Integer getWaitBeforeCapture() {
        return this.waitBeforeCapture;
    }
}

