/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.ICheckSettings;
import com.applitools.eyes.EyesBase;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.IBatchCloser;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.SessionStartInfo;
import com.applitools.eyes.SessionStopInfo;
import com.applitools.eyes.TestResultContainer;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.config.Configuration;
import com.applitools.eyes.fluent.ICheckSettingsInternal;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.selenium.ClassicRunner0;
import com.applitools.eyes.visualgrid.model.RenderBrowserInfo;
import com.applitools.eyes.visualgrid.model.VisualGridSelector;
import com.applitools.eyes.visualgrid.services.CheckTask;
import com.applitools.utils.GeneralUtils;
import java.util.List;

public abstract class RunningTest
extends EyesBase
implements IBatchCloser {
    protected final RenderBrowserInfo browserInfo;
    protected Throwable error = null;
    private Boolean isAbortIssued = null;
    private boolean inOpenProcess = false;
    private boolean startedCloseProcess = false;

    protected RunningTest(ClassicRunner0 runner) {
        super(runner);
        this.browserInfo = null;
    }

    protected RunningTest(RenderBrowserInfo browserInfo, Logger logger) {
        this.browserInfo = browserInfo;
        this.logger = logger;
    }

    public boolean isCloseTaskIssued() {
        return this.isAbortIssued != null;
    }

    public TestResultContainer getTestResultContainer() {
        return this.testResultContainer;
    }

    @Override
    public SessionStartInfo prepareForOpen() {
        this.inOpenProcess = true;
        return super.prepareForOpen();
    }

    @Override
    public void openCompleted(RunningSession result) {
        this.inOpenProcess = false;
        super.openCompleted(result);
    }

    public void openFailed(Throwable e) {
        this.inOpenProcess = false;
        this.setTestInExceptionMode(e);
    }

    public abstract MatchWindowData prepareForMatch(CheckTask var1);

    public abstract CheckTask issueCheck(ICheckSettings var1, List<VisualGridSelector[]> var2, String var3);

    public abstract void checkCompleted(CheckTask var1, MatchResult var2);

    public void issueClose() {
        if (this.isCloseTaskIssued()) {
            return;
        }
        this.isAbortIssued = false;
    }

    public void issueAbort(Throwable error, boolean forceAbort) {
        if (this.isCloseTaskIssued() && !forceAbort) {
            return;
        }
        this.isAbortIssued = true;
        if (this.error == null) {
            this.error = error;
        }
    }

    public void closeCompleted(TestResults testResults) {
        this.startedCloseProcess = true;
        if (!this.isTestAborted()) {
            try {
                this.logSessionResultsAndThrowException(true, testResults);
            }
            catch (Throwable e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CLOSE, (Throwable)e, (String[])new String[]{this.getTestId()});
                this.error = e;
            }
        }
        this.testResultContainer = new TestResultContainer(testResults, this.browserInfo, this.error);
    }

    public void closeFailed(Throwable t) {
        this.startedCloseProcess = true;
        if (this.error == null) {
            this.error = t;
        }
        this.testResultContainer = new TestResultContainer(null, this.browserInfo, this.error);
    }

    @Override
    public SessionStopInfo prepareStopSession(boolean isAborted) {
        this.startedCloseProcess = true;
        return super.prepareStopSession(isAborted);
    }

    public boolean isTestReadyToClose() {
        return !this.inOpenProcess && this.isAbortIssued != null && !this.startedCloseProcess;
    }

    public boolean isTestAborted() {
        return this.isAbortIssued != null && this.isAbortIssued != false;
    }

    public void setTestInExceptionMode(Throwable e) {
        GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.GENERAL, (Throwable)e, (String[])new String[]{this.getTestId()});
        if (this.isTestAborted()) {
            return;
        }
        this.issueAbort(e, true);
    }

    @Override
    protected RectangleSize getViewportSize() {
        return RectangleSize.EMPTY;
    }

    @Override
    protected Configuration setViewportSize(RectangleSize size) {
        return this.getConfigurationInstance();
    }

    @Override
    protected String getInferredEnvironment() {
        return null;
    }

    @Override
    protected EyesScreenshot getScreenshot(Region targetRegion, ICheckSettingsInternal checkSettingsInternal) {
        return null;
    }

    @Override
    protected String getTitle() {
        return null;
    }

    @Override
    public void closeBatch(String batchId) {
        this.getServerConnector().closeBatch(batchId);
    }

    public RenderBrowserInfo getBrowserInfo() {
        return this.browserInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunningTest that = (RunningTest)o;
        return this.getTestId().equals(that.getTestId());
    }

    public String toString() {
        return "RunningTest{browserInfo=" + this.browserInfo + ", testId='" + this.getTestId() + '\'' + '}';
    }
}

