/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.services;

import com.applitools.ICheckSettingsInternal;
import com.applitools.connectivity.ServerConnector;
import com.applitools.connectivity.UfgConnector;
import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.AutProxyMode;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.RunningTest;
import com.applitools.eyes.SessionStopInfo;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.services.CheckService;
import com.applitools.eyes.services.CloseService;
import com.applitools.eyes.services.OpenService;
import com.applitools.eyes.services.RenderService;
import com.applitools.eyes.services.ResourceCollectionService;
import com.applitools.eyes.visualgrid.model.FrameData;
import com.applitools.eyes.visualgrid.model.IDebugResourceWriter;
import com.applitools.eyes.visualgrid.model.RGridDom;
import com.applitools.eyes.visualgrid.model.RGridResource;
import com.applitools.eyes.visualgrid.model.RenderBrowserInfo;
import com.applitools.eyes.visualgrid.model.RenderInfo;
import com.applitools.eyes.visualgrid.model.RenderRequest;
import com.applitools.eyes.visualgrid.model.RenderStatusResults;
import com.applitools.eyes.visualgrid.model.RenderingInfo;
import com.applitools.eyes.visualgrid.model.VisualGridSelector;
import com.applitools.eyes.visualgrid.services.CheckTask;
import com.applitools.eyes.visualgrid.services.IEyes;
import com.applitools.eyes.visualgrid.services.VisualGridRunningTest;
import com.applitools.utils.ClassVersionGetter;
import com.applitools.utils.GeneralUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.tuple.Pair;

public class EyesServiceRunner
extends Thread {
    private static final String FULLPAGE = "full-page";
    private static final String VIEWPORT = "viewport";
    private final AtomicBoolean isRunning = new AtomicBoolean(true);
    private Throwable error = null;
    private Logger logger;
    private RenderingInfo renderingInfo;
    private final Set<IEyes> allEyes;
    private final Map<String, Pair<FrameData, List<CheckTask>>> resourceCollectionTasksMapping = new HashMap<String, Pair<FrameData, List<CheckTask>>>();
    private final List<RenderRequest> waitingRenderRequests = new ArrayList<RenderRequest>();
    private final Map<String, CheckTask> waitingCheckTasks = new HashMap<String, CheckTask>();
    private final OpenService openService;
    private final CheckService checkService;
    private final CloseService closeService;
    private final ResourceCollectionService resourceCollectionService;
    private final RenderService renderService;

    public EyesServiceRunner(Logger logger, ServerConnector serverConnector, Set<IEyes> allEyes, int testConcurrency, IDebugResourceWriter debugResourceWriter, Map<String, RGridResource> resourcesCacheMap) {
        this.logger = logger;
        this.allEyes = allEyes;
        this.openService = new OpenService(logger, serverConnector, testConcurrency);
        this.checkService = new CheckService(logger, serverConnector);
        this.closeService = new CloseService(logger, serverConnector);
        this.resourceCollectionService = new ResourceCollectionService(logger, (UfgConnector)serverConnector, debugResourceWriter, resourcesCacheMap);
        this.renderService = new RenderService(logger, (UfgConnector)serverConnector);
    }

    public void setRenderingInfo(RenderingInfo renderingInfo) {
        if (renderingInfo != null) {
            this.renderingInfo = renderingInfo;
        }
    }

    public void setDebugResourceWriter(IDebugResourceWriter debugResourceWriter) {
        this.resourceCollectionService.setDebugResourceWriter(debugResourceWriter);
    }

    public void setAutProxy(AbstractProxySettings proxy, String[] autProxyDomains, AutProxyMode mode) {
        boolean isWhiteList = mode == null || mode.equals((Object)AutProxyMode.ALLOW);
        this.resourceCollectionService.setAutProxy(proxy, autProxyDomains, isWhiteList);
    }

    public AbstractProxySettings getDefaultResourcesProxy() {
        return this.resourceCollectionService.defaultResourcesConnector.getProxy();
    }

    public AbstractProxySettings getCustomResourcesProxy() {
        return this.resourceCollectionService.customResourcesConnector.getProxy();
    }

    public void setLogger(Logger logger) {
        this.openService.setLogger(logger);
        this.checkService.setLogger(logger);
        this.closeService.setLogger(logger);
        this.resourceCollectionService.setLogger(logger);
        this.renderService.setLogger(logger);
        this.logger = logger;
    }

    public void setServerConnector(ServerConnector serverConnector) {
        this.openService.setServerConnector(serverConnector);
        this.checkService.setServerConnector(serverConnector);
        this.closeService.setServerConnector(serverConnector);
        this.resourceCollectionService.setServerConnector((UfgConnector)serverConnector);
        this.renderService.setServerConnector((UfgConnector)serverConnector);
    }

    public void openTests(Collection<VisualGridRunningTest> runningTests) {
        for (VisualGridRunningTest runningTest : runningTests) {
            this.openService.addInput(runningTest.getTestId(), runningTest.prepareForOpen());
        }
    }

    public void addResourceCollectionTask(FrameData domData, List<CheckTask> checkTasks) {
        String resourceCollectionTaskId = UUID.randomUUID().toString();
        HashSet<String> testIds = new HashSet<String>();
        testIds.add(resourceCollectionTaskId);
        for (CheckTask checkTask : checkTasks) {
            testIds.add(checkTask.getTestId());
        }
        domData.setTestIds(testIds);
        this.resourceCollectionService.addInput(resourceCollectionTaskId, (Object)domData);
        this.resourceCollectionTasksMapping.put(resourceCollectionTaskId, (Pair<FrameData, List<CheckTask>>)Pair.of((Object)domData, checkTasks));
        this.logger.log(testIds, Stage.RESOURCE_COLLECTION, new Pair[]{Pair.of((Object)"resourceCollectionTaskId", (Object)resourceCollectionTaskId)});
    }

    @Override
    public void run() {
        try {
            while (this.isRunning.get()) {
                this.openServiceIteration();
                this.resourceCollectionServiceIteration();
                this.renderServiceIteration();
                this.checkServiceIteration();
                this.closeServiceIteration();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Throwable e) {
            this.isRunning.set(false);
            this.error = e;
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.GENERAL, (Throwable)e, (String[])new String[0]);
        }
    }

    public Throwable getError() {
        return this.error;
    }

    public void stopServices() {
        this.isRunning.set(false);
    }

    private void openServiceIteration() {
        this.openService.run();
        for (Pair pair : this.openService.getSucceededTasks()) {
            this.findTestById((String)pair.getLeft()).openCompleted((RunningSession)pair.getRight());
        }
        for (Pair pair : this.openService.getFailedTasks()) {
            this.findTestById((String)pair.getLeft()).openFailed((Throwable)pair.getRight());
        }
    }

    private void checkServiceIteration() {
        CheckTask checkTask;
        for (CheckTask checkTask2 : this.waitingCheckTasks.values()) {
            if (!checkTask2.isTestActive() || !checkTask2.isReadyForMatch()) continue;
            MatchWindowData matchWindowData = checkTask2.startMatch();
            this.checkService.addInput(checkTask2.getStepId(), matchWindowData);
        }
        this.checkService.run();
        for (Pair pair : this.checkService.getSucceededTasks()) {
            checkTask = this.waitingCheckTasks.remove(pair.getLeft());
            if (!checkTask.isTestActive()) continue;
            checkTask.onComplete((MatchResult)pair.getRight());
        }
        for (Pair pair : this.checkService.getFailedTasks()) {
            checkTask = this.waitingCheckTasks.remove(pair.getLeft());
            checkTask.onFail((Throwable)pair.getRight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeServiceIteration() {
        RunningTest runningTest;
        Iterator iterator = this.allEyes;
        synchronized (iterator) {
            for (IEyes eyes : this.allEyes) {
                Map<String, RunningTest> map = eyes.getAllRunningTests();
                synchronized (map) {
                    for (RunningTest runningTest2 : eyes.getAllRunningTests().values()) {
                        if (!runningTest2.isTestReadyToClose()) continue;
                        if (!runningTest2.getIsOpen()) {
                            this.openService.decrementConcurrency();
                            runningTest2.closeFailed((Throwable)new EyesException("Eyes never opened"));
                            continue;
                        }
                        SessionStopInfo sessionStopInfo = runningTest2.prepareStopSession(runningTest2.isTestAborted());
                        this.closeService.addInput(runningTest2.getTestId(), sessionStopInfo);
                    }
                }
            }
        }
        this.closeService.run();
        for (Pair pair : this.closeService.getSucceededTasks()) {
            runningTest = this.findTestById((String)pair.getLeft());
            runningTest.closeCompleted((TestResults)pair.getRight());
            this.openService.decrementConcurrency();
        }
        for (Pair pair : this.closeService.getFailedTasks()) {
            runningTest = this.findTestById((String)pair.getLeft());
            runningTest.closeFailed((Throwable)pair.getRight());
            this.openService.decrementConcurrency();
        }
    }

    private void resourceCollectionServiceIteration() {
        Pair<FrameData, List<CheckTask>> checkTasks;
        this.resourceCollectionService.run();
        if (this.resourceCollectionService.outputQueue.isEmpty() && this.resourceCollectionService.errorQueue.isEmpty()) {
            return;
        }
        for (Pair pair : this.resourceCollectionService.getSucceededTasks()) {
            checkTasks = this.resourceCollectionTasksMapping.get(pair.getLeft());
            this.queueRenderRequests((FrameData)checkTasks.getLeft(), (Map)pair.getRight(), (List)checkTasks.getRight());
            this.resourceCollectionTasksMapping.remove(pair.getLeft());
        }
        for (Pair pair : this.resourceCollectionService.getFailedTasks()) {
            checkTasks = this.resourceCollectionTasksMapping.get(pair.getLeft());
            for (CheckTask checkTask : (List)checkTasks.getRight()) {
                checkTask.onFail((Throwable)pair.getRight());
            }
            this.resourceCollectionTasksMapping.remove(pair.getLeft());
        }
        System.gc();
    }

    private void renderServiceIteration() {
        CheckTask checkTask;
        ArrayList<RenderRequest> renderRequestsToRemove = new ArrayList<RenderRequest>();
        for (RenderRequest renderRequest : this.waitingRenderRequests) {
            checkTask = this.waitingCheckTasks.get(renderRequest.getStepId());
            if (!checkTask.isTestActive()) {
                this.waitingCheckTasks.remove(checkTask.getStepId());
                renderRequestsToRemove.add(renderRequest);
                continue;
            }
            if (!checkTask.isReadyForRender()) continue;
            this.renderService.addInput(checkTask.getStepId(), (Object)renderRequest);
            renderRequestsToRemove.add(renderRequest);
        }
        this.waitingRenderRequests.removeAll(renderRequestsToRemove);
        this.renderService.run();
        for (Pair pair : this.renderService.getSucceededTasks()) {
            checkTask = this.waitingCheckTasks.get(pair.getLeft());
            if (!checkTask.isTestActive()) {
                this.waitingCheckTasks.remove(pair.getLeft());
                continue;
            }
            checkTask.setRenderStatusResults((RenderStatusResults)pair.getRight());
        }
        for (Pair pair : this.renderService.getFailedTasks()) {
            checkTask = this.waitingCheckTasks.remove(pair.getLeft());
            checkTask.onFail((Throwable)pair.getRight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunningTest findTestById(String testId) {
        Set<IEyes> set = this.allEyes;
        synchronized (set) {
            for (IEyes eyes : this.allEyes) {
                if (!eyes.getAllRunningTests().containsKey(testId)) continue;
                return eyes.getAllRunningTests().get(testId);
            }
        }
        throw new IllegalStateException(String.format("Didn't find test id %s", testId));
    }

    private void queueRenderRequests(FrameData result, Map<String, RGridResource> resourceMapping, List<CheckTask> checkTasks) {
        RGridDom dom = new RGridDom(result.getCdt(), resourceMapping, result.getUrl());
        ICheckSettingsInternal checkSettingsInternal = (ICheckSettingsInternal)((Object)checkTasks.get(0).getCheckSettings());
        ArrayList<VisualGridSelector> regionSelectorsList = new ArrayList<VisualGridSelector>();
        for (VisualGridSelector[] regionSelector : checkTasks.get(0).getRegionSelectors()) {
            regionSelectorsList.addAll(Arrays.asList(regionSelector));
        }
        for (CheckTask checkTask : checkTasks) {
            if (!checkTask.isTestActive()) continue;
            RenderBrowserInfo browserInfo = checkTask.getBrowserInfo();
            String sizeMode = checkSettingsInternal.getSizeMode();
            if (sizeMode.equalsIgnoreCase(VIEWPORT) && checkSettingsInternal.isStitchContent().booleanValue()) {
                sizeMode = FULLPAGE;
            }
            RenderInfo renderInfo = new RenderInfo(browserInfo.getWidth(), browserInfo.getHeight(), sizeMode, checkSettingsInternal.getTargetRegion(), checkSettingsInternal.getVGTargetSelector(), browserInfo.getEmulationInfo(), browserInfo.getIosDeviceInfo());
            RenderRequest request = new RenderRequest(checkTask.getTestId(), this.renderingInfo.getResultsUrl(), result.getUrl(), dom, resourceMapping, renderInfo, browserInfo.getPlatform(), browserInfo.getBrowserType(), checkSettingsInternal.getScriptHooks(), regionSelectorsList, checkSettingsInternal.isSendDom().booleanValue(), checkTask.getRenderer(), checkTask.getStepId(), this.renderingInfo.getStitchingServiceUrl(), checkSettingsInternal.getVisualGridOptions(), "eyes.selenium.visualgrid.java/" + ClassVersionGetter.CURRENT_VERSION);
            this.waitingCheckTasks.put(checkTask.getStepId(), checkTask);
            if (checkTask.isReadyForRender()) {
                this.renderService.addInput(checkTask.getStepId(), (Object)request);
                continue;
            }
            this.waitingRenderRequests.add(request);
        }
    }
}

