/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.universal;

import com.applitools.eyes.Logger;
import com.applitools.eyes.Region;
import com.applitools.eyes.SyncTaskListener;
import com.applitools.eyes.locators.TextRegion;
import com.applitools.eyes.universal.Refer;
import com.applitools.eyes.universal.Reference;
import com.applitools.eyes.universal.dto.DebugHistoryDto;
import com.applitools.eyes.universal.dto.MatchResultDto;
import com.applitools.eyes.universal.dto.RectangleSizeDto;
import com.applitools.eyes.universal.dto.ResponseDto;
import com.applitools.eyes.universal.dto.TestResultsSummaryDto;
import com.applitools.eyes.universal.dto.response.CommandCloseResponseDto;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.asynchttpclient.ws.WebSocket;
import org.asynchttpclient.ws.WebSocketListener;

public abstract class AbstractSDKListener
implements WebSocketListener {
    protected Logger logger = new Logger();
    protected ObjectMapper objectMapper;
    protected Map<String, SyncTaskListener<ResponseDto<?>>> map = new HashMap();
    protected WebSocket webSocket;
    protected static final Map<String, TypeReference<?>> typeReferences = new HashMap<String, TypeReference<?>>(){
        {
            this.put("Core.makeManager", new TypeReference<ResponseDto<Reference>>(){});
            this.put("EyesManager.openEyes", new TypeReference<ResponseDto<Reference>>(){});
            this.put("Eyes.check", new TypeReference<ResponseDto<List<MatchResultDto>>>(){});
            this.put("Core.locate", new TypeReference<ResponseDto<Map<String, List<Region>>>>(){});
            this.put("Eyes.close", new TypeReference<ResponseDto<List<CommandCloseResponseDto>>>(){});
            this.put("Eyes.abort", new TypeReference<ResponseDto<List<CommandCloseResponseDto>>>(){});
            this.put("EyesManager.closeAllEyes", new TypeReference<ResponseDto<List<CommandCloseResponseDto>>>(){});
            this.put("Eyes.locateText", new TypeReference<ResponseDto<Map<String, List<TextRegion>>>>(){});
            this.put("Eyes.extractText", new TypeReference<ResponseDto<List<String>>>(){});
            this.put("Core.getViewportSize", new TypeReference<ResponseDto<RectangleSizeDto>>(){});
            this.put("EyesManager.closeManager", new TypeReference<ResponseDto<TestResultsSummaryDto>>(){});
            this.put("Debug.getHistory", new TypeReference<ResponseDto<DebugHistoryDto>>(){});
            this.put("Core.deleteTest", new TypeReference<ResponseDto>(){});
            this.put("Core.closeBatch", new TypeReference<ResponseDto>(){});
        }
    };

    public AbstractSDKListener() {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    protected void handleResponse(String payload, TypeReference<?> typeReference) {
        try {
            ResponseDto responseDto = (ResponseDto)this.objectMapper.readValue(payload, typeReference);
            SyncTaskListener<ResponseDto<?>> syncTaskListener = this.map.get(responseDto.getKey());
            syncTaskListener.onComplete((Object)responseDto);
            this.map.remove(responseDto.getKey());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setWebSocket(WebSocket webSocket) {
        this.webSocket = webSocket;
    }

    public abstract Refer getRefer();
}

