/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.universal;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.Region;
import com.applitools.eyes.SyncTaskListener;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.exceptions.DiffsFoundException;
import com.applitools.eyes.exceptions.NewTestException;
import com.applitools.eyes.exceptions.StaleElementReferenceException;
import com.applitools.eyes.exceptions.TestFailedException;
import com.applitools.eyes.locators.TextRegion;
import com.applitools.eyes.universal.AbstractSDKListener;
import com.applitools.eyes.universal.Reference;
import com.applitools.eyes.universal.USDKConnection;
import com.applitools.eyes.universal.dto.CheckEyes;
import com.applitools.eyes.universal.dto.CheckSettingsDto;
import com.applitools.eyes.universal.dto.CloseBatchSettingsDto;
import com.applitools.eyes.universal.dto.CloseSettingsDto;
import com.applitools.eyes.universal.dto.Command;
import com.applitools.eyes.universal.dto.ConfigurationDto;
import com.applitools.eyes.universal.dto.DebugHistoryDto;
import com.applitools.eyes.universal.dto.DeleteTestSettingsDto;
import com.applitools.eyes.universal.dto.ErrorDto;
import com.applitools.eyes.universal.dto.EventDto;
import com.applitools.eyes.universal.dto.ExtractTextDto;
import com.applitools.eyes.universal.dto.ITargetDto;
import com.applitools.eyes.universal.dto.LocateDto;
import com.applitools.eyes.universal.dto.LocateTextDto;
import com.applitools.eyes.universal.dto.MakeCore;
import com.applitools.eyes.universal.dto.MakeManager;
import com.applitools.eyes.universal.dto.OCRExtractSettingsDto;
import com.applitools.eyes.universal.dto.OCRSearchSettingsDto;
import com.applitools.eyes.universal.dto.OpenEyes;
import com.applitools.eyes.universal.dto.OpenSettingsDto;
import com.applitools.eyes.universal.dto.RectangleSizeDto;
import com.applitools.eyes.universal.dto.RequestDto;
import com.applitools.eyes.universal.dto.ResponseDto;
import com.applitools.eyes.universal.dto.TestResultsSummaryDto;
import com.applitools.eyes.universal.dto.VisualLocatorSettingsDto;
import com.applitools.eyes.universal.dto.request.CommandAbortRequestDto;
import com.applitools.eyes.universal.dto.request.CommandCheckAndCloseRequestDto;
import com.applitools.eyes.universal.dto.request.CommandCloseAllEyesRequestDto;
import com.applitools.eyes.universal.dto.request.CommandCloseBatchRequestDto;
import com.applitools.eyes.universal.dto.request.CommandCloseManagerRequestDto;
import com.applitools.eyes.universal.dto.request.CommandCloseRequestDto;
import com.applitools.eyes.universal.dto.request.CommandDeleteTestRequestDto;
import com.applitools.eyes.universal.dto.request.CommandGetViewportSizeRequestDto;
import com.applitools.eyes.universal.dto.response.CommandCloseResponseDto;
import com.applitools.utils.GeneralUtils;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class CommandExecutor {
    private static USDKConnection connection;
    private static volatile CommandExecutor instance;
    private static StaleElementReferenceException staleElementReferenceException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CommandExecutor getInstance(String name, String version, String protocol, String[] commands, AbstractSDKListener listener, StaleElementReferenceException e) {
        if (instance != null) return instance;
        Class<CommandExecutor> clazz = CommandExecutor.class;
        synchronized (CommandExecutor.class) {
            if (instance != null) return instance;
            staleElementReferenceException = e;
            instance = new CommandExecutor(name, version, protocol, commands, listener);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return instance;
        }
    }

    private CommandExecutor(String name, String version, String protocol, String[] commands, AbstractSDKListener listener) {
        connection = new USDKConnection(listener);
        connection.init();
        this.makeCore(name, version, GeneralUtils.getPropertyString((String)"user.dir"), protocol, commands);
    }

    public void makeCore(String name, String version, String cwd, String protocol, String[] commands) {
        EventDto<MakeCore> request = new EventDto<MakeCore>();
        MakeCore makeCore = new MakeCore(name, version, cwd, protocol, commands);
        request.setName("Core.makeCore");
        request.setPayload(makeCore);
        CommandExecutor.checkedCommand(request);
    }

    public Reference coreMakeManager(String type, Integer concurrency, Integer legacyConcurrency, String agentId) {
        RequestDto<MakeManager> request = new RequestDto<MakeManager>();
        request.setName("Core.makeManager");
        request.setKey(UUID.randomUUID().toString());
        request.setPayload(new MakeManager(type, concurrency, legacyConcurrency, null));
        SyncTaskListener syncTaskListener = CommandExecutor.checkedCommand(request);
        ResponseDto makeManagerResponse = (ResponseDto)syncTaskListener.get();
        if (makeManagerResponse != null && makeManagerResponse.getPayload().getError() != null) {
            String message = makeManagerResponse.getPayload().getError().getMessage();
            if (message != null && message.contains("stale element reference")) {
                staleElementReferenceException.throwException(message);
            }
            throw new EyesException(message);
        }
        return (Reference)makeManagerResponse.getPayload().getResult();
    }

    public Reference managerOpenEyes(Reference ref, ITargetDto target, OpenSettingsDto settings, ConfigurationDto config) {
        RequestDto<OpenEyes> request = new RequestDto<OpenEyes>();
        request.setName("EyesManager.openEyes");
        request.setKey(UUID.randomUUID().toString());
        request.setPayload(new OpenEyes(ref, target, settings, config));
        SyncTaskListener syncTaskListener = CommandExecutor.checkedCommand(request);
        ResponseDto referenceResponseDto = (ResponseDto)syncTaskListener.get();
        if (referenceResponseDto != null && referenceResponseDto.getPayload().getError() != null) {
            ErrorDto error;
            String message = referenceResponseDto.getPayload().getError().getMessage();
            if (message != null && message.contains("stale element reference")) {
                staleElementReferenceException.throwException(message);
            }
            if ((error = referenceResponseDto.getPayload().getError()).getReason() != null && error.getReason().equals("spec-driver")) {
                throw new EyesException("Message: " + error.getMessage() + ", Stack: " + error.getStack());
            }
            throw new EyesException(message);
        }
        return (Reference)referenceResponseDto.getPayload().getResult();
    }

    public void eyesCheck(Reference eyesRef, ITargetDto target, CheckSettingsDto settings, ConfigurationDto config) {
        RequestDto<CheckEyes> request = new RequestDto<CheckEyes>();
        request.setName("Eyes.check");
        request.setKey(UUID.randomUUID().toString());
        request.setPayload(new CheckEyes(eyesRef, target, settings, config, settings.getType()));
        SyncTaskListener syncTaskListener = CommandExecutor.checkedCommand(request);
        ResponseDto checkResponse = (ResponseDto)syncTaskListener.get();
        if (checkResponse != null && checkResponse.getPayload().getError() != null) {
            ErrorDto error;
            String message = checkResponse.getPayload().getError().getMessage();
            if (message != null && message.contains("stale element reference")) {
                staleElementReferenceException.throwException(message);
            }
            if ((error = checkResponse.getPayload().getError()).getReason() != null && error.getReason().equals("spec-driver")) {
                throw new EyesException("Message: " + error.getMessage() + ", Stack: " + error.getStack());
            }
            throw new EyesException(message);
        }
    }

    public Map<String, List<Region>> locate(ITargetDto target, VisualLocatorSettingsDto locatorSettingsDto, ConfigurationDto config) {
        RequestDto<LocateDto> request = new RequestDto<LocateDto>();
        request.setName("Core.locate");
        request.setKey(UUID.randomUUID().toString());
        request.setPayload(new LocateDto(target, locatorSettingsDto, config));
        SyncTaskListener syncTaskListener = CommandExecutor.checkedCommand(request);
        ResponseDto locateResponse = (ResponseDto)syncTaskListener.get();
        if (locateResponse != null && locateResponse.getPayload().getError() != null) {
            ErrorDto error;
            String message = locateResponse.getPayload().getError().getMessage();
            if (message != null && message.contains("stale element reference")) {
                staleElementReferenceException.throwException(message);
            }
            if ((error = locateResponse.getPayload().getError()).getReason() != null && error.getReason().equals("spec-driver")) {
                throw new EyesException("Message: " + error.getMessage() + ", Stack: " + error.getStack());
            }
            throw new EyesException(message);
        }
        return (Map)locateResponse.getPayload().getResult();
    }

    public Map<String, List<TextRegion>> locateText(Reference eyesRef, ITargetDto target, OCRSearchSettingsDto searchSettingsDto, ConfigurationDto config) {
        RequestDto<LocateTextDto> request = new RequestDto<LocateTextDto>();
        request.setName("Eyes.locateText");
        request.setKey(UUID.randomUUID().toString());
        request.setPayload(new LocateTextDto(eyesRef, target, searchSettingsDto, config));
        SyncTaskListener syncTaskListener = CommandExecutor.checkedCommand(request);
        ResponseDto locateTextResponse = (ResponseDto)syncTaskListener.get();
        if (locateTextResponse != null && locateTextResponse.getPayload().getError() != null) {
            ErrorDto error;
            String message = locateTextResponse.getPayload().getError().getMessage();
            if (message != null && message.contains("stale element reference")) {
                staleElementReferenceException.throwException(message);
            }
            if ((error = locateTextResponse.getPayload().getError()).getReason() != null && error.getReason().equals("spec-driver")) {
                throw new EyesException("Message: " + error.getMessage() + ", Stack: " + error.getStack());
            }
            throw new EyesException(message);
        }
        return (Map)locateTextResponse.getPayload().getResult();
    }

    public List<String> extractText(Reference eyesRef, ITargetDto target, List<OCRExtractSettingsDto> extractSettingsDtoList, ConfigurationDto config) {
        RequestDto<ExtractTextDto> request = new RequestDto<ExtractTextDto>();
        request.setName("Eyes.extractText");
        request.setKey(UUID.randomUUID().toString());
        request.setPayload(new ExtractTextDto(eyesRef, target, extractSettingsDtoList, config));
        SyncTaskListener syncTaskListener = CommandExecutor.checkedCommand(request);
        ResponseDto extractTextResponse = (ResponseDto)syncTaskListener.get();
        if (extractTextResponse != null && extractTextResponse.getPayload().getError() != null) {
            ErrorDto error;
            String message = extractTextResponse.getPayload().getError().getMessage();
            if (message != null && message.contains("stale element reference")) {
                staleElementReferenceException.throwException(message);
            }
            if ((error = extractTextResponse.getPayload().getError()).getReason() != null && error.getReason().equals("spec-driver")) {
                throw new EyesException("Message: " + error.getMessage() + ", Stack: " + error.getStack());
            }
            throw new EyesException(message);
        }
        return (List)extractTextResponse.getPayload().getResult();
    }

    public List<CommandCloseResponseDto> eyesCheckAndClose(Reference eyesRef, ITargetDto target, CheckSettingsDto checkSettings, CloseSettingsDto closeSettings, ConfigurationDto config) {
        RequestDto<CommandCheckAndCloseRequestDto> request = new RequestDto<CommandCheckAndCloseRequestDto>();
        request.setName("Eyes.checkAndClose");
        request.setKey(UUID.randomUUID().toString());
        request.setPayload(new CommandCheckAndCloseRequestDto(eyesRef, target, checkSettings, closeSettings, config));
        SyncTaskListener syncTaskListener = CommandExecutor.checkedCommand(request);
        ResponseDto closeResponse = (ResponseDto)syncTaskListener.get();
        if (closeResponse != null && closeResponse.getPayload().getError() != null) {
            String message = closeResponse.getPayload().getError().getMessage();
            if (message != null && message.contains("stale element reference")) {
                staleElementReferenceException.throwException(message);
            }
            ErrorDto error = closeResponse.getPayload().getError();
            throw new EyesException("Message: " + error.getMessage() + ", Stack: " + error.getStack());
        }
        return (List)closeResponse.getPayload().getResult();
    }

    public List<CommandCloseResponseDto> close(Reference eyesRef, CloseSettingsDto closeSettings, ConfigurationDto config, boolean waitResult) {
        RequestDto<CommandCloseRequestDto> request = new RequestDto<CommandCloseRequestDto>();
        request.setName("Eyes.close");
        request.setKey(UUID.randomUUID().toString());
        request.setPayload(new CommandCloseRequestDto(eyesRef, closeSettings, config));
        SyncTaskListener syncTaskListener = CommandExecutor.checkedCommand(request);
        if (!waitResult) {
            return null;
        }
        ResponseDto closeResponse = (ResponseDto)syncTaskListener.get();
        if (closeResponse != null && closeResponse.getPayload() != null && closeResponse.getPayload().getError() != null) {
            ErrorDto error;
            String message = closeResponse.getPayload().getError().getMessage();
            if (message != null && message.contains("stale element reference")) {
                staleElementReferenceException.throwException(message);
            }
            if ((error = closeResponse.getPayload().getError()).getReason() != null && error.getReason().equals("spec-driver")) {
                throw new EyesException("Message: " + error.getMessage() + ", Stack: " + error.getStack());
            }
            throw new EyesException(message);
        }
        return (List)closeResponse.getPayload().getResult();
    }

    public List<CommandCloseResponseDto> abort(Reference eyesRef, boolean waitResult) {
        RequestDto<CommandAbortRequestDto> request = new RequestDto<CommandAbortRequestDto>();
        request.setName("Eyes.abort");
        request.setKey(UUID.randomUUID().toString());
        request.setPayload(new CommandAbortRequestDto(eyesRef));
        SyncTaskListener syncTaskListener = CommandExecutor.checkedCommand(request);
        if (!waitResult) {
            return null;
        }
        ResponseDto abortResponse = (ResponseDto)syncTaskListener.get();
        if (abortResponse != null && abortResponse.getPayload().getError() != null) {
            String message = abortResponse.getPayload().getError().getMessage();
            if (message != null && message.contains("stale element reference")) {
                staleElementReferenceException.throwException(message);
            }
            throw new EyesException(message);
        }
        return (List)abortResponse.getPayload().getResult();
    }

    public List<CommandCloseResponseDto> closeAllEyes(Reference managerRef) {
        RequestDto<CommandCloseAllEyesRequestDto> request = new RequestDto<CommandCloseAllEyesRequestDto>();
        request.setName("EyesManager.closeAllEyes");
        request.setKey(UUID.randomUUID().toString());
        request.setPayload(new CommandCloseAllEyesRequestDto(managerRef));
        SyncTaskListener syncTaskListener = CommandExecutor.checkedCommand(request);
        ResponseDto closeResponse = (ResponseDto)syncTaskListener.get();
        if (closeResponse != null && closeResponse.getPayload().getError() != null) {
            String message = closeResponse.getPayload().getError().getMessage();
            if (message != null && message.contains("stale element reference")) {
                staleElementReferenceException.throwException(message);
            }
            throw new EyesException(message);
        }
        return (List)closeResponse.getPayload().getResult();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TestResultsSummaryDto closeManager(Reference managerRef, Boolean throwError) {
        RequestDto<CommandCloseManagerRequestDto> request = new RequestDto<CommandCloseManagerRequestDto>();
        request.setName("EyesManager.closeManager");
        request.setKey(UUID.randomUUID().toString());
        request.setPayload(new CommandCloseManagerRequestDto(managerRef, throwError));
        SyncTaskListener syncTaskListener = CommandExecutor.checkedCommand(request);
        ResponseDto closeResponse = (ResponseDto)syncTaskListener.get();
        if (closeResponse == null || closeResponse.getPayload() == null) return null;
        if (closeResponse.getPayload().getError() == null) return (TestResultsSummaryDto)closeResponse.getPayload().getResult();
        ErrorDto error = closeResponse.getPayload().getError();
        String message = error.getMessage();
        if (message != null && message.contains("stale element reference")) {
            staleElementReferenceException.throwException(message);
            return null;
        } else {
            if (error.getReason() == null) throw new EyesException(message);
            CommandExecutor.throwExceptionBasedOnReason(error.getReason(), error.getInfo() == null ? null : error.getInfo().getResult());
        }
        return null;
    }

    public static RectangleSizeDto getViewportSize(ITargetDto driver) {
        RequestDto<CommandGetViewportSizeRequestDto> request = new RequestDto<CommandGetViewportSizeRequestDto>();
        request.setName("Core.getViewportSize");
        request.setKey(UUID.randomUUID().toString());
        request.setPayload(new CommandGetViewportSizeRequestDto(driver));
        SyncTaskListener syncTaskListener = CommandExecutor.checkedCommand(request);
        ResponseDto getViewportSizeResponse = (ResponseDto)syncTaskListener.get();
        return (RectangleSizeDto)getViewportSizeResponse.getPayload().getResult();
    }

    public static DebugHistoryDto getDebugHistory() {
        RequestDto request = new RequestDto();
        request.setName("Debug.getHistory");
        request.setKey(UUID.randomUUID().toString());
        SyncTaskListener syncTaskListener = CommandExecutor.checkedCommand(request);
        ResponseDto getDebugHistory = (ResponseDto)syncTaskListener.get();
        return (DebugHistoryDto)getDebugHistory.getPayload().getResult();
    }

    public static void deleteTest(DeleteTestSettingsDto settings) {
        RequestDto<CommandDeleteTestRequestDto> request = new RequestDto<CommandDeleteTestRequestDto>();
        request.setName("Core.deleteTest");
        request.setKey(UUID.randomUUID().toString());
        request.setPayload(new CommandDeleteTestRequestDto(settings));
        SyncTaskListener syncTaskListener = CommandExecutor.checkedCommand(request);
        ResponseDto deleteTestResponse = (ResponseDto)syncTaskListener.get();
        if (deleteTestResponse != null && deleteTestResponse.getPayload().getError() != null) {
            String message = deleteTestResponse.getPayload().getError().getMessage();
            throw new EyesException(message);
        }
    }

    public static void closeBatch(List<CloseBatchSettingsDto> settings) {
        RequestDto<CommandCloseBatchRequestDto> request = new RequestDto<CommandCloseBatchRequestDto>();
        request.setName("Core.closeBatch");
        request.setKey(UUID.randomUUID().toString());
        request.setPayload(new CommandCloseBatchRequestDto(settings));
        SyncTaskListener syncTaskListener = CommandExecutor.checkedCommand(request);
        ResponseDto closeBatchResponse = (ResponseDto)syncTaskListener.get();
        if (closeBatchResponse != null && closeBatchResponse.getPayload().getError() != null) {
            String message = closeBatchResponse.getPayload().getError().getMessage();
            throw new EyesException(message);
        }
    }

    public static SyncTaskListener checkedCommand(Command command) {
        try {
            return connection.executeCommand(command);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void throwExceptionBasedOnReason(String reason, TestResults testResults) {
        String appIdOrName;
        String scenarioIdOrName;
        if (reason == null || reason.isEmpty() || reason.equals("internal")) {
            return;
        }
        if (testResults == null) {
            scenarioIdOrName = "(no test results)";
            appIdOrName = "";
        } else {
            scenarioIdOrName = testResults.getName();
            appIdOrName = testResults.getAppName();
        }
        switch (reason) {
            case "test different": {
                throw new DiffsFoundException(testResults, scenarioIdOrName, appIdOrName);
            }
            case "test failed": {
                throw new TestFailedException(testResults, scenarioIdOrName, appIdOrName);
            }
            case "test new": {
                throw new NewTestException(testResults, scenarioIdOrName, appIdOrName);
            }
        }
        throw new UnsupportedOperationException("Unsupported exception type: " + reason);
    }
}

