/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.universal;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.universal.AbstractSDKListener;
import com.applitools.eyes.universal.Refer;
import com.applitools.eyes.universal.dto.LogResponseDto;
import com.applitools.eyes.universal.dto.ResponseDto;
import com.fasterxml.jackson.core.type.TypeReference;
import java.sql.Timestamp;
import org.asynchttpclient.ws.WebSocket;
import org.asynchttpclient.ws.WebSocketListener;

public class USDKListener
extends AbstractSDKListener
implements WebSocketListener {
    private static volatile USDKListener instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static USDKListener getInstance() {
        if (instance != null) return instance;
        Class<AbstractSDKListener> clazz = AbstractSDKListener.class;
        synchronized (AbstractSDKListener.class) {
            if (instance != null) return instance;
            instance = new USDKListener();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private USDKListener() {
    }

    public void onOpen(WebSocket webSocket) {
    }

    public void onClose(WebSocket webSocket, int i, String s) {
    }

    public void onError(Throwable throwable) {
    }

    public void onTextFrame(String payload, boolean finalFragment, int rsv) {
        try {
            ResponseDto response = (ResponseDto)this.objectMapper.readValue(payload, ResponseDto.class);
            switch (response.getName()) {
                case "Core.makeManager": 
                case "EyesManager.openEyes": 
                case "Eyes.check": 
                case "Core.locate": 
                case "Eyes.close": 
                case "Eyes.abort": 
                case "EyesManager.closeAllEyes": 
                case "Eyes.locateText": 
                case "Eyes.extractText": 
                case "Core.getViewportSize": 
                case "EyesManager.closeManager": 
                case "Debug.getHistory": 
                case "Core.deleteTest": 
                case "Core.closeBatch": {
                    this.handleResponse(payload, (TypeReference)typeReferences.get(response.getName()));
                    break;
                }
                case "Server.log": {
                    try {
                        LogResponseDto serverLogResponse = (LogResponseDto)this.objectMapper.readValue(payload, (TypeReference)new TypeReference<LogResponseDto>(){});
                        String message = "eyes | " + new Timestamp(System.currentTimeMillis()) + " | [" + serverLogResponse.getPayload().getLevel() + "] | " + serverLogResponse.getPayload().getMessage();
                        this.logger.log(TraceLevel.Debug, Stage.GENERAL, message);
                        System.out.println(message);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                default: {
                    throw new EyesException("Unknown server command " + response.getName());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Refer getRefer() {
        return null;
    }
}

