/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.universal.mapper;

import com.applitools.eyes.universal.dto.AndroidDeviceInfoDto;
import com.applitools.eyes.universal.dto.AndroidDeviceRendererDto;
import com.applitools.eyes.universal.dto.ChromeEmulationDeviceRendererDto;
import com.applitools.eyes.universal.dto.ChromeEmulationInfoDto;
import com.applitools.eyes.universal.dto.DesktopBrowserRendererDto;
import com.applitools.eyes.universal.dto.IBrowsersInfo;
import com.applitools.eyes.universal.dto.IOSDeviceRendererDto;
import com.applitools.eyes.universal.dto.IosDeviceInfoDto;
import com.applitools.eyes.visualgrid.model.AndroidDeviceInfo;
import com.applitools.eyes.visualgrid.model.AndroidDeviceName;
import com.applitools.eyes.visualgrid.model.ChromeEmulationInfo;
import com.applitools.eyes.visualgrid.model.DeviceAndroidVersion;
import com.applitools.eyes.visualgrid.model.DeviceName;
import com.applitools.eyes.visualgrid.model.IosDeviceInfo;
import com.applitools.eyes.visualgrid.model.IosDeviceName;
import com.applitools.eyes.visualgrid.model.IosVersion;
import com.applitools.eyes.visualgrid.model.RenderBrowserInfo;
import com.applitools.eyes.visualgrid.model.ScreenOrientation;
import java.util.List;
import java.util.stream.Collectors;

public class RenderBrowserInfoMapper {
    public static IBrowsersInfo toRenderBrowserInfoDto(RenderBrowserInfo renderBrowserInfo) {
        if (renderBrowserInfo == null) {
            return null;
        }
        if (renderBrowserInfo.getEmulationInfo() instanceof ChromeEmulationInfo) {
            ChromeEmulationInfo chromeEmulationInfo = (ChromeEmulationInfo)renderBrowserInfo.getEmulationInfo();
            ChromeEmulationDeviceRendererDto chromeRenderer = new ChromeEmulationDeviceRendererDto();
            ChromeEmulationInfoDto chromeEmulation = new ChromeEmulationInfoDto();
            chromeEmulation.setDeviceName(chromeEmulationInfo.getDeviceName());
            chromeEmulation.setScreenOrientation(chromeEmulationInfo.getScreenOrientation().getOrientation());
            chromeRenderer.setChromeEmulationInfo(chromeEmulation);
            return chromeRenderer;
        }
        if (renderBrowserInfo.getIosDeviceInfo() != null) {
            IosDeviceInfo iosDeviceInfo = renderBrowserInfo.getIosDeviceInfo();
            IOSDeviceRendererDto iosRenderer = new IOSDeviceRendererDto();
            IosDeviceInfoDto iosDevice = new IosDeviceInfoDto();
            iosDevice.setDeviceName(iosDeviceInfo.getDeviceName());
            iosDevice.setScreenOrientation(iosDeviceInfo.getScreenOrientation() == null ? null : iosDeviceInfo.getScreenOrientation().getOrientation());
            iosDevice.setVersion(iosDeviceInfo.getVersion() == null ? null : iosDeviceInfo.getVersion().getVersion());
            iosRenderer.setIosDeviceInfo(iosDevice);
            return iosRenderer;
        }
        if (renderBrowserInfo.getAndroidDeviceInfo() != null) {
            AndroidDeviceInfo androidDeviceInfo = renderBrowserInfo.getAndroidDeviceInfo();
            AndroidDeviceRendererDto androidDeviceRenderer = new AndroidDeviceRendererDto();
            AndroidDeviceInfoDto androidDevice = new AndroidDeviceInfoDto();
            androidDevice.setDeviceName(androidDeviceInfo.getDeviceName());
            androidDevice.setScreenOrientation(androidDeviceInfo.getScreenOrientation() == null ? null : androidDeviceInfo.getScreenOrientation().getOrientation());
            androidDevice.setVersion(androidDeviceInfo.getVersion() == null ? null : androidDeviceInfo.getVersion().getVersion());
            androidDeviceRenderer.setAndroidDeviceInfo(androidDevice);
            return androidDeviceRenderer;
        }
        DesktopBrowserRendererDto desktopBrowserRendererDto = new DesktopBrowserRendererDto();
        desktopBrowserRendererDto.setName(renderBrowserInfo.getBrowserType().getName());
        desktopBrowserRendererDto.setHeight(renderBrowserInfo.getDeviceSize().getHeight());
        desktopBrowserRendererDto.setWidth(renderBrowserInfo.getDeviceSize().getWidth());
        return desktopBrowserRendererDto;
    }

    public static List<IBrowsersInfo> toRenderBrowserInfoDtoList(List<RenderBrowserInfo> renderBrowserInfos) {
        if (renderBrowserInfos == null || renderBrowserInfos.isEmpty()) {
            return null;
        }
        return renderBrowserInfos.stream().map(RenderBrowserInfoMapper::toRenderBrowserInfoDto).collect(Collectors.toList());
    }

    public static ChromeEmulationInfo toEmulationInfo(ChromeEmulationInfoDto dto) {
        if (dto == null) {
            return null;
        }
        DeviceName deviceName = DeviceName.fromName((String)dto.getDeviceName());
        ScreenOrientation screenOrientation = ScreenOrientation.fromOrientation((String)dto.getScreenOrientation());
        return new ChromeEmulationInfo(deviceName, screenOrientation);
    }

    public static IosDeviceInfo toIosDeviceInfo(IosDeviceInfoDto dto) {
        if (dto == null) {
            return null;
        }
        IosDeviceName iosDeviceName = IosDeviceName.fromName((String)dto.getDeviceName());
        ScreenOrientation screenOrientation = ScreenOrientation.fromOrientation((String)dto.getScreenOrientation());
        IosVersion iosVersion = IosVersion.fromVersion((String)dto.getVersion());
        return new IosDeviceInfo(iosDeviceName, screenOrientation, iosVersion);
    }

    public static AndroidDeviceInfo toAndroidDeviceInfo(AndroidDeviceInfoDto dto) {
        if (dto == null) {
            return null;
        }
        AndroidDeviceName androidDeviceName = AndroidDeviceName.fromName((String)dto.getDeviceName());
        ScreenOrientation screenOrientation = ScreenOrientation.fromOrientation((String)dto.getScreenOrientation());
        DeviceAndroidVersion version = DeviceAndroidVersion.fromVersion((String)dto.getVersion());
        return new AndroidDeviceInfo(androidDeviceName, screenOrientation, version);
    }
}

