/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.connectivity.ServerConnector;
import com.applitools.eyes.AccessibilityRegionByRectangle;
import com.applitools.eyes.AppOutput;
import com.applitools.eyes.EyesBase;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.FloatingMatchSettings;
import com.applitools.eyes.GetAccessibilityRegion;
import com.applitools.eyes.IRegion;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.OutOfBoundsException;
import com.applitools.eyes.Region;
import com.applitools.eyes.RunningSession;
import com.applitools.eyes.Trigger;
import com.applitools.eyes.capture.AppOutputProvider;
import com.applitools.eyes.config.Configuration;
import com.applitools.eyes.fluent.FloatingRegionByRectangle;
import com.applitools.eyes.fluent.GetFloatingRegion;
import com.applitools.eyes.fluent.GetSimpleRegion;
import com.applitools.eyes.fluent.ICheckSettingsInternal;
import com.applitools.eyes.fluent.IGetAccessibilityRegionType;
import com.applitools.eyes.fluent.SimpleRegionByRectangle;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.visualgrid.model.IGetFloatingRegionOffsets;
import com.applitools.eyes.visualgrid.model.MutableRegion;
import com.applitools.eyes.visualgrid.model.VisualGridSelector;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class MatchWindowTask {
    private static final int MATCH_INTERVAL = 500;
    private EyesScreenshot lastScreenshot = null;
    private String lastScreenshotHash;
    private final int defaultRetryTimeout;
    protected Logger logger;
    protected ServerConnector serverConnector;
    protected RunningSession runningSession;
    protected AppOutputProvider appOutputProvider;
    protected MatchResult matchResult;
    protected EyesBase eyes;

    public MatchWindowTask(Logger logger, ServerConnector serverConnector, RunningSession runningSession, int retryTimeout, EyesBase eyes, AppOutputProvider appOutputProvider) {
        ArgumentGuard.notNull((Object)((Object)serverConnector), (String)"serverConnector");
        ArgumentGuard.notNull((Object)runningSession, (String)"runningSession");
        ArgumentGuard.greaterThanOrEqualToZero((long)retryTimeout, (String)"retryTimeout");
        ArgumentGuard.notNull((Object)appOutputProvider, (String)"appOutputProvider");
        this.logger = logger;
        this.serverConnector = serverConnector;
        this.runningSession = runningSession;
        this.defaultRetryTimeout = retryTimeout;
        this.eyes = eyes;
        this.appOutputProvider = appOutputProvider;
    }

    public static void collectRegions(ImageMatchSettings imageMatchSettings, ICheckSettingsInternal checkSettingsInternal) {
    }

    private static AccessibilityRegionByRectangle[] convertAccessibilityRegions(GetAccessibilityRegion[] accessibilityRegions, AccessibilityRegionByRectangle[] currentRegions) {
        ArrayList<AccessibilityRegionByRectangle> mutableRegions = new ArrayList<AccessibilityRegionByRectangle>();
        if (currentRegions != null) {
            mutableRegions.addAll(Arrays.asList(currentRegions));
        }
        for (GetAccessibilityRegion getRegions : accessibilityRegions) {
            if (!(getRegions instanceof AccessibilityRegionByRectangle)) continue;
            mutableRegions.addAll(getRegions.getRegions(null));
        }
        return mutableRegions.toArray(new AccessibilityRegionByRectangle[0]);
    }

    private static Region[] convertSimpleRegions(GetSimpleRegion[] simpleRegions, Region[] currentRegions) {
        ArrayList<Region> mutableRegions = new ArrayList<Region>();
        if (currentRegions != null) {
            Collections.addAll(mutableRegions, currentRegions);
        }
        for (GetSimpleRegion simpleRegion : simpleRegions) {
            if (!(simpleRegion instanceof SimpleRegionByRectangle)) continue;
            mutableRegions.addAll(simpleRegion.getRegions(null));
        }
        return mutableRegions.toArray(new Region[0]);
    }

    private static FloatingMatchSettings[] convertFloatingRegions(GetFloatingRegion[] floatingRegions, FloatingMatchSettings[] currentRegions) {
        ArrayList<FloatingMatchSettings> mutableRegions = new ArrayList<FloatingMatchSettings>();
        if (currentRegions != null) {
            Collections.addAll(mutableRegions, currentRegions);
        }
        for (GetFloatingRegion getRegions : floatingRegions) {
            if (!(getRegions instanceof FloatingRegionByRectangle)) continue;
            mutableRegions.addAll(getRegions.getRegions(null));
        }
        return mutableRegions.toArray(new FloatingMatchSettings[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static void collectRegions(ImageMatchSettings imageMatchSettings, Location location, List<? extends IRegion> regions, List<VisualGridSelector[]> regionSelectors) {
        void var9_11;
        if (regions == null) {
            return;
        }
        int currentCounter = 0;
        int currentTypeIndex = 0;
        int currentTypeRegionCount = regionSelectors.get(0).length;
        ArrayList mutableRegions = new ArrayList();
        mutableRegions.add(new ArrayList());
        mutableRegions.add(new ArrayList());
        mutableRegions.add(new ArrayList());
        mutableRegions.add(new ArrayList());
        mutableRegions.add(new ArrayList());
        mutableRegions.add(new ArrayList());
        for (IRegion iRegion : regions) {
            boolean canAddRegion = false;
            while (!canAddRegion) {
                if (++currentCounter > currentTypeRegionCount) {
                    currentTypeRegionCount = regionSelectors.get(++currentTypeIndex).length;
                    currentCounter = 0;
                    continue;
                }
                canAddRegion = true;
            }
            MutableRegion mr = new MutableRegion(iRegion);
            ((List)mutableRegions.get(currentTypeIndex)).add(mr);
        }
        imageMatchSettings.setIgnoreRegions((Region[])MatchWindowTask.filterEmptyEntries((List)mutableRegions.get(0), location));
        imageMatchSettings.setLayoutRegions((Region[])MatchWindowTask.filterEmptyEntries((List)mutableRegions.get(1), location));
        imageMatchSettings.setStrictRegions((Region[])MatchWindowTask.filterEmptyEntries((List)mutableRegions.get(2), location));
        imageMatchSettings.setContentRegions((Region[])MatchWindowTask.filterEmptyEntries((List)mutableRegions.get(3), location));
        ArrayList<FloatingMatchSettings> floatingMatchSettings = new ArrayList<FloatingMatchSettings>();
        boolean bl = false;
        while (var9_11 < regionSelectors.get(4).length) {
            VisualGridSelector vgs;
            MutableRegion mr = (MutableRegion)((List)mutableRegions.get(4)).get((int)var9_11);
            if (mr.getArea() != 0 && (vgs = regionSelectors.get(4)[var9_11]).getCategory() instanceof IGetFloatingRegionOffsets) {
                IGetFloatingRegionOffsets gfr = (IGetFloatingRegionOffsets)vgs.getCategory();
                FloatingMatchSettings fms = new FloatingMatchSettings(mr.getLeft(), mr.getTop(), mr.getWidth(), mr.getHeight(), gfr.getMaxUpOffset(), gfr.getMaxDownOffset(), gfr.getMaxLeftOffset(), gfr.getMaxRightOffset());
                floatingMatchSettings.add(fms);
            }
            ++var9_11;
        }
        imageMatchSettings.setFloatingRegions(floatingMatchSettings.toArray(new FloatingMatchSettings[0]));
        ArrayList<AccessibilityRegionByRectangle> arrayList = new ArrayList<AccessibilityRegionByRectangle>();
        VisualGridSelector[] visualGridSelectors = regionSelectors.get(5);
        for (int i = 0; i < visualGridSelectors.length; ++i) {
            VisualGridSelector vgs;
            MutableRegion mr = (MutableRegion)((List)mutableRegions.get(5)).get(i);
            if (mr.getArea() == 0 || !((vgs = visualGridSelectors[i]).getCategory() instanceof IGetAccessibilityRegionType)) continue;
            IGetAccessibilityRegionType gar = (IGetAccessibilityRegionType)vgs.getCategory();
            AccessibilityRegionByRectangle accessibilityRegion = new AccessibilityRegionByRectangle(mr.getLeft() - location.getX(), mr.getTop() - location.getY(), mr.getWidth(), mr.getHeight(), gar.getAccessibilityRegionType());
            arrayList.add(accessibilityRegion);
        }
        imageMatchSettings.setAccessibility(arrayList.toArray(new AccessibilityRegionByRectangle[0]));
    }

    private static MutableRegion[] filterEmptyEntries(List<MutableRegion> list, Location location) {
        for (int i = list.size() - 1; i >= 0; --i) {
            MutableRegion mutableRegion = list.get(i);
            if (mutableRegion.getArea() == 0) {
                list.remove(i);
                continue;
            }
            mutableRegion.offset(-location.getX(), -location.getY());
            if (mutableRegion.getLeft() < 0) {
                mutableRegion.setLeft(0);
            }
            if (mutableRegion.getTop() >= 0) continue;
            mutableRegion.setTop(0);
        }
        return list.toArray(new MutableRegion[0]);
    }

    private static void collectFloatingRegions(ICheckSettingsInternal checkSettingsInternal, ImageMatchSettings imageMatchSettings, EyesScreenshot screenshot) {
        ArrayList floatingRegions = new ArrayList();
        imageMatchSettings.setFloatingRegions(floatingRegions.toArray(new FloatingMatchSettings[0]));
    }

    public MatchResult matchWindow(Trigger[] userInputs, Region region, String tag, boolean shouldRunOnceOnTimeout, ICheckSettingsInternal checkSettingsInternal, String source) {
        int retryTimeout = checkSettingsInternal.getTimeout();
        if (retryTimeout < 0) {
            retryTimeout = this.defaultRetryTimeout;
        }
        EyesScreenshot screenshot = this.takeScreenshot(userInputs, region, tag, shouldRunOnceOnTimeout, checkSettingsInternal, retryTimeout, source);
        this.updateLastScreenshot(screenshot);
        return this.matchResult;
    }

    private static void collectSimpleRegions(EyesBase eyes, ICheckSettingsInternal checkSettingsInternal, ImageMatchSettings imageMatchSettings, EyesScreenshot screenshot) {
    }

    private static Region[] collectSimpleRegions(EyesBase eyes, GetSimpleRegion[] regionProviders, EyesScreenshot screenshot) {
        ArrayList<Region> regions = new ArrayList<Region>();
        for (GetSimpleRegion regionProvider : regionProviders) {
            try {
                regions.addAll(regionProvider.getRegions(screenshot));
            }
            catch (OutOfBoundsException ex) {
                GeneralUtils.logExceptionStackTrace((Logger)eyes.getLogger(), (Stage)Stage.CHECK, (Throwable)((Object)ex), (String[])new String[]{eyes.getTestId()});
            }
        }
        return regions.toArray(new Region[0]);
    }

    public static ImageMatchSettings createImageMatchSettings(ICheckSettingsInternal checkSettingsInternal, EyesScreenshot screenshot, EyesBase eyesBase) {
        eyesBase.getLogger().log(TraceLevel.Info, eyesBase.getTestId(), Stage.CHECK, new Pair[]{Pair.of((Object)"configuration", (Object)eyesBase.getConfiguration()), Pair.of((Object)"checkSettings", (Object)checkSettingsInternal)});
        ImageMatchSettings imageMatchSettings = MatchWindowTask.createImageMatchSettings(checkSettingsInternal, eyesBase);
        if (imageMatchSettings != null) {
            PositionProvider positionProvider = checkSettingsInternal.getStepPositionProvider();
            PositionMemento originalState = null;
            if (positionProvider != null) {
                originalState = positionProvider.getState();
                positionProvider.setPosition(new Location(0, 0));
            }
            MatchWindowTask.collectSimpleRegions(eyesBase, checkSettingsInternal, imageMatchSettings, screenshot);
            MatchWindowTask.collectFloatingRegions(checkSettingsInternal, imageMatchSettings, screenshot);
            MatchWindowTask.collectAccessibilityRegions(checkSettingsInternal, imageMatchSettings, screenshot);
            if (positionProvider != null && originalState != null) {
                positionProvider.restoreState(originalState);
            }
        }
        return imageMatchSettings;
    }

    public static ImageMatchSettings createImageMatchSettings(ICheckSettingsInternal checkSettingsInternal, EyesBase eyes) {
        ImageMatchSettings imageMatchSettings = null;
        if (checkSettingsInternal != null) {
            Configuration config = eyes.getConfigurationInstance();
            ImageMatchSettings defaultMatchSettings = config.getDefaultMatchSettings();
            imageMatchSettings = new ImageMatchSettings(defaultMatchSettings);
            imageMatchSettings.setMatchLevel(checkSettingsInternal.getMatchLevel() != null ? checkSettingsInternal.getMatchLevel() : defaultMatchSettings.getMatchLevel());
            imageMatchSettings.setIgnoreCaret(checkSettingsInternal.getIgnoreCaret() != null ? checkSettingsInternal.getIgnoreCaret() : config.getIgnoreCaret());
            imageMatchSettings.setUseDom(checkSettingsInternal.isUseDom() != null ? checkSettingsInternal.isUseDom() : config.getUseDom());
            imageMatchSettings.setEnablePatterns(checkSettingsInternal.isEnablePatterns() != null ? checkSettingsInternal.isEnablePatterns() : config.getEnablePatterns());
            imageMatchSettings.setIgnoreDisplacements(checkSettingsInternal.isIgnoreDisplacements() != null ? checkSettingsInternal.isIgnoreDisplacements() : config.getIgnoreDisplacements());
            imageMatchSettings.setAccessibilitySettings(config.getAccessibilityValidation());
        }
        return imageMatchSettings;
    }

    private EyesScreenshot takeScreenshot(Trigger[] userInputs, Region region, String tag, boolean shouldMatchWindowRunOnceOnTimeout, ICheckSettingsInternal checkSettingsInternal, int retryTimeout, String source) {
        EyesScreenshot screenshot;
        this.lastScreenshotHash = null;
        if (0 == retryTimeout || shouldMatchWindowRunOnceOnTimeout) {
            if (shouldMatchWindowRunOnceOnTimeout) {
                GeneralUtils.sleep((long)retryTimeout);
            }
            screenshot = this.tryTakeScreenshot(userInputs, region, tag, checkSettingsInternal, source);
        } else {
            screenshot = this.retryTakingScreenshot(userInputs, region, tag, checkSettingsInternal, retryTimeout, source);
        }
        return screenshot;
    }

    private EyesScreenshot retryTakingScreenshot(Trigger[] userInputs, Region region, String tag, ICheckSettingsInternal checkSettingsInternal, int retryTimeout, String source) {
        long start = System.currentTimeMillis();
        EyesScreenshot screenshot = null;
        long retry = System.currentTimeMillis() - start;
        while (retry < (long)retryTimeout) {
            GeneralUtils.sleep((long)500L);
            screenshot = this.tryTakeScreenshot(userInputs, region, tag, checkSettingsInternal, source);
            if (this.matchResult.getAsExpected()) break;
            retry = System.currentTimeMillis() - start;
        }
        if (!this.matchResult.getAsExpected()) {
            screenshot = this.tryTakeScreenshot(userInputs, region, tag, checkSettingsInternal, source);
        }
        return screenshot;
    }

    private EyesScreenshot tryTakeScreenshot(Trigger[] userInputs, Region region, String tag, ICheckSettingsInternal checkSettingsInternal, String source) {
        AppOutput appOutput = this.appOutputProvider.getAppOutput(region, checkSettingsInternal);
        EyesScreenshot screenshot = appOutput.getScreenshot();
        String currentScreenshotHash = GeneralUtils.getSha256hash((byte[])appOutput.getScreenshotBytes());
        if (currentScreenshotHash.equals(this.lastScreenshotHash)) {
            return screenshot;
        }
        ImageMatchSettings matchSettings = MatchWindowTask.createImageMatchSettings(checkSettingsInternal, screenshot, this.eyes);
        MatchWindowData data = this.eyes.prepareForMatch(checkSettingsInternal, Arrays.asList(userInputs), appOutput, tag, this.lastScreenshotHash != null, matchSettings, null, source);
        this.matchResult = this.eyes.performMatch(data);
        this.lastScreenshotHash = currentScreenshotHash;
        return screenshot;
    }

    private void updateLastScreenshot(EyesScreenshot screenshot) {
        if (screenshot != null) {
            this.lastScreenshot = screenshot;
        }
    }

    public EyesScreenshot getLastScreenshot() {
        return this.lastScreenshot;
    }

    private static void collectAccessibilityRegions(ICheckSettingsInternal checkSettingsInternal, ImageMatchSettings imageMatchSettings, EyesScreenshot screenshot) {
        ArrayList accessibilityRegions = new ArrayList();
        imageMatchSettings.setAccessibility(accessibilityRegions.toArray(new AccessibilityRegionByRectangle[0]));
    }
}

