/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.LogHandler;
import com.applitools.eyes.Logger;
import com.applitools.eyes.NullLogHandler;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.TestResultsStatus;
import com.applitools.eyes.TestResultsSummary;
import com.applitools.eyes.exceptions.DiffsFoundException;
import com.applitools.eyes.exceptions.NewTestException;
import com.applitools.eyes.exceptions.StaleElementReferenceException;
import com.applitools.eyes.exceptions.TestFailedException;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.Type;
import com.applitools.eyes.settings.GetResultsSettings;
import com.applitools.eyes.universal.AbstractSDKListener;
import com.applitools.eyes.universal.CommandExecutor;
import com.applitools.eyes.universal.Refer;
import com.applitools.eyes.universal.Reference;
import com.applitools.eyes.universal.dto.SpecDto;
import com.applitools.eyes.universal.dto.TestResultsSummaryDto;
import com.applitools.eyes.universal.mapper.TestResultsSummaryMapper;
import com.applitools.eyes.universal.server.UniversalSdkNativeLoader;
import com.applitools.eyes.visualgrid.services.RunnerOptions;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.ClassVersionGetter;
import org.apache.commons.lang3.tuple.Pair;

public abstract class EyesRunner
implements AutoCloseable {
    protected CommandExecutor commandExecutor;
    protected Reference managerRef;
    protected static String BASE_AGENT_ID = "eyes.sdk.java";
    protected static String VERSION = ClassVersionGetter.CURRENT_VERSION;
    protected static String PROTOCOL = "webdriver";
    protected static String[] COMMANDS = null;
    protected static AbstractSDKListener listener;
    private Boolean dontCloseBatches;
    private Boolean removeDuplicateTests;
    protected Logger logger = new Logger();

    public EyesRunner() {
        this.setLogHandler((LogHandler)new NullLogHandler());
        this.runServer(BASE_AGENT_ID, VERSION);
    }

    public EyesRunner(String baseAgentId, String version) {
        this.setLogHandler((LogHandler)new NullLogHandler());
        this.runServer(baseAgentId, version);
    }

    public EyesRunner(String baseAgentId, String version, AbstractSDKListener listener) {
        this.runServer(baseAgentId, version, PROTOCOL, COMMANDS, listener);
    }

    public EyesRunner(String baseAgentId, String version, RunnerOptions runnerOptions) {
        ArgumentGuard.notNull((Object)runnerOptions, (String)"runnerOptions");
        this.setLogHandler(runnerOptions.getLogHandler());
        this.runServer(baseAgentId, version);
    }

    public EyesRunner(String baseAgentId, String version, RunnerOptions runnerOptions, AbstractSDKListener listener) {
        ArgumentGuard.notNull((Object)runnerOptions, (String)"runnerOptions");
        this.setLogHandler(runnerOptions.getLogHandler());
        this.runServer(baseAgentId, version, PROTOCOL, COMMANDS, listener);
    }

    public EyesRunner(String baseAgentId, String version, String protocol, String[] commands, AbstractSDKListener listener) {
        this.setLogHandler((LogHandler)new NullLogHandler());
        this.runServer(baseAgentId, version, protocol, commands, listener);
    }

    public EyesRunner(String baseAgentId, String version, String protocol, String[] commands, AbstractSDKListener listener, RunnerOptions runnerOptions) {
        ArgumentGuard.notNull((Object)runnerOptions, (String)"runnerOptions");
        this.setLogHandler(runnerOptions.getLogHandler());
        this.runServer(baseAgentId, version, protocol, commands, listener);
    }

    protected void runServer(String baseAgentId, String version) {
        this.runServer(baseAgentId, version, PROTOCOL, null, listener);
    }

    protected void runServer(String baseAgentId, String version, String protocol, String[] commands, AbstractSDKListener listener) {
        UniversalSdkNativeLoader.setLogger((Logger)this.getLogger());
        UniversalSdkNativeLoader.start();
        this.commandExecutor = CommandExecutor.getInstance(baseAgentId + '/' + version, new SpecDto(protocol, commands), listener, this.getStaleElementException());
    }

    public TestResultsSummary getAllTestResults(boolean shouldThrowException) {
        GetResultsSettings settings = new GetResultsSettings(shouldThrowException, this.removeDuplicateTests);
        TestResultsSummaryDto dto = this.commandExecutor.getResults(this.managerRef, settings);
        return TestResultsSummaryMapper.fromDto(dto, shouldThrowException);
    }

    public void setLogHandler(LogHandler logHandler) {
        this.logger.setLogHandler(logHandler);
        if (!logHandler.isOpen()) {
            logHandler.open();
        }
    }

    public void logSessionResultsAndThrowException(boolean throwEx, TestResults results) {
        if (results == null) {
            return;
        }
        TestResultsStatus status = results.getStatus();
        String sessionResultsUrl = results.getUrl();
        String scenarioIdOrName = results.getName();
        String appIdOrName = results.getAppName();
        if (status == null) {
            throw new EyesException("Status is null in the test results");
        }
        this.logger.log(results.getId(), Stage.CLOSE, Type.TEST_RESULTS, new Pair[]{Pair.of((Object)"status", (Object)((Object)status)), Pair.of((Object)"url", (Object)sessionResultsUrl)});
        switch (status) {
            case Failed: {
                if (!throwEx) break;
                throw new TestFailedException(results, scenarioIdOrName, appIdOrName);
            }
            case Passed: {
                break;
            }
            case NotOpened: {
                if (!throwEx) break;
                throw new EyesException("Called close before calling open");
            }
            case Unresolved: {
                if (results.isNew().booleanValue()) {
                    if (!throwEx) break;
                    throw new NewTestException(results, scenarioIdOrName, appIdOrName);
                }
                if (!throwEx) break;
                throw new DiffsFoundException(results, scenarioIdOrName, appIdOrName);
            }
        }
    }

    protected StaleElementReferenceException getStaleElementException() {
        return new StaleElementReferenceException(){

            @Override
            public void throwException(String message) {
                throw new RuntimeException(message);
            }
        };
    }

    public TestResultsSummary getAllTestResults() {
        return this.getAllTestResults(true);
    }

    public void setDontCloseBatches(boolean dontCloseBatches) {
        this.dontCloseBatches = dontCloseBatches;
    }

    public Boolean isDontCloseBatches() {
        return this.dontCloseBatches;
    }

    public void setRemoveDuplicateTests(Boolean removeDuplicateTests) {
        this.removeDuplicateTests = removeDuplicateTests;
    }

    public Boolean getRemoveDuplicateTests() {
        return this.removeDuplicateTests;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setProxy(AbstractProxySettings proxySettings) {
    }

    public AbstractProxySettings getProxy() {
        return null;
    }

    public String getAgentId() {
        return BASE_AGENT_ID;
    }

    public Reference getManagerRef() {
        return this.managerRef;
    }

    public void setManagerRef(Reference managerRef) {
        this.managerRef = managerRef;
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public void setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    protected Refer getRefer() {
        return listener.getRefer();
    }

    @Override
    public void close() {
        this.commandExecutor.close();
    }
}

