/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.options;

import com.applitools.utils.ArgumentGuard;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LayoutBreakpointsOptions {
    private Boolean isLayoutBreakpoints;
    private final List<Integer> layoutBreakpoints = new ArrayList<Integer>();
    private Boolean reload;

    public LayoutBreakpointsOptions breakpoints() {
        this.isLayoutBreakpoints = true;
        this.layoutBreakpoints.clear();
        return this;
    }

    public LayoutBreakpointsOptions breakpoints(Boolean shouldSet) {
        this.isLayoutBreakpoints = shouldSet;
        this.layoutBreakpoints.clear();
        return this;
    }

    public LayoutBreakpointsOptions breakpoints(int ... breakpoints) {
        this.isLayoutBreakpoints = null;
        this.layoutBreakpoints.clear();
        if (breakpoints == null || breakpoints.length == 0) {
            return this;
        }
        for (int breakpoint : breakpoints) {
            ArgumentGuard.greaterThanZero((long)breakpoint, (String)"breakpoint");
            this.layoutBreakpoints.add(breakpoint);
        }
        Collections.sort(this.layoutBreakpoints);
        return this;
    }

    public LayoutBreakpointsOptions reload() {
        this.reload = true;
        return this;
    }

    public LayoutBreakpointsOptions reload(Boolean shouldReload) {
        this.reload = shouldReload;
        return this;
    }

    public Boolean getReload() {
        return this.reload;
    }

    public Boolean isLayoutBreakpoints() {
        return this.isLayoutBreakpoints;
    }

    public List<Integer> getLayoutBreakpoints() {
        return this.layoutBreakpoints;
    }
}

