/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.debug;

import com.applitools.eyes.Logger;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import com.applitools.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class FileDebugScreenshotsProvider
extends DebugScreenshotsProvider {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss_SSS");
    private final Logger logger;

    public FileDebugScreenshotsProvider(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void save(BufferedImage image, String suffix) {
        String filename = this.getPath() + this.getPrefix() + this.getFormattedTimeStamp() + "_" + suffix + ".png";
        ImageUtils.saveImage(image, filename);
    }

    private String getFormattedTimeStamp() {
        return this.dateFormat.format(Calendar.getInstance().getTime());
    }
}

