/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.fluent;

import com.applitools.eyes.EyesException;
import com.applitools.eyes.EyesRunner;
import com.applitools.eyes.Logger;
import com.applitools.eyes.ProxySettings;
import com.applitools.eyes.exceptions.StaleElementReferenceException;
import com.applitools.eyes.fluent.BatchClose;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.Type;
import com.applitools.eyes.universal.AbstractSDKListener;
import com.applitools.eyes.universal.CommandExecutor;
import com.applitools.eyes.universal.USDKListener;
import com.applitools.eyes.universal.dto.CloseBatchSettingsDto;
import com.applitools.eyes.universal.mapper.SettingsMapper;
import com.applitools.eyes.universal.server.UniversalSdkNativeLoader;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.ClassVersionGetter;
import com.applitools.utils.GeneralUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class EnabledBatchClose
extends BatchClose {
    protected static String BASE_AGENT_ID = "eyes.sdk.java";
    protected static String VERSION = ClassVersionGetter.CURRENT_VERSION;
    private List<String> batchIds;

    EnabledBatchClose(Logger logger, String serverUrl, List<String> batchIds) {
        super(logger);
        this.serverUrl = serverUrl;
        this.batchIds = batchIds;
    }

    @Override
    public EnabledBatchClose setUrl(String url) {
        ArgumentGuard.notNull((Object)url, (String)"url");
        this.serverUrl = url;
        return this;
    }

    @Override
    public EnabledBatchClose setApiKey(String apiKey) {
        ArgumentGuard.notNull((Object)apiKey, (String)"apiKey");
        this.apiKey = apiKey;
        return this;
    }

    @Override
    public EnabledBatchClose setProxy(ProxySettings proxySettings) {
        ArgumentGuard.notNull((Object)((Object)proxySettings), (String)"proxySettings");
        this.proxySettings = proxySettings;
        return this;
    }

    @Override
    public EnabledBatchClose setBatchId(List<String> batchIds) {
        ArgumentGuard.notNull(batchIds, (String)"batchIds");
        ArgumentGuard.notContainsNull(batchIds, (String)"batchIds");
        this.batchIds = batchIds;
        return this;
    }

    public void close() {
        this.logger.log(new HashSet(), Stage.CLOSE, Type.CLOSE_BATCH, new Pair[]{Pair.of((Object)"batchSize", (Object)this.batchIds.size())});
        if (this.batchIds == null || this.batchIds.isEmpty()) {
            return;
        }
        Boolean shouldStopServer = this.startServer();
        List<CloseBatchSettingsDto> dto = SettingsMapper.toCloseBatchSettingsDto(this.batchIds, this.apiKey, this.serverUrl, this.proxySettings);
        CommandExecutor.closeBatch(dto);
        this.stopServer(shouldStopServer);
    }

    private Boolean startServer() {
        boolean shouldStopServer = true;
        try {
            Field nativeProcess = UniversalSdkNativeLoader.class.getDeclaredField("nativeProcess");
            nativeProcess.setAccessible(true);
            Object isNativeProcess = nativeProcess.get(UniversalSdkNativeLoader.class);
            if (isNativeProcess != null) {
                shouldStopServer = false;
            }
            nativeProcess.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        if (shouldStopServer) {
            new EyesRunner(BASE_AGENT_ID, VERSION, (AbstractSDKListener)USDKListener.getInstance()){

                @Override
                public StaleElementReferenceException getStaleElementException() {
                    return null;
                }
            };
        }
        return shouldStopServer;
    }

    private void stopServer(Boolean shouldStopServer) {
        if (shouldStopServer.booleanValue()) {
            try {
                Method stopServer = UniversalSdkNativeLoader.class.getDeclaredMethod("destroyProcess", new Class[0]);
                stopServer.setAccessible(true);
                stopServer.invoke(UniversalSdkNativeLoader.class, new Object[0]);
                stopServer.setAccessible(false);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                String errorMessage = GeneralUtils.createErrorMessageFromExceptionWithText((Exception)e, (String)"Failed to stop server!");
                System.out.println(errorMessage);
                throw new EyesException(errorMessage, (Throwable)e);
            }
        }
    }
}

