/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.fluent;

import com.applitools.eyes.Logger;
import com.applitools.eyes.ProxySettings;
import com.applitools.eyes.fluent.EnabledBatchClose;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import java.util.List;

public class BatchClose {
    protected final Logger logger;
    protected String serverUrl;
    protected String apiKey;
    protected ProxySettings proxySettings;

    public BatchClose() {
        this(new Logger());
    }

    public BatchClose(Logger logger) {
        this.logger = logger;
        this.serverUrl = GeneralUtils.getServerUrl().toString();
    }

    public BatchClose setUrl(String url) {
        ArgumentGuard.notNull((Object)url, (String)"url");
        this.serverUrl = url;
        return this;
    }

    public BatchClose setApiKey(String apiKey) {
        ArgumentGuard.notNull((Object)apiKey, (String)"apiKey");
        this.apiKey = apiKey;
        return this;
    }

    public BatchClose setProxy(ProxySettings proxySettings) {
        ArgumentGuard.notNull((Object)((Object)proxySettings), (String)"proxySettings");
        this.proxySettings = proxySettings;
        return this;
    }

    public EnabledBatchClose setBatchId(List<String> batchIds) {
        ArgumentGuard.notNull(batchIds, (String)"batchIds");
        ArgumentGuard.notContainsNull(batchIds, (String)"batchIds");
        EnabledBatchClose enabledBatchClose = new EnabledBatchClose(this.logger, this.serverUrl, batchIds);
        if (this.apiKey != null) {
            enabledBatchClose.setApiKey(this.apiKey);
        }
        if (this.proxySettings != null) {
            enabledBatchClose.setProxy(this.proxySettings);
        }
        return enabledBatchClose;
    }
}

