/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.locators;

import com.applitools.utils.ArgumentGuard;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TextRegionSettings {
    @JsonIgnore
    private BufferedImage image;
    private final List<String> patterns;
    private Boolean ignoreCase;
    private Boolean firstOnly;
    private String language;

    public TextRegionSettings(String pattern, String ... patterns) {
        ArgumentGuard.notNull((Object)pattern, (String)"pattern");
        if (patterns != null && patterns.length != 0) {
            ArgumentGuard.notContainsNull((Object[])patterns, (String)"patterns");
            ArrayList<String> list = new ArrayList<String>();
            list.add(pattern);
            Collections.addAll(list, patterns);
            this.patterns = list;
        } else {
            this.patterns = Collections.singletonList(pattern);
        }
    }

    public TextRegionSettings ignoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        return this;
    }

    public TextRegionSettings firstOnly(boolean firstOnly) {
        this.firstOnly = firstOnly;
        return this;
    }

    public TextRegionSettings language(String language) {
        this.language = language;
        return this;
    }

    public TextRegionSettings image(BufferedImage image) {
        this.image = image;
        return this;
    }

    public List<String> getPatterns() {
        return this.patterns;
    }

    public Boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public Boolean getFirstOnly() {
        return this.firstOnly;
    }

    public String getLanguage() {
        return this.language;
    }

    public BufferedImage getImage() {
        return this.image;
    }
}

