/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.utils;

import com.applitools.utils.CountingOutputStream;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class ImageDeltaCompressor {
    private static final byte[] PREAMBLE;
    private static final byte COMPRESS_BY_RAW_BLOCKS_FORMAT = 3;

    private static Dimension getActualBlockSize(Dimension imageSize, int blockSize, int blockColumn, int blockRow) {
        int actualWidth = Math.min(imageSize.width - blockColumn * blockSize, blockSize);
        int actualHeight = Math.min(imageSize.height - blockRow * blockSize, blockSize);
        return new Dimension(actualWidth, actualHeight);
    }

    private static CompareAndCopyBlockChannelDataResult CompareAndCopyBlockChannelData(byte[] sourcePixels, byte[] targetPixels, Dimension imageSize, int pixelLength, int blockSize, int blockColumn, int blockRow, int channel) {
        boolean isIdentical = true;
        Dimension actualBlockSize = ImageDeltaCompressor.getActualBlockSize(imageSize, blockSize, blockColumn, blockRow);
        int actualBlockHeight = actualBlockSize.height;
        int actualBlockWidth = actualBlockSize.width;
        int stride = imageSize.width * pixelLength;
        byte[] channelBytes = new byte[actualBlockHeight * actualBlockWidth];
        int channelBytesOffset = 0;
        for (int h = 0; h < actualBlockHeight; ++h) {
            int offset = (blockSize * blockRow + h) * stride + blockSize * blockColumn * pixelLength + channel;
            for (int w = 0; w < actualBlockWidth; ++w) {
                byte sourceByte = sourcePixels[offset];
                byte targetByte = targetPixels[offset];
                if (sourceByte != targetByte) {
                    isIdentical = false;
                }
                channelBytes[channelBytesOffset++] = targetByte;
                offset += pixelLength;
            }
        }
        return new CompareAndCopyBlockChannelDataResult(isIdentical, channelBytes);
    }

    public static byte[] compressByRawBlocks(BufferedImage target, byte[] targetEncoded, BufferedImage source, int blockSize) throws IOException {
        if (source == null || source.getWidth() != target.getWidth() || source.getHeight() != target.getHeight()) {
            return targetEncoded;
        }
        byte[] targetPixels = ((DataBufferByte)target.getRaster().getDataBuffer()).getData();
        byte[] sourcePixels = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
        int pixelLength = target.getAlphaRaster() != null ? 4 : 3;
        Dimension imageSize = new Dimension(target.getWidth(), target.getHeight());
        int blockColumnsCount = target.getWidth() / blockSize + (target.getWidth() % blockSize == 0 ? 0 : 1);
        int blockRowsCount = target.getHeight() / blockSize + (target.getHeight() % blockSize == 0 ? 0 : 1);
        ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
        CountingOutputStream resultCountingStream = new CountingOutputStream(resultStream);
        DataOutputStream resultDataOutputStream = new DataOutputStream(resultCountingStream);
        DeflaterOutputStream compressed = new DeflaterOutputStream((OutputStream)resultCountingStream, new Deflater(9, true));
        DataOutputStream compressedDos = new DataOutputStream(compressed);
        resultStream.write(PREAMBLE, 0, PREAMBLE.length);
        resultStream.write(3);
        resultDataOutputStream.writeShort(0);
        resultDataOutputStream.writeShort(blockSize);
        for (int channel = 0; channel < 3; ++channel) {
            int actualChannelIndex = pixelLength == 4 ? channel + 1 : channel;
            int blockNumber = 0;
            for (int blockRow = 0; blockRow < blockRowsCount; ++blockRow) {
                for (int blockColumn = 0; blockColumn < blockColumnsCount; ++blockColumn) {
                    CompareAndCopyBlockChannelDataResult compareResult = ImageDeltaCompressor.CompareAndCopyBlockChannelData(sourcePixels, targetPixels, imageSize, pixelLength, blockSize, blockColumn, blockRow, actualChannelIndex);
                    if (!compareResult.getIsIdentical()) {
                        compressed.write(channel);
                        compressedDos.writeInt(blockNumber);
                        byte[] channelBytes = compareResult.getBuffer();
                        compressed.write(channelBytes, 0, channelBytes.length);
                        if (resultCountingStream.getBytesCount() > (long)targetEncoded.length) {
                            compressedDos.close();
                            return Arrays.copyOf(targetEncoded, targetEncoded.length);
                        }
                    }
                    ++blockNumber;
                }
            }
        }
        compressedDos.close();
        if (resultCountingStream.getBytesCount() > (long)targetEncoded.length) {
            return targetEncoded;
        }
        return resultStream.toByteArray();
    }

    public static byte[] compressByRawBlocks(BufferedImage target, byte[] targetEncoded, BufferedImage source) throws IOException {
        return ImageDeltaCompressor.compressByRawBlocks(target, targetEncoded, source, 10);
    }

    static {
        byte[] preambleBytes;
        try {
            preambleBytes = "applitools".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            preambleBytes = "applitools".getBytes();
        }
        PREAMBLE = preambleBytes;
    }

    private static class CompareAndCopyBlockChannelDataResult {
        private boolean isIdentical;
        private byte[] buffer;

        public CompareAndCopyBlockChannelDataResult(boolean isIdentical, byte[] buffer) {
            this.isIdentical = isIdentical;
            this.buffer = buffer;
        }

        public boolean getIsIdentical() {
            return this.isIdentical;
        }

        public byte[] getBuffer() {
            return this.buffer;
        }
    }
}

