/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes;

import com.applitools.eyes.TestResultContainer;
import com.applitools.eyes.TestResults;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TestResultsSummary
implements Iterable<TestResultContainer> {
    private List<TestResultContainer> results;
    private Integer passed;
    private Integer unresolved;
    private Integer failed;
    private Integer exceptions;
    private Integer mismatches;
    private Integer missing;
    private Integer matches;

    public TestResultsSummary(List<TestResultContainer> allResults) {
        this.results = allResults;
        for (TestResultContainer resultContainer : allResults) {
            TestResults result = null;
            if (resultContainer != null) {
                if (resultContainer.getException() != null) {
                    this.exceptions = 1;
                }
                result = resultContainer.getTestResults();
            }
            if (result == null) continue;
            if (result.getStatus() != null) {
                switch (result.getStatus()) {
                    case Failed: {
                        this.failed = 1;
                        break;
                    }
                    case Passed: {
                        this.passed = 1;
                        break;
                    }
                    case Unresolved: {
                        this.unresolved = 1;
                    }
                }
            }
            this.matches = result.getMatches();
            this.missing = result.getMissing();
            this.mismatches = result.getMismatches();
        }
    }

    public TestResultsSummary(List<TestResultContainer> allResults, Integer passed, Integer unresolved, Integer failed, Integer exceptions, Integer mismatches, Integer missing, Integer matches) {
        this.results = allResults;
        this.passed = passed;
        this.unresolved = unresolved;
        this.failed = failed;
        this.exceptions = exceptions;
        this.mismatches = mismatches;
        this.missing = missing;
        this.matches = matches;
    }

    public TestResultContainer[] getAllResults() {
        return this.results.toArray(new TestResultContainer[0]);
    }

    public String toString() {
        return "result summary {\n\tall results=\n\t\t" + StringUtils.join(this.results, (String)"\n\t\t") + "\n\tpassed=" + this.passed + "\n\tunresolved=" + this.unresolved + "\n\tfailed=" + this.failed + "\n\texceptions=" + this.exceptions + "\n\tmismatches=" + this.mismatches + "\n\tmissing=" + this.missing + "\n\tmatches=" + this.matches + "\n}";
    }

    @Override
    public Iterator<TestResultContainer> iterator() {
        return this.results.iterator();
    }

    public int size() {
        return this.results.size();
    }
}

