/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.universal.dto;

import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.SessionAccessibilityStatus;
import com.applitools.eyes.SessionUrls;
import com.applitools.eyes.StepInfo;
import com.applitools.eyes.TestResultsStatus;
import com.applitools.eyes.universal.dto.ExactEnvironment;
import com.applitools.eyes.universal.dto.ProxyDto;
import com.applitools.eyes.universal.dto.ServerInfoDto;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.Iso8610CalendarDeserializer;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Calendar;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TestResultsDto {
    private int steps;
    private int matches;
    private int mismatches;
    private int missing;
    private int exactMatches;
    private int strictMatches;
    private int contentMatches;
    private int layoutMatches;
    private int noneMatches;
    private String url;
    private Boolean isNew;
    private TestResultsStatus status;
    private String name;
    private String secretToken;
    private String id;
    private String appName;
    private String batchName;
    private String batchId;
    private String branchName;
    private String hostOS;
    private String hostApp;
    private RectangleSize hostDisplaySize;
    @JsonDeserialize(using=Iso8610CalendarDeserializer.class)
    private Calendar startedAt;
    private Integer duration;
    private boolean isDifferent;
    private boolean isAborted;
    private SessionUrls appUrls;
    private SessionUrls apiUrls;
    private StepInfo[] stepsInfo;
    private SessionAccessibilityStatus accessibilityStatus;
    private String userTestId;
    private ExactEnvironment environment;
    @JsonProperty(value="server")
    private ServerInfoDto serverInfo;
    @JsonIgnore
    private ProxyDto proxy;

    public StepInfo[] getStepsInfo() {
        return this.stepsInfo;
    }

    public void setStepsInfo(StepInfo[] stepsInfo) {
        this.stepsInfo = stepsInfo;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSecretToken() {
        return this.secretToken;
    }

    public void setSecretToken(String secretToken) {
        this.secretToken = secretToken;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getBatchName() {
        return this.batchName;
    }

    public void setBatchName(String batchName) {
        this.batchName = batchName;
    }

    public String getBatchId() {
        return this.batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public String getHostOS() {
        return this.hostOS;
    }

    public void setHostOS(String hostOS) {
        this.hostOS = hostOS;
    }

    public String getHostApp() {
        return this.hostApp;
    }

    public void setHostApp(String hostApp) {
        this.hostApp = hostApp;
    }

    public RectangleSize getHostDisplaySize() {
        return this.hostDisplaySize;
    }

    public void setHostDisplaySize(RectangleSize hostDisplaySize) {
        this.hostDisplaySize = hostDisplaySize;
    }

    public Calendar getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(Calendar startedAt) {
        this.startedAt = startedAt;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    @JsonGetter(value="isDifferent")
    public boolean isDifferent() {
        return this.isDifferent;
    }

    @JsonSetter(value="isDifferent")
    public void setDifferent(boolean different) {
        this.isDifferent = different;
    }

    @JsonGetter(value="isAborted")
    public boolean isAborted() {
        return this.isAborted;
    }

    @JsonSetter(value="isAborted")
    public void setAborted(boolean aborted) {
        this.isAborted = aborted;
    }

    public SessionUrls getAppUrls() {
        return this.appUrls;
    }

    public void setAppUrls(SessionUrls appUrls) {
        this.appUrls = appUrls;
    }

    public SessionUrls getApiUrls() {
        return this.apiUrls;
    }

    public void setApiUrls(SessionUrls apiUrls) {
        this.apiUrls = apiUrls;
    }

    public int getSteps() {
        return this.steps;
    }

    public int getMatches() {
        return this.matches;
    }

    public int getMismatches() {
        return this.mismatches;
    }

    public int getMissing() {
        return this.missing;
    }

    public int getExactMatches() {
        return this.exactMatches;
    }

    public int getStrictMatches() {
        return this.strictMatches;
    }

    public int getContentMatches() {
        return this.contentMatches;
    }

    public int getLayoutMatches() {
        return this.layoutMatches;
    }

    public int getNoneMatches() {
        return this.noneMatches;
    }

    public String getUrl() {
        return this.url;
    }

    @JsonGetter(value="isNew")
    public Boolean isNew() {
        return this.isNew;
    }

    public boolean isPassed() {
        return this.status == TestResultsStatus.Passed;
    }

    public TestResultsStatus getStatus() {
        return this.status;
    }

    public void setSteps(int steps) {
        ArgumentGuard.greaterThanOrEqualToZero((long)steps, (String)"steps");
        this.steps = steps;
    }

    public void setMatches(int matches) {
        ArgumentGuard.greaterThanOrEqualToZero((long)matches, (String)"matches");
        this.matches = matches;
    }

    public void setMismatches(int mismatches) {
        ArgumentGuard.greaterThanOrEqualToZero((long)mismatches, (String)"mismatches");
        this.mismatches = mismatches;
    }

    public void setMissing(int missing) {
        ArgumentGuard.greaterThanOrEqualToZero((long)missing, (String)"missing");
        this.missing = missing;
    }

    public void setExactMatches(int exactMatches) {
        ArgumentGuard.greaterThanOrEqualToZero((long)exactMatches, (String)"exactMatches");
        this.exactMatches = exactMatches;
    }

    public void setStrictMatches(int strictMatches) {
        ArgumentGuard.greaterThanOrEqualToZero((long)strictMatches, (String)"strictMatches");
        this.strictMatches = strictMatches;
    }

    public void setContentMatches(int contentMatches) {
        ArgumentGuard.greaterThanOrEqualToZero((long)contentMatches, (String)"contentMatches");
        this.contentMatches = contentMatches;
    }

    public void setLayoutMatches(int layoutMatches) {
        ArgumentGuard.greaterThanOrEqualToZero((long)layoutMatches, (String)"layoutMatches");
        this.layoutMatches = layoutMatches;
    }

    public void setNoneMatches(int noneMatches) {
        ArgumentGuard.greaterThanOrEqualToZero((long)noneMatches, (String)"noneMatches");
        this.noneMatches = noneMatches;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @JsonSetter(value="isNew")
    public void setNew(Boolean isNew) {
        this.isNew = isNew;
    }

    public void setStatus(TestResultsStatus status) {
        this.status = status;
    }

    public void setAccessibilityStatus(SessionAccessibilityStatus accessibilityStatus) {
        this.accessibilityStatus = accessibilityStatus;
    }

    public SessionAccessibilityStatus getAccessibilityStatus() {
        return this.accessibilityStatus;
    }

    public String getUserTestId() {
        return this.userTestId;
    }

    public void setUserTestId(String userTestId) {
        this.userTestId = userTestId;
    }

    public void setApiKey(ServerInfoDto serverInfo) {
        this.serverInfo = serverInfo;
    }

    public ServerInfoDto getServer() {
        return this.serverInfo;
    }

    @JsonIgnore
    public void setProxy(ProxyDto proxy) {
        this.proxy = proxy;
    }

    public ProxyDto getProxy() {
        return this.proxy;
    }

    public ExactEnvironment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(ExactEnvironment environment) {
        this.environment = environment;
    }
}

