/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.universal.mapper;

import com.applitools.eyes.Region;
import com.applitools.eyes.universal.dto.RegionDto;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class LocateMapper {
    private static Region toRegionFromRegionDto(RegionDto regionDto) {
        if (regionDto == null) {
            return null;
        }
        Region region = Region.EMPTY;
        if (regionDto.getX() != null && regionDto.getY() != null) {
            region.setX(regionDto.getX().intValue());
            region.setY(regionDto.getY().intValue());
            region.setWidth(regionDto.getWidth().intValue());
            region.setHeight(regionDto.getHeight().intValue());
            return region;
        }
        if (regionDto.getLeft() != null && regionDto.getTop() != null) {
            region.setLeft(regionDto.getLeft().intValue());
            region.setTop(regionDto.getTop().intValue());
            region.setWidth(regionDto.getWidth().intValue());
            region.setHeight(regionDto.getHeight().intValue());
            return region;
        }
        return null;
    }

    private static List<Region> toRegionListFromDto(List<RegionDto> regionsDto) {
        if (regionsDto == null || regionsDto.isEmpty()) {
            return null;
        }
        return regionsDto.stream().map(LocateMapper::toRegionFromRegionDto).collect(Collectors.toList());
    }

    public static Map<String, List<Region>> toLocateFromDto(Map<String, List<RegionDto>> regions) {
        if (regions == null || regions.isEmpty()) {
            return null;
        }
        HashMap<String, List<Region>> locateRegions = new HashMap<String, List<Region>>();
        for (Map.Entry<String, List<RegionDto>> entry : regions.entrySet()) {
            locateRegions.put(entry.getKey(), LocateMapper.toRegionListFromDto(entry.getValue()));
        }
        return locateRegions;
    }
}

