package com.applitools.eyes;

import java.net.URI;
import java.util.List;

public interface IEyesBase {

    String APPLITOOLS_PUBLIC_CLOUD_URL= "https://eyesapi.applitools.com";

    String getApiKey();

    URI getServerUrl();

    void setIsDisabled(Boolean isDisabled);

    Boolean getIsDisabled();

    String getFullAgentId();

    boolean getIsOpen();

    void setLogHandler(LogHandler logHandler);

    LogHandler getLogHandler();

    Logger getLogger();

    void addProperty(String name, String value);

    void clearProperties();

    TestResults abortIfNotClosed();

    void closeAsync();

    void abortAsync();

    TestResults abort();

    List<TestResults> getResults(boolean shouldThrowException);
    List<TestResults> getResults();
}
