/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.locators;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class VisualLocatorSettings {
    @JsonIgnore
    private BufferedImage image;
    @JsonIgnore
    private String path;
    private List<String> names = new ArrayList<String>();
    private Boolean firstOnly;

    public VisualLocatorSettings() {
    }

    protected VisualLocatorSettings(String name) {
        this.names.add(name);
    }

    protected VisualLocatorSettings(List<String> names) {
        this.names.addAll(names);
    }

    public VisualLocatorSettings first() {
        return this.first(true);
    }

    public VisualLocatorSettings first(boolean firstOnly) {
        VisualLocatorSettings clone = this.clone();
        clone.firstOnly = firstOnly;
        return clone;
    }

    public VisualLocatorSettings all() {
        VisualLocatorSettings clone = this.clone();
        clone.firstOnly = false;
        return clone;
    }

    public VisualLocatorSettings name(String name) {
        VisualLocatorSettings clone = this.clone();
        clone.names.add(name);
        return clone;
    }

    public VisualLocatorSettings names(List<String> names) {
        VisualLocatorSettings clone = this.clone();
        clone.names.addAll(names);
        return clone;
    }

    public VisualLocatorSettings image(BufferedImage image) {
        VisualLocatorSettings clone = this.clone();
        clone.image = image;
        clone.path = null;
        return clone;
    }

    public VisualLocatorSettings image(String path) {
        VisualLocatorSettings clone = this.clone();
        clone.image = null;
        clone.path = path;
        return clone;
    }

    protected VisualLocatorSettings clone() {
        VisualLocatorSettings settings = new VisualLocatorSettings();
        this.populateClone(settings);
        return settings;
    }

    private void populateClone(VisualLocatorSettings clone) {
        clone.names = this.names;
        clone.firstOnly = this.firstOnly;
        clone.image = this.image;
        clone.path = this.path;
    }

    public List<String> getNames() {
        return this.names;
    }

    public Boolean isFirstOnly() {
        return this.firstOnly;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public String getPath() {
        return this.path;
    }
}

