package com.applitools.eyes.universal.dto;

import com.fasterxml.jackson.annotation.JsonInclude;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class ECClientSettingsDto {

    private String ecServerUrl;
    private ECCapabilitiesOptions options;
    private Integer port;
    private ProxyDto proxy;

    public ECClientSettingsDto(String ecServerUrl, ECCapabilitiesOptions options, Integer port, ProxyDto proxy) {
        this.ecServerUrl = ecServerUrl;
        this.options = options;
        this.port = port;
        this.proxy = proxy;
    }

    public String getECServerUrl() {
        return ecServerUrl;
    }

    public void setECServerUrl(String ecServerUrl) {
        this.ecServerUrl = ecServerUrl;
    }

    public ECCapabilitiesOptions getOptions() {
        return options;
    }

    public void setOptions(ECCapabilitiesOptions options) {
        this.options = options;
    }

    public Integer getPort() {
        return port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public ProxyDto getProxy() {
        return proxy;
    }

    public void setProxy(ProxyDto proxy) {
        this.proxy = proxy;
    }

    @Override
    public String toString() {
        return "ECClientSettingsDto{" +
                "ecServerUrl='" + ecServerUrl + '\'' +
                ", options=" + options +
                ", port=" + port +
                ", proxy=" + proxy +
                '}';
    }
}
