/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;

public class EfficientStringReplace {
    public static String efficientStringReplace(String refIdOpenToken, String refIdCloseToken, String input, Map<String, String> replacements) {
        int resultBufferSize = input.length();
        for (String rep : replacements.values()) {
            resultBufferSize += rep.length();
        }
        StringBuilder result = new StringBuilder(resultBufferSize);
        StringBuilder refId = new StringBuilder();
        int inLen = input.length();
        char[] refIdOpenChars = refIdOpenToken.toCharArray();
        int refOpenTokenLen = refIdOpenChars.length;
        char[] refIdCloseChars = refIdCloseToken.toCharArray();
        int refCloseTokenLen = refIdCloseChars.length;
        block1: for (int i = 0; i < inLen; ++i) {
            boolean refTokenEncountered;
            boolean bl = refTokenEncountered = input.charAt(i) == refIdOpenChars[0];
            if (refTokenEncountered) {
                for (int j = 1; j < refOpenTokenLen; ++j) {
                    if (input.charAt(i + j) == refIdOpenChars[j]) continue;
                    refTokenEncountered = false;
                    break;
                }
                if (refTokenEncountered) {
                    refId.setLength(0);
                    i += refOpenTokenLen;
                    while (i < inLen) {
                        boolean refEndTokenEncountered;
                        boolean bl2 = refEndTokenEncountered = input.charAt(i) == refIdCloseChars[0];
                        if (refEndTokenEncountered) {
                            String rep;
                            for (int j = 1; j < refCloseTokenLen; ++j) {
                                if (input.charAt(i + j) == refIdCloseChars[j]) continue;
                                refEndTokenEncountered = false;
                                break;
                            }
                            if (refEndTokenEncountered && (rep = replacements.get(refId.toString())) != null) {
                                result.append(rep);
                                i += refCloseTokenLen - 1;
                                continue block1;
                            }
                        }
                        if (!refEndTokenEncountered) {
                            refId.append(input.charAt(i));
                        }
                        ++i;
                    }
                }
            }
            if (refTokenEncountered) continue;
            result.append(input.charAt(i));
        }
        return result.toString();
    }

    public static String stringify(String s) {
        String cleaned;
        if (s == null || s.isEmpty()) {
            return "";
        }
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            cleaned = objectMapper.writeValueAsString((Object)s);
            cleaned = cleaned.substring(1, cleaned.length() - 1);
        }
        catch (JsonProcessingException e) {
            cleaned = "";
        }
        return cleaned;
    }
}

