package com.applitools.utils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonInclude(JsonInclude.Include.NON_NULL)
public abstract class EnvironmentVersions {

    private final String java = GeneralUtils.getPropertyString("java.version");

    public String getJava() {
        return java;
    }

    @JsonIgnore
    public abstract String getName();

    @JsonIgnore
    public String getCurrentVersion() {
        return ClassVersionGetter.CURRENT_VERSION;
    }

}
