/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.config;

import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.AccessibilitySettings;
import com.applitools.eyes.AutProxySettings;
import com.applitools.eyes.BatchInfo;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.FailureReports;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.PropertyData;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.SessionType;
import com.applitools.eyes.StitchOverlap;
import com.applitools.eyes.WebDriverProxySettings;
import com.applitools.eyes.config.ContentInset;
import com.applitools.eyes.config.Feature;
import com.applitools.eyes.config.IConfiguration;
import com.applitools.eyes.options.LayoutBreakpointsOptions;
import com.applitools.eyes.selenium.BrowserType;
import com.applitools.eyes.selenium.StitchMode;
import com.applitools.eyes.visualgrid.model.AndroidDeviceInfo;
import com.applitools.eyes.visualgrid.model.ChromeEmulationInfo;
import com.applitools.eyes.visualgrid.model.DesktopBrowserInfo;
import com.applitools.eyes.visualgrid.model.DeviceName;
import com.applitools.eyes.visualgrid.model.DeviceTarget;
import com.applitools.eyes.visualgrid.model.EmulationBaseInfo;
import com.applitools.eyes.visualgrid.model.IDebugResourceWriter;
import com.applitools.eyes.visualgrid.model.IRenderingBrowserInfo;
import com.applitools.eyes.visualgrid.model.IosDeviceInfo;
import com.applitools.eyes.visualgrid.model.RenderBrowserInfo;
import com.applitools.eyes.visualgrid.model.ScreenOrientation;
import com.applitools.eyes.visualgrid.model.VisualGridOption;
import com.applitools.utils.GeneralUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Configuration
implements IConfiguration {
    private static final int DEFAULT_WAIT_BEFORE_SCREENSHOTS = 100;
    private static final int DEFAULT_MATCH_TIMEOUT = 2000;
    private String branchName = GeneralUtils.getEnvString((String)"APPLITOOLS_BRANCH");
    private String parentBranchName = GeneralUtils.getEnvString((String)"APPLITOOLS_PARENT_BRANCH");
    private String baselineBranchName = GeneralUtils.getEnvString((String)"APPLITOOLS_BASELINE_BRANCH");
    private String agentId;
    private String environmentName;
    private Boolean saveDiffs;
    private SessionType sessionType;
    protected BatchInfo batch;
    protected String baselineEnvName;
    protected String appName;
    protected String testName;
    protected RectangleSize viewportSize;
    protected Boolean ignoreDisplacements;
    protected ImageMatchSettings defaultMatchSettings = new ImageMatchSettings();
    private Integer matchTimeout = 2000;
    private String hostApp;
    private String hostOS;
    private String deviceInfo;
    private String hostingAppInfo;
    private String osInfo;
    private Boolean saveNewTests;
    private Boolean saveFailedTests;
    private StitchOverlap stitchOverlap;
    private Boolean isSendDom;
    private String apiKey = GeneralUtils.getEnvString((String)"APPLITOOLS_API_KEY");
    private String serverUrl = GeneralUtils.getEnvString((String)"APPLITOOLS_SERVER_URL") == null ? "https://eyesapi.applitools.com" : GeneralUtils.getEnvString((String)"APPLITOOLS_SERVER_URL");
    private AbstractProxySettings proxy;
    private AutProxySettings autProxy;
    private FailureReports failureReports;
    private AccessibilitySettings accessibilitySettings;
    private Boolean enablePatterns;
    private Boolean useDom;
    private Integer abortIdleTestTimeout;
    private Boolean forceFullPageScreenshot;
    private Integer waitBeforeScreenshots;
    private StitchMode stitchMode;
    private Boolean hideScrollbars;
    private Boolean hideCaret;
    private Boolean isVisualGrid;
    private Boolean disableBrowserFetching;
    private Boolean useCookies;
    private Boolean captureStatusBar;
    @JsonIgnore
    private IDebugResourceWriter debugResourceWriter;
    private Boolean isRenderingConfig;
    private List<RenderBrowserInfo> browsersInfo = new ArrayList<RenderBrowserInfo>();
    private Set<Feature> features = new HashSet<Feature>();
    private List<VisualGridOption> visualGridOptions = new ArrayList<VisualGridOption>();
    private LayoutBreakpointsOptions layoutBreakpointsOptions;
    private Boolean saveDebugScreenshots;
    private String debugScreenshotsPath;
    private String debugScreenshotsPrefix;
    private Boolean isDisabled = false;
    private List<PropertyData> properties = new ArrayList<PropertyData>();
    private CutProvider cutProvider;
    private Integer rotation;
    private Double scaleRatio;
    private Boolean useCeilForViewportSize;
    private Integer waitBeforeCapture;
    private WebDriverProxySettings webdriverProxySettings;
    private ContentInset contentInset;

    public Configuration(Configuration other) {
        this.branchName = other.getBranchName();
        this.parentBranchName = other.getParentBranchName();
        this.baselineBranchName = other.getBaselineBranchName();
        this.agentId = other.getAgentId();
        this.environmentName = other.getEnvironmentName();
        this.saveDiffs = other.getSaveDiffs();
        this.sessionType = other.getSessionType();
        this.batch = other.getBatch();
        this.baselineEnvName = other.getBaselineEnvName();
        this.appName = other.getAppName();
        this.testName = other.getTestName();
        this.viewportSize = other.getViewportSize();
        this.defaultMatchSettings = new ImageMatchSettings(other.getDefaultMatchSettings());
        this.matchTimeout = other.getMatchTimeout();
        this.hostApp = other.getHostApp();
        this.hostOS = other.getHostOS();
        this.deviceInfo = other.getDeviceInfo();
        this.hostingAppInfo = other.getHostingAppInfo();
        this.osInfo = other.getOsInfo();
        this.saveNewTests = other.getSaveNewTests();
        this.saveFailedTests = other.getSaveFailedTests();
        this.stitchOverlap = other.getOverlap();
        this.isSendDom = other.isSendDom();
        this.apiKey = other.getApiKey();
        this.useDom = other.getUseDom();
        this.abortIdleTestTimeout = other.getAbortIdleTestTimeout();
        this.enablePatterns = other.getEnablePatterns();
        URI serverUrl = other.getServerUrl();
        if (serverUrl != null) {
            this.serverUrl = serverUrl.toString();
        }
        this.failureReports = other.getFailureReports();
        this.proxy = other.getProxy();
        this.autProxy = other.getAutProxy();
        if (other.getMatchLevel() != null) {
            this.defaultMatchSettings.setMatchLevel(other.getMatchLevel());
        }
        this.ignoreDisplacements = other.getIgnoreDisplacements();
        this.accessibilitySettings = other.getAccessibilityValidation();
        this.forceFullPageScreenshot = other.getForceFullPageScreenshot();
        this.waitBeforeScreenshots = other.getWaitBeforeScreenshots();
        this.stitchMode = other.getStitchMode();
        this.hideScrollbars = other.getHideScrollbars();
        this.hideCaret = other.getHideCaret();
        this.isRenderingConfig = other.isRenderingConfig();
        if (other.getBrowsersInfo() != null) {
            this.browsersInfo = new ArrayList<RenderBrowserInfo>(other.getBrowsersInfo());
        }
        this.defaultMatchSettings = new ImageMatchSettings(other.getDefaultMatchSettings());
        this.isVisualGrid = other.isVisualGrid();
        this.features = new HashSet<Feature>(other.getFeatures());
        this.visualGridOptions = other.getVisualGridOptions();
        this.disableBrowserFetching = other.isDisableBrowserFetching();
        this.useCookies = other.isUseCookies();
        this.debugResourceWriter = other.getDebugResourceWriter();
        this.layoutBreakpointsOptions = other.getLayoutBreakpointsOptions();
        this.captureStatusBar = other.isCaptureStatusBar();
        this.useCeilForViewportSize = other.getUseCeilForViewportSize();
        this.waitBeforeCapture = other.getWaitBeforeCapture();
        this.webdriverProxySettings = other.getWebDriverProxy();
        this.contentInset = other.getContentInset();
        this.cutProvider = other.getCutProvider();
        this.rotation = other.getRotation();
        this.scaleRatio = other.getScaleRatio();
        this.debugScreenshotsPath = other.getDebugScreenshotsPath();
        this.debugScreenshotsPrefix = other.getDebugScreenshotsPrefix();
        this.saveDebugScreenshots = other.getSaveDebugScreenshots();
        this.isDisabled = other.getIsDisabled();
        this.properties = new ArrayList<PropertyData>(other.getProperties());
    }

    public Configuration() {
    }

    public Configuration(RectangleSize viewportSize) {
        this();
        this.browsersInfo.add(new RenderBrowserInfo(viewportSize.getWidth(), viewportSize.getHeight(), BrowserType.CHROME, null));
    }

    public Configuration(String testName) {
        this.testName = testName;
    }

    public Configuration(String appName, String testName, RectangleSize viewportSize) {
        this();
        if (viewportSize != null) {
            this.browsersInfo.add(new RenderBrowserInfo(viewportSize.getWidth(), viewportSize.getHeight(), BrowserType.CHROME, null));
        }
        this.testName = testName;
        this.viewportSize = viewportSize;
        this.appName = appName;
    }

    @Override
    public Boolean getSaveNewTests() {
        return this.saveNewTests;
    }

    @Override
    public Configuration setSaveNewTests(Boolean saveNewTests) {
        this.saveNewTests = saveNewTests;
        return this;
    }

    @Override
    public Boolean getSaveFailedTests() {
        return this.saveFailedTests;
    }

    @Override
    public Configuration setSaveFailedTests(Boolean saveFailedTests) {
        this.saveFailedTests = saveFailedTests;
        return this;
    }

    @Override
    public ImageMatchSettings getDefaultMatchSettings() {
        return this.defaultMatchSettings;
    }

    @Override
    public Configuration setDefaultMatchSettings(ImageMatchSettings defaultMatchSettings) {
        this.defaultMatchSettings = defaultMatchSettings;
        return this;
    }

    @Override
    public Integer getMatchTimeout() {
        return this.matchTimeout;
    }

    @Override
    public Configuration setMatchTimeout(Integer matchTimeout) {
        this.matchTimeout = matchTimeout;
        return this;
    }

    @Override
    public String getHostApp() {
        return this.hostApp;
    }

    @Override
    public Configuration setHostApp(String hostApp) {
        this.hostApp = hostApp;
        return this;
    }

    @Override
    public String getHostOS() {
        return this.hostOS;
    }

    @Override
    public Configuration setHostOS(String hostOS) {
        this.hostOS = hostOS;
        return this;
    }

    @Override
    public Integer getStitchOverlap() {
        return this.stitchOverlap.getBottom();
    }

    @Override
    public StitchOverlap getOverlap() {
        return this.stitchOverlap;
    }

    @Override
    public Configuration setStitchOverlap(Integer stitchOverlap) {
        this.stitchOverlap = new StitchOverlap().bottom(stitchOverlap);
        return this;
    }

    @Override
    public Configuration setStitchOverlap(StitchOverlap stitchOverlap) {
        this.stitchOverlap = stitchOverlap;
        return this;
    }

    @Override
    public Configuration setBatch(BatchInfo batch) {
        this.batch = batch;
        return this;
    }

    @Override
    public BatchInfo getBatch() {
        return this.batch;
    }

    @Override
    public Configuration setBranchName(String branchName) {
        this.branchName = branchName;
        return this;
    }

    @Override
    public String getBranchName() {
        return this.branchName;
    }

    @Override
    public String getAgentId() {
        return this.agentId;
    }

    @Override
    public Configuration setAgentId(String agentId) {
        this.agentId = agentId;
        return this;
    }

    @Override
    public String getParentBranchName() {
        return this.parentBranchName;
    }

    @Override
    public Configuration setParentBranchName(String parentBranchName) {
        this.parentBranchName = parentBranchName;
        return this;
    }

    @Override
    public String getBaselineBranchName() {
        return this.baselineBranchName;
    }

    @Override
    public Configuration setBaselineBranchName(String baselineBranchName) {
        this.baselineBranchName = baselineBranchName;
        return this;
    }

    @Override
    public String getBaselineEnvName() {
        return this.baselineEnvName;
    }

    @Override
    public Configuration setBaselineEnvName(String baselineEnvName) {
        this.baselineEnvName = baselineEnvName;
        return this;
    }

    @Override
    public String getEnvironmentName() {
        return this.environmentName;
    }

    @Override
    public Configuration setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
        return this;
    }

    @Override
    public Boolean getSaveDiffs() {
        return this.saveDiffs;
    }

    @Override
    public Configuration setSaveDiffs(Boolean saveDiffs) {
        this.saveDiffs = saveDiffs;
        return this;
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public Configuration setAppName(String appName) {
        this.appName = appName;
        return this;
    }

    @Override
    public String getTestName() {
        return this.testName;
    }

    @Override
    public Configuration setTestName(String testName) {
        this.testName = testName;
        return this;
    }

    @Override
    public RectangleSize getViewportSize() {
        return this.viewportSize;
    }

    @Override
    public Configuration setViewportSize(RectangleSize viewportSize) {
        this.viewportSize = viewportSize;
        return this;
    }

    @Override
    public SessionType getSessionType() {
        return this.sessionType;
    }

    @Override
    public Configuration setSessionType(SessionType sessionType) {
        this.sessionType = sessionType;
        return this;
    }

    @Override
    public Configuration setFailureReports(FailureReports failureReports) {
        this.failureReports = failureReports;
        return this;
    }

    @Override
    public FailureReports getFailureReports() {
        return this.failureReports;
    }

    public String toString() {
        return super.toString() + "\n\tbatch = " + this.batch + "\n\tbranchName = " + this.branchName + "\n\tparentBranchName = " + this.parentBranchName + "\n\tagentId = " + this.agentId + "\n\tbaselineEnvName = " + this.baselineEnvName + "\n\tenvironmentName = " + this.environmentName + "\n\tsaveDiffs = " + this.saveDiffs + "\n\tappName = " + this.appName + "\n\ttestName = " + this.testName + "\n\tviewportSize = " + this.viewportSize + "\n\tsessionType = " + (Object)((Object)this.sessionType) + "\n\tforceFullPageScreenshot = " + this.forceFullPageScreenshot + "\n\twaitBeforeScreenshots = " + this.waitBeforeScreenshots + "\n\tstitchMode = " + (Object)((Object)this.stitchMode) + "\n\thideScrollbars = " + this.hideScrollbars + "\n\thideCaret = " + this.hideCaret;
    }

    @Override
    public Boolean isSendDom() {
        return this.isSendDom;
    }

    @Override
    public Configuration setSendDom(Boolean sendDom) {
        this.isSendDom = sendDom;
        return this;
    }

    @Override
    public Boolean getIgnoreCaret() {
        Boolean ignoreCaret = null;
        if (this.getDefaultMatchSettings() != null) {
            ignoreCaret = this.getDefaultMatchSettings().getIgnoreCaret();
        }
        return ignoreCaret == null || ignoreCaret != false;
    }

    @Override
    public Configuration setIgnoreCaret(Boolean value) {
        this.defaultMatchSettings.setIgnoreCaret(value);
        return this;
    }

    @Override
    public String getApiKey() {
        return this.apiKey;
    }

    @Override
    public Configuration setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @Override
    public URI getServerUrl() {
        if (this.serverUrl != null) {
            return URI.create(this.serverUrl);
        }
        return null;
    }

    @Override
    public Configuration setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
        return this;
    }

    @Override
    public AbstractProxySettings getProxy() {
        return this.proxy;
    }

    @Override
    public Configuration setProxy(AbstractProxySettings proxy) {
        this.proxy = proxy;
        return this;
    }

    @Override
    public MatchLevel getMatchLevel() {
        return this.defaultMatchSettings.getMatchLevel();
    }

    @Override
    public Boolean getIgnoreDisplacements() {
        return this.ignoreDisplacements;
    }

    @Override
    public Configuration setMatchLevel(MatchLevel matchLevel) {
        this.defaultMatchSettings.setMatchLevel(matchLevel);
        return this;
    }

    @Override
    public Configuration setIgnoreDisplacements(Boolean isIgnoreDisplacements) {
        this.defaultMatchSettings.setIgnoreDisplacements(isIgnoreDisplacements);
        this.ignoreDisplacements = isIgnoreDisplacements;
        return this;
    }

    @Override
    public AccessibilitySettings getAccessibilityValidation() {
        return this.accessibilitySettings;
    }

    @Override
    public Configuration setAccessibilityValidation(AccessibilitySettings accessibilitySettings) {
        if (accessibilitySettings == null) {
            return this;
        }
        if (accessibilitySettings.getLevel() == null || accessibilitySettings.getGuidelinesVersion() == null) {
            throw new IllegalArgumentException("AccessibilitySettings should have the following properties: \u2018level,version\u2019");
        }
        this.defaultMatchSettings.setAccessibilitySettings(accessibilitySettings);
        this.accessibilitySettings = accessibilitySettings;
        return this;
    }

    @Override
    public Configuration setUseDom(Boolean useDom) {
        this.defaultMatchSettings.setUseDom(useDom);
        this.useDom = useDom;
        return this;
    }

    @Override
    public Boolean getUseDom() {
        return this.useDom;
    }

    @Override
    public Configuration setEnablePatterns(Boolean enablePatterns) {
        this.defaultMatchSettings.setEnablePatterns(enablePatterns);
        this.enablePatterns = enablePatterns;
        return this;
    }

    @Override
    public Boolean getEnablePatterns() {
        return this.enablePatterns;
    }

    public Boolean getForceFullPageScreenshot() {
        return this.forceFullPageScreenshot;
    }

    public Integer getWaitBeforeScreenshots() {
        return this.waitBeforeScreenshots;
    }

    public Configuration setWaitBeforeScreenshots(int waitBeforeScreenshots) {
        this.waitBeforeScreenshots = waitBeforeScreenshots <= 0 ? Integer.valueOf(100) : Integer.valueOf(waitBeforeScreenshots);
        return this;
    }

    public StitchMode getStitchMode() {
        return this.stitchMode;
    }

    public Configuration setStitchMode(StitchMode stitchMode) {
        this.stitchMode = stitchMode;
        return this;
    }

    public Boolean getHideScrollbars() {
        return this.hideScrollbars;
    }

    public Configuration setHideScrollbars(boolean hideScrollbars) {
        this.hideScrollbars = hideScrollbars;
        return this;
    }

    public Boolean getHideCaret() {
        return this.hideCaret;
    }

    public Configuration setHideCaret(boolean hideCaret) {
        this.hideCaret = hideCaret;
        return this;
    }

    public Configuration addBrowsers(IRenderingBrowserInfo ... browserInfos) {
        if (browserInfos == null) {
            return this;
        }
        for (IRenderingBrowserInfo browserInfo : browserInfos) {
            this.addBrowser(browserInfo);
        }
        return this;
    }

    private void addBrowser(IRenderingBrowserInfo browserInfo) {
        if (browserInfo instanceof DesktopBrowserInfo) {
            this.addBrowser((DesktopBrowserInfo)browserInfo);
        } else if (browserInfo instanceof ChromeEmulationInfo) {
            this.addBrowser((ChromeEmulationInfo)browserInfo);
        } else if (browserInfo instanceof IosDeviceInfo) {
            this.addBrowser((IosDeviceInfo)browserInfo);
        }
    }

    public Configuration addBrowser(RenderBrowserInfo renderBrowserInfo) {
        this.browsersInfo.add(renderBrowserInfo);
        return this;
    }

    public Configuration addBrowser(DesktopBrowserInfo desktopBrowserInfo) {
        this.browsersInfo.add(desktopBrowserInfo.getRenderBrowserInfo());
        return this;
    }

    public Configuration addBrowser(ChromeEmulationInfo chromeEmulationInfo) {
        RenderBrowserInfo renderBrowserInfo = new RenderBrowserInfo((EmulationBaseInfo)chromeEmulationInfo);
        this.browsersInfo.add(renderBrowserInfo);
        return this;
    }

    public Configuration addBrowser(IosDeviceInfo iosDeviceInfo) {
        RenderBrowserInfo renderBrowserInfo = new RenderBrowserInfo(iosDeviceInfo);
        this.browsersInfo.add(renderBrowserInfo);
        return this;
    }

    public Configuration addBrowser(int width, int height, BrowserType browserType, String baselineEnvName) {
        RenderBrowserInfo browserInfo = new RenderBrowserInfo(width, height, browserType, baselineEnvName);
        this.addBrowser(browserInfo);
        return this;
    }

    public Configuration addBrowser(int width, int height, BrowserType browserType) {
        return this.addBrowser(width, height, browserType, this.baselineEnvName);
    }

    public Configuration addBrowser(int width, int height, com.applitools.eyes.visualgrid.BrowserType browserType, String baselineEnvName) {
        BrowserType browserType1 = BrowserType.fromName((String)browserType.getName());
        return this.addBrowser(width, height, browserType1, baselineEnvName);
    }

    public Configuration addBrowser(int width, int height, com.applitools.eyes.visualgrid.BrowserType browserType) {
        return this.addBrowser(width, height, browserType, this.baselineEnvName);
    }

    public Configuration addDeviceEmulation(DeviceName deviceName, ScreenOrientation orientation) {
        ChromeEmulationInfo emulationInfo = new ChromeEmulationInfo(deviceName, orientation);
        RenderBrowserInfo browserInfo = new RenderBrowserInfo((EmulationBaseInfo)emulationInfo, this.baselineEnvName);
        this.browsersInfo.add(browserInfo);
        return this;
    }

    public Configuration addDeviceEmulation(DeviceName deviceName) {
        ChromeEmulationInfo emulationInfo = new ChromeEmulationInfo(deviceName, ScreenOrientation.PORTRAIT);
        RenderBrowserInfo browserInfo = new RenderBrowserInfo((EmulationBaseInfo)emulationInfo, this.baselineEnvName);
        this.browsersInfo.add(browserInfo);
        return this;
    }

    public Configuration addDeviceEmulation(DeviceName deviceName, String baselineEnvName) {
        ChromeEmulationInfo emulationInfo = new ChromeEmulationInfo(deviceName, ScreenOrientation.PORTRAIT);
        RenderBrowserInfo browserInfo = new RenderBrowserInfo((EmulationBaseInfo)emulationInfo, baselineEnvName);
        this.browsersInfo.add(browserInfo);
        return this;
    }

    public Configuration addDeviceEmulation(DeviceName deviceName, ScreenOrientation orientation, String baselineEnvName) {
        ChromeEmulationInfo emulationInfo = new ChromeEmulationInfo(deviceName, orientation);
        RenderBrowserInfo browserInfo = new RenderBrowserInfo((EmulationBaseInfo)emulationInfo, baselineEnvName);
        this.browsersInfo.add(browserInfo);
        return this;
    }

    public Configuration addMultiDeviceTarget(DeviceTarget deviceTarget, DeviceTarget ... deviceTargets) {
        RenderBrowserInfo browserInfo = new RenderBrowserInfo(deviceTarget);
        this.browsersInfo.add(browserInfo);
        for (DeviceTarget target : deviceTargets) {
            browserInfo = new RenderBrowserInfo(target);
            this.browsersInfo.add(browserInfo);
        }
        return this;
    }

    public List<RenderBrowserInfo> getBrowsersInfo() {
        if (this.browsersInfo != null && !this.browsersInfo.isEmpty()) {
            return this.browsersInfo;
        }
        return null;
    }

    public Configuration setBrowsersInfo(List<RenderBrowserInfo> browsersInfo) {
        this.browsersInfo = browsersInfo;
        return this;
    }

    public Boolean isForceFullPageScreenshot() {
        return this.forceFullPageScreenshot;
    }

    public Configuration setForceFullPageScreenshot(boolean forceFullPageScreenshot) {
        this.forceFullPageScreenshot = forceFullPageScreenshot;
        return this;
    }

    public Boolean isRenderingConfig() {
        return this.isRenderingConfig;
    }

    public Configuration setRenderingConfig(Boolean renderingConfig) {
        this.isRenderingConfig = renderingConfig;
        return this;
    }

    public Configuration setIsVisualGrid(Boolean isVisualGrid) {
        this.isVisualGrid = isVisualGrid;
        return this;
    }

    public Boolean isVisualGrid() {
        return this.isVisualGrid;
    }

    public Configuration setFeatures(Feature feature, Feature ... features) {
        this.features.clear();
        this.features.add(feature);
        this.features.addAll(Arrays.asList(features));
        this.features.remove(null);
        return this;
    }

    public List<Feature> getFeatures() {
        return new ArrayList<Feature>(this.features);
    }

    public boolean isFeatureActivated(Feature feature) {
        return this.features.contains((Object)feature);
    }

    public Configuration setVisualGridOptions(VisualGridOption option, VisualGridOption ... options) {
        this.visualGridOptions.clear();
        this.visualGridOptions.add(option);
        this.visualGridOptions.addAll(Arrays.asList(options));
        this.visualGridOptions.remove(null);
        return this;
    }

    public List<VisualGridOption> getVisualGridOptions() {
        return this.visualGridOptions;
    }

    public String getDeviceInfo() {
        return this.deviceInfo;
    }

    public Configuration setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
        return this;
    }

    public String getHostingAppInfo() {
        return this.hostingAppInfo;
    }

    public Configuration setHostingAppInfo(String hostingAppInfo) {
        this.hostingAppInfo = hostingAppInfo;
        return this;
    }

    public String getOsInfo() {
        return this.osInfo;
    }

    public Configuration setOsInfo(String osInfo) {
        this.osInfo = osInfo;
        return this;
    }

    public Boolean isDisableBrowserFetching() {
        return this.disableBrowserFetching;
    }

    public Configuration setDisableBrowserFetching(Boolean disableBrowserFetching) {
        this.disableBrowserFetching = disableBrowserFetching;
        return this;
    }

    public Boolean isUseCookies() {
        return this.useCookies;
    }

    public Configuration setUseCookies(Boolean useCookies) {
        this.useCookies = useCookies;
        return this;
    }

    public IDebugResourceWriter getDebugResourceWriter() {
        return this.debugResourceWriter;
    }

    public Configuration setDebugResourceWriter(IDebugResourceWriter debugResourceWriter) {
        this.debugResourceWriter = debugResourceWriter;
        return this;
    }

    public Integer getAbortIdleTestTimeout() {
        return this.abortIdleTestTimeout;
    }

    public Configuration setAbortIdleTestTimeout(Integer abortIdleTestTimeout) {
        this.abortIdleTestTimeout = abortIdleTestTimeout;
        return this;
    }

    public Configuration setLayoutBreakpoints(Boolean shouldSet) {
        this.layoutBreakpointsOptions = this.layoutBreakpointsOptions != null ? this.layoutBreakpointsOptions.breakpoints(shouldSet) : new LayoutBreakpointsOptions().breakpoints(shouldSet);
        return this;
    }

    public Configuration setLayoutBreakpoints(LayoutBreakpointsOptions layoutBreakpointsOptions) {
        this.layoutBreakpointsOptions = layoutBreakpointsOptions;
        return this;
    }

    public Boolean isDefaultLayoutBreakpointsSet() {
        return this.layoutBreakpointsOptions != null ? this.layoutBreakpointsOptions.isLayoutBreakpoints() : null;
    }

    public Configuration setLayoutBreakpoints(int[] breakpoints) {
        this.layoutBreakpointsOptions = this.layoutBreakpointsOptions != null ? this.layoutBreakpointsOptions.breakpoints(breakpoints) : new LayoutBreakpointsOptions().breakpoints(breakpoints);
        return this;
    }

    public Configuration setLayoutBreakpoints(Integer ... breakpoints) {
        this.layoutBreakpointsOptions = this.layoutBreakpointsOptions != null ? this.layoutBreakpointsOptions.breakpoints(breakpoints) : new LayoutBreakpointsOptions().breakpoints(breakpoints);
        return this;
    }

    public List<Integer> getLayoutBreakpoints() {
        return this.layoutBreakpointsOptions != null ? this.layoutBreakpointsOptions.getLayoutBreakpoints() : new ArrayList();
    }

    public LayoutBreakpointsOptions getLayoutBreakpointsOptions() {
        return this.layoutBreakpointsOptions;
    }

    public Boolean isCaptureStatusBar() {
        return this.captureStatusBar;
    }

    public void setCaptureStatusBar(Boolean captureStatusBar) {
        this.captureStatusBar = captureStatusBar;
    }

    public Configuration setSaveDebugScreenshots(Boolean saveDebugScreenshots) {
        this.saveDebugScreenshots = saveDebugScreenshots;
        return this;
    }

    public Boolean getSaveDebugScreenshots() {
        return this.saveDebugScreenshots;
    }

    public Configuration setDebugScreenshotsPath(String debugScreenshotsPath) {
        this.debugScreenshotsPath = debugScreenshotsPath;
        return this;
    }

    public String getDebugScreenshotsPath() {
        return this.debugScreenshotsPath;
    }

    public Configuration setDebugScreenshotsPrefix(String debugScreenshotsPrefix) {
        this.debugScreenshotsPrefix = debugScreenshotsPrefix;
        return this;
    }

    public String getDebugScreenshotsPrefix() {
        return this.debugScreenshotsPrefix;
    }

    public Configuration setIsDisabled(Boolean isDisabled) {
        this.isDisabled = isDisabled;
        return this;
    }

    public Boolean getIsDisabled() {
        return this.isDisabled;
    }

    public Configuration addProperty(String name, String value) {
        PropertyData pd = new PropertyData(name, value);
        this.properties.add(pd);
        return this;
    }

    public void clearProperties() {
        this.properties.clear();
    }

    public List<PropertyData> getProperties() {
        return this.properties;
    }

    public Configuration setCutProvider(CutProvider cutProvider) {
        this.cutProvider = cutProvider;
        return this;
    }

    public CutProvider getCutProvider() {
        return this.cutProvider;
    }

    public Configuration setRotation(Integer rotation) {
        this.rotation = rotation;
        return this;
    }

    public Integer getRotation() {
        return this.rotation;
    }

    public Configuration setScaleRatio(Double scaleRatio) {
        this.scaleRatio = scaleRatio;
        return this;
    }

    public Double getScaleRatio() {
        return this.scaleRatio;
    }

    public Configuration addMobileDevice(IosDeviceInfo iosDeviceInfo) {
        return this.addBrowser(iosDeviceInfo);
    }

    public Configuration addMobileDevices(IosDeviceInfo iosDeviceInfo, IosDeviceInfo ... iosDeviceInfos) {
        this.addMobileDevice(iosDeviceInfo);
        if (iosDeviceInfos == null) {
            return this;
        }
        for (IosDeviceInfo info : iosDeviceInfos) {
            this.addMobileDevice(info);
        }
        return this;
    }

    public Configuration addMobileDevice(IosDeviceInfo iosDeviceInfo, String version) {
        RenderBrowserInfo renderBrowserInfo = new RenderBrowserInfo(version, iosDeviceInfo);
        this.browsersInfo.add(renderBrowserInfo);
        return this;
    }

    public Configuration addMobileDevice(AndroidDeviceInfo androidDeviceInfo, String version) {
        RenderBrowserInfo renderBrowserInfo = new RenderBrowserInfo(version, androidDeviceInfo);
        this.browsersInfo.add(renderBrowserInfo);
        return this;
    }

    public Configuration addMobileDevice(AndroidDeviceInfo androidDeviceInfo) {
        RenderBrowserInfo renderBrowserInfo = new RenderBrowserInfo(androidDeviceInfo);
        this.browsersInfo.add(renderBrowserInfo);
        return this;
    }

    public Configuration addMobileDevices(AndroidDeviceInfo androidDeviceInfo, AndroidDeviceInfo ... androidDeviceInfos) {
        this.addMobileDevice(androidDeviceInfo);
        if (androidDeviceInfos == null) {
            return this;
        }
        for (AndroidDeviceInfo info : androidDeviceInfos) {
            this.addMobileDevice(info);
        }
        return this;
    }

    public Configuration setUseCeilForViewportSize(Boolean useCeilForViewportSize) {
        this.useCeilForViewportSize = useCeilForViewportSize;
        return this;
    }

    public Boolean getUseCeilForViewportSize() {
        return this.useCeilForViewportSize;
    }

    public Integer getWaitBeforeCapture() {
        return this.waitBeforeCapture;
    }

    public void setWaitBeforeCapture(Integer milliSec) {
        this.waitBeforeCapture = milliSec;
    }

    public WebDriverProxySettings getWebDriverProxy() {
        return this.webdriverProxySettings;
    }

    public Configuration setWebDriverProxy(WebDriverProxySettings proxySettings) {
        this.webdriverProxySettings = proxySettings;
        return this;
    }

    public Configuration setAutProxy(AutProxySettings autProxy) {
        this.autProxy = autProxy;
        return this;
    }

    public AutProxySettings getAutProxy() {
        return this.autProxy;
    }

    public ContentInset getContentInset() {
        return this.contentInset;
    }

    public Configuration setContentInset(ContentInset contentInset) {
        this.contentInset = contentInset;
        return this;
    }
}

