/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.universal.mapper;

import com.applitools.eyes.EyesError;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.TestResultContainer;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.TestResultsSummary;
import com.applitools.eyes.exceptions.DiffsFoundException;
import com.applitools.eyes.exceptions.NewTestException;
import com.applitools.eyes.exceptions.TestFailedException;
import com.applitools.eyes.selenium.BrowserType;
import com.applitools.eyes.universal.dto.BrowserInfoDto;
import com.applitools.eyes.universal.dto.TestResultContainerDto;
import com.applitools.eyes.universal.dto.TestResultsSummaryDto;
import com.applitools.eyes.universal.mapper.RenderBrowserInfoMapper;
import com.applitools.eyes.universal.mapper.TestResultsMapper;
import com.applitools.eyes.visualgrid.model.ChromeEmulationInfo;
import com.applitools.eyes.visualgrid.model.EmulationBaseInfo;
import com.applitools.eyes.visualgrid.model.IosDeviceInfo;
import com.applitools.eyes.visualgrid.model.RenderBrowserInfo;
import java.util.ArrayList;
import java.util.List;

public class TestResultsSummaryMapper {
    public static TestResultsSummary fromDto(TestResultsSummaryDto dto, boolean shouldThrowException) {
        if (dto == null) {
            return null;
        }
        List<TestResultContainerDto> containerDtoList = dto.getResults();
        ArrayList<TestResultContainer> containerList = new ArrayList<TestResultContainer>();
        if (containerDtoList != null && !containerDtoList.isEmpty()) {
            for (TestResultContainerDto containerDto : containerDtoList) {
                BrowserInfoDto browserInfoDto = containerDto.getEnvironment().getRequested();
                RenderBrowserInfo renderBrowserInfo = null;
                if (browserInfoDto != null) {
                    if (browserInfoDto.getChromeEmulationInfo() != null) {
                        ChromeEmulationInfo emulationBaseInfo = RenderBrowserInfoMapper.toEmulationInfo(browserInfoDto.getChromeEmulationInfo());
                        renderBrowserInfo = new RenderBrowserInfo((EmulationBaseInfo)emulationBaseInfo);
                    } else if (browserInfoDto.getIosDeviceInfo() != null) {
                        IosDeviceInfo iosDeviceInfo = RenderBrowserInfoMapper.toIosDeviceInfo(browserInfoDto.getIosDeviceInfo());
                        renderBrowserInfo = new RenderBrowserInfo(iosDeviceInfo);
                    } else {
                        renderBrowserInfo = new RenderBrowserInfo(browserInfoDto.getWidth().intValue(), browserInfoDto.getHeight().intValue(), BrowserType.fromName((String)browserInfoDto.getName()));
                    }
                }
                Throwable throwable = null;
                if (containerDto.getError() != null) {
                    EyesError eyesError = containerDto.getError();
                    throwable = TestResultsSummaryMapper.getExceptionBasedOnReason(eyesError.getReason(), eyesError.getInfo() == null ? null : eyesError.getInfo().getResult(), eyesError.getMessage(), eyesError.getStack());
                    if (shouldThrowException) {
                        throw new Error(throwable);
                    }
                }
                TestResults testResults = TestResultsMapper.toTestResults(containerDto.getResult());
                TestResultContainer container = new TestResultContainer(testResults, renderBrowserInfo, throwable);
                containerList.add(container);
            }
        }
        return new TestResultsSummary(containerList, dto.getPassed(), dto.getUnresolved(), dto.getFailed(), dto.getExceptions(), dto.getMismatches(), dto.getMissing(), dto.getMatches());
    }

    private static Throwable getExceptionBasedOnReason(String reason, TestResults testResults, String message, String stack) {
        String appIdOrName;
        String scenarioIdOrName;
        if (reason == null || reason.isEmpty() || reason.equals("internal")) {
            return new EyesException("Message: " + message + ", Stack: " + stack);
        }
        if (testResults == null) {
            scenarioIdOrName = "(no test results)";
            appIdOrName = "";
        } else {
            scenarioIdOrName = testResults.getName();
            appIdOrName = testResults.getAppName();
        }
        switch (reason) {
            case "test different": {
                return new DiffsFoundException(testResults, scenarioIdOrName, appIdOrName);
            }
            case "test failed": {
                return new TestFailedException(testResults, scenarioIdOrName, appIdOrName);
            }
            case "test new": {
                return new NewTestException(testResults, scenarioIdOrName, appIdOrName);
            }
        }
        throw new UnsupportedOperationException("Unsupported exception type: " + reason);
    }
}

