/*
 * Decompiled with CFR 0.152.
 */
package com.shaded.asynchttpclient.filter;

import com.shaded.asynchttpclient.AsyncHandler;
import com.shaded.asynchttpclient.HttpResponseStatus;
import com.shaded.asynchttpclient.Request;
import com.shaded.jetbrains.annotations.Nullable;
import com.shaded.netty.handler.codec.http.HttpHeaders;
import java.io.IOException;

public class FilterContext<T> {
    private final FilterContextBuilder<T> builder;

    private FilterContext(FilterContextBuilder<T> builder) {
        this.builder = builder;
    }

    public AsyncHandler<T> getAsyncHandler() {
        return this.builder.asyncHandler;
    }

    public Request getRequest() {
        return this.builder.request;
    }

    @Nullable
    public HttpResponseStatus getResponseStatus() {
        return this.builder.responseStatus;
    }

    @Nullable
    public HttpHeaders getResponseHeaders() {
        return this.builder.headers;
    }

    public boolean replayRequest() {
        return this.builder.replayRequest;
    }

    @Nullable
    public IOException getIOException() {
        return this.builder.ioException;
    }

    public static class FilterContextBuilder<T> {
        private AsyncHandler<T> asyncHandler;
        private Request request;
        @Nullable
        private HttpResponseStatus responseStatus;
        private boolean replayRequest;
        @Nullable
        private IOException ioException;
        @Nullable
        private HttpHeaders headers;

        public FilterContextBuilder(AsyncHandler<T> asyncHandler, Request request) {
            this.asyncHandler = asyncHandler;
            this.request = request;
        }

        public FilterContextBuilder(FilterContext<T> clone) {
            this.asyncHandler = clone.getAsyncHandler();
            this.request = clone.getRequest();
            this.responseStatus = clone.getResponseStatus();
            this.replayRequest = clone.replayRequest();
            this.ioException = clone.getIOException();
        }

        public AsyncHandler<T> getAsyncHandler() {
            return this.asyncHandler;
        }

        public FilterContextBuilder<T> asyncHandler(AsyncHandler<T> asyncHandler) {
            this.asyncHandler = asyncHandler;
            return this;
        }

        public Request getRequest() {
            return this.request;
        }

        public FilterContextBuilder<T> request(Request request) {
            this.request = request;
            return this;
        }

        public FilterContextBuilder<T> responseStatus(HttpResponseStatus responseStatus) {
            this.responseStatus = responseStatus;
            return this;
        }

        public FilterContextBuilder<T> responseHeaders(HttpHeaders headers) {
            this.headers = headers;
            return this;
        }

        public FilterContextBuilder<T> replayRequest(boolean replayRequest) {
            this.replayRequest = replayRequest;
            return this;
        }

        public FilterContextBuilder<T> ioException(IOException ioException) {
            this.ioException = ioException;
            return this;
        }

        public FilterContext<T> build() {
            return new FilterContext(this);
        }
    }
}

