/*
 * Decompiled with CFR 0.152.
 */
package com.shaded.asynchttpclient.netty.handler;

import com.shaded.asynchttpclient.AsyncHandler;
import com.shaded.asynchttpclient.AsyncHttpClientConfig;
import com.shaded.asynchttpclient.HttpResponseStatus;
import com.shaded.asynchttpclient.netty.NettyResponseFuture;
import com.shaded.asynchttpclient.netty.NettyResponseStatus;
import com.shaded.asynchttpclient.netty.channel.ChannelManager;
import com.shaded.asynchttpclient.netty.channel.Channels;
import com.shaded.asynchttpclient.netty.handler.AsyncHttpClientHandler;
import com.shaded.asynchttpclient.netty.request.NettyRequestSender;
import com.shaded.asynchttpclient.netty.ws.NettyWebSocket;
import com.shaded.asynchttpclient.ws.WebSocketUpgradeHandler;
import com.shaded.asynchttpclient.ws.WebSocketUtils;
import com.shaded.netty.channel.Channel;
import com.shaded.netty.channel.ChannelHandler;
import com.shaded.netty.handler.codec.http.HttpHeaderNames;
import com.shaded.netty.handler.codec.http.HttpHeaderValues;
import com.shaded.netty.handler.codec.http.HttpHeaders;
import com.shaded.netty.handler.codec.http.HttpRequest;
import com.shaded.netty.handler.codec.http.HttpResponse;
import com.shaded.netty.handler.codec.http.LastHttpContent;
import com.shaded.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.io.IOException;

@ChannelHandler.Sharable
public final class WebSocketHandler
extends AsyncHttpClientHandler {
    public WebSocketHandler(AsyncHttpClientConfig config, ChannelManager channelManager, NettyRequestSender requestSender) {
        super(config, channelManager, requestSender);
    }

    private static WebSocketUpgradeHandler getWebSocketUpgradeHandler(NettyResponseFuture<?> future) {
        return (WebSocketUpgradeHandler)future.getAsyncHandler();
    }

    private static NettyWebSocket getNettyWebSocket(NettyResponseFuture<?> future) throws Exception {
        return WebSocketHandler.getWebSocketUpgradeHandler(future).onCompleted();
    }

    private void upgrade(Channel channel, NettyResponseFuture<?> future, WebSocketUpgradeHandler handler, HttpResponse response, HttpHeaders responseHeaders) throws Exception {
        boolean headerOK;
        boolean validStatus = response.status().equals(com.shaded.netty.handler.codec.http.HttpResponseStatus.SWITCHING_PROTOCOLS);
        boolean validUpgrade = response.headers().get(HttpHeaderNames.UPGRADE) != null;
        String connection = response.headers().get(HttpHeaderNames.CONNECTION);
        boolean validConnection = HttpHeaderValues.UPGRADE.contentEqualsIgnoreCase(connection);
        boolean bl = headerOK = handler.onHeadersReceived(responseHeaders) == AsyncHandler.State.CONTINUE;
        if (!(headerOK && validStatus && validUpgrade && validConnection)) {
            this.requestSender.abort(channel, future, new IOException("Invalid handshake response"));
            return;
        }
        String accept = response.headers().get(HttpHeaderNames.SEC_WEBSOCKET_ACCEPT);
        String key = WebSocketUtils.getAcceptKey(future.getNettyRequest().getHttpRequest().headers().get(HttpHeaderNames.SEC_WEBSOCKET_KEY));
        if (accept == null || !accept.equals(key)) {
            this.requestSender.abort(channel, future, new IOException("Invalid challenge. Actual: " + accept + ". Expected: " + key));
        }
        Channels.setAttribute(channel, future);
        NettyWebSocket webSocket = new NettyWebSocket(channel, responseHeaders);
        handler.setWebSocket(webSocket);
        this.channelManager.upgradePipelineForWebSockets(channel.pipeline());
        try {
            handler.onOpen(webSocket);
        }
        catch (Exception ex) {
            this.logger.warn("onSuccess unexpected exception", ex);
        }
        future.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abort(Channel channel, NettyResponseFuture<?> future, WebSocketUpgradeHandler handler, HttpResponseStatus status) {
        try {
            handler.onThrowable(new IOException("Invalid Status code=" + status.getStatusCode() + " text=" + status.getStatusText()));
        }
        finally {
            this.finishUpdate(future, channel, true);
        }
    }

    @Override
    public void handleRead(Channel channel, NettyResponseFuture<?> future, Object e) throws Exception {
        if (e instanceof HttpResponse) {
            HttpHeaders responseHeaders;
            NettyResponseStatus status;
            WebSocketUpgradeHandler handler;
            HttpResponse response = (HttpResponse)e;
            if (this.logger.isDebugEnabled()) {
                HttpRequest httpRequest = future.getNettyRequest().getHttpRequest();
                this.logger.debug("\n\nRequest {}\n\nResponse {}\n", (Object)httpRequest, (Object)response);
            }
            if (!this.interceptors.exitAfterIntercept(channel, future, handler = WebSocketHandler.getWebSocketUpgradeHandler(future), response, status = new NettyResponseStatus(future.getUri(), response, channel), responseHeaders = response.headers())) {
                if (handler.onStatusReceived(status) == AsyncHandler.State.CONTINUE) {
                    this.upgrade(channel, future, handler, response, responseHeaders);
                } else {
                    this.abort(channel, future, handler, status);
                }
            }
        } else if (e instanceof WebSocketFrame) {
            WebSocketFrame frame = (WebSocketFrame)e;
            NettyWebSocket webSocket = WebSocketHandler.getNettyWebSocket(future);
            if (webSocket.isReady()) {
                webSocket.handleFrame(frame);
            } else {
                webSocket.bufferFrame(frame);
            }
        } else if (!(e instanceof LastHttpContent)) {
            this.logger.error("Invalid message {}", e);
        }
    }

    @Override
    public void handleException(NettyResponseFuture<?> future, Throwable e) {
        this.logger.warn("onError", e);
        try {
            NettyWebSocket webSocket = WebSocketHandler.getNettyWebSocket(future);
            if (webSocket != null) {
                webSocket.onError(e);
                webSocket.sendCloseFrame();
            }
        }
        catch (Throwable t) {
            this.logger.error("onError", t);
        }
    }

    @Override
    public void handleChannelInactive(NettyResponseFuture<?> future) {
        this.logger.trace("Connection was closed abnormally (that is, with no close frame being received).");
        try {
            NettyWebSocket webSocket = WebSocketHandler.getNettyWebSocket(future);
            if (webSocket != null) {
                webSocket.onClose(1006, "Connection was closed abnormally (that is, with no close frame being received).");
            }
        }
        catch (Throwable t) {
            this.logger.error("onError", t);
        }
    }
}

