/*
 * Decompiled with CFR 0.152.
 */
package com.shaded.asynchttpclient.netty.handler.intercept;

import com.shaded.asynchttpclient.AsyncHandler;
import com.shaded.asynchttpclient.AsyncHttpClientConfig;
import com.shaded.asynchttpclient.HttpResponseStatus;
import com.shaded.asynchttpclient.exception.FilterException;
import com.shaded.asynchttpclient.filter.FilterContext;
import com.shaded.asynchttpclient.filter.ResponseFilter;
import com.shaded.asynchttpclient.netty.NettyResponseFuture;
import com.shaded.asynchttpclient.netty.request.NettyRequestSender;
import com.shaded.netty.channel.Channel;
import com.shaded.netty.handler.codec.http.HttpHeaders;

public class ResponseFiltersInterceptor {
    private final AsyncHttpClientConfig config;
    private final NettyRequestSender requestSender;

    ResponseFiltersInterceptor(AsyncHttpClientConfig config, NettyRequestSender requestSender) {
        this.config = config;
        this.requestSender = requestSender;
    }

    public boolean exitAfterProcessingFilters(Channel channel, NettyResponseFuture<?> future, AsyncHandler<?> handler, HttpResponseStatus status, HttpHeaders responseHeaders) {
        FilterContext<?> fc = new FilterContext.FilterContextBuilder(handler, future.getCurrentRequest()).responseStatus(status).responseHeaders(responseHeaders).build();
        for (ResponseFilter asyncFilter : this.config.getResponseFilters()) {
            try {
                fc = asyncFilter.filter(fc);
            }
            catch (FilterException fe) {
                this.requestSender.abort(channel, future, fe);
            }
        }
        future.setAsyncHandler(fc.getAsyncHandler());
        if (fc.replayRequest()) {
            this.requestSender.replayRequest(future, fc, channel);
            return true;
        }
        return false;
    }
}

