/*
 * Decompiled with CFR 0.152.
 */
package com.shaded.asynchttpclient.netty.request.body;

import com.shaded.asynchttpclient.AsyncHttpClientConfig;
import com.shaded.asynchttpclient.netty.NettyResponseFuture;
import com.shaded.asynchttpclient.netty.channel.ChannelManager;
import com.shaded.asynchttpclient.netty.request.WriteProgressListener;
import com.shaded.asynchttpclient.netty.request.body.BodyChunkedInput;
import com.shaded.asynchttpclient.netty.request.body.BodyFileRegion;
import com.shaded.asynchttpclient.netty.request.body.NettyBody;
import com.shaded.asynchttpclient.request.body.Body;
import com.shaded.asynchttpclient.request.body.RandomAccessBody;
import com.shaded.asynchttpclient.request.body.generator.BodyGenerator;
import com.shaded.asynchttpclient.request.body.generator.FeedListener;
import com.shaded.asynchttpclient.request.body.generator.FeedableBodyGenerator;
import com.shaded.asynchttpclient.util.MiscUtils;
import com.shaded.netty.channel.Channel;
import com.shaded.netty.channel.ChannelProgressiveFuture;
import com.shaded.netty.handler.codec.http.LastHttpContent;
import com.shaded.netty.handler.stream.ChunkedWriteHandler;

public class NettyBodyBody
implements NettyBody {
    private final Body body;
    private final AsyncHttpClientConfig config;

    public NettyBodyBody(Body body, AsyncHttpClientConfig config) {
        this.body = body;
        this.config = config;
    }

    public Body getBody() {
        return this.body;
    }

    @Override
    public long getContentLength() {
        return this.body.getContentLength();
    }

    @Override
    public void write(Channel channel, NettyResponseFuture<?> future) {
        Object msg;
        if (this.body instanceof RandomAccessBody && !ChannelManager.isSslHandlerConfigured(channel.pipeline()) && !this.config.isDisableZeroCopy() && this.getContentLength() > 0L) {
            msg = new BodyFileRegion((RandomAccessBody)this.body);
        } else {
            msg = new BodyChunkedInput(this.body);
            BodyGenerator bg = future.getTargetRequest().getBodyGenerator();
            if (bg instanceof FeedableBodyGenerator) {
                final ChunkedWriteHandler chunkedWriteHandler = channel.pipeline().get(ChunkedWriteHandler.class);
                ((FeedableBodyGenerator)bg).setListener(new FeedListener(){

                    @Override
                    public void onContentAdded() {
                        chunkedWriteHandler.resumeTransfer();
                    }

                    @Override
                    public void onError(Throwable t) {
                    }
                });
            }
        }
        channel.write(msg, channel.newProgressivePromise()).addListener(new WriteProgressListener(future, false, this.getContentLength()){

            @Override
            public void operationComplete(ChannelProgressiveFuture cf) {
                MiscUtils.closeSilently(NettyBodyBody.this.body);
                super.operationComplete(cf);
            }
        });
        channel.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT, channel.voidPromise());
    }
}

