/*
 * Decompiled with CFR 0.152.
 */
package com.shaded.netty.handler.codec.dns;

import com.shaded.netty.buffer.ByteBuf;
import com.shaded.netty.channel.ChannelHandler;
import com.shaded.netty.channel.ChannelHandlerContext;
import com.shaded.netty.handler.codec.MessageToMessageEncoder;
import com.shaded.netty.handler.codec.dns.DnsMessageUtil;
import com.shaded.netty.handler.codec.dns.DnsRecordEncoder;
import com.shaded.netty.handler.codec.dns.DnsResponse;
import com.shaded.netty.util.internal.ObjectUtil;
import java.util.List;

@ChannelHandler.Sharable
public final class TcpDnsResponseEncoder
extends MessageToMessageEncoder<DnsResponse> {
    private final DnsRecordEncoder encoder;

    public TcpDnsResponseEncoder() {
        this(DnsRecordEncoder.DEFAULT);
    }

    public TcpDnsResponseEncoder(DnsRecordEncoder encoder) {
        this.encoder = ObjectUtil.checkNotNull(encoder, "encoder");
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, DnsResponse response, List<Object> out) throws Exception {
        ByteBuf buf = ctx.alloc().ioBuffer(1024);
        buf.writerIndex(buf.writerIndex() + 2);
        DnsMessageUtil.encodeDnsResponse(this.encoder, response, buf);
        buf.setShort(0, buf.readableBytes() - 2);
        out.add(buf);
    }
}

